/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.TimeSparseArray;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.res.Configuration;
import android.util.ArrayMap;
import com.android.internal.util.XmlUtils;
import com.android.server.usage.IntervalStats;
import java.io.IOException;
import java.net.ProtocolException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class UsageStatsXmlV1 {
    private static final String PACKAGES_TAG = "packages";
    private static final String PACKAGE_TAG = "package";
    private static final String CHOOSER_COUNT_TAG = "chosen_action";
    private static final String CATEGORY_TAG = "category";
    private static final String NAME = "name";
    private static final String COUNT = "count";
    private static final String CONFIGURATIONS_TAG = "configurations";
    private static final String CONFIG_TAG = "config";
    private static final String EVENT_LOG_TAG = "event-log";
    private static final String EVENT_TAG = "event";
    private static final String PACKAGE_ATTR = "package";
    private static final String CLASS_ATTR = "class";
    private static final String TOTAL_TIME_ACTIVE_ATTR = "timeActive";
    private static final String COUNT_ATTR = "count";
    private static final String ACTIVE_ATTR = "active";
    private static final String LAST_EVENT_ATTR = "lastEvent";
    private static final String TYPE_ATTR = "type";
    private static final String SHORTCUT_ID_ATTR = "shortcutId";
    private static final String LAST_TIME_ACTIVE_ATTR = "lastTimeActive";
    private static final String END_TIME_ATTR = "endTime";
    private static final String TIME_ATTR = "time";

    private static void loadUsageStats(XmlPullParser parser, IntervalStats statsOut) throws XmlPullParserException, IOException {
        int eventCode;
        String pkg = parser.getAttributeValue(null, "package");
        if (pkg == null) {
            throw new ProtocolException("no package attribute present");
        }
        UsageStats stats = statsOut.getOrCreateUsageStats(pkg);
        stats.mLastTimeUsed = statsOut.beginTime + XmlUtils.readLongAttribute(parser, LAST_TIME_ACTIVE_ATTR);
        stats.mTotalTimeInForeground = XmlUtils.readLongAttribute(parser, TOTAL_TIME_ACTIVE_ATTR);
        stats.mLastEvent = XmlUtils.readIntAttribute(parser, LAST_EVENT_ATTR);
        while ((eventCode = parser.next()) != 1) {
            String tag = parser.getName();
            if (eventCode == 3 && tag.equals("package")) break;
            if (eventCode != 2 || !tag.equals(CHOOSER_COUNT_TAG)) continue;
            String action = XmlUtils.readStringAttribute(parser, NAME);
            UsageStatsXmlV1.loadChooserCounts(parser, stats, action);
        }
    }

    private static void loadChooserCounts(XmlPullParser parser, UsageStats usageStats, String action) throws XmlPullParserException, IOException {
        int eventCode;
        if (action == null) {
            return;
        }
        if (usageStats.mChooserCounts == null) {
            usageStats.mChooserCounts = new ArrayMap();
        }
        if (!usageStats.mChooserCounts.containsKey(action)) {
            ArrayMap counts = new ArrayMap();
            usageStats.mChooserCounts.put(action, counts);
        }
        while ((eventCode = parser.next()) != 1) {
            String tag = parser.getName();
            if (eventCode == 3 && tag.equals(CHOOSER_COUNT_TAG)) break;
            if (eventCode != 2 || !tag.equals(CATEGORY_TAG)) continue;
            String category = XmlUtils.readStringAttribute(parser, NAME);
            int count = XmlUtils.readIntAttribute(parser, "count");
            usageStats.mChooserCounts.get(action).put(category, count);
        }
    }

    private static void loadConfigStats(XmlPullParser parser, IntervalStats statsOut) throws XmlPullParserException, IOException {
        Configuration config = new Configuration();
        Configuration.readXmlAttrs(parser, config);
        ConfigurationStats configStats = statsOut.getOrCreateConfigurationStats(config);
        configStats.mLastTimeActive = statsOut.beginTime + XmlUtils.readLongAttribute(parser, LAST_TIME_ACTIVE_ATTR);
        configStats.mTotalTimeActive = XmlUtils.readLongAttribute(parser, TOTAL_TIME_ACTIVE_ATTR);
        configStats.mActivationCount = XmlUtils.readIntAttribute(parser, "count");
        if (XmlUtils.readBooleanAttribute(parser, ACTIVE_ATTR)) {
            statsOut.activeConfiguration = configStats.mConfiguration;
        }
    }

    private static void loadEvent(XmlPullParser parser, IntervalStats statsOut) throws XmlPullParserException, IOException {
        String packageName = XmlUtils.readStringAttribute(parser, "package");
        if (packageName == null) {
            throw new ProtocolException("no package attribute present");
        }
        String className = XmlUtils.readStringAttribute(parser, CLASS_ATTR);
        UsageEvents.Event event = statsOut.buildEvent(packageName, className);
        event.mTimeStamp = statsOut.beginTime + XmlUtils.readLongAttribute(parser, TIME_ATTR);
        event.mEventType = XmlUtils.readIntAttribute(parser, TYPE_ATTR);
        switch (event.mEventType) {
            case 5: {
                event.mConfiguration = new Configuration();
                Configuration.readXmlAttrs(parser, event.mConfiguration);
                break;
            }
            case 8: {
                String id2 = XmlUtils.readStringAttribute(parser, SHORTCUT_ID_ATTR);
                String string2 = event.mShortcutId = id2 != null ? id2.intern() : null;
            }
        }
        if (statsOut.events == null) {
            statsOut.events = new TimeSparseArray();
        }
        statsOut.events.put(event.mTimeStamp, event);
    }

    private static void writeUsageStats(XmlSerializer xml2, IntervalStats stats, UsageStats usageStats) throws IOException {
        xml2.startTag(null, "package");
        XmlUtils.writeLongAttribute(xml2, LAST_TIME_ACTIVE_ATTR, usageStats.mLastTimeUsed - stats.beginTime);
        XmlUtils.writeStringAttribute(xml2, "package", usageStats.mPackageName);
        XmlUtils.writeLongAttribute(xml2, TOTAL_TIME_ACTIVE_ATTR, usageStats.mTotalTimeInForeground);
        XmlUtils.writeIntAttribute(xml2, LAST_EVENT_ATTR, usageStats.mLastEvent);
        UsageStatsXmlV1.writeChooserCounts(xml2, usageStats);
        xml2.endTag(null, "package");
    }

    private static void writeChooserCounts(XmlSerializer xml2, UsageStats usageStats) throws IOException {
        if (usageStats == null || usageStats.mChooserCounts == null || usageStats.mChooserCounts.keySet().isEmpty()) {
            return;
        }
        int chooserCountSize = usageStats.mChooserCounts.size();
        for (int i = 0; i < chooserCountSize; ++i) {
            String action = usageStats.mChooserCounts.keyAt(i);
            ArrayMap<String, Integer> counts = usageStats.mChooserCounts.valueAt(i);
            if (action == null || counts == null || counts.isEmpty()) continue;
            xml2.startTag(null, CHOOSER_COUNT_TAG);
            XmlUtils.writeStringAttribute(xml2, NAME, action);
            UsageStatsXmlV1.writeCountsForAction(xml2, counts);
            xml2.endTag(null, CHOOSER_COUNT_TAG);
        }
    }

    private static void writeCountsForAction(XmlSerializer xml2, ArrayMap<String, Integer> counts) throws IOException {
        int countsSize = counts.size();
        for (int i = 0; i < countsSize; ++i) {
            String key = counts.keyAt(i);
            int count = counts.valueAt(i);
            if (count <= 0) continue;
            xml2.startTag(null, CATEGORY_TAG);
            XmlUtils.writeStringAttribute(xml2, NAME, key);
            XmlUtils.writeIntAttribute(xml2, "count", count);
            xml2.endTag(null, CATEGORY_TAG);
        }
    }

    private static void writeConfigStats(XmlSerializer xml2, IntervalStats stats, ConfigurationStats configStats, boolean isActive) throws IOException {
        xml2.startTag(null, CONFIG_TAG);
        XmlUtils.writeLongAttribute(xml2, LAST_TIME_ACTIVE_ATTR, configStats.mLastTimeActive - stats.beginTime);
        XmlUtils.writeLongAttribute(xml2, TOTAL_TIME_ACTIVE_ATTR, configStats.mTotalTimeActive);
        XmlUtils.writeIntAttribute(xml2, "count", configStats.mActivationCount);
        if (isActive) {
            XmlUtils.writeBooleanAttribute(xml2, ACTIVE_ATTR, true);
        }
        Configuration.writeXmlAttrs(xml2, configStats.mConfiguration);
        xml2.endTag(null, CONFIG_TAG);
    }

    private static void writeEvent(XmlSerializer xml2, IntervalStats stats, UsageEvents.Event event) throws IOException {
        xml2.startTag(null, EVENT_TAG);
        XmlUtils.writeLongAttribute(xml2, TIME_ATTR, event.mTimeStamp - stats.beginTime);
        XmlUtils.writeStringAttribute(xml2, "package", event.mPackage);
        if (event.mClass != null) {
            XmlUtils.writeStringAttribute(xml2, CLASS_ATTR, event.mClass);
        }
        XmlUtils.writeIntAttribute(xml2, TYPE_ATTR, event.mEventType);
        switch (event.mEventType) {
            case 5: {
                if (event.mConfiguration == null) break;
                Configuration.writeXmlAttrs(xml2, event.mConfiguration);
                break;
            }
            case 8: {
                if (event.mShortcutId == null) break;
                XmlUtils.writeStringAttribute(xml2, SHORTCUT_ID_ATTR, event.mShortcutId);
            }
        }
        xml2.endTag(null, EVENT_TAG);
    }

    public static void read(XmlPullParser parser, IntervalStats statsOut) throws XmlPullParserException, IOException {
        int eventCode;
        statsOut.packageStats.clear();
        statsOut.configurations.clear();
        statsOut.activeConfiguration = null;
        if (statsOut.events != null) {
            statsOut.events.clear();
        }
        statsOut.endTime = statsOut.beginTime + XmlUtils.readLongAttribute(parser, END_TIME_ATTR);
        int outerDepth = parser.getDepth();
        while ((eventCode = parser.next()) != 1 && (eventCode != 3 || parser.getDepth() > outerDepth)) {
            String tag;
            if (eventCode != 2) continue;
            switch (tag = parser.getName()) {
                case "package": {
                    UsageStatsXmlV1.loadUsageStats(parser, statsOut);
                    break;
                }
                case "config": {
                    UsageStatsXmlV1.loadConfigStats(parser, statsOut);
                    break;
                }
                case "event": {
                    UsageStatsXmlV1.loadEvent(parser, statsOut);
                }
            }
        }
    }

    public static void write(XmlSerializer xml2, IntervalStats stats) throws IOException {
        XmlUtils.writeLongAttribute(xml2, END_TIME_ATTR, stats.endTime - stats.beginTime);
        xml2.startTag(null, PACKAGES_TAG);
        int statsCount = stats.packageStats.size();
        for (int i = 0; i < statsCount; ++i) {
            UsageStatsXmlV1.writeUsageStats(xml2, stats, stats.packageStats.valueAt(i));
        }
        xml2.endTag(null, PACKAGES_TAG);
        xml2.startTag(null, CONFIGURATIONS_TAG);
        int configCount = stats.configurations.size();
        for (int i = 0; i < configCount; ++i) {
            boolean active = stats.activeConfiguration.equals(stats.configurations.keyAt(i));
            UsageStatsXmlV1.writeConfigStats(xml2, stats, stats.configurations.valueAt(i), active);
        }
        xml2.endTag(null, CONFIGURATIONS_TAG);
        xml2.startTag(null, EVENT_LOG_TAG);
        int eventCount = stats.events != null ? stats.events.size() : 0;
        for (int i = 0; i < eventCount; ++i) {
            UsageStatsXmlV1.writeEvent(xml2, stats, (UsageEvents.Event)stats.events.valueAt(i));
        }
        xml2.endTag(null, EVENT_LOG_TAG);
    }

    private UsageStatsXmlV1() {
    }
}

