/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.Context;
import android.content.res.Resources;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.media.IAudioService;
import android.os.Bundle;
import android.os.FileObserver;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Slog;
import com.android.internal.alsa.AlsaCardsParser;
import com.android.internal.alsa.AlsaDevicesParser;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.audio.AudioService;
import com.android.server.usb.UsbAudioDevice;
import com.android.server.usb.UsbMidiDevice;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import libcore.io.IoUtils;

public final class UsbAlsaManager {
    private static final String TAG = UsbAlsaManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String ALSA_DIRECTORY = "/dev/snd/";
    private final Context mContext;
    private IAudioService mAudioService;
    private final boolean mHasMidiFeature;
    private final AlsaCardsParser mCardsParser = new AlsaCardsParser();
    private final AlsaDevicesParser mDevicesParser = new AlsaDevicesParser();
    private final HashMap<UsbDevice, UsbAudioDevice> mAudioDevices = new HashMap();
    private final HashMap<UsbDevice, UsbMidiDevice> mMidiDevices = new HashMap();
    private final HashMap<String, AlsaDevice> mAlsaDevices = new HashMap();
    private UsbAudioDevice mAccessoryAudioDevice = null;
    private UsbMidiDevice mPeripheralMidiDevice = null;
    private final FileObserver mAlsaObserver = new FileObserver("/dev/snd/", 768){

        @Override
        public void onEvent(int event, String path) {
            switch (event) {
                case 256: {
                    UsbAlsaManager.this.alsaFileAdded(path);
                    break;
                }
                case 512: {
                    UsbAlsaManager.this.alsaFileRemoved(path);
                }
            }
        }
    };

    UsbAlsaManager(Context context) {
        this.mContext = context;
        this.mHasMidiFeature = context.getPackageManager().hasSystemFeature("android.software.midi");
        this.mCardsParser.scan();
    }

    public void systemReady() {
        this.mAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        this.mAlsaObserver.startWatching();
        File[] files = new File(ALSA_DIRECTORY).listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.alsaFileAdded(files[i].getName());
            }
        }
    }

    private void notifyDeviceState(UsbAudioDevice audioDevice, boolean enabled) {
        if (this.mAudioService == null) {
            Slog.e(TAG, "no AudioService");
            return;
        }
        int isDisabled = Settings.Secure.getInt(this.mContext.getContentResolver(), "usb_audio_automatic_routing_disabled", 0);
        if (isDisabled != 0) {
            return;
        }
        int state = enabled ? 1 : 0;
        int alsaCard = audioDevice.mCard;
        int alsaDevice = audioDevice.mDevice;
        if (alsaCard < 0 || alsaDevice < 0) {
            Slog.e(TAG, "Invalid alsa card or device alsaCard: " + alsaCard + " alsaDevice: " + alsaDevice);
            return;
        }
        String address = AudioService.makeAlsaAddressString(alsaCard, alsaDevice);
        try {
            int device;
            if (audioDevice.mHasPlayback) {
                device = audioDevice == this.mAccessoryAudioDevice ? 8192 : 16384;
                this.mAudioService.setWiredDeviceConnectionState(device, state, address, audioDevice.mDeviceName, TAG);
            }
            if (audioDevice.mHasCapture) {
                device = audioDevice == this.mAccessoryAudioDevice ? -2147481600 : -2147479552;
                this.mAudioService.setWiredDeviceConnectionState(device, state, address, audioDevice.mDeviceName, TAG);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException in setWiredDeviceConnectionState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlsaDevice waitForAlsaDevice(int card, int device, int type) {
        AlsaDevice testDevice = new AlsaDevice(type, card, device);
        int kWaitTime = 2500;
        HashMap<String, AlsaDevice> hashMap = this.mAlsaDevices;
        synchronized (hashMap) {
            long timeout = SystemClock.elapsedRealtime() + 2500L;
            do {
                if (this.mAlsaDevices.values().contains(testDevice)) {
                    return testDevice;
                }
                long waitTime = timeout - SystemClock.elapsedRealtime();
                if (waitTime <= 0L) continue;
                try {
                    this.mAlsaDevices.wait(waitTime);
                }
                catch (InterruptedException e) {
                    Slog.d(TAG, "usb: InterruptedException while waiting for ALSA file.");
                }
            } while (timeout > SystemClock.elapsedRealtime());
        }
        Slog.e(TAG, "waitForAlsaDevice failed for " + testDevice);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alsaFileAdded(String name) {
        int type = 0;
        int card = -1;
        int device = -1;
        if (name.startsWith("pcmC")) {
            if (name.endsWith("p")) {
                type = 1;
            } else if (name.endsWith("c")) {
                type = 2;
            }
        } else if (name.startsWith("midiC")) {
            type = 3;
        }
        if (type != 0) {
            try {
                int c_index = name.indexOf(67);
                int d_index = name.indexOf(68);
                int end = name.length();
                if (type == 1 || type == 2) {
                    --end;
                }
                card = Integer.parseInt(name.substring(c_index + 1, d_index));
                device = Integer.parseInt(name.substring(d_index + 1, end));
            }
            catch (Exception e) {
                Slog.e(TAG, "Could not parse ALSA file name " + name, e);
                return;
            }
            HashMap<String, AlsaDevice> hashMap = this.mAlsaDevices;
            synchronized (hashMap) {
                if (this.mAlsaDevices.get(name) == null) {
                    AlsaDevice alsaDevice = new AlsaDevice(type, card, device);
                    Slog.d(TAG, "Adding ALSA device " + alsaDevice);
                    this.mAlsaDevices.put(name, alsaDevice);
                    this.mAlsaDevices.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alsaFileRemoved(String path) {
        HashMap<String, AlsaDevice> hashMap = this.mAlsaDevices;
        synchronized (hashMap) {
            AlsaDevice device = this.mAlsaDevices.remove(path);
            if (device != null) {
                Slog.d(TAG, "ALSA device removed: " + device);
            }
        }
    }

    UsbAudioDevice selectAudioCard(int card) {
        if (!this.mCardsParser.isCardUsb(card)) {
            return null;
        }
        this.mDevicesParser.scan();
        int device = this.mDevicesParser.getDefaultDeviceNum(card);
        boolean hasPlayback = this.mDevicesParser.hasPlaybackDevices(card);
        boolean hasCapture = this.mDevicesParser.hasCaptureDevices(card);
        int deviceClass = (this.mCardsParser.isCardUsb(card) ? 2 : 1) | Integer.MIN_VALUE;
        if (hasPlayback && this.waitForAlsaDevice(card, device, 1) == null) {
            return null;
        }
        if (hasCapture && this.waitForAlsaDevice(card, device, 2) == null) {
            return null;
        }
        UsbAudioDevice audioDevice = new UsbAudioDevice(card, device, hasPlayback, hasCapture, deviceClass);
        AlsaCardsParser.AlsaCardRecord cardRecord = this.mCardsParser.getCardRecordFor(card);
        audioDevice.mDeviceName = cardRecord.mCardName;
        audioDevice.mDeviceDescription = cardRecord.mCardDescription;
        this.notifyDeviceState(audioDevice, true);
        return audioDevice;
    }

    UsbAudioDevice selectDefaultDevice() {
        return this.selectAudioCard(this.mCardsParser.getDefaultCard());
    }

    void usbDeviceAdded(UsbDevice usbDevice) {
        boolean isAudioDevice = false;
        int interfaceCount = usbDevice.getInterfaceCount();
        for (int ntrfaceIndex = 0; !isAudioDevice && ntrfaceIndex < interfaceCount; ++ntrfaceIndex) {
            UsbInterface ntrface = usbDevice.getInterface(ntrfaceIndex);
            if (ntrface.getInterfaceClass() != 1) continue;
            isAudioDevice = true;
        }
        if (!isAudioDevice) {
            return;
        }
        int addedCard = this.mCardsParser.getDefaultUsbCard();
        if (this.mCardsParser.isCardUsb(addedCard)) {
            int device;
            AlsaDevice alsaDevice;
            boolean hasMidi;
            UsbAudioDevice audioDevice = this.selectAudioCard(addedCard);
            if (audioDevice != null) {
                this.mAudioDevices.put(usbDevice, audioDevice);
                Slog.i(TAG, "USB Audio Device Added: " + audioDevice);
            }
            if ((hasMidi = this.mDevicesParser.hasMIDIDevices(addedCard)) && this.mHasMidiFeature && (alsaDevice = this.waitForAlsaDevice(addedCard, device = this.mDevicesParser.getDefaultDeviceNum(addedCard), 3)) != null) {
                Bundle properties = new Bundle();
                String manufacturer = usbDevice.getManufacturerName();
                String product = usbDevice.getProductName();
                String version = usbDevice.getVersion();
                String name = manufacturer == null || manufacturer.isEmpty() ? product : (product == null || product.isEmpty() ? manufacturer : manufacturer + " " + product);
                properties.putString("name", name);
                properties.putString("manufacturer", manufacturer);
                properties.putString("product", product);
                properties.putString("version", version);
                properties.putString("serial_number", usbDevice.getSerialNumber());
                properties.putInt("alsa_card", alsaDevice.mCard);
                properties.putInt("alsa_device", alsaDevice.mDevice);
                properties.putParcelable("usb_device", usbDevice);
                UsbMidiDevice usbMidiDevice = UsbMidiDevice.create(this.mContext, properties, alsaDevice.mCard, alsaDevice.mDevice);
                if (usbMidiDevice != null) {
                    this.mMidiDevices.put(usbDevice, usbMidiDevice);
                }
            }
        }
    }

    void usbDeviceRemoved(UsbDevice usbDevice) {
        UsbMidiDevice usbMidiDevice;
        UsbAudioDevice audioDevice = this.mAudioDevices.remove(usbDevice);
        Slog.i(TAG, "USB Audio Device Removed: " + audioDevice);
        if (audioDevice != null && (audioDevice.mHasPlayback || audioDevice.mHasCapture)) {
            this.notifyDeviceState(audioDevice, false);
            this.selectDefaultDevice();
        }
        if ((usbMidiDevice = this.mMidiDevices.remove(usbDevice)) != null) {
            IoUtils.closeQuietly(usbMidiDevice);
        }
    }

    void setAccessoryAudioState(boolean enabled, int card, int device) {
        if (enabled) {
            this.mAccessoryAudioDevice = new UsbAudioDevice(card, device, true, false, 2);
            this.notifyDeviceState(this.mAccessoryAudioDevice, true);
        } else if (this.mAccessoryAudioDevice != null) {
            this.notifyDeviceState(this.mAccessoryAudioDevice, false);
            this.mAccessoryAudioDevice = null;
        }
    }

    void setPeripheralMidiState(boolean enabled, int card, int device) {
        if (!this.mHasMidiFeature) {
            return;
        }
        if (enabled && this.mPeripheralMidiDevice == null) {
            Bundle properties = new Bundle();
            Resources r = this.mContext.getResources();
            properties.putString("name", r.getString(17040844));
            properties.putString("manufacturer", r.getString(17040843));
            properties.putString("product", r.getString(17040845));
            properties.putInt("alsa_card", card);
            properties.putInt("alsa_device", device);
            this.mPeripheralMidiDevice = UsbMidiDevice.create(this.mContext, properties, card, device);
        } else if (!enabled && this.mPeripheralMidiDevice != null) {
            IoUtils.closeQuietly(this.mPeripheralMidiDevice);
            this.mPeripheralMidiDevice = null;
        }
    }

    public ArrayList<UsbAudioDevice> getConnectedDevices() {
        ArrayList<UsbAudioDevice> devices = new ArrayList<UsbAudioDevice>(this.mAudioDevices.size());
        for (Map.Entry<UsbDevice, UsbAudioDevice> entry : this.mAudioDevices.entrySet()) {
            devices.add(entry.getValue());
        }
        return devices;
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("USB Audio Devices:");
        for (UsbDevice device : this.mAudioDevices.keySet()) {
            pw.println("  " + device.getDeviceName() + ": " + this.mAudioDevices.get(device));
        }
        pw.println("USB MIDI Devices:");
        for (UsbDevice device : this.mMidiDevices.keySet()) {
            pw.println("  " + device.getDeviceName() + ": " + this.mMidiDevices.get(device));
        }
    }

    public void logDevicesList(String title) {
    }

    public void logDevices(String title) {
    }

    private final class AlsaDevice {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_PLAYBACK = 1;
        public static final int TYPE_CAPTURE = 2;
        public static final int TYPE_MIDI = 3;
        public int mCard;
        public int mDevice;
        public int mType;

        public AlsaDevice(int type, int card, int device) {
            this.mType = type;
            this.mCard = card;
            this.mDevice = device;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlsaDevice)) {
                return false;
            }
            AlsaDevice other = (AlsaDevice)obj;
            return this.mType == other.mType && this.mCard == other.mCard && this.mDevice == other.mDevice;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AlsaDevice: [card: " + this.mCard);
            sb.append(", device: " + this.mDevice);
            sb.append(", type: " + this.mType);
            sb.append("]");
            return sb.toString();
        }
    }
}

