/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.hardware.usb.V1_0.IUsb;
import android.hardware.usb.V1_0.IUsbCallback;
import android.hardware.usb.V1_0.PortRole;
import android.hardware.usb.V1_0.PortStatus;
import android.hidl.manager.V1_0.IServiceManager;
import android.hidl.manager.V1_0.IServiceNotification;
import android.os.Bundle;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.FgThread;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class UsbPortManager {
    private static final String TAG = "UsbPortManager";
    private static final int MSG_UPDATE_PORTS = 1;
    private static final int COMBO_SOURCE_HOST = UsbPort.combineRolesAsBit(1, 1);
    private static final int COMBO_SOURCE_DEVICE = UsbPort.combineRolesAsBit(1, 2);
    private static final int COMBO_SINK_HOST = UsbPort.combineRolesAsBit(2, 1);
    private static final int COMBO_SINK_DEVICE = UsbPort.combineRolesAsBit(2, 2);
    private final Context mContext;
    private IUsb mProxy = null;
    private HALCallback mHALCallback = new HALCallback(null, this);
    private final ServiceNotification mServiceNotification = new ServiceNotification();
    private static final int USB_HAL_DEATH_COOKIE = 1000;
    private static String sSERVICENAME = "usb_hal";
    private static final String PORT_INFO = "port_info";
    private boolean mSystemReady;
    private final Object mLock = new Object();
    private final ArrayMap<String, PortInfo> mPorts = new ArrayMap();
    private final ArrayMap<String, RawPortInfo> mSimulatedPorts = new ArrayMap();
    private final Handler mHandler = new Handler(FgThread.get().getLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Bundle b = msg.getData();
                    ArrayList PortInfo2 = b.getParcelableArrayList(UsbPortManager.PORT_INFO);
                    Object object = UsbPortManager.this.mLock;
                    synchronized (object) {
                        UsbPortManager.this.updatePortsLocked(null, PortInfo2);
                        break;
                    }
                }
            }
        }
    };

    public UsbPortManager(Context context) {
        this.mContext = context;
        try {
            boolean ret = IServiceManager.getService("manager").registerForNotifications("android.hardware.usb@1.0::IUsb", "", this.mServiceNotification);
            if (!ret) {
                UsbPortManager.logAndPrint(6, null, "Failed to register service start notification");
            }
        }
        catch (RemoteException e) {
            UsbPortManager.logAndPrint(6, null, "Failed to register service start notification");
            Thread.dumpStack();
            return;
        }
        this.connectToProxy(null);
    }

    public void systemReady() {
        if (this.mProxy != null) {
            try {
                this.mProxy.queryPortStatus();
            }
            catch (RemoteException e) {
                UsbPortManager.logAndPrint(6, null, "ServiceStart: Failed to query port status");
                Thread.dumpStack();
            }
        }
        this.mSystemReady = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbPort[] getPorts() {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mPorts.size();
            UsbPort[] result = new UsbPort[count];
            for (int i = 0; i < count; ++i) {
                result[i] = this.mPorts.valueAt((int)i).mUsbPort;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbPortStatus getPortStatus(String portId) {
        Object object = this.mLock;
        synchronized (object) {
            PortInfo portInfo = this.mPorts.get(portId);
            return portInfo != null ? portInfo.mUsbPortStatus : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPortRoles(String portId, int newPowerRole, int newDataRole, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int newMode;
            int currentMode;
            int currentPowerRole;
            int currentDataRole;
            block19: {
                block20: {
                    PortInfo portInfo = this.mPorts.get(portId);
                    if (portInfo == null) {
                        if (pw == null) return;
                        pw.println("No such USB port: " + portId);
                        return;
                    }
                    if (!portInfo.mUsbPortStatus.isRoleCombinationSupported(newPowerRole, newDataRole)) {
                        UsbPortManager.logAndPrint(6, pw, "Attempted to set USB port into unsupported role combination: portId=" + portId + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole) + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
                        return;
                    }
                    currentDataRole = portInfo.mUsbPortStatus.getCurrentDataRole();
                    currentPowerRole = portInfo.mUsbPortStatus.getCurrentPowerRole();
                    if (currentDataRole == newDataRole && currentPowerRole == newPowerRole) {
                        if (pw == null) return;
                        pw.println("No change.");
                        return;
                    }
                    boolean canChangeMode = portInfo.mCanChangeMode;
                    boolean canChangePowerRole = portInfo.mCanChangePowerRole;
                    boolean canChangeDataRole = portInfo.mCanChangeDataRole;
                    currentMode = portInfo.mUsbPortStatus.getCurrentMode();
                    if ((canChangePowerRole || currentPowerRole == newPowerRole) && (canChangeDataRole || currentDataRole == newDataRole)) break block20;
                    if (canChangeMode && newPowerRole == 1 && newDataRole == 1) {
                        newMode = 2;
                        break block19;
                    } else if (canChangeMode && newPowerRole == 2 && newDataRole == 2) {
                        newMode = 1;
                        break block19;
                    } else {
                        UsbPortManager.logAndPrint(6, pw, "Found mismatch in supported USB role combinations while attempting to change role: " + portInfo + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole) + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
                        return;
                    }
                }
                newMode = currentMode;
            }
            UsbPortManager.logAndPrint(4, pw, "Setting USB port mode and role: portId=" + portId + ", currentMode=" + UsbPort.modeToString(currentMode) + ", currentPowerRole=" + UsbPort.powerRoleToString(currentPowerRole) + ", currentDataRole=" + UsbPort.dataRoleToString(currentDataRole) + ", newMode=" + UsbPort.modeToString(newMode) + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole) + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
            RawPortInfo sim = this.mSimulatedPorts.get(portId);
            if (sim != null) {
                sim.mCurrentMode = newMode;
                sim.mCurrentPowerRole = newPowerRole;
                sim.mCurrentDataRole = newDataRole;
                this.updatePortsLocked(pw, null);
            } else {
                PortRole newRole;
                if (this.mProxy == null) return;
                if (currentMode != newMode) {
                    UsbPortManager.logAndPrint(6, pw, "Trying to set the USB port mode: portId=" + portId + ", newMode=" + UsbPort.modeToString(newMode));
                    PortRole newRole2 = new PortRole();
                    newRole2.type = 2;
                    newRole2.role = newMode;
                    try {
                        this.mProxy.switchRole(portId, newRole2);
                    }
                    catch (RemoteException e) {
                        UsbPortManager.logAndPrint(6, pw, "Failed to set the USB port mode: portId=" + portId + ", newMode=" + UsbPort.modeToString(newRole2.role));
                        Thread.dumpStack();
                        return;
                    }
                }
                if (currentPowerRole != newPowerRole) {
                    newRole = new PortRole();
                    newRole.type = 1;
                    newRole.role = newPowerRole;
                    try {
                        this.mProxy.switchRole(portId, newRole);
                    }
                    catch (RemoteException e) {
                        UsbPortManager.logAndPrint(6, pw, "Failed to set the USB port power role: portId=" + portId + ", newPowerRole=" + UsbPort.powerRoleToString(newRole.role));
                        Thread.dumpStack();
                        return;
                    }
                }
                if (currentDataRole == newDataRole) return;
                newRole = new PortRole();
                newRole.type = 0;
                newRole.role = newDataRole;
                try {
                    this.mProxy.switchRole(portId, newRole);
                }
                catch (RemoteException e) {
                    UsbPortManager.logAndPrint(6, pw, "Failed to set the USB port data role: portId=" + portId + ", newDataRole=" + UsbPort.dataRoleToString(newRole.role));
                    Thread.dumpStack();
                    return;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimulatedPort(String portId, int supportedModes, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSimulatedPorts.containsKey(portId)) {
                pw.println("Port with same name already exists.  Please remove it first.");
                return;
            }
            pw.println("Adding simulated port: portId=" + portId + ", supportedModes=" + UsbPort.modeToString(supportedModes));
            this.mSimulatedPorts.put(portId, new RawPortInfo(portId, supportedModes));
            this.updatePortsLocked(pw, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectSimulatedPort(String portId, int mode, boolean canChangeMode, int powerRole, boolean canChangePowerRole, int dataRole, boolean canChangeDataRole, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            RawPortInfo portInfo = this.mSimulatedPorts.get(portId);
            if (portInfo == null) {
                pw.println("Cannot connect simulated port which does not exist.");
                return;
            }
            if (mode == 0 || powerRole == 0 || dataRole == 0) {
                pw.println("Cannot connect simulated port in null mode, power role, or data role.");
                return;
            }
            if ((portInfo.mSupportedModes & mode) == 0) {
                pw.println("Simulated port does not support mode: " + UsbPort.modeToString(mode));
                return;
            }
            pw.println("Connecting simulated port: portId=" + portId + ", mode=" + UsbPort.modeToString(mode) + ", canChangeMode=" + canChangeMode + ", powerRole=" + UsbPort.powerRoleToString(powerRole) + ", canChangePowerRole=" + canChangePowerRole + ", dataRole=" + UsbPort.dataRoleToString(dataRole) + ", canChangeDataRole=" + canChangeDataRole);
            portInfo.mCurrentMode = mode;
            portInfo.mCanChangeMode = canChangeMode;
            portInfo.mCurrentPowerRole = powerRole;
            portInfo.mCanChangePowerRole = canChangePowerRole;
            portInfo.mCurrentDataRole = dataRole;
            portInfo.mCanChangeDataRole = canChangeDataRole;
            this.updatePortsLocked(pw, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectSimulatedPort(String portId, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            RawPortInfo portInfo = this.mSimulatedPorts.get(portId);
            if (portInfo == null) {
                pw.println("Cannot disconnect simulated port which does not exist.");
                return;
            }
            pw.println("Disconnecting simulated port: portId=" + portId);
            portInfo.mCurrentMode = 0;
            portInfo.mCanChangeMode = false;
            portInfo.mCurrentPowerRole = 0;
            portInfo.mCanChangePowerRole = false;
            portInfo.mCurrentDataRole = 0;
            portInfo.mCanChangeDataRole = false;
            this.updatePortsLocked(pw, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimulatedPort(String portId, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mSimulatedPorts.indexOfKey(portId);
            if (index < 0) {
                pw.println("Cannot remove simulated port which does not exist.");
                return;
            }
            pw.println("Disconnecting simulated port: portId=" + portId);
            this.mSimulatedPorts.removeAt(index);
            this.updatePortsLocked(pw, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSimulation(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Removing all simulated ports and ending simulation.");
            if (!this.mSimulatedPorts.isEmpty()) {
                this.mSimulatedPorts.clear();
                this.updatePortsLocked(pw, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print("USB Port State:");
            if (!this.mSimulatedPorts.isEmpty()) {
                pw.print(" (simulation active; end with 'dumpsys usb reset')");
            }
            pw.println();
            if (this.mPorts.isEmpty()) {
                pw.println("  <no ports>");
            } else {
                for (PortInfo portInfo : this.mPorts.values()) {
                    pw.println("  " + portInfo.mUsbPort.getId() + ": " + portInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToProxy(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProxy != null) {
                return;
            }
            try {
                this.mProxy = IUsb.getService(sSERVICENAME);
                this.mProxy.linkToDeath(new DeathRecipient(pw), 1000L);
                this.mProxy.setCallback(this.mHALCallback);
                this.mProxy.queryPortStatus();
            }
            catch (NoSuchElementException e) {
                UsbPortManager.logAndPrint(6, pw, sSERVICENAME + "not found." + " Did the service failed to start ?");
                Thread.dumpStack();
            }
            catch (RemoteException e) {
                UsbPortManager.logAndPrint(6, pw, sSERVICENAME + "connectToProxy: Service not responding");
                Thread.dumpStack();
            }
        }
    }

    private void updatePortsLocked(IndentingPrintWriter pw, ArrayList<RawPortInfo> newPortInfo) {
        int i = this.mPorts.size();
        while (i-- > 0) {
            this.mPorts.valueAt((int)i).mDisposition = 3;
        }
        if (!this.mSimulatedPorts.isEmpty()) {
            int count = this.mSimulatedPorts.size();
            for (int i2 = 0; i2 < count; ++i2) {
                RawPortInfo portInfo = this.mSimulatedPorts.valueAt(i2);
                this.addOrUpdatePortLocked(portInfo.mPortId, portInfo.mSupportedModes, portInfo.mCurrentMode, portInfo.mCanChangeMode, portInfo.mCurrentPowerRole, portInfo.mCanChangePowerRole, portInfo.mCurrentDataRole, portInfo.mCanChangeDataRole, pw);
            }
        } else {
            for (RawPortInfo currentPortInfo : newPortInfo) {
                this.addOrUpdatePortLocked(currentPortInfo.mPortId, currentPortInfo.mSupportedModes, currentPortInfo.mCurrentMode, currentPortInfo.mCanChangeMode, currentPortInfo.mCurrentPowerRole, currentPortInfo.mCanChangePowerRole, currentPortInfo.mCurrentDataRole, currentPortInfo.mCanChangeDataRole, pw);
            }
        }
        i = this.mPorts.size();
        while (i-- > 0) {
            PortInfo portInfo = this.mPorts.valueAt(i);
            switch (portInfo.mDisposition) {
                case 0: {
                    this.handlePortAddedLocked(portInfo, pw);
                    portInfo.mDisposition = 2;
                    break;
                }
                case 1: {
                    this.handlePortChangedLocked(portInfo, pw);
                    portInfo.mDisposition = 2;
                    break;
                }
                case 3: {
                    this.mPorts.removeAt(i);
                    portInfo.mUsbPortStatus = null;
                    this.handlePortRemovedLocked(portInfo, pw);
                }
            }
        }
    }

    private void addOrUpdatePortLocked(String portId, int supportedModes, int currentMode, boolean canChangeMode, int currentPowerRole, boolean canChangePowerRole, int currentDataRole, boolean canChangeDataRole, IndentingPrintWriter pw) {
        PortInfo portInfo;
        if (supportedModes != 3) {
            canChangeMode = false;
            if (currentMode != 0 && currentMode != supportedModes) {
                UsbPortManager.logAndPrint(5, pw, "Ignoring inconsistent current mode from USB port driver: supportedModes=" + UsbPort.modeToString(supportedModes) + ", currentMode=" + UsbPort.modeToString(currentMode));
                currentMode = 0;
            }
        }
        int supportedRoleCombinations = UsbPort.combineRolesAsBit(currentPowerRole, currentDataRole);
        if (currentMode != 0 && currentPowerRole != 0 && currentDataRole != 0) {
            if (canChangePowerRole && canChangeDataRole) {
                supportedRoleCombinations |= COMBO_SOURCE_HOST | COMBO_SOURCE_DEVICE | COMBO_SINK_HOST | COMBO_SINK_DEVICE;
            } else if (canChangePowerRole) {
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(1, currentDataRole);
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(2, currentDataRole);
            } else if (canChangeDataRole) {
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(currentPowerRole, 1);
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(currentPowerRole, 2);
            } else if (canChangeMode) {
                supportedRoleCombinations |= COMBO_SOURCE_HOST | COMBO_SINK_DEVICE;
            }
        }
        if ((portInfo = this.mPorts.get(portId)) == null) {
            portInfo = new PortInfo(portId, supportedModes);
            portInfo.setStatus(currentMode, canChangeMode, currentPowerRole, canChangePowerRole, currentDataRole, canChangeDataRole, supportedRoleCombinations);
            this.mPorts.put(portId, portInfo);
        } else {
            if (supportedModes != portInfo.mUsbPort.getSupportedModes()) {
                UsbPortManager.logAndPrint(5, pw, "Ignoring inconsistent list of supported modes from USB port driver (should be immutable): previous=" + UsbPort.modeToString(portInfo.mUsbPort.getSupportedModes()) + ", current=" + UsbPort.modeToString(supportedModes));
            }
            portInfo.mDisposition = portInfo.setStatus(currentMode, canChangeMode, currentPowerRole, canChangePowerRole, currentDataRole, canChangeDataRole, supportedRoleCombinations) ? 1 : 2;
        }
    }

    private void handlePortAddedLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        UsbPortManager.logAndPrint(4, pw, "USB port added: " + portInfo);
        this.sendPortChangedBroadcastLocked(portInfo);
    }

    private void handlePortChangedLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        UsbPortManager.logAndPrint(4, pw, "USB port changed: " + portInfo);
        this.sendPortChangedBroadcastLocked(portInfo);
    }

    private void handlePortRemovedLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        UsbPortManager.logAndPrint(4, pw, "USB port removed: " + portInfo);
        this.sendPortChangedBroadcastLocked(portInfo);
    }

    private void sendPortChangedBroadcastLocked(PortInfo portInfo) {
        final Intent intent = new Intent("android.hardware.usb.action.USB_PORT_CHANGED");
        intent.addFlags(0x11000000);
        intent.putExtra("port", portInfo.mUsbPort);
        intent.putExtra("portStatus", portInfo.mUsbPortStatus);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                UsbPortManager.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            }
        });
    }

    private static void logAndPrint(int priority, IndentingPrintWriter pw, String msg) {
        Slog.println(priority, TAG, msg);
        if (pw != null) {
            pw.println(msg);
        }
    }

    private static final class RawPortInfo
    implements Parcelable {
        public final String mPortId;
        public final int mSupportedModes;
        public int mCurrentMode;
        public boolean mCanChangeMode;
        public int mCurrentPowerRole;
        public boolean mCanChangePowerRole;
        public int mCurrentDataRole;
        public boolean mCanChangeDataRole;
        public static final Parcelable.Creator<RawPortInfo> CREATOR = new Parcelable.Creator<RawPortInfo>(){

            @Override
            public RawPortInfo createFromParcel(Parcel in) {
                String id2 = in.readString();
                int supportedModes = in.readInt();
                int currentMode = in.readInt();
                boolean canChangeMode = in.readByte() != 0;
                int currentPowerRole = in.readInt();
                boolean canChangePowerRole = in.readByte() != 0;
                int currentDataRole = in.readInt();
                boolean canChangeDataRole = in.readByte() != 0;
                return new RawPortInfo(id2, supportedModes, currentMode, canChangeMode, currentPowerRole, canChangePowerRole, currentDataRole, canChangeDataRole);
            }

            public RawPortInfo[] newArray(int size) {
                return new RawPortInfo[size];
            }
        };

        RawPortInfo(String portId, int supportedModes) {
            this.mPortId = portId;
            this.mSupportedModes = supportedModes;
        }

        RawPortInfo(String portId, int supportedModes, int currentMode, boolean canChangeMode, int currentPowerRole, boolean canChangePowerRole, int currentDataRole, boolean canChangeDataRole) {
            this.mPortId = portId;
            this.mSupportedModes = supportedModes;
            this.mCurrentMode = currentMode;
            this.mCanChangeMode = canChangeMode;
            this.mCurrentPowerRole = currentPowerRole;
            this.mCanChangePowerRole = canChangePowerRole;
            this.mCurrentDataRole = currentDataRole;
            this.mCanChangeDataRole = canChangeDataRole;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mPortId);
            dest.writeInt(this.mSupportedModes);
            dest.writeInt(this.mCurrentMode);
            dest.writeByte((byte)(this.mCanChangeMode ? 1 : 0));
            dest.writeInt(this.mCurrentPowerRole);
            dest.writeByte((byte)(this.mCanChangePowerRole ? 1 : 0));
            dest.writeInt(this.mCurrentDataRole);
            dest.writeByte((byte)(this.mCanChangeDataRole ? 1 : 0));
        }
    }

    private static final class PortInfo {
        public static final int DISPOSITION_ADDED = 0;
        public static final int DISPOSITION_CHANGED = 1;
        public static final int DISPOSITION_READY = 2;
        public static final int DISPOSITION_REMOVED = 3;
        public final UsbPort mUsbPort;
        public UsbPortStatus mUsbPortStatus;
        public boolean mCanChangeMode;
        public boolean mCanChangePowerRole;
        public boolean mCanChangeDataRole;
        public int mDisposition;

        public PortInfo(String portId, int supportedModes) {
            this.mUsbPort = new UsbPort(portId, supportedModes);
        }

        public boolean setStatus(int currentMode, boolean canChangeMode, int currentPowerRole, boolean canChangePowerRole, int currentDataRole, boolean canChangeDataRole, int supportedRoleCombinations) {
            this.mCanChangeMode = canChangeMode;
            this.mCanChangePowerRole = canChangePowerRole;
            this.mCanChangeDataRole = canChangeDataRole;
            if (this.mUsbPortStatus == null || this.mUsbPortStatus.getCurrentMode() != currentMode || this.mUsbPortStatus.getCurrentPowerRole() != currentPowerRole || this.mUsbPortStatus.getCurrentDataRole() != currentDataRole || this.mUsbPortStatus.getSupportedRoleCombinations() != supportedRoleCombinations) {
                this.mUsbPortStatus = new UsbPortStatus(currentMode, currentPowerRole, currentDataRole, supportedRoleCombinations);
                return true;
            }
            return false;
        }

        public String toString() {
            return "port=" + this.mUsbPort + ", status=" + this.mUsbPortStatus + ", canChangeMode=" + this.mCanChangeMode + ", canChangePowerRole=" + this.mCanChangePowerRole + ", canChangeDataRole=" + this.mCanChangeDataRole;
        }
    }

    final class ServiceNotification
    extends IServiceNotification.Stub {
        ServiceNotification() {
        }

        @Override
        public void onRegistration(String fqName, String name, boolean preexisting) {
            UsbPortManager.logAndPrint(4, null, "Usb hal service started " + fqName + " " + name);
            UsbPortManager.this.connectToProxy(null);
        }
    }

    final class DeathRecipient
    implements IHwBinder.DeathRecipient {
        public IndentingPrintWriter pw;

        DeathRecipient(IndentingPrintWriter pw) {
            this.pw = pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceDied(long cookie) {
            if (cookie == 1000L) {
                UsbPortManager.logAndPrint(6, this.pw, "Usb hal service died cookie: " + cookie);
                Object object = UsbPortManager.this.mLock;
                synchronized (object) {
                    UsbPortManager.this.mProxy = null;
                }
            }
        }
    }

    private static class HALCallback
    extends IUsbCallback.Stub {
        public IndentingPrintWriter pw;
        public UsbPortManager portManager;

        HALCallback() {
        }

        HALCallback(IndentingPrintWriter pw, UsbPortManager portManager) {
            this.pw = pw;
            this.portManager = portManager;
        }

        @Override
        public void notifyPortStatusChange(ArrayList<PortStatus> currentPortStatus, int retval) {
            if (!this.portManager.mSystemReady) {
                return;
            }
            if (retval != 0) {
                UsbPortManager.logAndPrint(6, this.pw, "port status enquiry failed");
                return;
            }
            ArrayList<RawPortInfo> newPortInfo = new ArrayList<RawPortInfo>();
            for (PortStatus current : currentPortStatus) {
                RawPortInfo temp = new RawPortInfo(current.portName, current.supportedModes, current.currentMode, current.canChangeMode, current.currentPowerRole, current.canChangePowerRole, current.currentDataRole, current.canChangeDataRole);
                newPortInfo.add(temp);
                UsbPortManager.logAndPrint(4, this.pw, "ClientCallback: " + current.portName);
            }
            Message message = this.portManager.mHandler.obtainMessage();
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList(UsbPortManager.PORT_INFO, newPortInfo);
            message.what = 1;
            message.setData(bundle);
            this.portManager.mHandler.sendMessage(message);
        }

        @Override
        public void notifyRoleSwitchStatus(String portName, PortRole role, int retval) {
            if (retval == 0) {
                UsbPortManager.logAndPrint(4, this.pw, portName + "role switch successful");
            } else {
                UsbPortManager.logAndPrint(6, this.pw, portName + "role switch failed");
            }
        }
    }
}

