/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.XmlResourceParser;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.Immutable;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.XmlUtils;
import com.android.server.usb.MtpNotificationManager;
import com.android.server.usb.UsbProfileGroupSettingsManager$$Lambda$1;
import com.android.server.usb.UsbSettingsManager;
import com.android.server.usb.UsbUserSettingsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class UsbProfileGroupSettingsManager {
    private static final String TAG = UsbProfileGroupSettingsManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final File sSingleUserSettingsFile = new File("/data/system/usb_device_manager.xml");
    private final UserHandle mParentUser;
    private final AtomicFile mSettingsFile;
    private final boolean mDisablePermissionDialogs;
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final UserManager mUserManager;
    private final UsbSettingsManager mSettingsManager;
    @GuardedBy(value="mLock")
    private final HashMap<DeviceFilter, UserPackage> mDevicePreferenceMap = new HashMap();
    @GuardedBy(value="mLock")
    private final HashMap<AccessoryFilter, UserPackage> mAccessoryPreferenceMap = new HashMap();
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mIsWriteSettingsScheduled;
    MyPackageMonitor mPackageMonitor = new MyPackageMonitor();
    private final MtpNotificationManager mMtpNotificationManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UsbProfileGroupSettingsManager(Context context, UserHandle user, UsbSettingsManager settingsManager) {
        Context parentUserContext;
        try {
            parentUserContext = context.createPackageContextAsUser("android", 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Missing android package");
        }
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mSettingsManager = settingsManager;
        this.mUserManager = (UserManager)context.getSystemService("user");
        this.mParentUser = user;
        this.mSettingsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(user.getIdentifier()), "usb_device_manager.xml"));
        this.mDisablePermissionDialogs = context.getResources().getBoolean(17956923);
        Object object = this.mLock;
        synchronized (object) {
            if (UserHandle.SYSTEM.equals(user)) {
                this.upgradeSingleUserLocked();
            }
            this.readSettingsLocked();
        }
        this.mPackageMonitor.register(context, null, true);
        this.mMtpNotificationManager = new MtpNotificationManager(parentUserContext, new MtpNotificationManager.OnOpenInAppListener(){

            @Override
            public void onOpenInApp(UsbDevice device) {
                UsbProfileGroupSettingsManager.this.resolveActivity(UsbProfileGroupSettingsManager.createDeviceAttachedIntent(device), device);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllDefaultsForUser(UserHandle userToRemove) {
        Object object = this.mLock;
        synchronized (object) {
            boolean needToPersist = false;
            Iterator<Map.Entry<DeviceFilter, UserPackage>> devicePreferenceIt = this.mDevicePreferenceMap.entrySet().iterator();
            while (devicePreferenceIt.hasNext()) {
                Map.Entry<DeviceFilter, UserPackage> entry = devicePreferenceIt.next();
                if (!entry.getValue().user.equals(userToRemove)) continue;
                devicePreferenceIt.remove();
                needToPersist = true;
            }
            Iterator<Map.Entry<AccessoryFilter, UserPackage>> accessoryPreferenceIt = this.mAccessoryPreferenceMap.entrySet().iterator();
            while (accessoryPreferenceIt.hasNext()) {
                Map.Entry<AccessoryFilter, UserPackage> entry = accessoryPreferenceIt.next();
                if (!entry.getValue().user.equals(userToRemove)) continue;
                accessoryPreferenceIt.remove();
                needToPersist = true;
            }
            if (needToPersist) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    private void readPreference(XmlPullParser parser) throws XmlPullParserException, IOException {
        String packageName = null;
        UserHandle user = this.mParentUser;
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if ("package".equals(parser.getAttributeName(i))) {
                packageName = parser.getAttributeValue(i);
            }
            if (!"user".equals(parser.getAttributeName(i))) continue;
            user = this.mUserManager.getUserForSerialNumber(Integer.parseInt(parser.getAttributeValue(i)));
        }
        XmlUtils.nextElement(parser);
        if ("usb-device".equals(parser.getName())) {
            DeviceFilter filter = DeviceFilter.read(parser);
            if (user != null) {
                this.mDevicePreferenceMap.put(filter, new UserPackage(packageName, user));
            }
        } else if ("usb-accessory".equals(parser.getName())) {
            AccessoryFilter filter = AccessoryFilter.read(parser);
            if (user != null) {
                this.mAccessoryPreferenceMap.put(filter, new UserPackage(packageName, user));
            }
        }
        XmlUtils.nextElement(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void upgradeSingleUserLocked() {
        block8: {
            if (!sSingleUserSettingsFile.exists()) break block8;
            this.mDevicePreferenceMap.clear();
            this.mAccessoryPreferenceMap.clear();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(sSingleUserSettingsFile);
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(fis, StandardCharsets.UTF_8.name());
                XmlUtils.nextElement(parser);
                while (parser.getEventType() != 1) {
                    String tagName = parser.getName();
                    if ("preference".equals(tagName)) {
                        this.readPreference(parser);
                        continue;
                    }
                    XmlUtils.nextElement(parser);
                }
            }
            catch (IOException e) {
                Log.wtf(TAG, "Failed to read single-user settings", e);
                IoUtils.closeQuietly(fis);
            }
            catch (XmlPullParserException e2) {
                Log.wtf(TAG, "Failed to read single-user settings", e2);
                {
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(fis);
            }
            IoUtils.closeQuietly(fis);
            this.scheduleWriteSettingsLocked();
            sSingleUserSettingsFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSettingsLocked() {
        this.mDevicePreferenceMap.clear();
        this.mAccessoryPreferenceMap.clear();
        FileInputStream stream = null;
        try {
            stream = this.mSettingsFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            XmlUtils.nextElement(parser);
            while (parser.getEventType() != 1) {
                String tagName = parser.getName();
                if ("preference".equals(tagName)) {
                    this.readPreference(parser);
                    continue;
                }
                XmlUtils.nextElement(parser);
            }
        }
        catch (FileNotFoundException parser) {
        }
        catch (Exception e) {
            Slog.e(TAG, "error reading settings file, deleting to start fresh", e);
            this.mSettingsFile.delete();
        }
        finally {
            IoUtils.closeQuietly(stream);
        }
    }

    private void scheduleWriteSettingsLocked() {
        if (this.mIsWriteSettingsScheduled) {
            return;
        }
        this.mIsWriteSettingsScheduled = true;
        AsyncTask.execute(UsbProfileGroupSettingsManager$$Lambda$1.get$Lambda(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean packageMatchesLocked(ResolveInfo info, String metaDataName, UsbDevice device, UsbAccessory accessory) {
        if (info.getComponentInfo().name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            return true;
        }
        ActivityInfo ai = info.activityInfo;
        try (XmlResourceParser parser = null;){
            parser = ai.loadXmlMetaData(this.mPackageManager, metaDataName);
            if (parser == null) {
                Slog.w(TAG, "no meta-data for " + info);
                boolean bl = false;
                return bl;
            }
            XmlUtils.nextElement(parser);
            while (parser.getEventType() != 1) {
                Object filter;
                String tagName = parser.getName();
                if (device != null && "usb-device".equals(tagName)) {
                    filter = DeviceFilter.read(parser);
                    if (((DeviceFilter)filter).matches(device)) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (accessory != null && "usb-accessory".equals(tagName) && ((AccessoryFilter)(filter = AccessoryFilter.read(parser))).matches(accessory)) {
                    boolean bl = true;
                    return bl;
                }
                XmlUtils.nextElement(parser);
            }
        }
        return false;
    }

    private ArrayList<ResolveInfo> queryIntentActivitiesForAllProfiles(Intent intent) {
        List<UserInfo> profiles = this.mUserManager.getEnabledProfiles(this.mParentUser.getIdentifier());
        ArrayList<ResolveInfo> resolveInfos = new ArrayList<ResolveInfo>();
        int numProfiles = profiles.size();
        for (int i = 0; i < numProfiles; ++i) {
            resolveInfos.addAll(this.mPackageManager.queryIntentActivitiesAsUser(intent, 128, profiles.get((int)i).id));
        }
        return resolveInfos;
    }

    private ArrayList<ResolveInfo> preferHighPriority(ArrayList<ResolveInfo> matches) {
        SparseArray highestPriorityMatchesByUserId = new SparseArray();
        SparseIntArray highestPriorityByUserId = new SparseIntArray();
        int numMatches = matches.size();
        for (int matchNum = 0; matchNum < numMatches; ++matchNum) {
            ResolveInfo match = matches.get(matchNum);
            if (highestPriorityByUserId.indexOfKey(match.targetUserId) < 0) {
                highestPriorityByUserId.put(match.targetUserId, Integer.MIN_VALUE);
                highestPriorityMatchesByUserId.put(match.targetUserId, new ArrayList());
            }
            int highestPriority = highestPriorityByUserId.get(match.targetUserId);
            ArrayList highestPriorityMatches = (ArrayList)highestPriorityMatchesByUserId.get(match.targetUserId);
            if (match.priority == highestPriority) {
                highestPriorityMatches.add(match);
                continue;
            }
            if (match.priority <= highestPriority) continue;
            highestPriorityByUserId.put(match.targetUserId, match.priority);
            highestPriorityMatches.clear();
            highestPriorityMatches.add(match);
        }
        ArrayList<ResolveInfo> combinedMatches = new ArrayList<ResolveInfo>();
        int numMatchArrays = highestPriorityMatchesByUserId.size();
        for (int matchArrayNum = 0; matchArrayNum < numMatchArrays; ++matchArrayNum) {
            combinedMatches.addAll((Collection)highestPriorityMatchesByUserId.valueAt(matchArrayNum));
        }
        return combinedMatches;
    }

    private final ArrayList<ResolveInfo> getDeviceMatchesLocked(UsbDevice device, Intent intent) {
        ArrayList<ResolveInfo> matches = new ArrayList<ResolveInfo>();
        ArrayList<ResolveInfo> resolveInfos = this.queryIntentActivitiesForAllProfiles(intent);
        int count = resolveInfos.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(i);
            if (!this.packageMatchesLocked(resolveInfo, intent.getAction(), device, null)) continue;
            matches.add(resolveInfo);
        }
        return this.preferHighPriority(matches);
    }

    private final ArrayList<ResolveInfo> getAccessoryMatchesLocked(UsbAccessory accessory, Intent intent) {
        ArrayList<ResolveInfo> matches = new ArrayList<ResolveInfo>();
        ArrayList<ResolveInfo> resolveInfos = this.queryIntentActivitiesForAllProfiles(intent);
        int count = resolveInfos.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(i);
            if (!this.packageMatchesLocked(resolveInfo, intent.getAction(), null, accessory)) continue;
            matches.add(resolveInfo);
        }
        return this.preferHighPriority(matches);
    }

    public void deviceAttached(UsbDevice device) {
        Intent intent = UsbProfileGroupSettingsManager.createDeviceAttachedIntent(device);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        if (MtpNotificationManager.shouldShowNotification(this.mPackageManager, device)) {
            this.mMtpNotificationManager.showNotification(device);
        } else {
            this.resolveActivity(intent, device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveActivity(Intent intent, UsbDevice device) {
        ArrayList<ResolveInfo> matches;
        String defaultPackage = null;
        UserHandle user = null;
        Object object = this.mLock;
        synchronized (object) {
            matches = this.getDeviceMatchesLocked(device, intent);
            UserPackage userPackage = this.mDevicePreferenceMap.get(new DeviceFilter(device));
            if (userPackage != null) {
                defaultPackage = userPackage.packageName;
                user = userPackage.user;
            }
        }
        this.resolveActivity(intent, matches, defaultPackage, user, device, null);
    }

    public void deviceAttachedForFixedHandler(UsbDevice device, ComponentName component) {
        ApplicationInfo appInfo;
        Intent intent = UsbProfileGroupSettingsManager.createDeviceAttachedIntent(device);
        this.mContext.sendBroadcast(intent);
        try {
            appInfo = this.mPackageManager.getApplicationInfo(component.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Default USB handling package not found: " + component.getPackageName());
            return;
        }
        this.mSettingsManager.getSettingsForUser(UserHandle.getUserId(appInfo.uid)).grantDevicePermission(device, appInfo.uid);
        Intent activityIntent = new Intent(intent);
        activityIntent.setComponent(component);
        try {
            this.mContext.startActivityAsUser(activityIntent, this.mParentUser);
        }
        catch (ActivityNotFoundException e) {
            Slog.e(TAG, "unable to start activity " + activityIntent);
        }
    }

    void usbDeviceRemoved(UsbDevice device) {
        this.mMtpNotificationManager.hideNotification(device.getDeviceId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessoryAttached(UsbAccessory accessory) {
        ArrayList<ResolveInfo> matches;
        Intent intent = new Intent("android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
        intent.putExtra("accessory", accessory);
        intent.addFlags(0x11000000);
        String defaultPackage = null;
        UserHandle user = null;
        Object object = this.mLock;
        synchronized (object) {
            matches = this.getAccessoryMatchesLocked(accessory, intent);
            UserPackage userPackage = this.mAccessoryPreferenceMap.get(new AccessoryFilter(accessory));
            if (userPackage != null) {
                defaultPackage = userPackage.packageName;
                user = userPackage.user;
            }
        }
        this.resolveActivity(intent, matches, defaultPackage, user, null, accessory);
    }

    private void resolveActivity(Intent intent, ArrayList<ResolveInfo> matches, String defaultPackage, UserHandle defaultUser, UsbDevice device, UsbAccessory accessory) {
        UserHandle user;
        int count = matches.size();
        if (count == 0) {
            String uri;
            if (accessory != null && (uri = accessory.getUri()) != null && uri.length() > 0) {
                Intent dialogIntent = new Intent();
                dialogIntent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbAccessoryUriActivity");
                dialogIntent.addFlags(0x10000000);
                dialogIntent.putExtra("accessory", accessory);
                dialogIntent.putExtra("uri", uri);
                try {
                    this.mContext.startActivityAsUser(dialogIntent, this.mParentUser);
                }
                catch (ActivityNotFoundException e) {
                    Slog.e(TAG, "unable to start UsbAccessoryUriActivity");
                }
            }
            return;
        }
        ResolveInfo defaultRI = null;
        if (count == 1 && defaultPackage == null) {
            ResolveInfo rInfo = matches.get(0);
            if (rInfo.activityInfo != null && rInfo.activityInfo.applicationInfo != null && (rInfo.activityInfo.applicationInfo.flags & 1) != 0) {
                defaultRI = rInfo;
            }
            if (this.mDisablePermissionDialogs) {
                rInfo = matches.get(0);
                if (rInfo.activityInfo != null) {
                    defaultPackage = rInfo.activityInfo.packageName;
                    defaultUser = UserHandle.getUserHandleForUid(rInfo.activityInfo.applicationInfo.uid);
                }
            }
        }
        if (defaultRI == null && defaultPackage != null) {
            for (int i = 0; i < count; ++i) {
                ResolveInfo rInfo = matches.get(i);
                if (rInfo.activityInfo == null || !defaultPackage.equals(rInfo.activityInfo.packageName) || defaultUser.getIdentifier() != UserHandle.getUserId(rInfo.activityInfo.applicationInfo.uid)) continue;
                defaultRI = rInfo;
                break;
            }
        }
        if (defaultRI != null) {
            UsbUserSettingsManager defaultRIUserSettings = this.mSettingsManager.getSettingsForUser(UserHandle.getUserId(defaultRI.activityInfo.applicationInfo.uid));
            if (device != null) {
                defaultRIUserSettings.grantDevicePermission(device, defaultRI.activityInfo.applicationInfo.uid);
            } else if (accessory != null) {
                defaultRIUserSettings.grantAccessoryPermission(accessory, defaultRI.activityInfo.applicationInfo.uid);
            }
            try {
                intent.setComponent(new ComponentName(defaultRI.activityInfo.packageName, defaultRI.activityInfo.name));
                user = UserHandle.getUserHandleForUid(defaultRI.activityInfo.applicationInfo.uid);
                this.mContext.startActivityAsUser(intent, user);
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "startActivity failed", e);
            }
        } else {
            Intent resolverIntent = new Intent();
            resolverIntent.addFlags(0x10000000);
            if (count == 1) {
                ResolveInfo rInfo = matches.get(0);
                resolverIntent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbConfirmActivity");
                resolverIntent.putExtra("rinfo", rInfo);
                user = UserHandle.getUserHandleForUid(rInfo.activityInfo.applicationInfo.uid);
                if (device != null) {
                    resolverIntent.putExtra("device", device);
                } else {
                    resolverIntent.putExtra("accessory", accessory);
                }
            } else {
                user = this.mParentUser;
                resolverIntent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbResolverActivity");
                resolverIntent.putParcelableArrayListExtra("rlist", matches);
                resolverIntent.putExtra("android.intent.extra.INTENT", intent);
            }
            try {
                this.mContext.startActivityAsUser(resolverIntent, user);
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "unable to start activity " + resolverIntent, e);
            }
        }
    }

    private boolean clearCompatibleMatchesLocked(String packageName, DeviceFilter filter) {
        boolean changed = false;
        for (DeviceFilter test : this.mDevicePreferenceMap.keySet()) {
            if (!filter.matches(test)) continue;
            this.mDevicePreferenceMap.remove(test);
            changed = true;
        }
        return changed;
    }

    private boolean clearCompatibleMatchesLocked(String packageName, AccessoryFilter filter) {
        boolean changed = false;
        for (AccessoryFilter test : this.mAccessoryPreferenceMap.keySet()) {
            if (!filter.matches(test)) continue;
            this.mAccessoryPreferenceMap.remove(test);
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlePackageUpdateLocked(String packageName, ActivityInfo aInfo, String metaDataName) {
        boolean changed = false;
        try (XmlResourceParser parser = null;){
            parser = aInfo.loadXmlMetaData(this.mPackageManager, metaDataName);
            if (parser == null) {
                boolean bl = false;
                return bl;
            }
            XmlUtils.nextElement(parser);
            while (parser.getEventType() != 1) {
                Object filter;
                String tagName = parser.getName();
                if ("usb-device".equals(tagName)) {
                    filter = DeviceFilter.read(parser);
                    if (this.clearCompatibleMatchesLocked(packageName, (DeviceFilter)filter)) {
                        changed = true;
                    }
                } else if ("usb-accessory".equals(tagName) && this.clearCompatibleMatchesLocked(packageName, (AccessoryFilter)(filter = AccessoryFilter.read(parser)))) {
                    changed = true;
                }
                XmlUtils.nextElement(parser);
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackageUpdate(String packageName) {
        Object object = this.mLock;
        synchronized (object) {
            PackageInfo info;
            boolean changed = false;
            try {
                info = this.mPackageManager.getPackageInfo(packageName, 129);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.e(TAG, "handlePackageUpdate could not find package " + packageName, e);
                return;
            }
            ActivityInfo[] activities = info.activities;
            if (activities == null) {
                return;
            }
            for (int i = 0; i < activities.length; ++i) {
                if (this.handlePackageUpdateLocked(packageName, activities[i], "android.hardware.usb.action.USB_DEVICE_ATTACHED")) {
                    changed = true;
                }
                if (!this.handlePackageUpdateLocked(packageName, activities[i], "android.hardware.usb.action.USB_ACCESSORY_ATTACHED")) continue;
                changed = true;
            }
            if (changed) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    private int getSerial(UserHandle user) {
        return this.mUserManager.getUserSerialNumber(user.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDevicePackage(UsbDevice device, String packageName, UserHandle user) {
        DeviceFilter filter = new DeviceFilter(device);
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (packageName == null) {
                changed = this.mDevicePreferenceMap.remove(filter) != null;
            } else {
                boolean bl = changed = !packageName.equals(this.mDevicePreferenceMap.get(filter));
                if (changed) {
                    this.mDevicePreferenceMap.put(filter, new UserPackage(packageName, user));
                }
            }
            if (changed) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAccessoryPackage(UsbAccessory accessory, String packageName, UserHandle user) {
        AccessoryFilter filter = new AccessoryFilter(accessory);
        boolean changed = false;
        Object object = this.mLock;
        synchronized (object) {
            if (packageName == null) {
                changed = this.mAccessoryPreferenceMap.remove(filter) != null;
            } else {
                boolean bl = changed = !packageName.equals(this.mAccessoryPreferenceMap.get(filter));
                if (changed) {
                    this.mAccessoryPreferenceMap.put(filter, new UserPackage(packageName, user));
                }
            }
            if (changed) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasDefaults(String packageName, UserHandle user) {
        UserPackage userPackage = new UserPackage(packageName, user);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDevicePreferenceMap.values().contains(userPackage)) {
                return true;
            }
            return this.mAccessoryPreferenceMap.values().contains(userPackage);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDefaults(String packageName, UserHandle user) {
        UserPackage userPackage = new UserPackage(packageName, user);
        Object object = this.mLock;
        synchronized (object) {
            if (this.clearPackageDefaultsLocked(userPackage)) {
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearPackageDefaultsLocked(UserPackage userPackage) {
        boolean cleared = false;
        Object object = this.mLock;
        synchronized (object) {
            Object key;
            int i;
            Object[] keys;
            if (this.mDevicePreferenceMap.containsValue(userPackage)) {
                keys = this.mDevicePreferenceMap.keySet().toArray();
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!userPackage.equals(this.mDevicePreferenceMap.get(key))) continue;
                    this.mDevicePreferenceMap.remove(key);
                    cleared = true;
                }
            }
            if (this.mAccessoryPreferenceMap.containsValue(userPackage)) {
                keys = this.mAccessoryPreferenceMap.keySet().toArray();
                for (i = 0; i < keys.length; ++i) {
                    key = keys[i];
                    if (!userPackage.equals(this.mAccessoryPreferenceMap.get(key))) continue;
                    this.mAccessoryPreferenceMap.remove(key);
                    cleared = true;
                }
            }
            return cleared;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Device preferences:");
            for (DeviceFilter deviceFilter : this.mDevicePreferenceMap.keySet()) {
                pw.println("  " + deviceFilter + ": " + this.mDevicePreferenceMap.get(deviceFilter));
            }
            pw.println("Accessory preferences:");
            for (AccessoryFilter accessoryFilter : this.mAccessoryPreferenceMap.keySet()) {
                pw.println("  " + accessoryFilter + ": " + this.mAccessoryPreferenceMap.get(accessoryFilter));
            }
        }
    }

    private static Intent createDeviceAttachedIntent(UsbDevice device) {
        Intent intent = new Intent("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intent.putExtra("device", device);
        intent.addFlags(0x11000000);
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$scheduleWriteSettingsLocked$0$UsbProfileGroupSettingsManager() {
        Object object = this.mLock;
        synchronized (object) {
            block7: {
                FileOutputStream fos = null;
                try {
                    fos = this.mSettingsFile.startWrite();
                    FastXmlSerializer serializer = new FastXmlSerializer();
                    serializer.setOutput(fos, StandardCharsets.UTF_8.name());
                    serializer.startDocument(null, true);
                    serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                    serializer.startTag(null, "settings");
                    for (DeviceFilter deviceFilter : this.mDevicePreferenceMap.keySet()) {
                        serializer.startTag(null, "preference");
                        serializer.attribute(null, "package", this.mDevicePreferenceMap.get((Object)deviceFilter).packageName);
                        serializer.attribute(null, "user", String.valueOf(this.getSerial(this.mDevicePreferenceMap.get((Object)deviceFilter).user)));
                        deviceFilter.write(serializer);
                        serializer.endTag(null, "preference");
                    }
                    for (AccessoryFilter accessoryFilter : this.mAccessoryPreferenceMap.keySet()) {
                        serializer.startTag(null, "preference");
                        serializer.attribute(null, "package", this.mAccessoryPreferenceMap.get((Object)accessoryFilter).packageName);
                        serializer.attribute(null, "user", String.valueOf(this.getSerial(this.mAccessoryPreferenceMap.get((Object)accessoryFilter).user)));
                        accessoryFilter.write(serializer);
                        serializer.endTag(null, "preference");
                    }
                    serializer.endTag(null, "settings");
                    serializer.endDocument();
                    this.mSettingsFile.finishWrite(fos);
                }
                catch (IOException e) {
                    Slog.e(TAG, "Failed to write settings", e);
                    if (fos == null) break block7;
                    this.mSettingsFile.failWrite(fos);
                }
            }
            this.mIsWriteSettingsScheduled = false;
        }
    }

    private class MyPackageMonitor
    extends PackageMonitor {
        private MyPackageMonitor() {
        }

        @Override
        public void onPackageAdded(String packageName, int uid) {
            UsbProfileGroupSettingsManager.this.handlePackageUpdate(packageName);
        }

        @Override
        public boolean onPackageChanged(String packageName, int uid, String[] components) {
            UsbProfileGroupSettingsManager.this.handlePackageUpdate(packageName);
            return false;
        }

        @Override
        public void onPackageRemoved(String packageName, int uid) {
            UsbProfileGroupSettingsManager.this.clearDefaults(packageName, UserHandle.getUserHandleForUid(uid));
        }
    }

    private static class AccessoryFilter {
        public final String mManufacturer;
        public final String mModel;
        public final String mVersion;

        public AccessoryFilter(String manufacturer, String model, String version) {
            this.mManufacturer = manufacturer;
            this.mModel = model;
            this.mVersion = version;
        }

        public AccessoryFilter(UsbAccessory accessory) {
            this.mManufacturer = accessory.getManufacturer();
            this.mModel = accessory.getModel();
            this.mVersion = accessory.getVersion();
        }

        public static AccessoryFilter read(XmlPullParser parser) throws XmlPullParserException, IOException {
            String manufacturer = null;
            String model = null;
            String version = null;
            int count = parser.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                String name = parser.getAttributeName(i);
                String value = parser.getAttributeValue(i);
                if ("manufacturer".equals(name)) {
                    manufacturer = value;
                    continue;
                }
                if ("model".equals(name)) {
                    model = value;
                    continue;
                }
                if (!"version".equals(name)) continue;
                version = value;
            }
            return new AccessoryFilter(manufacturer, model, version);
        }

        public void write(XmlSerializer serializer) throws IOException {
            serializer.startTag(null, "usb-accessory");
            if (this.mManufacturer != null) {
                serializer.attribute(null, "manufacturer", this.mManufacturer);
            }
            if (this.mModel != null) {
                serializer.attribute(null, "model", this.mModel);
            }
            if (this.mVersion != null) {
                serializer.attribute(null, "version", this.mVersion);
            }
            serializer.endTag(null, "usb-accessory");
        }

        public boolean matches(UsbAccessory acc) {
            if (this.mManufacturer != null && !acc.getManufacturer().equals(this.mManufacturer)) {
                return false;
            }
            if (this.mModel != null && !acc.getModel().equals(this.mModel)) {
                return false;
            }
            return this.mVersion == null || acc.getVersion().equals(this.mVersion);
        }

        public boolean matches(AccessoryFilter f) {
            if (this.mManufacturer != null && !f.mManufacturer.equals(this.mManufacturer)) {
                return false;
            }
            if (this.mModel != null && !f.mModel.equals(this.mModel)) {
                return false;
            }
            return this.mVersion == null || f.mVersion.equals(this.mVersion);
        }

        public boolean equals(Object obj) {
            if (this.mManufacturer == null || this.mModel == null || this.mVersion == null) {
                return false;
            }
            if (obj instanceof AccessoryFilter) {
                AccessoryFilter filter = (AccessoryFilter)obj;
                return this.mManufacturer.equals(filter.mManufacturer) && this.mModel.equals(filter.mModel) && this.mVersion.equals(filter.mVersion);
            }
            if (obj instanceof UsbAccessory) {
                UsbAccessory accessory = (UsbAccessory)obj;
                return this.mManufacturer.equals(accessory.getManufacturer()) && this.mModel.equals(accessory.getModel()) && this.mVersion.equals(accessory.getVersion());
            }
            return false;
        }

        public int hashCode() {
            return (this.mManufacturer == null ? 0 : this.mManufacturer.hashCode()) ^ (this.mModel == null ? 0 : this.mModel.hashCode()) ^ (this.mVersion == null ? 0 : this.mVersion.hashCode());
        }

        public String toString() {
            return "AccessoryFilter[mManufacturer=\"" + this.mManufacturer + "\", mModel=\"" + this.mModel + "\", mVersion=\"" + this.mVersion + "\"]";
        }
    }

    private static class DeviceFilter {
        public final int mVendorId;
        public final int mProductId;
        public final int mClass;
        public final int mSubclass;
        public final int mProtocol;
        public final String mManufacturerName;
        public final String mProductName;
        public final String mSerialNumber;

        public DeviceFilter(int vid, int pid, int clasz, int subclass, int protocol, String manufacturer, String product, String serialnum) {
            this.mVendorId = vid;
            this.mProductId = pid;
            this.mClass = clasz;
            this.mSubclass = subclass;
            this.mProtocol = protocol;
            this.mManufacturerName = manufacturer;
            this.mProductName = product;
            this.mSerialNumber = serialnum;
        }

        public DeviceFilter(UsbDevice device) {
            this.mVendorId = device.getVendorId();
            this.mProductId = device.getProductId();
            this.mClass = device.getDeviceClass();
            this.mSubclass = device.getDeviceSubclass();
            this.mProtocol = device.getDeviceProtocol();
            this.mManufacturerName = device.getManufacturerName();
            this.mProductName = device.getProductName();
            this.mSerialNumber = device.getSerialNumber();
        }

        public static DeviceFilter read(XmlPullParser parser) throws XmlPullParserException, IOException {
            int vendorId = -1;
            int productId = -1;
            int deviceClass = -1;
            int deviceSubclass = -1;
            int deviceProtocol = -1;
            String manufacturerName = null;
            String productName = null;
            String serialNumber = null;
            int count = parser.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                String name = parser.getAttributeName(i);
                String value = parser.getAttributeValue(i);
                if ("manufacturer-name".equals(name)) {
                    manufacturerName = value;
                    continue;
                }
                if ("product-name".equals(name)) {
                    productName = value;
                    continue;
                }
                if ("serial-number".equals(name)) {
                    serialNumber = value;
                    continue;
                }
                int intValue = -1;
                int radix = 10;
                if (value != null && value.length() > 2 && value.charAt(0) == '0' && (value.charAt(1) == 'x' || value.charAt(1) == 'X')) {
                    radix = 16;
                    value = value.substring(2);
                }
                try {
                    intValue = Integer.parseInt(value, radix);
                }
                catch (NumberFormatException e) {
                    Slog.e(TAG, "invalid number for field " + name, e);
                    continue;
                }
                if ("vendor-id".equals(name)) {
                    vendorId = intValue;
                    continue;
                }
                if ("product-id".equals(name)) {
                    productId = intValue;
                    continue;
                }
                if ("class".equals(name)) {
                    deviceClass = intValue;
                    continue;
                }
                if ("subclass".equals(name)) {
                    deviceSubclass = intValue;
                    continue;
                }
                if (!"protocol".equals(name)) continue;
                deviceProtocol = intValue;
            }
            return new DeviceFilter(vendorId, productId, deviceClass, deviceSubclass, deviceProtocol, manufacturerName, productName, serialNumber);
        }

        public void write(XmlSerializer serializer) throws IOException {
            serializer.startTag(null, "usb-device");
            if (this.mVendorId != -1) {
                serializer.attribute(null, "vendor-id", Integer.toString(this.mVendorId));
            }
            if (this.mProductId != -1) {
                serializer.attribute(null, "product-id", Integer.toString(this.mProductId));
            }
            if (this.mClass != -1) {
                serializer.attribute(null, "class", Integer.toString(this.mClass));
            }
            if (this.mSubclass != -1) {
                serializer.attribute(null, "subclass", Integer.toString(this.mSubclass));
            }
            if (this.mProtocol != -1) {
                serializer.attribute(null, "protocol", Integer.toString(this.mProtocol));
            }
            if (this.mManufacturerName != null) {
                serializer.attribute(null, "manufacturer-name", this.mManufacturerName);
            }
            if (this.mProductName != null) {
                serializer.attribute(null, "product-name", this.mProductName);
            }
            if (this.mSerialNumber != null) {
                serializer.attribute(null, "serial-number", this.mSerialNumber);
            }
            serializer.endTag(null, "usb-device");
        }

        private boolean matches(int clasz, int subclass, int protocol) {
            return !(this.mClass != -1 && clasz != this.mClass || this.mSubclass != -1 && subclass != this.mSubclass || this.mProtocol != -1 && protocol != this.mProtocol);
        }

        public boolean matches(UsbDevice device) {
            if (this.mVendorId != -1 && device.getVendorId() != this.mVendorId) {
                return false;
            }
            if (this.mProductId != -1 && device.getProductId() != this.mProductId) {
                return false;
            }
            if (this.mManufacturerName != null && device.getManufacturerName() == null) {
                return false;
            }
            if (this.mProductName != null && device.getProductName() == null) {
                return false;
            }
            if (this.mSerialNumber != null && device.getSerialNumber() == null) {
                return false;
            }
            if (this.mManufacturerName != null && device.getManufacturerName() != null && !this.mManufacturerName.equals(device.getManufacturerName())) {
                return false;
            }
            if (this.mProductName != null && device.getProductName() != null && !this.mProductName.equals(device.getProductName())) {
                return false;
            }
            if (this.mSerialNumber != null && device.getSerialNumber() != null && !this.mSerialNumber.equals(device.getSerialNumber())) {
                return false;
            }
            if (this.matches(device.getDeviceClass(), device.getDeviceSubclass(), device.getDeviceProtocol())) {
                return true;
            }
            int count = device.getInterfaceCount();
            for (int i = 0; i < count; ++i) {
                UsbInterface intf = device.getInterface(i);
                if (!this.matches(intf.getInterfaceClass(), intf.getInterfaceSubclass(), intf.getInterfaceProtocol())) continue;
                return true;
            }
            return false;
        }

        public boolean matches(DeviceFilter f) {
            if (this.mVendorId != -1 && f.mVendorId != this.mVendorId) {
                return false;
            }
            if (this.mProductId != -1 && f.mProductId != this.mProductId) {
                return false;
            }
            if (f.mManufacturerName != null && this.mManufacturerName == null) {
                return false;
            }
            if (f.mProductName != null && this.mProductName == null) {
                return false;
            }
            if (f.mSerialNumber != null && this.mSerialNumber == null) {
                return false;
            }
            if (this.mManufacturerName != null && f.mManufacturerName != null && !this.mManufacturerName.equals(f.mManufacturerName)) {
                return false;
            }
            if (this.mProductName != null && f.mProductName != null && !this.mProductName.equals(f.mProductName)) {
                return false;
            }
            if (this.mSerialNumber != null && f.mSerialNumber != null && !this.mSerialNumber.equals(f.mSerialNumber)) {
                return false;
            }
            return this.matches(f.mClass, f.mSubclass, f.mProtocol);
        }

        public boolean equals(Object obj) {
            if (this.mVendorId == -1 || this.mProductId == -1 || this.mClass == -1 || this.mSubclass == -1 || this.mProtocol == -1) {
                return false;
            }
            if (obj instanceof DeviceFilter) {
                DeviceFilter filter = (DeviceFilter)obj;
                if (filter.mVendorId != this.mVendorId || filter.mProductId != this.mProductId || filter.mClass != this.mClass || filter.mSubclass != this.mSubclass || filter.mProtocol != this.mProtocol) {
                    return false;
                }
                if (filter.mManufacturerName != null && this.mManufacturerName == null || filter.mManufacturerName == null && this.mManufacturerName != null || filter.mProductName != null && this.mProductName == null || filter.mProductName == null && this.mProductName != null || filter.mSerialNumber != null && this.mSerialNumber == null || filter.mSerialNumber == null && this.mSerialNumber != null) {
                    return false;
                }
                return !(filter.mManufacturerName != null && this.mManufacturerName != null && !this.mManufacturerName.equals(filter.mManufacturerName) || filter.mProductName != null && this.mProductName != null && !this.mProductName.equals(filter.mProductName)) && (filter.mSerialNumber == null || this.mSerialNumber == null || this.mSerialNumber.equals(filter.mSerialNumber));
            }
            if (obj instanceof UsbDevice) {
                UsbDevice device = (UsbDevice)obj;
                if (device.getVendorId() != this.mVendorId || device.getProductId() != this.mProductId || device.getDeviceClass() != this.mClass || device.getDeviceSubclass() != this.mSubclass || device.getDeviceProtocol() != this.mProtocol) {
                    return false;
                }
                if (this.mManufacturerName != null && device.getManufacturerName() == null || this.mManufacturerName == null && device.getManufacturerName() != null || this.mProductName != null && device.getProductName() == null || this.mProductName == null && device.getProductName() != null || this.mSerialNumber != null && device.getSerialNumber() == null || this.mSerialNumber == null && device.getSerialNumber() != null) {
                    return false;
                }
                return !(device.getManufacturerName() != null && !this.mManufacturerName.equals(device.getManufacturerName()) || device.getProductName() != null && !this.mProductName.equals(device.getProductName())) && (device.getSerialNumber() == null || this.mSerialNumber.equals(device.getSerialNumber()));
            }
            return false;
        }

        public int hashCode() {
            return (this.mVendorId << 16 | this.mProductId) ^ (this.mClass << 16 | this.mSubclass << 8 | this.mProtocol);
        }

        public String toString() {
            return "DeviceFilter[mVendorId=" + this.mVendorId + ",mProductId=" + this.mProductId + ",mClass=" + this.mClass + ",mSubclass=" + this.mSubclass + ",mProtocol=" + this.mProtocol + ",mManufacturerName=" + this.mManufacturerName + ",mProductName=" + this.mProductName + ",mSerialNumber=" + this.mSerialNumber + "]";
        }
    }

    @Immutable
    private static class UserPackage {
        final UserHandle user;
        final String packageName;

        private UserPackage(String packageName, UserHandle user) {
            this.packageName = packageName;
            this.user = user;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UserPackage)) {
                return false;
            }
            UserPackage other = (UserPackage)obj;
            return this.user.equals(this.user) && this.packageName.equals(other.packageName);
        }

        public int hashCode() {
            int result = this.user.hashCode();
            result = 31 * result + this.packageName.hashCode();
            return result;
        }

        public String toString() {
            return this.user.getIdentifier() + "/" + this.packageName;
        }
    }
}

