/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.vr;

import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.Log;

class CompatibilityDisplay {
    private static final String TAG = "CompatDisplay";
    private static final boolean DEBUG = false;
    private static final int HEIGHT = 960;
    private static final int WIDTH = 720;
    private static final int DPI = 320;
    private final DisplayManager mDisplayManager;
    private final IVrManager mVrManager;
    private final Object vdLock = new Object();
    private final IVrStateCallbacks mVrStateCallbacks = new IVrStateCallbacks.Stub(){

        @Override
        public void onVrStateChanged(boolean enabled) {
            if (enabled != CompatibilityDisplay.this.mIsVrModeEnabled) {
                CompatibilityDisplay.this.mIsVrModeEnabled = enabled;
                if (enabled) {
                    CompatibilityDisplay.this.startVirtualDisplay();
                } else {
                    CompatibilityDisplay.this.stopVirtualDisplay();
                }
            }
        }
    };
    private VirtualDisplay mVirtualDisplay;
    private boolean mIsVrModeEnabled;

    public CompatibilityDisplay(DisplayManager displayManager, IVrManager vrManager) {
        this.mDisplayManager = displayManager;
        this.mVrManager = vrManager;
    }

    public void init() {
        this.startVrModeListener();
    }

    private void startVrModeListener() {
        if (this.mVrManager != null) {
            try {
                this.mVrManager.registerListener(this.mVrStateCallbacks);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Could not register VR State listener.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startVirtualDisplay() {
        if (this.mDisplayManager == null) {
            Log.w(TAG, "Cannot create virtual display because mDisplayManager == null");
            return;
        }
        Object object = this.vdLock;
        synchronized (object) {
            if (this.mVirtualDisplay != null) {
                Log.e(TAG, "Starting the virtual display when one already exists", new Exception());
                return;
            }
            this.mVirtualDisplay = this.mDisplayManager.createVirtualDisplay("VR 2D Display", 720, 960, 320, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopVirtualDisplay() {
        Object object = this.vdLock;
        synchronized (object) {
            if (this.mVirtualDisplay != null) {
                this.mVirtualDisplay.release();
                this.mVirtualDisplay = null;
            }
        }
    }
}

