/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.webkit;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Slog;
import android.webkit.UserPackage;
import android.webkit.WebViewFactory;
import android.webkit.WebViewProviderInfo;
import android.webkit.WebViewProviderResponse;
import com.android.server.webkit.SystemInterface;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WebViewUpdateServiceImpl {
    private static final String TAG = WebViewUpdateServiceImpl.class.getSimpleName();
    private SystemInterface mSystemInterface;
    private WebViewUpdater mWebViewUpdater;
    private final Context mContext;

    public WebViewUpdateServiceImpl(Context context, SystemInterface systemInterface) {
        this.mContext = context;
        this.mSystemInterface = systemInterface;
        this.mWebViewUpdater = new WebViewUpdater(this.mContext, this.mSystemInterface);
    }

    void packageStateChanged(String packageName, int changedState, int userId) {
        this.updateFallbackStateOnPackageChange(packageName, changedState);
        this.mWebViewUpdater.packageStateChanged(packageName, changedState);
    }

    void prepareWebViewInSystemServer() {
        this.updateFallbackStateOnBoot();
        this.mWebViewUpdater.prepareWebViewInSystemServer();
        this.mSystemInterface.notifyZygote(this.isMultiProcessEnabled());
    }

    private boolean existsValidNonFallbackProvider(WebViewProviderInfo[] providers) {
        for (WebViewProviderInfo provider : providers) {
            List<UserPackage> userPackages;
            if (!provider.availableByDefault || provider.isFallback || !WebViewUpdateServiceImpl.isInstalledAndEnabledForAllUsers(userPackages = this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, provider)) || !this.mWebViewUpdater.isValidProvider(provider, userPackages.get(0).getPackageInfo())) continue;
            return true;
        }
        return false;
    }

    void handleNewUser(int userId) {
        this.handleUserChange();
    }

    void handleUserRemoved(int userId) {
        this.handleUserChange();
    }

    private void handleUserChange() {
        if (this.mSystemInterface.isFallbackLogicEnabled()) {
            this.updateFallbackState(this.mSystemInterface.getWebViewPackages());
        }
        this.mWebViewUpdater.updateCurrentWebViewPackage(null);
    }

    void notifyRelroCreationCompleted() {
        this.mWebViewUpdater.notifyRelroCreationCompleted();
    }

    WebViewProviderResponse waitForAndGetProvider() {
        return this.mWebViewUpdater.waitForAndGetProvider();
    }

    String changeProviderAndSetting(String newProvider) {
        return this.mWebViewUpdater.changeProviderAndSetting(newProvider);
    }

    WebViewProviderInfo[] getValidWebViewPackages() {
        return this.mWebViewUpdater.getValidWebViewPackages();
    }

    WebViewProviderInfo[] getWebViewPackages() {
        return this.mSystemInterface.getWebViewPackages();
    }

    PackageInfo getCurrentWebViewPackage() {
        return this.mWebViewUpdater.getCurrentWebViewPackage();
    }

    void enableFallbackLogic(boolean enable) {
        this.mSystemInterface.enableFallbackLogic(enable);
    }

    private void updateFallbackStateOnBoot() {
        if (!this.mSystemInterface.isFallbackLogicEnabled()) {
            return;
        }
        WebViewProviderInfo[] webviewProviders = this.mSystemInterface.getWebViewPackages();
        this.updateFallbackState(webviewProviders);
    }

    private void updateFallbackStateOnPackageChange(String changedPackage, int changedState) {
        if (!this.mSystemInterface.isFallbackLogicEnabled()) {
            return;
        }
        WebViewProviderInfo[] webviewProviders = this.mSystemInterface.getWebViewPackages();
        boolean changedPackageAvailableByDefault = false;
        for (WebViewProviderInfo provider : webviewProviders) {
            if (!provider.packageName.equals(changedPackage)) continue;
            if (!provider.availableByDefault) break;
            changedPackageAvailableByDefault = true;
            break;
        }
        if (!changedPackageAvailableByDefault) {
            return;
        }
        this.updateFallbackState(webviewProviders);
    }

    private void updateFallbackState(WebViewProviderInfo[] webviewProviders) {
        WebViewProviderInfo fallbackProvider = WebViewUpdateServiceImpl.getFallbackProvider(webviewProviders);
        if (fallbackProvider == null) {
            return;
        }
        boolean existsValidNonFallbackProvider = this.existsValidNonFallbackProvider(webviewProviders);
        List<UserPackage> userPackages = this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, fallbackProvider);
        if (existsValidNonFallbackProvider && !WebViewUpdateServiceImpl.isDisabledForAllUsers(userPackages)) {
            this.mSystemInterface.uninstallAndDisablePackageForAllUsers(this.mContext, fallbackProvider.packageName);
        } else if (!existsValidNonFallbackProvider && !WebViewUpdateServiceImpl.isInstalledAndEnabledForAllUsers(userPackages)) {
            this.mSystemInterface.enablePackageForAllUsers(this.mContext, fallbackProvider.packageName, true);
        }
    }

    private static WebViewProviderInfo getFallbackProvider(WebViewProviderInfo[] webviewPackages) {
        for (WebViewProviderInfo provider : webviewPackages) {
            if (!provider.isFallback) continue;
            return provider;
        }
        return null;
    }

    boolean isFallbackPackage(String packageName) {
        if (packageName == null || !this.mSystemInterface.isFallbackLogicEnabled()) {
            return false;
        }
        WebViewProviderInfo[] webviewPackages = this.mSystemInterface.getWebViewPackages();
        WebViewProviderInfo fallbackProvider = WebViewUpdateServiceImpl.getFallbackProvider(webviewPackages);
        return fallbackProvider != null && packageName.equals(fallbackProvider.packageName);
    }

    boolean isMultiProcessEnabled() {
        PackageInfo current = this.getCurrentWebViewPackage();
        if (current == null) {
            return false;
        }
        int currentVersion = current.versionCode;
        int settingValue = this.mSystemInterface.getMultiProcessSetting(this.mContext);
        if (this.mSystemInterface.isMultiProcessDefaultEnabled()) {
            return settingValue > -currentVersion;
        }
        return settingValue > 0;
    }

    void enableMultiProcess(boolean enable) {
        PackageInfo current = this.getCurrentWebViewPackage();
        int currentVersion = current != null ? current.versionCode : 1;
        this.mSystemInterface.setMultiProcessSetting(this.mContext, enable ? currentVersion : -currentVersion);
        this.mSystemInterface.notifyZygote(enable);
        if (current != null) {
            this.mSystemInterface.killPackageDependents(current.packageName);
        }
    }

    private static boolean providerHasValidSignature(WebViewProviderInfo provider, PackageInfo packageInfo, SystemInterface systemInterface) {
        if (systemInterface.systemIsDebuggable()) {
            return true;
        }
        if (provider.signatures == null || provider.signatures.length == 0) {
            return packageInfo.applicationInfo.isSystemApp();
        }
        Signature[] packageSignatures = packageInfo.signatures;
        if (packageSignatures.length != 1) {
            return false;
        }
        byte[] packageSignature = packageSignatures[0].toByteArray();
        for (String signature : provider.signatures) {
            byte[] validSignature = Base64.decode(signature, 0);
            if (!Arrays.equals(packageSignature, validSignature)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInstalledAndEnabledForAllUsers(List<UserPackage> userPackages) {
        for (UserPackage userPackage : userPackages) {
            if (userPackage.isInstalledPackage() && userPackage.isEnabledPackage()) continue;
            return false;
        }
        return true;
    }

    private static boolean isDisabledForAllUsers(List<UserPackage> userPackages) {
        for (UserPackage userPackage : userPackages) {
            if (userPackage.getPackageInfo() == null || !userPackage.isEnabledPackage()) continue;
            return false;
        }
        return true;
    }

    void dumpState(PrintWriter pw) {
        pw.println("Current WebView Update Service state");
        pw.println(String.format("  Fallback logic enabled: %b", this.mSystemInterface.isFallbackLogicEnabled()));
        this.mWebViewUpdater.dumpState(pw);
    }

    private static class WebViewUpdater {
        private Context mContext;
        private SystemInterface mSystemInterface;
        private int mMinimumVersionCode = -1;
        private static final int WAIT_TIMEOUT_MS = 1000;
        private int mNumRelroCreationsStarted = 0;
        private int mNumRelroCreationsFinished = 0;
        private boolean mWebViewPackageDirty = false;
        private boolean mAnyWebViewInstalled = false;
        private int NUMBER_OF_RELROS_UNKNOWN = Integer.MAX_VALUE;
        private PackageInfo mCurrentWebViewPackage = null;
        private Object mLock = new Object();

        public WebViewUpdater(Context context, SystemInterface systemInterface) {
            this.mContext = context;
            this.mSystemInterface = systemInterface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void packageStateChanged(String packageName, int changedState) {
            for (WebViewProviderInfo provider : this.mSystemInterface.getWebViewPackages()) {
                String webviewPackage = provider.packageName;
                if (!webviewPackage.equals(packageName)) continue;
                boolean updateWebView = false;
                boolean removedOrChangedOldPackage = false;
                String oldProviderName = null;
                PackageInfo newPackage = null;
                Object object = this.mLock;
                synchronized (object) {
                    try {
                        newPackage = this.findPreferredWebViewPackage();
                        if (this.mCurrentWebViewPackage != null) {
                            oldProviderName = this.mCurrentWebViewPackage.packageName;
                            if (changedState == 0 && newPackage.packageName.equals(oldProviderName)) {
                                return;
                            }
                            if (newPackage.packageName.equals(oldProviderName) && newPackage.lastUpdateTime == this.mCurrentWebViewPackage.lastUpdateTime) {
                                return;
                            }
                        }
                        updateWebView = provider.packageName.equals(newPackage.packageName) || provider.packageName.equals(oldProviderName) || this.mCurrentWebViewPackage == null;
                        removedOrChangedOldPackage = provider.packageName.equals(oldProviderName);
                        if (updateWebView) {
                            this.onWebViewProviderChanged(newPackage);
                        }
                    }
                    catch (WebViewPackageMissingException e) {
                        this.mCurrentWebViewPackage = null;
                        Slog.e(TAG, "Could not find valid WebView package to create relro with " + e);
                    }
                }
                if (updateWebView && !removedOrChangedOldPackage && oldProviderName != null) {
                    this.mSystemInterface.killPackageDependents(oldProviderName);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepareWebViewInSystemServer() {
            try {
                Object object = this.mLock;
                synchronized (object) {
                    this.mCurrentWebViewPackage = this.findPreferredWebViewPackage();
                    this.mSystemInterface.updateUserSetting(this.mContext, this.mCurrentWebViewPackage.packageName);
                    this.onWebViewProviderChanged(this.mCurrentWebViewPackage);
                }
            }
            catch (Throwable t) {
                Slog.e(TAG, "error preparing webview provider from system server", t);
            }
        }

        public String changeProviderAndSetting(String newProviderName) {
            PackageInfo newPackage = this.updateCurrentWebViewPackage(newProviderName);
            if (newPackage == null) {
                return "";
            }
            return newPackage.packageName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onWebViewProviderChanged(PackageInfo newPackage) {
            Object object = this.mLock;
            synchronized (object) {
                this.mAnyWebViewInstalled = true;
                if (this.mNumRelroCreationsStarted == this.mNumRelroCreationsFinished) {
                    this.mCurrentWebViewPackage = newPackage;
                    this.mNumRelroCreationsStarted = this.NUMBER_OF_RELROS_UNKNOWN;
                    this.mNumRelroCreationsFinished = 0;
                    this.mNumRelroCreationsStarted = this.mSystemInterface.onWebViewProviderChanged(newPackage);
                    this.checkIfRelrosDoneLocked();
                } else {
                    this.mWebViewPackageDirty = true;
                }
            }
        }

        private ProviderAndPackageInfo[] getValidWebViewPackagesAndInfos() {
            WebViewProviderInfo[] allProviders = this.mSystemInterface.getWebViewPackages();
            ArrayList<ProviderAndPackageInfo> providers = new ArrayList<ProviderAndPackageInfo>();
            for (int n = 0; n < allProviders.length; ++n) {
                try {
                    PackageInfo packageInfo = this.mSystemInterface.getPackageInfoForProvider(allProviders[n]);
                    if (!this.isValidProvider(allProviders[n], packageInfo)) continue;
                    providers.add(new ProviderAndPackageInfo(allProviders[n], packageInfo));
                    continue;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            return providers.toArray(new ProviderAndPackageInfo[providers.size()]);
        }

        public WebViewProviderInfo[] getValidWebViewPackages() {
            ProviderAndPackageInfo[] providersAndPackageInfos = this.getValidWebViewPackagesAndInfos();
            WebViewProviderInfo[] providers = new WebViewProviderInfo[providersAndPackageInfos.length];
            for (int n = 0; n < providersAndPackageInfos.length; ++n) {
                providers[n] = providersAndPackageInfos[n].provider;
            }
            return providers;
        }

        private PackageInfo findPreferredWebViewPackage() throws WebViewPackageMissingException {
            List<UserPackage> userPackages;
            ProviderAndPackageInfo[] providers = this.getValidWebViewPackagesAndInfos();
            String userChosenProvider = this.mSystemInterface.getUserChosenWebViewProvider(this.mContext);
            for (ProviderAndPackageInfo providerAndPackage : providers) {
                if (!providerAndPackage.provider.packageName.equals(userChosenProvider) || !WebViewUpdateServiceImpl.isInstalledAndEnabledForAllUsers(userPackages = this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, providerAndPackage.provider))) continue;
                return providerAndPackage.packageInfo;
            }
            for (ProviderAndPackageInfo providerAndPackage : providers) {
                if (!providerAndPackage.provider.availableByDefault || !WebViewUpdateServiceImpl.isInstalledAndEnabledForAllUsers(userPackages = this.mSystemInterface.getPackageInfoForProviderAllUsers(this.mContext, providerAndPackage.provider))) continue;
                return providerAndPackage.packageInfo;
            }
            for (ProviderAndPackageInfo providerAndPackage : providers) {
                if (!providerAndPackage.provider.availableByDefault) continue;
                return providerAndPackage.packageInfo;
            }
            this.mAnyWebViewInstalled = false;
            throw new WebViewPackageMissingException("Could not find a loadable WebView package");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyRelroCreationCompleted() {
            Object object = this.mLock;
            synchronized (object) {
                ++this.mNumRelroCreationsFinished;
                this.checkIfRelrosDoneLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WebViewProviderResponse waitForAndGetProvider() {
            PackageInfo webViewPackage = null;
            long NS_PER_MS = 1000000L;
            long timeoutTimeMs = System.nanoTime() / 1000000L + 1000L;
            boolean webViewReady = false;
            int webViewStatus = 0;
            Object object = this.mLock;
            synchronized (object) {
                long timeNowMs;
                webViewReady = this.webViewIsReadyLocked();
                while (!webViewReady && (timeNowMs = System.nanoTime() / 1000000L) < timeoutTimeMs) {
                    try {
                        this.mLock.wait(timeoutTimeMs - timeNowMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    webViewReady = this.webViewIsReadyLocked();
                }
                webViewPackage = this.mCurrentWebViewPackage;
                if (!webViewReady) {
                    if (!this.mAnyWebViewInstalled) {
                        webViewStatus = 4;
                    } else {
                        webViewStatus = 3;
                        Slog.e(TAG, "Timed out waiting for relro creation, relros started " + this.mNumRelroCreationsStarted + " relros finished " + this.mNumRelroCreationsFinished + " package dirty? " + this.mWebViewPackageDirty);
                    }
                }
            }
            if (!webViewReady) {
                Slog.w(TAG, "creating relro file timed out");
            }
            return new WebViewProviderResponse(webViewPackage, webViewStatus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PackageInfo getCurrentWebViewPackage() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mCurrentWebViewPackage;
            }
        }

        private boolean webViewIsReadyLocked() {
            return !this.mWebViewPackageDirty && this.mNumRelroCreationsStarted == this.mNumRelroCreationsFinished && this.mAnyWebViewInstalled;
        }

        private void checkIfRelrosDoneLocked() {
            if (this.mNumRelroCreationsStarted == this.mNumRelroCreationsFinished) {
                if (this.mWebViewPackageDirty) {
                    this.mWebViewPackageDirty = false;
                    try {
                        PackageInfo newPackage = this.findPreferredWebViewPackage();
                        this.onWebViewProviderChanged(newPackage);
                    }
                    catch (WebViewPackageMissingException e) {
                        this.mCurrentWebViewPackage = null;
                    }
                } else {
                    this.mLock.notifyAll();
                }
            }
        }

        private static boolean versionCodeGE(int versionCode1, int versionCode2) {
            int v1 = versionCode1 / 100000;
            int v2 = versionCode2 / 100000;
            return v1 >= v2;
        }

        public boolean isValidProvider(WebViewProviderInfo configInfo, PackageInfo packageInfo) {
            if (!UserPackage.hasCorrectTargetSdkVersion(packageInfo)) {
                return false;
            }
            if (!WebViewUpdater.versionCodeGE(packageInfo.versionCode, this.getMinimumVersionCode()) && !this.mSystemInterface.systemIsDebuggable()) {
                return false;
            }
            return WebViewUpdateServiceImpl.providerHasValidSignature(configInfo, packageInfo, this.mSystemInterface) && WebViewFactory.getWebViewLibrary(packageInfo.applicationInfo) != null;
        }

        private int getMinimumVersionCode() {
            if (this.mMinimumVersionCode > 0) {
                return this.mMinimumVersionCode;
            }
            int minimumVersionCode = -1;
            for (WebViewProviderInfo provider : this.mSystemInterface.getWebViewPackages()) {
                if (!provider.availableByDefault || provider.isFallback) continue;
                try {
                    int versionCode = this.mSystemInterface.getFactoryPackageVersion(provider.packageName);
                    if (minimumVersionCode >= 0 && versionCode >= minimumVersionCode) continue;
                    minimumVersionCode = versionCode;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            this.mMinimumVersionCode = minimumVersionCode;
            return this.mMinimumVersionCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dumpState(PrintWriter pw) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mCurrentWebViewPackage == null) {
                    pw.println("  Current WebView package is null");
                } else {
                    pw.println(String.format("  Current WebView package (name, version): (%s, %s)", this.mCurrentWebViewPackage.packageName, this.mCurrentWebViewPackage.versionName));
                }
                pw.println(String.format("  Minimum WebView version code: %d", this.mMinimumVersionCode));
                pw.println(String.format("  Number of relros started: %d", this.mNumRelroCreationsStarted));
                pw.println(String.format("  Number of relros finished: %d", this.mNumRelroCreationsFinished));
                pw.println(String.format("  WebView package dirty: %b", this.mWebViewPackageDirty));
                pw.println(String.format("  Any WebView package installed: %b", this.mAnyWebViewInstalled));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PackageInfo updateCurrentWebViewPackage(String newProviderName) {
            PackageInfo oldPackage = null;
            PackageInfo newPackage = null;
            boolean providerChanged = false;
            Object object = this.mLock;
            synchronized (object) {
                oldPackage = this.mCurrentWebViewPackage;
                if (newProviderName != null) {
                    this.mSystemInterface.updateUserSetting(this.mContext, newProviderName);
                }
                try {
                    newPackage = this.findPreferredWebViewPackage();
                    providerChanged = oldPackage == null || !newPackage.packageName.equals(oldPackage.packageName);
                }
                catch (WebViewPackageMissingException e) {
                    this.mCurrentWebViewPackage = null;
                    Slog.e(TAG, "Couldn't find WebView package to use " + e);
                    return null;
                }
                if (providerChanged) {
                    this.onWebViewProviderChanged(newPackage);
                }
            }
            if (providerChanged && oldPackage != null) {
                this.mSystemInterface.killPackageDependents(oldPackage.packageName);
            }
            return newPackage;
        }

        private static class ProviderAndPackageInfo {
            public final WebViewProviderInfo provider;
            public final PackageInfo packageInfo;

            public ProviderAndPackageInfo(WebViewProviderInfo provider, PackageInfo packageInfo) {
                this.provider = provider;
                this.packageInfo = packageInfo;
            }
        }

        private static class WebViewPackageMissingException
        extends Exception {
            public WebViewPackageMissingException(String message) {
                super(message);
            }

            public WebViewPackageMissingException(Exception e) {
                super(e);
            }
        }
    }
}

