/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.IBinder;
import com.android.server.wm.AlertWindowNotification$$Lambda$84;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.HashMap;

class AlertWindowNotification {
    private static final String CHANNEL_PREFIX = "com.android.server.wm.AlertWindowNotification - ";
    private static final int NOTIFICATION_ID = 0;
    private static int sNextRequestCode = 0;
    private final int mRequestCode;
    private final WindowManagerService mService;
    private String mNotificationTag;
    private final NotificationManager mNotificationManager;
    private final String mPackageName;
    private final int mUid;
    private boolean mCancelled;

    AlertWindowNotification(WindowManagerService service, String packageName, int uid) {
        this.mService = service;
        this.mPackageName = packageName;
        this.mUid = uid;
        this.mNotificationManager = (NotificationManager)this.mService.mContext.getSystemService("notification");
        this.mNotificationTag = CHANNEL_PREFIX + this.mPackageName;
        this.mRequestCode = sNextRequestCode++;
        this.mService.mH.post(AlertWindowNotification$$Lambda$84.get$Lambda(this));
    }

    void cancel() {
        this.mNotificationManager.cancel(this.mNotificationTag, 0);
        this.mCancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postNotification() {
        Context context = this.mService.mContext;
        PackageManager pm = context.getPackageManager();
        ApplicationInfo aInfo = this.getApplicationInfo(pm, this.mPackageName);
        String appName = aInfo != null ? pm.getApplicationLabel(aInfo).toString() : this.mPackageName;
        this.createNotificationChannelIfNeeded(context, appName);
        String message = context.getString(17039455);
        Notification.Builder builder = new Notification.Builder(context, this.mNotificationTag).setOngoing(true).setContentTitle(context.getString(17039456, appName)).setContentText(message).setSmallIcon(17301708).setColor(context.getColor(17170762)).setStyle(new Notification.BigTextStyle().bigText(message)).setLocalOnly(true).addAction(this.getTurnOffAction(context, this.mPackageName, this.mUid));
        if (aInfo != null) {
            Bitmap bitmap = ((BitmapDrawable)pm.getApplicationIcon(aInfo)).getBitmap();
            builder.setLargeIcon(bitmap);
        }
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            if (this.mCancelled) {
                return;
            }
            this.mNotificationManager.notify(this.mNotificationTag, 0, builder.build());
        }
    }

    private Notification.Action getTurnOffAction(Context context, String packageName, int uid) {
        Intent intent = new Intent("com.android.server.wm.ACTION_REVOKE_SYSTEM_ALERT_WINDOW_PERMISSION");
        intent.putExtra("android.intent.extra.PACKAGE_NAME", packageName);
        intent.putExtra("android.intent.extra.UID", uid);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(context, this.mRequestCode, intent, 0x10000000);
        return new Notification.Action.Builder(17301708, (CharSequence)context.getString(17039457), pendingIntent).build();
    }

    private void createNotificationChannelIfNeeded(Context context, String appName) {
        if (this.mNotificationManager.getNotificationChannel(this.mNotificationTag) != null) {
            return;
        }
        String nameChannel = context.getString(17039454, appName);
        NotificationChannel channel = new NotificationChannel(this.mNotificationTag, nameChannel, 1);
        channel.enableLights(false);
        channel.enableVibration(false);
        this.mNotificationManager.createNotificationChannel(channel);
    }

    private ApplicationInfo getApplicationInfo(PackageManager pm, String packageName) {
        try {
            return pm.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }
}

