/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.TimeUtils;
import android.view.Choreographer;
import android.view.SurfaceControl;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowStateAnimator;
import java.io.PrintWriter;
import java.util.ArrayList;

public class AppWindowAnimator {
    static final String TAG = "WindowManager";
    private static final int PROLONG_ANIMATION_DISABLED = 0;
    static final int PROLONG_ANIMATION_AT_END = 1;
    static final int PROLONG_ANIMATION_AT_START = 2;
    final AppWindowToken mAppToken;
    final WindowManagerService mService;
    final WindowAnimator mAnimator;
    boolean animating;
    boolean wasAnimating;
    Animation animation;
    boolean hasTransformation;
    final Transformation transformation = new Transformation();
    boolean freezingScreen;
    int lastFreezeDuration;
    int animLayerAdjustment;
    boolean allDrawn;
    SurfaceControl thumbnail;
    int thumbnailTransactionSeq;
    int thumbnailLayer;
    int thumbnailForceAboveLayer;
    Animation thumbnailAnimation;
    final Transformation thumbnailTransformation = new Transformation();
    boolean deferThumbnailDestruction;
    boolean deferFinalFrameCleanup;
    private int mProlongAnimation;
    private boolean mClearProlongedAnimation;
    private int mTransit;
    private int mTransitFlags;
    ArrayList<WindowStateAnimator> mAllAppWinAnimators = new ArrayList();
    boolean usingTransferredAnimation = false;
    private boolean mSkipFirstFrame = false;
    private int mStackClip = 1;
    static final Animation sDummyAnimation = new DummyAnimation();

    public AppWindowAnimator(AppWindowToken atoken, WindowManagerService service) {
        this.mAppToken = atoken;
        this.mService = service;
        this.mAnimator = this.mService.mAnimator;
    }

    public void setAnimation(Animation anim2, int width, int height, int parentWidth, int parentHeight, boolean skipFirstFrame, int stackClip, int transit, int transitFlags) {
        this.animation = anim2;
        this.animating = false;
        if (!anim2.isInitialized()) {
            anim2.initialize(width, height, parentWidth, parentHeight);
        }
        anim2.restrictDuration(10000L);
        anim2.scaleCurrentDuration(this.mService.getTransitionAnimationScaleLocked());
        int zorder = anim2.getZAdjustment();
        int adj = 0;
        if (zorder == 1) {
            adj = 1000;
        } else if (zorder == -1) {
            adj = -1000;
        }
        if (this.animLayerAdjustment != adj) {
            this.animLayerAdjustment = adj;
            this.updateLayers();
        }
        this.transformation.clear();
        this.transformation.setAlpha(this.mAppToken.hasContentToDisplay() ? 1.0f : 0.0f);
        this.hasTransformation = true;
        this.mStackClip = stackClip;
        this.mSkipFirstFrame = skipFirstFrame;
        this.mTransit = transit;
        this.mTransitFlags = transitFlags;
        if (!this.mAppToken.fillsParent()) {
            anim2.setBackgroundColor(0);
        }
        if (this.mClearProlongedAnimation) {
            this.mProlongAnimation = 0;
        } else {
            this.mClearProlongedAnimation = true;
        }
        this.mAppToken.resetJustMovedInStack();
    }

    public void setDummyAnimation() {
        this.animation = sDummyAnimation;
        this.hasTransformation = true;
        this.transformation.clear();
        this.transformation.setAlpha(this.mAppToken.hasContentToDisplay() ? 1.0f : 0.0f);
    }

    void setNullAnimation() {
        this.animation = null;
        this.usingTransferredAnimation = false;
    }

    public void clearAnimation() {
        if (this.animation != null) {
            this.animating = true;
        }
        this.clearThumbnail();
        this.setNullAnimation();
        if (this.mAppToken.deferClearAllDrawn) {
            this.mAppToken.clearAllDrawn();
        }
        this.mStackClip = 1;
        this.mTransit = -1;
        this.mTransitFlags = 0;
    }

    public boolean isAnimating() {
        return this.animation != null || this.mAppToken.inPendingTransaction;
    }

    public int getTransit() {
        return this.mTransit;
    }

    int getTransitFlags() {
        return this.mTransitFlags;
    }

    public void clearThumbnail() {
        if (this.thumbnail != null) {
            this.thumbnail.hide();
            this.mService.mWindowPlacerLocked.destroyAfterTransaction(this.thumbnail);
            this.thumbnail = null;
        }
        this.deferThumbnailDestruction = false;
    }

    int getStackClip() {
        return this.mStackClip;
    }

    void transferCurrentAnimation(AppWindowAnimator toAppAnimator, WindowStateAnimator transferWinAnimator) {
        if (this.animation != null) {
            toAppAnimator.animation = this.animation;
            toAppAnimator.animating = this.animating;
            toAppAnimator.animLayerAdjustment = this.animLayerAdjustment;
            this.setNullAnimation();
            this.animLayerAdjustment = 0;
            toAppAnimator.updateLayers();
            this.updateLayers();
            toAppAnimator.usingTransferredAnimation = true;
            toAppAnimator.mTransit = this.mTransit;
        }
        if (transferWinAnimator != null) {
            this.mAllAppWinAnimators.remove(transferWinAnimator);
            toAppAnimator.mAllAppWinAnimators.add(transferWinAnimator);
            toAppAnimator.hasTransformation = transferWinAnimator.mAppAnimator.hasTransformation;
            if (toAppAnimator.hasTransformation) {
                toAppAnimator.transformation.set(transferWinAnimator.mAppAnimator.transformation);
            } else {
                toAppAnimator.transformation.clear();
            }
            transferWinAnimator.mAppAnimator = toAppAnimator;
        }
    }

    void updateLayers() {
        this.thumbnailLayer = this.mAppToken.adjustAnimLayer(this.animLayerAdjustment);
    }

    private void stepThumbnailAnimation(long currentTime) {
        boolean screenAnimation;
        this.thumbnailTransformation.clear();
        long animationFrameTime = this.getAnimationFrameTime(this.thumbnailAnimation, currentTime);
        this.thumbnailAnimation.getTransformation(animationFrameTime, this.thumbnailTransformation);
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(0);
        boolean bl = screenAnimation = screenRotationAnimation != null && screenRotationAnimation.isAnimating();
        if (screenAnimation) {
            this.thumbnailTransformation.postCompose(screenRotationAnimation.getEnterTransformation());
        }
        float[] tmpFloats = this.mService.mTmpFloats;
        this.thumbnailTransformation.getMatrix().getValues(tmpFloats);
        this.thumbnail.setPosition(tmpFloats[2], tmpFloats[5]);
        this.thumbnail.setAlpha(this.thumbnailTransformation.getAlpha());
        if (this.thumbnailForceAboveLayer > 0) {
            this.thumbnail.setLayer(this.thumbnailForceAboveLayer + 1);
        } else {
            this.thumbnail.setLayer(this.thumbnailLayer + 5 - 4);
        }
        this.thumbnail.setMatrix(tmpFloats[0], tmpFloats[3], tmpFloats[1], tmpFloats[4]);
        this.thumbnail.setWindowCrop(this.thumbnailTransformation.getClipRect());
    }

    private long getAnimationFrameTime(Animation animation, long currentTime) {
        if (this.mProlongAnimation == 2) {
            animation.setStartTime(currentTime);
            return currentTime + 1L;
        }
        return currentTime;
    }

    private boolean stepAnimation(long currentTime) {
        if (this.animation == null) {
            return false;
        }
        this.transformation.clear();
        long animationFrameTime = this.getAnimationFrameTime(this.animation, currentTime);
        boolean hasMoreFrames = this.animation.getTransformation(animationFrameTime, this.transformation);
        if (!hasMoreFrames) {
            if (this.deferThumbnailDestruction && !this.deferFinalFrameCleanup) {
                this.deferFinalFrameCleanup = true;
                hasMoreFrames = true;
            } else {
                this.deferFinalFrameCleanup = false;
                if (this.mProlongAnimation == 1) {
                    hasMoreFrames = true;
                } else {
                    this.setNullAnimation();
                    this.clearThumbnail();
                }
            }
        }
        this.hasTransformation = hasMoreFrames;
        return hasMoreFrames;
    }

    private long getStartTimeCorrection() {
        if (this.mSkipFirstFrame) {
            return -Choreographer.getInstance().getFrameIntervalNanos() / 1000000L;
        }
        return 0L;
    }

    boolean stepAnimationLocked(long currentTime) {
        if (this.mService.okToDisplay()) {
            if (this.animation == sDummyAnimation) {
                return false;
            }
            if ((this.mAppToken.allDrawn || this.animating || this.mAppToken.startingDisplayed) && this.animation != null) {
                if (!this.animating) {
                    long correction = this.getStartTimeCorrection();
                    this.animation.setStartTime(currentTime + correction);
                    this.animating = true;
                    if (this.thumbnail != null) {
                        this.thumbnail.show();
                        this.thumbnailAnimation.setStartTime(currentTime + correction);
                    }
                    this.mSkipFirstFrame = false;
                }
                if (this.stepAnimation(currentTime)) {
                    if (this.thumbnail != null) {
                        this.stepThumbnailAnimation(currentTime);
                    }
                    return true;
                }
            }
        } else if (this.animation != null) {
            this.animating = true;
            this.animation = null;
        }
        this.hasTransformation = false;
        if (!this.animating && this.animation == null) {
            return false;
        }
        this.mAppToken.setAppLayoutChanges(8, "AppWindowToken");
        this.clearAnimation();
        this.animating = false;
        if (this.animLayerAdjustment != 0) {
            this.animLayerAdjustment = 0;
            this.updateLayers();
        }
        if (this.mService.mInputMethodTarget != null && this.mService.mInputMethodTarget.mAppToken == this.mAppToken) {
            this.mAppToken.getDisplayContent().computeImeTarget(true);
        }
        this.transformation.clear();
        int numAllAppWinAnimators = this.mAllAppWinAnimators.size();
        for (int i = 0; i < numAllAppWinAnimators; ++i) {
            this.mAllAppWinAnimators.get((int)i).mWin.onExitAnimationDone();
        }
        this.mService.mAppTransition.notifyAppTransitionFinishedLocked(this.mAppToken.token);
        return false;
    }

    boolean showAllWindowsLocked() {
        boolean isAnimating = false;
        int NW = this.mAllAppWinAnimators.size();
        for (int i = 0; i < NW; ++i) {
            WindowStateAnimator winAnimator = this.mAllAppWinAnimators.get(i);
            winAnimator.mWin.performShowLocked();
            isAnimating |= winAnimator.isAnimationSet();
        }
        return isAnimating;
    }

    void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        pw.print(prefix);
        pw.print("mAppToken=");
        pw.println(this.mAppToken);
        pw.print(prefix);
        pw.print("mAnimator=");
        pw.println(this.mAnimator);
        pw.print(prefix);
        pw.print("freezingScreen=");
        pw.print(this.freezingScreen);
        pw.print(" allDrawn=");
        pw.print(this.allDrawn);
        pw.print(" animLayerAdjustment=");
        pw.println(this.animLayerAdjustment);
        if (this.lastFreezeDuration != 0) {
            pw.print(prefix);
            pw.print("lastFreezeDuration=");
            TimeUtils.formatDuration((long)this.lastFreezeDuration, pw);
            pw.println();
        }
        if (this.animating || this.animation != null) {
            pw.print(prefix);
            pw.print("animating=");
            pw.println(this.animating);
            pw.print(prefix);
            pw.print("animation=");
            pw.println(this.animation);
            pw.print(prefix);
            pw.print("mTransit=");
            pw.println(this.mTransit);
            pw.print(prefix);
            pw.print("mTransitFlags=");
            pw.println(this.mTransitFlags);
        }
        if (this.hasTransformation) {
            pw.print(prefix);
            pw.print("XForm: ");
            this.transformation.printShortString(pw);
            pw.println();
        }
        if (this.thumbnail != null) {
            pw.print(prefix);
            pw.print("thumbnail=");
            pw.print(this.thumbnail);
            pw.print(" layer=");
            pw.println(this.thumbnailLayer);
            pw.print(prefix);
            pw.print("thumbnailAnimation=");
            pw.println(this.thumbnailAnimation);
            pw.print(prefix);
            pw.print("thumbnailTransformation=");
            pw.println(this.thumbnailTransformation.toShortString());
        }
        for (int i = 0; i < this.mAllAppWinAnimators.size(); ++i) {
            WindowStateAnimator wanim = this.mAllAppWinAnimators.get(i);
            pw.print(prefix);
            pw.print("App Win Anim #");
            pw.print(i);
            pw.print(": ");
            pw.println(wanim);
        }
    }

    void startProlongAnimation(int prolongType) {
        this.mProlongAnimation = prolongType;
        this.mClearProlongedAnimation = false;
    }

    void endProlongedAnimation() {
        this.mProlongAnimation = 0;
    }

    static final class DummyAnimation
    extends Animation {
        DummyAnimation() {
        }

        @Override
        public boolean getTransformation(long currentTime, Transformation outTransformation) {
            return false;
        }
    }
}

