/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.IBinder;
import android.os.Trace;
import android.util.Slog;
import android.view.IApplicationToken;
import android.view.WindowManagerPolicy;
import com.android.internal.R;
import com.android.server.AttributeCache;
import com.android.server.wm.AppWindowContainerController$$Lambda$42;
import com.android.server.wm.AppWindowContainerController$$Lambda$43;
import com.android.server.wm.AppWindowContainerController$$Lambda$44;
import com.android.server.wm.AppWindowContainerController$$Lambda$45;
import com.android.server.wm.AppWindowContainerController$$Lambda$46;
import com.android.server.wm.AppWindowContainerListener;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.SnapshotStartingData;
import com.android.server.wm.SplashScreenStartingData;
import com.android.server.wm.StartingData;
import com.android.server.wm.Task;
import com.android.server.wm.TaskWindowContainerController;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;
import java.util.HashMap;

public class AppWindowContainerController
extends WindowContainerController<AppWindowToken, AppWindowContainerListener> {
    private static final int STARTING_WINDOW_TYPE_NONE = 0;
    private static final int STARTING_WINDOW_TYPE_SNAPSHOT = 1;
    private static final int STARTING_WINDOW_TYPE_SPLASH_SCREEN = 2;
    private final IApplicationToken mToken;
    private final Handler mHandler;
    private final Runnable mOnWindowsDrawn = AppWindowContainerController$$Lambda$42.get$Lambda(this);
    private final Runnable mOnWindowsVisible = AppWindowContainerController$$Lambda$43.get$Lambda(this);
    private final Runnable mOnWindowsGone = AppWindowContainerController$$Lambda$44.get$Lambda(this);
    private final Runnable mRemoveStartingWindow = AppWindowContainerController$$Lambda$45.get$Lambda(this);
    private final Runnable mAddStartingWindow = AppWindowContainerController$$Lambda$46.get$Lambda(this);

    public AppWindowContainerController(TaskWindowContainerController taskController, IApplicationToken token, AppWindowContainerListener listener, int index, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int configChanges, boolean voiceInteraction, boolean launchTaskBehind, boolean alwaysFocusable, int targetSdkVersion, int rotationAnimationHint, long inputDispatchingTimeoutNanos) {
        this(taskController, token, listener, index, requestedOrientation, fullscreen, showForAllUsers, configChanges, voiceInteraction, launchTaskBehind, alwaysFocusable, targetSdkVersion, rotationAnimationHint, inputDispatchingTimeoutNanos, WindowManagerService.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppWindowContainerController(TaskWindowContainerController taskController, IApplicationToken token, AppWindowContainerListener listener, int index, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int configChanges, boolean voiceInteraction, boolean launchTaskBehind, boolean alwaysFocusable, int targetSdkVersion, int rotationAnimationHint, long inputDispatchingTimeoutNanos, WindowManagerService service) {
        super(listener, service);
        this.mHandler = new Handler(service.mH.getLooper());
        this.mToken = token;
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.mRoot.getAppWindowToken(this.mToken.asBinder());
            if (atoken != null) {
                Slog.w("WindowManager", "Attempted to add existing app token: " + this.mToken);
                return;
            }
            Task task = (Task)taskController.mContainer;
            if (task == null) {
                throw new IllegalArgumentException("AppWindowContainerController: invalid  controller=" + taskController);
            }
            atoken = this.createAppWindow(this.mService, token, voiceInteraction, task.getDisplayContent(), inputDispatchingTimeoutNanos, fullscreen, showForAllUsers, targetSdkVersion, requestedOrientation, rotationAnimationHint, configChanges, launchTaskBehind, alwaysFocusable, this);
            task.addChild(atoken, index);
        }
    }

    AppWindowToken createAppWindow(WindowManagerService service, IApplicationToken token, boolean voiceInteraction, DisplayContent dc, long inputDispatchingTimeoutNanos, boolean fullscreen, boolean showForAllUsers, int targetSdk, int orientation, int rotationAnimationHint, int configChanges, boolean launchTaskBehind, boolean alwaysFocusable, AppWindowContainerController controller) {
        return new AppWindowToken(service, token, voiceInteraction, dc, inputDispatchingTimeoutNanos, fullscreen, showForAllUsers, targetSdk, orientation, rotationAnimationHint, configChanges, launchTaskBehind, alwaysFocusable, controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainer(int displayId) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent dc = this.mRoot.getDisplayContent(displayId);
            if (dc == null) {
                Slog.w("WindowManager", "removeAppToken: Attempted to remove binder token: " + this.mToken + " from non-existing displayId=" + displayId);
                return;
            }
            dc.removeAppToken(this.mToken.asBinder());
            super.removeContainer();
        }
    }

    @Override
    public void removeContainer() {
        throw new UnsupportedOperationException("Use removeContainer(displayId) instead.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparent(TaskWindowContainerController taskController, int position) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                return;
            }
            Task task = (Task)taskController.mContainer;
            if (task == null) {
                throw new IllegalArgumentException("reparent: could not find task=" + taskController);
            }
            ((AppWindowToken)this.mContainer).reparent(task, position);
            ((AppWindowToken)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration setOrientation(int requestedOrientation, int displayId, Configuration displayConfig, boolean freezeScreenIfNeeded) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to set orientation of non-existing app token: " + this.mToken);
                return null;
            }
            ((AppWindowToken)this.mContainer).setOrientation(requestedOrientation);
            IBinder binder = freezeScreenIfNeeded ? this.mToken.asBinder() : null;
            return this.mService.updateOrientationFromAppTokens(displayConfig, binder, displayId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrientation() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                return -1;
            }
            return ((AppWindowToken)this.mContainer).getOrientationIgnoreVisibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(boolean visible) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to set visibility of non-existing app token: " + this.mToken);
                return;
            }
            AppWindowToken wtoken = (AppWindowToken)this.mContainer;
            this.mService.mOpeningApps.remove(wtoken);
            this.mService.mClosingApps.remove(wtoken);
            wtoken.waitingToShow = false;
            boolean bl = wtoken.hiddenRequested = !visible;
            if (!visible) {
                wtoken.removeDeadWindows();
                wtoken.setVisibleBeforeClientHidden();
            } else {
                if (!this.mService.mAppTransition.isTransitionSet() && this.mService.mAppTransition.isReady()) {
                    this.mService.mOpeningApps.add(wtoken);
                }
                wtoken.startingMoved = false;
                if (wtoken.hidden || wtoken.mAppStopped) {
                    wtoken.clearAllDrawn();
                    if (wtoken.hidden) {
                        wtoken.waitingToShow = true;
                    }
                    if (wtoken.clientHidden) {
                        wtoken.clientHidden = false;
                        wtoken.sendAppVisibilityToClients();
                    }
                }
                wtoken.requestUpdateWallpaperIfNeeded();
                wtoken.mAppStopped = false;
            }
            if (this.mService.okToDisplay() && this.mService.mAppTransition.isTransitionSet()) {
                AppWindowToken focusedToken;
                WindowState win;
                if (wtoken.mAppAnimator.usingTransferredAnimation && wtoken.mAppAnimator.animation == null) {
                    Slog.wtf("WindowManager", "Will NOT set dummy animation on: " + wtoken + ", using null transferred animation!");
                }
                if (!(wtoken.mAppAnimator.usingTransferredAnimation || wtoken.startingDisplayed && !this.mService.mSkipAppTransitionAnimation)) {
                    wtoken.mAppAnimator.setDummyAnimation();
                }
                wtoken.inPendingTransaction = true;
                if (visible) {
                    this.mService.mOpeningApps.add(wtoken);
                    wtoken.mEnteringAnimation = true;
                } else {
                    this.mService.mClosingApps.add(wtoken);
                    wtoken.mEnteringAnimation = false;
                }
                if (this.mService.mAppTransition.getAppTransition() == 16 && (win = this.mService.getDefaultDisplayContentLocked().findFocusedWindow()) != null && (focusedToken = win.mAppToken) != null) {
                    focusedToken.hidden = true;
                    this.mService.mOpeningApps.add(focusedToken);
                }
                return;
            }
            wtoken.setVisibility(null, visible, -1, true, wtoken.mVoiceInteraction);
            wtoken.updateReportedVisibilityLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUnknownVisibilityLaunched() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer != null) {
                this.mService.mUnknownAppVisibilityController.notifyLaunched((AppWindowToken)this.mContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addStartingWindow(String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, IBinder transferFrom, boolean newTask, boolean taskSwitch, boolean processRunning) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to set icon of non-existing app token: " + this.mToken);
                return false;
            }
            if (!this.mService.okToDisplay()) {
                return false;
            }
            if (((AppWindowToken)this.mContainer).startingData != null) {
                return false;
            }
            int type = this.getStartingWindowType(newTask, taskSwitch, processRunning);
            if (type == 1) {
                return this.createSnapshot();
            }
            if (theme != 0) {
                AttributeCache.Entry ent = AttributeCache.instance().get(pkg, theme, R.styleable.Window, this.mService.mCurrentUserId);
                if (ent == null) {
                    return false;
                }
                boolean windowIsTranslucent = ent.array.getBoolean(5, false);
                boolean windowIsFloating = ent.array.getBoolean(4, false);
                boolean windowShowWallpaper = ent.array.getBoolean(14, false);
                boolean windowDisableStarting = ent.array.getBoolean(12, false);
                if (windowIsTranslucent) {
                    return false;
                }
                if (windowIsFloating || windowDisableStarting) {
                    return false;
                }
                if (windowShowWallpaper) {
                    if (((AppWindowToken)this.mContainer).getDisplayContent().mWallpaperController.getWallpaperTarget() == null) {
                        windowFlags |= 0x100000;
                    } else {
                        return false;
                    }
                }
            }
            if (((AppWindowToken)this.mContainer).transferStartingWindow(transferFrom)) {
                return true;
            }
            if (type != 2) {
                return false;
            }
            ((AppWindowToken)this.mContainer).startingData = new SplashScreenStartingData(this.mService, pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, logo, windowFlags, ((AppWindowToken)this.mContainer).getMergedOverrideConfiguration());
            this.scheduleAddStartingWindow();
        }
        return true;
    }

    private int getStartingWindowType(boolean newTask, boolean taskSwitch, boolean processRunning) {
        if (newTask || !processRunning) {
            return 2;
        }
        if (taskSwitch) {
            return 1;
        }
        return 0;
    }

    void scheduleAddStartingWindow() {
        this.mHandler.postAtFrontOfQueue(this.mAddStartingWindow);
    }

    private boolean createSnapshot() {
        ActivityManager.TaskSnapshot snapshot = this.mService.mTaskSnapshotController.getSnapshot(((AppWindowToken)this.mContainer).mTask.mTaskId, ((AppWindowToken)this.mContainer).mTask.mUserId, false);
        if (snapshot == null) {
            return false;
        }
        ((AppWindowToken)this.mContainer).startingData = new SnapshotStartingData(this.mService, snapshot.getSnapshot());
        this.scheduleAddStartingWindow();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStartingWindow() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mHandler.hasCallbacks(this.mRemoveStartingWindow)) {
                return;
            }
            if (((AppWindowToken)this.mContainer).startingWindow == null) {
                if (((AppWindowToken)this.mContainer).startingData != null) {
                    ((AppWindowToken)this.mContainer).startingData = null;
                }
                return;
            }
            this.mHandler.post(this.mRemoveStartingWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseKeyDispatching() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer != null) {
                this.mService.mInputMonitor.pauseDispatchingLw((WindowToken)this.mContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeKeyDispatching() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer != null) {
                this.mService.mInputMonitor.resumeDispatchingLw((WindowToken)this.mContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppResumed(boolean wasStopped, boolean allowSavedSurface) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to notify resumed of non-existing app token: " + this.mToken);
                return;
            }
            ((AppWindowToken)this.mContainer).notifyAppResumed(wasStopped, allowSavedSurface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppStopped() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to notify stopped of non-existing app token: " + this.mToken);
                return;
            }
            ((AppWindowToken)this.mContainer).notifyAppStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFreezingScreen(int configChanges) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (configChanges == 0 && this.mService.okToDisplay()) {
                return;
            }
            if (this.mContainer == null) {
                Slog.w("WindowManager", "Attempted to freeze screen with non-existing app token: " + this.mContainer);
                return;
            }
            ((AppWindowToken)this.mContainer).startFreezingScreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFreezingScreen(boolean force) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                return;
            }
            ((AppWindowToken)this.mContainer).stopFreezingScreen(true, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap screenshotApplications(int displayId, int width, int height, float frameScale) {
        try {
            DisplayContent dc;
            Trace.traceBegin(32L, "screenshotApplications");
            Object object = this.mWindowMap;
            synchronized (object) {
                dc = this.mRoot.getDisplayContentOrCreate(displayId);
                if (dc == null) {
                    Bitmap bitmap = null;
                    return bitmap;
                }
            }
            object = dc.screenshotApplications(this.mToken.asBinder(), width, height, false, frameScale, Bitmap.Config.RGB_565, false, false);
            return object;
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    void reportWindowsDrawn() {
        this.mHandler.post(this.mOnWindowsDrawn);
    }

    void reportWindowsVisible() {
        this.mHandler.post(this.mOnWindowsVisible);
    }

    void reportWindowsGone() {
        this.mHandler.post(this.mOnWindowsGone);
    }

    boolean keyDispatchingTimedOut(String reason) {
        return this.mListener != null && ((AppWindowContainerListener)this.mListener).keyDispatchingTimedOut(reason);
    }

    public String toString() {
        return "{AppWindowContainerController token=" + this.mToken + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$new$47$AppWindowContainerController() {
        AppWindowToken container;
        StartingData startingData;
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                return;
            }
            startingData = ((AppWindowToken)this.mContainer).startingData;
            container = (AppWindowToken)this.mContainer;
        }
        if (startingData == null) {
            return;
        }
        WindowManagerPolicy.StartingSurface surface = null;
        try {
            surface = startingData.createStartingSurface(container);
        }
        catch (Exception e) {
            Slog.w("WindowManager", "Exception when adding starting window", e);
        }
        if (surface != null) {
            boolean abort = false;
            HashMap hashMap2 = this.mWindowMap;
            synchronized (hashMap2) {
                if (container.removed || container.startingData == null) {
                    if (container.startingWindow != null) {
                        container.startingWindow = null;
                        container.startingData = null;
                        abort = true;
                    }
                } else {
                    container.startingSurface = surface;
                }
            }
            if (abort) {
                surface.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$new$46$AppWindowContainerController() {
        WindowManagerPolicy.StartingSurface surface = null;
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                return;
            }
            if (((AppWindowToken)this.mContainer).startingWindow != null) {
                surface = ((AppWindowToken)this.mContainer).startingSurface;
                ((AppWindowToken)this.mContainer).startingData = null;
                ((AppWindowToken)this.mContainer).startingSurface = null;
                ((AppWindowToken)this.mContainer).startingWindow = null;
                ((AppWindowToken)this.mContainer).startingDisplayed = false;
            }
        }
        if (surface != null) {
            try {
                surface.remove();
            }
            catch (Exception e) {
                Slog.w("WindowManager", "Exception when removing starting window", e);
            }
        }
    }

    final /* synthetic */ void lambda$new$45$AppWindowContainerController() {
        if (this.mListener == null) {
            return;
        }
        ((AppWindowContainerListener)this.mListener).onWindowsGone();
    }

    final /* synthetic */ void lambda$new$44$AppWindowContainerController() {
        if (this.mListener == null) {
            return;
        }
        ((AppWindowContainerListener)this.mListener).onWindowsVisible();
    }

    final /* synthetic */ void lambda$new$43$AppWindowContainerController() {
        if (this.mListener == null) {
            return;
        }
        ((AppWindowContainerListener)this.mListener).onWindowsDrawn();
    }
}

