/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.util.ArrayMap;
import android.view.WindowManagerInternal;
import android.view.animation.LinearInterpolator;
import com.android.server.wm.AppTransition;

public class BoundsAnimationController {
    private static final boolean DEBUG_LOCAL = false;
    private static final boolean DEBUG = false;
    private static final String TAG = "WindowManager";
    private static final int DEBUG_ANIMATION_SLOW_DOWN_FACTOR = 1;
    private ArrayMap<AnimateBoundsUser, BoundsAnimator> mRunningAnimations = new ArrayMap();
    private final Handler mHandler;
    private final AppTransition mAppTransition;
    private final AppTransitionNotifier mAppTransitionNotifier = new AppTransitionNotifier();
    private boolean mFinishAnimationAfterTransition = false;

    BoundsAnimationController(AppTransition transition2, Handler handler) {
        this.mHandler = handler;
        this.mAppTransition = transition2;
        this.mAppTransition.registerListenerLocked(this.mAppTransitionNotifier);
    }

    void animateBounds(AnimateBoundsUser target, Rect from, Rect to, int animationDuration) {
        BoundsAnimator existing;
        boolean replacing;
        boolean moveToFullscreen = false;
        if (to == null) {
            to = new Rect();
            target.getFullScreenBounds(to);
            moveToFullscreen = true;
        }
        boolean bl = replacing = (existing = this.mRunningAnimations.get(target)) != null;
        if (replacing) {
            if (existing.isAnimatingTo(to)) {
                return;
            }
            existing.cancel();
        }
        BoundsAnimator animator2 = new BoundsAnimator(target, from, to, moveToFullscreen, replacing);
        this.mRunningAnimations.put(target, animator2);
        animator2.setFloatValues(0.0f, 1.0f);
        animator2.setDuration((animationDuration != -1 ? animationDuration : 336) * 1);
        animator2.setInterpolator(new LinearInterpolator());
        animator2.start();
    }

    public static interface AnimateBoundsUser {
        public boolean setSize(Rect var1);

        public boolean setPinnedStackSize(Rect var1, Rect var2);

        public void onAnimationStart(boolean var1);

        public void onAnimationEnd();

        public void moveToFullscreen();

        public void getFullScreenBounds(Rect var1);
    }

    private final class BoundsAnimator
    extends ValueAnimator
    implements ValueAnimator.AnimatorUpdateListener,
    Animator.AnimatorListener {
        private final AnimateBoundsUser mTarget;
        private final Rect mFrom = new Rect();
        private final Rect mTo = new Rect();
        private final Rect mTmpRect = new Rect();
        private final Rect mTmpTaskBounds = new Rect();
        private final boolean mMoveToFullScreen;
        private boolean mWillReplace;
        private final boolean mReplacement;
        private final int mFrozenTaskWidth;
        private final int mFrozenTaskHeight;

        BoundsAnimator(AnimateBoundsUser target, Rect from, Rect to, boolean moveToFullScreen, boolean replacement) {
            this.mTarget = target;
            this.mFrom.set(from);
            this.mTo.set(to);
            this.mMoveToFullScreen = moveToFullScreen;
            this.mReplacement = replacement;
            this.addUpdateListener(this);
            this.addListener(this);
            if (this.animatingToLargerSize()) {
                this.mFrozenTaskWidth = this.mTo.width();
                this.mFrozenTaskHeight = this.mTo.height();
            } else {
                this.mFrozenTaskWidth = this.mFrom.width();
                this.mFrozenTaskHeight = this.mFrom.height();
            }
        }

        boolean animatingToLargerSize() {
            return this.mFrom.width() * this.mFrom.height() <= this.mTo.width() * this.mTo.height();
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            float remains = 1.0f - value;
            this.mTmpRect.left = (int)((float)this.mFrom.left * remains + (float)this.mTo.left * value + 0.5f);
            this.mTmpRect.top = (int)((float)this.mFrom.top * remains + (float)this.mTo.top * value + 0.5f);
            this.mTmpRect.right = (int)((float)this.mFrom.right * remains + (float)this.mTo.right * value + 0.5f);
            this.mTmpRect.bottom = (int)((float)this.mFrom.bottom * remains + (float)this.mTo.bottom * value + 0.5f);
            this.mTmpTaskBounds.set(this.mTmpRect.left, this.mTmpRect.top, this.mTmpRect.left + this.mFrozenTaskWidth, this.mTmpRect.top + this.mFrozenTaskHeight);
            if (!this.mTarget.setPinnedStackSize(this.mTmpRect, this.mTmpTaskBounds)) {
                animation.cancel();
            }
        }

        @Override
        public void onAnimationStart(Animator animation) {
            BoundsAnimationController.this.mFinishAnimationAfterTransition = false;
            if (!this.mReplacement) {
                this.mTarget.onAnimationStart(this.mMoveToFullScreen);
            }
            if (this.animatingToLargerSize()) {
                this.mTmpRect.set(this.mFrom.left, this.mFrom.top, this.mFrom.left + this.mFrozenTaskWidth, this.mFrom.top + this.mFrozenTaskHeight);
                this.mTarget.setPinnedStackSize(this.mFrom, this.mTmpRect);
            }
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            if (BoundsAnimationController.this.mAppTransition.isRunning() && !BoundsAnimationController.this.mFinishAnimationAfterTransition) {
                BoundsAnimationController.this.mFinishAnimationAfterTransition = true;
                return;
            }
            this.finishAnimation();
            this.mTarget.setPinnedStackSize(this.mTo, null);
            if (this.mMoveToFullScreen && !this.mWillReplace) {
                this.mTarget.moveToFullscreen();
            }
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            this.finishAnimation();
        }

        @Override
        public void cancel() {
            this.mWillReplace = true;
            super.cancel();
        }

        public boolean isAnimatingTo(Rect bounds) {
            return this.mTo.equals(bounds);
        }

        private void finishAnimation() {
            if (!this.mWillReplace) {
                this.mTarget.onAnimationEnd();
            }
            this.removeListener(this);
            this.removeUpdateListener(this);
            BoundsAnimationController.this.mRunningAnimations.remove(this.mTarget);
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }
    }

    private final class AppTransitionNotifier
    extends WindowManagerInternal.AppTransitionListener
    implements Runnable {
        private AppTransitionNotifier() {
        }

        public void onAppTransitionCancelledLocked() {
            this.animationFinished();
        }

        @Override
        public void onAppTransitionFinishedLocked(IBinder token) {
            this.animationFinished();
        }

        private void animationFinished() {
            if (BoundsAnimationController.this.mFinishAnimationAfterTransition) {
                BoundsAnimationController.this.mHandler.removeCallbacks(this);
                BoundsAnimationController.this.mHandler.post(this);
            }
        }

        @Override
        public void run() {
            for (int i = 0; i < BoundsAnimationController.this.mRunningAnimations.size(); ++i) {
                BoundsAnimator b = (BoundsAnimator)BoundsAnimationController.this.mRunningAnimations.valueAt(i);
                b.onAnimationEnd(null);
            }
        }
    }
}

