/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.hardware.display.DisplayManagerInternal;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.MutableBoolean;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.SurfaceControl;
import android.view.WindowManagerPolicy;
import com.android.internal.util.ToBooleanFunction;
import com.android.internal.view.IInputMethodClient;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DimLayerController;
import com.android.server.wm.DisplayContent$$Lambda$49;
import com.android.server.wm.DisplayContent$$Lambda$50;
import com.android.server.wm.DisplayContent$$Lambda$51;
import com.android.server.wm.DisplayContent$$Lambda$52;
import com.android.server.wm.DisplayContent$$Lambda$53;
import com.android.server.wm.DisplayContent$$Lambda$54;
import com.android.server.wm.DisplayContent$$Lambda$55;
import com.android.server.wm.DisplayContent$$Lambda$56;
import com.android.server.wm.DisplayContent$$Lambda$57;
import com.android.server.wm.DisplayContent$$Lambda$58;
import com.android.server.wm.DisplayContent$$Lambda$59;
import com.android.server.wm.DisplayContent$$Lambda$60;
import com.android.server.wm.DisplayContent$$Lambda$61;
import com.android.server.wm.DisplayContent$$Lambda$62;
import com.android.server.wm.DisplayContent$$Lambda$63;
import com.android.server.wm.DisplayContent$$Lambda$64;
import com.android.server.wm.DisplayContent$$Lambda$65;
import com.android.server.wm.DisplayContent$$Lambda$66;
import com.android.server.wm.DisplayContent$$Lambda$67;
import com.android.server.wm.DisplayContent$$Lambda$68;
import com.android.server.wm.DisplayContent$$Lambda$69;
import com.android.server.wm.DisplayContent$$Lambda$70;
import com.android.server.wm.DisplayContent$$Lambda$71;
import com.android.server.wm.DisplayContent$$Lambda$72;
import com.android.server.wm.DisplayContent$$Lambda$73;
import com.android.server.wm.DisplayContent$$Lambda$74;
import com.android.server.wm.DisplayContent$$Lambda$75;
import com.android.server.wm.DisplayContent$$Lambda$76;
import com.android.server.wm.DisplayContent$$Lambda$77;
import com.android.server.wm.DisplayContent$$Lambda$78;
import com.android.server.wm.DisplayContent$NonAppWindowContainers$$Lambda$79;
import com.android.server.wm.DisplayContent$NonAppWindowContainers$$Lambda$80;
import com.android.server.wm.DockedStackDividerController;
import com.android.server.wm.PinnedStackController;
import com.android.server.wm.RootWindowContainer;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskTapPointerEventListener;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowLayersController;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfaceController;
import com.android.server.wm.WindowSurfacePlacer;
import com.android.server.wm.WindowToken;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

class DisplayContent
extends WindowContainer<DisplayChildWindowContainer> {
    private static final String TAG = "WindowManager";
    private final int mDisplayId;
    private final TaskStackContainers mTaskStackContainers = new TaskStackContainers();
    private final NonAppWindowContainers mAboveAppWindowsContainers = new NonAppWindowContainers("mAboveAppWindowsContainers");
    private final NonAppWindowContainers mBelowAppWindowsContainers = new NonAppWindowContainers("mBelowAppWindowsContainers");
    private final NonAppWindowContainers mImeWindowsContainers = new NonAppWindowContainers("mImeWindowsContainers");
    private WindowState mTmpWindow;
    private WindowState mTmpWindow2;
    private WindowAnimator mTmpWindowAnimator;
    private boolean mTmpRecoveringMemory;
    private boolean mUpdateImeTarget;
    private boolean mTmpInitial;
    private final HashMap<IBinder, WindowToken> mTokenMap = new HashMap();
    int mInitialDisplayWidth = 0;
    int mInitialDisplayHeight = 0;
    int mInitialDisplayDensity = 0;
    int mBaseDisplayWidth = 0;
    int mBaseDisplayHeight = 0;
    int mBaseDisplayDensity = 0;
    boolean mDisplayScalingDisabled;
    private final DisplayInfo mDisplayInfo = new DisplayInfo();
    private final Display mDisplay;
    private final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    Rect mBaseDisplayRect = new Rect();
    private Rect mContentRect = new Rect();
    private boolean mLayoutNeeded;
    int pendingLayoutChanges;
    boolean isDefaultDisplay;
    final ArrayList<WindowToken> mExitingTokens = new ArrayList();
    private TaskStack mHomeStack = null;
    TaskTapPointerEventListener mTapDetector;
    private Region mTouchExcludeRegion = new Region();
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpRect2 = new Rect();
    private final RectF mTmpRectF = new RectF();
    private final Matrix mTmpMatrix = new Matrix();
    private final Region mTmpRegion = new Region();
    WindowManagerService mService;
    private boolean mDeferredRemoval;
    final DockedStackDividerController mDividerControllerLocked;
    final PinnedStackController mPinnedStackControllerLocked;
    DimLayerController mDimLayerController;
    final ArrayList<WindowState> mTapExcludedWindows = new ArrayList();
    private boolean mHaveBootMsg = false;
    private boolean mHaveApp = false;
    private boolean mHaveWallpaper = false;
    private boolean mHaveKeyguard = true;
    private final LinkedList<AppWindowToken> mTmpUpdateAllDrawn = new LinkedList();
    private final TaskForResizePointSearchResult mTmpTaskForResizePointSearchResult = new TaskForResizePointSearchResult();
    private final ApplySurfaceChangesTransactionState mTmpApplySurfaceChangesTransactionState = new ApplySurfaceChangesTransactionState();
    private final ScreenshotApplicationState mScreenshotApplicationState = new ScreenshotApplicationState();
    private boolean mRemovingDisplay = false;
    private final WindowLayersController mLayersController;
    WallpaperController mWallpaperController;
    int mInputMethodAnimLayerAdjustment;
    private final Consumer<WindowState> mUpdateWindowsForAnimator = DisplayContent$$Lambda$49.get$Lambda(this);
    private final Consumer<WindowState> mUpdateWallpaperForAnimator = DisplayContent$$Lambda$50.get$Lambda(this);
    private final Consumer<WindowState> mSetInputMethodAnimLayerAdjustment = DisplayContent$$Lambda$51.get$Lambda(this);
    private final Consumer<WindowState> mScheduleToastTimeout = DisplayContent$$Lambda$52.get$Lambda(this);
    private final ToBooleanFunction<WindowState> mFindFocusedWindow = DisplayContent$$Lambda$53.get$Lambda(this);
    private final Consumer<WindowState> mPrepareWindowSurfaces = DisplayContent$$Lambda$54.get$Lambda();
    private final Consumer<WindowState> mPerformLayout = DisplayContent$$Lambda$55.get$Lambda(this);
    private final Consumer<WindowState> mPerformLayoutAttached = DisplayContent$$Lambda$56.get$Lambda(this);
    private final Predicate<WindowState> mComputeImeTargetPredicate = DisplayContent$$Lambda$57.get$Lambda(this);
    private final Consumer<WindowState> mApplyPostLayoutPolicy = DisplayContent$$Lambda$58.get$Lambda(this);
    private final Consumer<WindowState> mApplySurfaceChangesTransaction = DisplayContent$$Lambda$59.get$Lambda(this);

    DisplayContent(Display display, WindowManagerService service, WindowLayersController layersController, WallpaperController wallpaperController) {
        if (service.mRoot.getDisplayContent(display.getDisplayId()) != null) {
            throw new IllegalArgumentException("Display with ID=" + display.getDisplayId() + " already exists=" + service.mRoot.getDisplayContent(display.getDisplayId()) + " new=" + display);
        }
        this.mDisplay = display;
        this.mDisplayId = display.getDisplayId();
        this.mLayersController = layersController;
        this.mWallpaperController = wallpaperController;
        display.getDisplayInfo(this.mDisplayInfo);
        display.getMetrics(this.mDisplayMetrics);
        this.isDefaultDisplay = this.mDisplayId == 0;
        this.mService = service;
        this.initializeDisplayBaseInfo();
        this.mDividerControllerLocked = new DockedStackDividerController(service, this);
        this.mPinnedStackControllerLocked = new PinnedStackController(service, this);
        this.mDimLayerController = new DimLayerController(this);
        super.addChild(this.mBelowAppWindowsContainers, null);
        super.addChild(this.mTaskStackContainers, null);
        super.addChild(this.mAboveAppWindowsContainers, null);
        super.addChild(this.mImeWindowsContainers, null);
        this.mService.mRoot.addChild(this, null);
    }

    int getDisplayId() {
        return this.mDisplayId;
    }

    WindowToken getWindowToken(IBinder binder) {
        return this.mTokenMap.get(binder);
    }

    AppWindowToken getAppWindowToken(IBinder binder) {
        WindowToken token = this.getWindowToken(binder);
        if (token == null) {
            return null;
        }
        return token.asAppWindowToken();
    }

    void addWindowToken(IBinder binder, WindowToken token) {
        DisplayContent dc = this.mService.mRoot.getWindowTokenDisplay(token);
        if (dc != null) {
            throw new IllegalArgumentException("Can't map token=" + token + " to display=" + this + " already mapped to display=" + dc + " tokens=" + dc.mTokenMap);
        }
        this.mTokenMap.put(binder, token);
        if (token.asAppWindowToken() == null) {
            switch (token.windowType) {
                case 2013: {
                    this.mBelowAppWindowsContainers.addChild(token);
                    break;
                }
                case 2011: 
                case 2012: {
                    this.mImeWindowsContainers.addChild(token);
                    break;
                }
                default: {
                    this.mAboveAppWindowsContainers.addChild(token);
                }
            }
        }
    }

    WindowToken removeWindowToken(IBinder binder) {
        WindowToken token = this.mTokenMap.remove(binder);
        if (token != null && token.asAppWindowToken() == null) {
            token.setExiting();
        }
        return token;
    }

    void reParentWindowToken(WindowToken token) {
        DisplayContent prevDc = token.getDisplayContent();
        if (prevDc == this) {
            return;
        }
        if (prevDc != null && prevDc.mTokenMap.remove(token.token) != null && token.asAppWindowToken() == null) {
            token.getParent().removeChild(token);
        }
        this.addWindowToken(token.token, token);
    }

    void removeAppToken(IBinder binder) {
        WindowToken token = this.removeWindowToken(binder);
        if (token == null) {
            Slog.w(TAG, "removeAppToken: Attempted to remove non-existing token: " + binder);
            return;
        }
        AppWindowToken appToken = token.asAppWindowToken();
        if (appToken == null) {
            Slog.w(TAG, "Attempted to remove non-App token: " + binder + " token=" + token);
            return;
        }
        appToken.onRemovedFromDisplay();
    }

    Display getDisplay() {
        return this.mDisplay;
    }

    DisplayInfo getDisplayInfo() {
        return this.mDisplayInfo;
    }

    DisplayMetrics getDisplayMetrics() {
        return this.mDisplayMetrics;
    }

    DockedStackDividerController getDockedDividerController() {
        return this.mDividerControllerLocked;
    }

    PinnedStackController getPinnedStackController() {
        return this.mPinnedStackControllerLocked;
    }

    boolean hasAccess(int uid) {
        return this.mDisplay.hasAccess(uid);
    }

    boolean isPrivate() {
        return (this.mDisplay.getFlags() & 4) != 0;
    }

    TaskStack getHomeStack() {
        if (this.mHomeStack == null && this.mDisplayId == 0) {
            Slog.e(TAG, "getHomeStack: Returning null from this=" + this);
        }
        return this.mHomeStack;
    }

    TaskStack getStackById(int stackId) {
        for (int i = this.mTaskStackContainers.size() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.get(i);
            if (stack.mStackId != stackId) continue;
            return stack;
        }
        return null;
    }

    @Override
    void onConfigurationChanged(Configuration newParentConfig) {
        super.onConfigurationChanged(newParentConfig);
        this.mService.reconfigureDisplayLocked(this);
        this.getDockedDividerController().onConfigurationChanged();
        this.getPinnedStackController().onConfigurationChanged();
    }

    void updateStackBoundsAfterConfigChange(List<Integer> changedStackList) {
        for (int i = this.mTaskStackContainers.size() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.get(i);
            if (!stack.updateBoundsAfterConfigChange()) continue;
            changedStackList.add(stack.mStackId);
        }
    }

    @Override
    boolean fillsParent() {
        return true;
    }

    @Override
    boolean isVisible() {
        return true;
    }

    @Override
    void onAppTransitionDone() {
        super.onAppTransitionDone();
        this.mService.mWindowsChanged = true;
    }

    @Override
    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (traverseTopToBottom) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                DisplayChildWindowContainer child = (DisplayChildWindowContainer)this.mChildren.get(i);
                if (child == this.mImeWindowsContainers && this.mService.mInputMethodTarget != null || !child.forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        } else {
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                DisplayChildWindowContainer child = (DisplayChildWindowContainer)this.mChildren.get(i);
                if (child == this.mImeWindowsContainers && this.mService.mInputMethodTarget != null || !child.forAllWindows(callback, traverseTopToBottom)) continue;
                return true;
            }
        }
        return false;
    }

    boolean forAllImeWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return this.mImeWindowsContainers.forAllWindows(callback, traverseTopToBottom);
    }

    @Override
    int getOrientation() {
        WindowManagerPolicy policy = this.mService.mPolicy;
        if (this.mService.mDisplayFrozen) {
            if (this.mService.mLastWindowForcedOrientation != -1) {
                return this.mService.mLastWindowForcedOrientation;
            }
            if (policy.isKeyguardLocked()) {
                return this.mService.mLastOrientation;
            }
        } else {
            int orientation = this.mAboveAppWindowsContainers.getOrientation();
            if (orientation != -2) {
                return orientation;
            }
        }
        return this.mTaskStackContainers.getOrientation();
    }

    void updateDisplayInfo() {
        this.mDisplay.getDisplayInfo(this.mDisplayInfo);
        this.mDisplay.getMetrics(this.mDisplayMetrics);
        for (int i = this.mTaskStackContainers.size() - 1; i >= 0; --i) {
            ((TaskStack)this.mTaskStackContainers.get(i)).updateDisplayInfo(null);
        }
    }

    void initializeDisplayBaseInfo() {
        DisplayInfo newDisplayInfo;
        DisplayManagerInternal displayManagerInternal = this.mService.mDisplayManagerInternal;
        if (displayManagerInternal != null && (newDisplayInfo = displayManagerInternal.getDisplayInfo(this.mDisplayId)) != null) {
            this.mDisplayInfo.copyFrom(newDisplayInfo);
        }
        this.mBaseDisplayWidth = this.mInitialDisplayWidth = this.mDisplayInfo.logicalWidth;
        this.mBaseDisplayHeight = this.mInitialDisplayHeight = this.mDisplayInfo.logicalHeight;
        this.mBaseDisplayDensity = this.mInitialDisplayDensity = this.mDisplayInfo.logicalDensityDpi;
        this.mBaseDisplayRect.set(0, 0, this.mBaseDisplayWidth, this.mBaseDisplayHeight);
    }

    void getLogicalDisplayRect(Rect out) {
        int orientation = this.mDisplayInfo.rotation;
        boolean rotated = orientation == 1 || orientation == 3;
        int physWidth = rotated ? this.mBaseDisplayHeight : this.mBaseDisplayWidth;
        int physHeight = rotated ? this.mBaseDisplayWidth : this.mBaseDisplayHeight;
        int width = this.mDisplayInfo.logicalWidth;
        int left = (physWidth - width) / 2;
        int height = this.mDisplayInfo.logicalHeight;
        int top = (physHeight - height) / 2;
        out.set(left, top, left + width, top + height);
    }

    private void getLogicalDisplayRect(Rect out, int orientation) {
        this.getLogicalDisplayRect(out);
        int currentRotation = this.mDisplayInfo.rotation;
        int rotationDelta = DisplayContent.deltaRotation(currentRotation, orientation);
        if (rotationDelta == 1 || rotationDelta == 3) {
            DisplayContent.createRotationMatrix(rotationDelta, this.mBaseDisplayWidth, this.mBaseDisplayHeight, this.mTmpMatrix);
            this.mTmpRectF.set(out);
            this.mTmpMatrix.mapRect(this.mTmpRectF);
            this.mTmpRectF.round(out);
        }
    }

    void getContentRect(Rect out) {
        out.set(this.mContentRect);
    }

    TaskStack addStackToDisplay(int stackId, boolean onTop) {
        TaskStack stack = this.getStackById(stackId);
        if (stack != null) {
            stack.mDeferRemoval = false;
            this.mTaskStackContainers.positionChildAt(onTop ? Integer.MAX_VALUE : Integer.MIN_VALUE, stack, false);
        } else {
            stack = new TaskStack(this.mService, stackId);
            this.mTaskStackContainers.addStackToDisplay(stack, onTop);
        }
        if (stackId == 3) {
            this.mDividerControllerLocked.notifyDockedStackExistsChanged(true);
        }
        return stack;
    }

    void moveStackToDisplay(TaskStack stack) {
        DisplayContent prevDc = stack.getDisplayContent();
        if (prevDc == null) {
            throw new IllegalStateException("Trying to move stackId=" + stack.mStackId + " which is not currently attached to any display");
        }
        if (prevDc.getDisplayId() == this.mDisplayId) {
            throw new IllegalArgumentException("Trying to move stackId=" + stack.mStackId + " to its current displayId=" + this.mDisplayId);
        }
        prevDc.mTaskStackContainers.removeStackFromDisplay(stack);
        this.mTaskStackContainers.addStackToDisplay(stack, true);
    }

    @Override
    protected void addChild(DisplayChildWindowContainer child, Comparator<DisplayChildWindowContainer> comparator) {
        throw new UnsupportedOperationException("See DisplayChildWindowContainer");
    }

    @Override
    protected void addChild(DisplayChildWindowContainer child, int index) {
        throw new UnsupportedOperationException("See DisplayChildWindowContainer");
    }

    @Override
    protected void removeChild(DisplayChildWindowContainer child) {
        if (this.mRemovingDisplay) {
            super.removeChild(child);
            return;
        }
        throw new UnsupportedOperationException("See DisplayChildWindowContainer");
    }

    @Override
    void positionChildAt(int position, DisplayChildWindowContainer child, boolean includingParents) {
        this.getParent().positionChildAt(position, this, includingParents);
    }

    int taskIdFromPoint(int x, int y) {
        for (int stackNdx = this.mTaskStackContainers.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.get(stackNdx);
            int taskId = stack.taskIdFromPoint(x, y);
            if (taskId == -1) continue;
            return taskId;
        }
        return -1;
    }

    Task findTaskForResizePoint(int x, int y) {
        int delta = WindowManagerService.dipToPixel(30, this.mDisplayMetrics);
        this.mTmpTaskForResizePointSearchResult.reset();
        for (int stackNdx = this.mTaskStackContainers.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.get(stackNdx);
            if (!ActivityManager.StackId.isTaskResizeAllowed(stack.mStackId)) {
                return null;
            }
            stack.findTaskForResizePoint(x, y, delta, this.mTmpTaskForResizePointSearchResult);
            if (!this.mTmpTaskForResizePointSearchResult.searchDone) continue;
            return this.mTmpTaskForResizePointSearchResult.taskForResize;
        }
        return null;
    }

    void setTouchExcludeRegion(Task focusedTask) {
        if (focusedTask == null) {
            this.mTouchExcludeRegion.setEmpty();
        } else {
            this.mTouchExcludeRegion.set(this.mBaseDisplayRect);
            int delta = WindowManagerService.dipToPixel(30, this.mDisplayMetrics);
            this.mTmpRect2.setEmpty();
            for (int stackNdx = this.mTaskStackContainers.size() - 1; stackNdx >= 0; --stackNdx) {
                TaskStack stack = (TaskStack)this.mTaskStackContainers.get(stackNdx);
                stack.setTouchExcludeRegion(focusedTask, delta, this.mTouchExcludeRegion, this.mContentRect, this.mTmpRect2);
            }
            if (!this.mTmpRect2.isEmpty()) {
                this.mTouchExcludeRegion.op(this.mTmpRect2, Region.Op.UNION);
            }
        }
        WindowState inputMethod = this.mService.mInputMethodWindow;
        if (inputMethod != null && inputMethod.isVisibleLw()) {
            inputMethod.getTouchableRegion(this.mTmpRegion);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        for (int i = this.mTapExcludedWindows.size() - 1; i >= 0; --i) {
            WindowState win = this.mTapExcludedWindows.get(i);
            win.getTouchableRegion(this.mTmpRegion);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        if (this.mDisplayId == 0 && this.getDockedStackLocked() != null) {
            this.mDividerControllerLocked.getTouchRegion(this.mTmpRect);
            this.mTmpRegion.set(this.mTmpRect);
            this.mTouchExcludeRegion.op(this.mTmpRegion, Region.Op.UNION);
        }
        if (this.mTapDetector != null) {
            this.mTapDetector.setTouchExcludeRegion(this.mTouchExcludeRegion);
        }
    }

    @Override
    void switchUser() {
        super.switchUser();
        this.mService.mWindowsChanged = true;
    }

    private void resetAnimationBackgroundAnimator() {
        for (int stackNdx = this.mTaskStackContainers.size() - 1; stackNdx >= 0; --stackNdx) {
            ((TaskStack)this.mTaskStackContainers.get(stackNdx)).resetAnimationBackgroundAnimator();
        }
    }

    boolean animateDimLayers() {
        return this.mDimLayerController.animateDimLayers();
    }

    private void resetDimming() {
        this.mDimLayerController.resetDimming();
    }

    boolean isDimming() {
        return this.mDimLayerController.isDimming();
    }

    private void stopDimmingIfNeeded() {
        this.mDimLayerController.stopDimmingIfNeeded();
    }

    @Override
    void removeIfPossible() {
        if (this.isAnimating()) {
            this.mDeferredRemoval = true;
            return;
        }
        this.removeImmediately();
    }

    @Override
    void removeImmediately() {
        this.mRemovingDisplay = true;
        try {
            super.removeImmediately();
            this.mDimLayerController.close();
            if (this.mDisplayId == 0 && this.mService.canDispatchPointerEvents()) {
                this.mService.unregisterPointerEventListener(this.mTapDetector);
                this.mService.unregisterPointerEventListener(this.mService.mMousePositionTracker);
            }
        }
        finally {
            this.mRemovingDisplay = false;
        }
    }

    @Override
    boolean checkCompleteDeferredRemoval() {
        boolean stillDeferringRemoval = super.checkCompleteDeferredRemoval();
        if (!stillDeferringRemoval && this.mDeferredRemoval) {
            this.removeImmediately();
            this.mService.onDisplayRemoved(this.mDisplayId);
            return false;
        }
        return true;
    }

    boolean animateForIme(float interpolatedValue, float animationTarget, float dividerAnimationTarget) {
        boolean updated = false;
        for (int i = this.mTaskStackContainers.size() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.get(i);
            if (stack == null || !stack.isAdjustedForIme()) continue;
            if (interpolatedValue >= 1.0f && animationTarget == 0.0f && dividerAnimationTarget == 0.0f) {
                stack.resetAdjustedForIme(true);
                updated = true;
            } else {
                this.mDividerControllerLocked.mLastAnimationProgress = this.mDividerControllerLocked.getInterpolatedAnimationValue(interpolatedValue);
                this.mDividerControllerLocked.mLastDividerProgress = this.mDividerControllerLocked.getInterpolatedDividerValue(interpolatedValue);
                updated |= stack.updateAdjustForIme(this.mDividerControllerLocked.mLastAnimationProgress, this.mDividerControllerLocked.mLastDividerProgress, false);
            }
            if (!(interpolatedValue >= 1.0f)) continue;
            stack.endImeAdjustAnimation();
        }
        return updated;
    }

    boolean clearImeAdjustAnimation() {
        boolean changed = false;
        for (int i = this.mTaskStackContainers.size() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.get(i);
            if (stack == null || !stack.isAdjustedForIme()) continue;
            stack.resetAdjustedForIme(true);
            changed = true;
        }
        return changed;
    }

    void beginImeAdjustAnimation() {
        for (int i = this.mTaskStackContainers.size() - 1; i >= 0; --i) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.get(i);
            if (!stack.isVisible() || !stack.isAdjustedForIme()) continue;
            stack.beginImeAdjustAnimation();
        }
    }

    void adjustForImeIfNeeded() {
        boolean imeHeightChanged;
        WindowState imeWin = this.mService.mInputMethodWindow;
        boolean imeVisible = imeWin != null && imeWin.isVisibleLw() && imeWin.isDisplayedLw() && !this.mDividerControllerLocked.isImeHideRequested();
        boolean dockVisible = this.isStackVisible(3);
        TaskStack imeTargetStack = this.mService.getImeFocusStackLocked();
        int imeDockSide = dockVisible && imeTargetStack != null ? imeTargetStack.getDockSide() : -1;
        boolean imeOnTop = imeDockSide == 2;
        boolean imeOnBottom = imeDockSide == 4;
        boolean dockMinimized = this.mDividerControllerLocked.isMinimizedDock();
        int imeHeight = this.mService.mPolicy.getInputMethodWindowVisibleHeightLw();
        boolean bl = imeHeightChanged = imeVisible && imeHeight != this.mDividerControllerLocked.getImeHeightAdjustedFor();
        if (imeVisible && dockVisible && (imeOnTop || imeOnBottom) && !dockMinimized) {
            for (int i = this.mTaskStackContainers.size() - 1; i >= 0; --i) {
                boolean isDockedOnBottom;
                TaskStack stack = (TaskStack)this.mTaskStackContainers.get(i);
                boolean bl2 = isDockedOnBottom = stack.getDockSide() == 4;
                if (stack.isVisible() && (imeOnBottom || isDockedOnBottom)) {
                    stack.setAdjustedForIme(imeWin, imeOnBottom && imeHeightChanged);
                    continue;
                }
                stack.resetAdjustedForIme(false);
            }
            this.mDividerControllerLocked.setAdjustedForIme(imeOnBottom, true, true, imeWin, imeHeight);
        } else {
            for (int i = this.mTaskStackContainers.size() - 1; i >= 0; --i) {
                TaskStack stack = (TaskStack)this.mTaskStackContainers.get(i);
                stack.resetAdjustedForIme(!dockVisible);
            }
            this.mDividerControllerLocked.setAdjustedForIme(false, false, dockVisible, imeWin, imeHeight);
        }
        this.mPinnedStackControllerLocked.setAdjustedForIme(imeVisible, imeHeight);
    }

    void setInputMethodAnimLayerAdjustment(int adj) {
        this.mInputMethodAnimLayerAdjustment = adj;
        this.mImeWindowsContainers.forAllWindows(this.mSetInputMethodAnimLayerAdjustment, true);
    }

    int getLayerForAnimationBackground(WindowStateAnimator winAnimator) {
        WindowState visibleWallpaper = this.mBelowAppWindowsContainers.getWindow(DisplayContent$$Lambda$60.get$Lambda());
        if (visibleWallpaper != null) {
            return visibleWallpaper.mWinAnimator.mAnimLayer;
        }
        return winAnimator.mAnimLayer;
    }

    void prepareFreezingTaskBounds() {
        for (int stackNdx = this.mTaskStackContainers.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.get(stackNdx);
            stack.prepareFreezingTaskBounds();
        }
    }

    void rotateBounds(int oldRotation, int newRotation, Rect bounds) {
        this.getLogicalDisplayRect(this.mTmpRect, newRotation);
        int deltaRotation = DisplayContent.deltaRotation(newRotation, oldRotation);
        DisplayContent.createRotationMatrix(deltaRotation, this.mTmpRect.width(), this.mTmpRect.height(), this.mTmpMatrix);
        this.mTmpRectF.set(bounds);
        this.mTmpMatrix.mapRect(this.mTmpRectF);
        this.mTmpRectF.round(bounds);
    }

    static int deltaRotation(int oldRotation, int newRotation) {
        int delta = newRotation - oldRotation;
        if (delta < 0) {
            delta += 4;
        }
        return delta;
    }

    private static void createRotationMatrix(int rotation, float displayWidth, float displayHeight, Matrix outMatrix) {
        DisplayContent.createRotationMatrix(rotation, 0.0f, 0.0f, displayWidth, displayHeight, outMatrix);
    }

    static void createRotationMatrix(int rotation, float rectLeft, float rectTop, float displayWidth, float displayHeight, Matrix outMatrix) {
        switch (rotation) {
            case 0: {
                outMatrix.reset();
                break;
            }
            case 3: {
                outMatrix.setRotate(270.0f, 0.0f, 0.0f);
                outMatrix.postTranslate(0.0f, displayHeight);
                outMatrix.postTranslate(rectTop, 0.0f);
                break;
            }
            case 2: {
                outMatrix.reset();
                break;
            }
            case 1: {
                outMatrix.setRotate(90.0f, 0.0f, 0.0f);
                outMatrix.postTranslate(displayWidth, 0.0f);
                outMatrix.postTranslate(-rectTop, rectLeft);
            }
        }
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("Display: mDisplayId=");
        pw.println(this.mDisplayId);
        String subPrefix = "  " + prefix;
        pw.print(subPrefix);
        pw.print("init=");
        pw.print(this.mInitialDisplayWidth);
        pw.print("x");
        pw.print(this.mInitialDisplayHeight);
        pw.print(" ");
        pw.print(this.mInitialDisplayDensity);
        pw.print("dpi");
        if (this.mInitialDisplayWidth != this.mBaseDisplayWidth || this.mInitialDisplayHeight != this.mBaseDisplayHeight || this.mInitialDisplayDensity != this.mBaseDisplayDensity) {
            pw.print(" base=");
            pw.print(this.mBaseDisplayWidth);
            pw.print("x");
            pw.print(this.mBaseDisplayHeight);
            pw.print(" ");
            pw.print(this.mBaseDisplayDensity);
            pw.print("dpi");
        }
        if (this.mDisplayScalingDisabled) {
            pw.println(" noscale");
        }
        pw.print(" cur=");
        pw.print(this.mDisplayInfo.logicalWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.logicalHeight);
        pw.print(" app=");
        pw.print(this.mDisplayInfo.appWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.appHeight);
        pw.print(" rng=");
        pw.print(this.mDisplayInfo.smallestNominalAppWidth);
        pw.print("x");
        pw.print(this.mDisplayInfo.smallestNominalAppHeight);
        pw.print("-");
        pw.print(this.mDisplayInfo.largestNominalAppWidth);
        pw.print("x");
        pw.println(this.mDisplayInfo.largestNominalAppHeight);
        pw.println(subPrefix + "deferred=" + this.mDeferredRemoval + " mLayoutNeeded=" + this.mLayoutNeeded);
        pw.println();
        pw.println(prefix + "Application tokens in top down Z order:");
        for (int stackNdx = this.mTaskStackContainers.size() - 1; stackNdx >= 0; --stackNdx) {
            TaskStack stack = (TaskStack)this.mTaskStackContainers.get(stackNdx);
            stack.dump(prefix + "  ", pw);
        }
        pw.println();
        if (!this.mExitingTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting tokens:");
            for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
                WindowToken token = this.mExitingTokens.get(i);
                pw.print("  Exiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ");
            }
        }
        pw.println();
        this.mDimLayerController.dump(prefix, pw);
        pw.println();
        this.mDividerControllerLocked.dump(prefix, pw);
        pw.println();
        this.mPinnedStackControllerLocked.dump(prefix, pw);
        if (this.mInputMethodAnimLayerAdjustment != 0) {
            pw.println(subPrefix + "mInputMethodAnimLayerAdjustment=" + this.mInputMethodAnimLayerAdjustment);
        }
    }

    public String toString() {
        return "Display " + this.mDisplayId + " info=" + this.mDisplayInfo + " stacks=" + this.mChildren;
    }

    @Override
    String getName() {
        return "Display " + this.mDisplayId + " name=\"" + this.mDisplayInfo.name + "\"";
    }

    boolean isStackVisible(int stackId) {
        TaskStack stack = this.getStackById(stackId);
        return stack != null && stack.isVisible();
    }

    TaskStack getDockedStackLocked() {
        TaskStack stack = this.getStackById(3);
        return stack != null && stack.isVisible() ? stack : null;
    }

    TaskStack getDockedStackIgnoringVisibility() {
        return this.getStackById(3);
    }

    WindowState getTouchableWinAtPointLocked(float xf, float yf) {
        int x = (int)xf;
        int y = (int)yf;
        WindowState touchedWin = this.getWindow(DisplayContent$$Lambda$61.get$Lambda(this, x, y));
        return touchedWin;
    }

    boolean canAddToastWindowForUid(int uid) {
        WindowState focusedWindowForUid = this.getWindow(DisplayContent$$Lambda$62.get$Lambda(uid));
        if (focusedWindowForUid != null) {
            return true;
        }
        WindowState win = this.getWindow(DisplayContent$$Lambda$63.get$Lambda(uid));
        return win == null;
    }

    void scheduleToastWindowsTimeoutIfNeededLocked(WindowState oldFocus, WindowState newFocus) {
        if (oldFocus == null || newFocus != null && newFocus.mOwnerUid == oldFocus.mOwnerUid) {
            return;
        }
        this.mTmpWindow = oldFocus;
        this.forAllWindows(this.mScheduleToastTimeout, false);
    }

    WindowState findFocusedWindow() {
        this.mTmpWindow = null;
        this.forAllWindows(this.mFindFocusedWindow, true);
        if (this.mTmpWindow == null) {
            return null;
        }
        return this.mTmpWindow;
    }

    void assignWindowLayers(boolean setLayoutNeeded) {
        this.mLayersController.assignWindowLayers(this);
        if (setLayoutNeeded) {
            this.setLayoutNeeded();
        }
    }

    void layoutAndAssignWindowLayersIfNeeded() {
        this.mService.mWindowsChanged = true;
        this.setLayoutNeeded();
        if (!this.mService.updateFocusedWindowLocked(3, false)) {
            this.assignWindowLayers(false);
        }
        this.mService.mInputMonitor.setUpdateInputWindowsNeededLw();
        this.mService.mWindowPlacerLocked.performSurfacePlacement();
        this.mService.mInputMonitor.updateInputWindowsLw(false);
    }

    boolean destroyLeakedSurfaces() {
        this.mTmpWindow = null;
        this.forAllWindows(DisplayContent$$Lambda$64.get$Lambda(this), false);
        return this.mTmpWindow != null;
    }

    WindowState computeImeTarget(boolean updateImeTarget) {
        WindowState curTarget;
        WindowState betterTarget;
        AppWindowToken token;
        if (this.mService.mInputMethodWindow == null) {
            if (updateImeTarget) {
                this.setInputMethodTarget(null, this.mService.mInputMethodTargetWaitingAnim, 0);
            }
            return null;
        }
        this.mUpdateImeTarget = updateImeTarget;
        WindowState target = this.getWindow(this.mComputeImeTargetPredicate);
        if (target != null && target.mAttrs.type == 3 && (token = target.mAppToken) != null && (betterTarget = token.getImeTargetBelowWindow(target)) != null) {
            target = betterTarget;
        }
        if ((curTarget = this.mService.mInputMethodTarget) != null && curTarget.isDisplayedLw() && curTarget.isClosing() && (target == null || curTarget.mWinAnimator.mAnimLayer > target.mWinAnimator.mAnimLayer)) {
            return curTarget;
        }
        if (target == null) {
            if (updateImeTarget) {
                this.setInputMethodTarget(null, this.mService.mInputMethodTargetWaitingAnim, 0);
            }
            return null;
        }
        if (updateImeTarget) {
            AppWindowToken token2;
            AppWindowToken appWindowToken = token2 = curTarget == null ? null : curTarget.mAppToken;
            if (token2 != null) {
                WindowState highestTarget = null;
                if (token2.mAppAnimator.animating || token2.mAppAnimator.animation != null) {
                    highestTarget = token2.getHighestAnimLayerWindow(curTarget);
                }
                if (highestTarget != null) {
                    AppTransition appTransition = this.mService.mAppTransition;
                    if (appTransition.isTransitionSet()) {
                        this.setInputMethodTarget(highestTarget, true, this.mInputMethodAnimLayerAdjustment);
                        return highestTarget;
                    }
                    if (highestTarget.mWinAnimator.isAnimationSet() && highestTarget.mWinAnimator.mAnimLayer > target.mWinAnimator.mAnimLayer) {
                        this.setInputMethodTarget(highestTarget, true, this.mInputMethodAnimLayerAdjustment);
                        return highestTarget;
                    }
                }
            }
            this.setInputMethodTarget(target, false, target.mAppToken != null ? target.mAppToken.mAppAnimator.animLayerAdjustment : 0);
        }
        return target;
    }

    private void setInputMethodTarget(WindowState target, boolean targetWaitingAnim, int layerAdj) {
        if (target == this.mService.mInputMethodTarget && this.mService.mInputMethodTargetWaitingAnim == targetWaitingAnim && this.mInputMethodAnimLayerAdjustment == layerAdj) {
            return;
        }
        this.mService.mInputMethodTarget = target;
        this.mService.mInputMethodTargetWaitingAnim = targetWaitingAnim;
        this.setInputMethodAnimLayerAdjustment(layerAdj);
        this.assignWindowLayers(false);
    }

    boolean getNeedsMenu(WindowState top, WindowManagerPolicy.WindowState bottom) {
        if (top.mAttrs.needsMenuKey != 0) {
            return top.mAttrs.needsMenuKey == 1;
        }
        this.mTmpWindow = null;
        WindowState candidate = this.getWindow(DisplayContent$$Lambda$65.get$Lambda(this, top, bottom));
        return candidate != null && candidate.mAttrs.needsMenuKey == 1;
    }

    void setLayoutNeeded() {
        this.mLayoutNeeded = true;
    }

    private void clearLayoutNeeded() {
        this.mLayoutNeeded = false;
    }

    boolean isLayoutNeeded() {
        return this.mLayoutNeeded;
    }

    void dumpTokens(PrintWriter pw, boolean dumpAll) {
        if (this.mTokenMap.isEmpty()) {
            return;
        }
        pw.println("  Display #" + this.mDisplayId);
        for (WindowToken token : this.mTokenMap.values()) {
            pw.print("  ");
            pw.print(token);
            if (dumpAll) {
                pw.println(':');
                token.dump(pw, "    ");
                continue;
            }
            pw.println();
        }
    }

    void dumpWindowAnimators(PrintWriter pw, String subPrefix) {
        int[] index = new int[1];
        this.forAllWindows(DisplayContent$$Lambda$66.get$Lambda(pw, subPrefix, index), false);
    }

    void enableSurfaceTrace(FileDescriptor fd) {
        this.forAllWindows(DisplayContent$$Lambda$67.get$Lambda(fd), true);
    }

    void disableSurfaceTrace() {
        this.forAllWindows(DisplayContent$$Lambda$68.get$Lambda(), true);
    }

    void startKeyguardExitOnNonAppWindows(boolean onWallpaper, boolean goingToShade) {
        WindowManagerPolicy policy = this.mService.mPolicy;
        this.forAllWindows(DisplayContent$$Lambda$69.get$Lambda(policy, onWallpaper, goingToShade), true);
    }

    boolean checkWaitingForWindows() {
        boolean wallpaperEnabled;
        this.mHaveBootMsg = false;
        this.mHaveApp = false;
        this.mHaveWallpaper = false;
        this.mHaveKeyguard = true;
        WindowState visibleWindow = this.getWindow(DisplayContent$$Lambda$70.get$Lambda(this));
        if (visibleWindow != null) {
            return true;
        }
        boolean bl = wallpaperEnabled = this.mService.mContext.getResources().getBoolean(17956951) && !this.mService.mOnlyCore;
        if (!this.mService.mSystemBooted && !this.mHaveBootMsg) {
            return true;
        }
        return this.mService.mSystemBooted && (!this.mHaveApp && !this.mHaveKeyguard || wallpaperEnabled && !this.mHaveWallpaper);
    }

    void updateWindowsForAnimator(WindowAnimator animator2) {
        this.mTmpWindowAnimator = animator2;
        this.forAllWindows(this.mUpdateWindowsForAnimator, true);
    }

    void updateWallpaperForAnimator(WindowAnimator animator2) {
        this.resetAnimationBackgroundAnimator();
        this.mTmpWindow = null;
        this.mTmpWindowAnimator = animator2;
        this.forAllWindows(this.mUpdateWallpaperForAnimator, true);
        if (animator2.mWindowDetachedWallpaper != this.mTmpWindow) {
            animator2.mWindowDetachedWallpaper = this.mTmpWindow;
            animator2.mBulkUpdateParams |= 2;
        }
    }

    void prepareWindowSurfaces() {
        this.forAllWindows(this.mPrepareWindowSurfaces, false);
    }

    boolean inputMethodClientHasFocus(IInputMethodClient client) {
        WindowState imFocus = this.computeImeTarget(false);
        if (imFocus == null) {
            return false;
        }
        IInputMethodClient imeClient = imFocus.mSession.mClient;
        return imeClient != null && imeClient.asBinder() == client.asBinder();
    }

    boolean hasSecureWindowOnScreen() {
        WindowState win = this.getWindow(DisplayContent$$Lambda$71.get$Lambda());
        return win != null;
    }

    void updateSystemUiVisibility(int visibility, int globalDiff) {
        this.forAllWindows(DisplayContent$$Lambda$72.get$Lambda(visibility, globalDiff), true);
    }

    void onWindowFreezeTimeout() {
        Slog.w(TAG, "Window freeze timeout expired.");
        this.mService.mWindowsFreezingScreen = 2;
        this.forAllWindows(DisplayContent$$Lambda$73.get$Lambda(this), true);
        this.mService.mWindowPlacerLocked.performSurfacePlacement();
    }

    void waitForAllWindowsDrawn() {
        WindowManagerPolicy policy = this.mService.mPolicy;
        this.forAllWindows(DisplayContent$$Lambda$74.get$Lambda(this, policy), true);
    }

    boolean applySurfaceChangesTransaction(boolean recoveringMemory) {
        int dw = this.mDisplayInfo.logicalWidth;
        int dh = this.mDisplayInfo.logicalHeight;
        WindowSurfacePlacer surfacePlacer = this.mService.mWindowPlacerLocked;
        this.mTmpUpdateAllDrawn.clear();
        int repeats = 0;
        do {
            if (++repeats > 6) {
                Slog.w(TAG, "Animation repeat aborted after too many iterations");
                this.clearLayoutNeeded();
                break;
            }
            if (this.isDefaultDisplay && (this.pendingLayoutChanges & 4) != 0) {
                this.mWallpaperController.adjustWallpaperWindows(this);
            }
            if (this.isDefaultDisplay && (this.pendingLayoutChanges & 2) != 0 && this.mService.updateOrientationFromAppTokensLocked(true, this.mDisplayId)) {
                this.setLayoutNeeded();
                this.mService.mH.obtainMessage(18, this.mDisplayId).sendToTarget();
            }
            if ((this.pendingLayoutChanges & 1) != 0) {
                this.setLayoutNeeded();
            }
            if (repeats < 4) {
                this.performLayout(repeats == 1, false);
            } else {
                Slog.w(TAG, "Layout repeat skipped after too many iterations");
            }
            this.pendingLayoutChanges = 0;
            if (!this.isDefaultDisplay) continue;
            this.mService.mPolicy.beginPostLayoutPolicyLw(dw, dh);
            this.forAllWindows(this.mApplyPostLayoutPolicy, true);
            this.pendingLayoutChanges |= this.mService.mPolicy.finishPostLayoutPolicyLw();
        } while (this.pendingLayoutChanges != 0);
        this.mTmpApplySurfaceChangesTransactionState.reset();
        this.resetDimming();
        this.mTmpRecoveringMemory = recoveringMemory;
        this.forAllWindows(this.mApplySurfaceChangesTransaction, true);
        this.mService.mDisplayManagerInternal.setDisplayProperties(this.mDisplayId, this.mTmpApplySurfaceChangesTransactionState.displayHasContent, this.mTmpApplySurfaceChangesTransactionState.preferredRefreshRate, this.mTmpApplySurfaceChangesTransactionState.preferredModeId, true);
        this.stopDimmingIfNeeded();
        while (!this.mTmpUpdateAllDrawn.isEmpty()) {
            AppWindowToken atoken = this.mTmpUpdateAllDrawn.removeLast();
            atoken.updateAllDrawn(this);
        }
        return this.mTmpApplySurfaceChangesTransactionState.focusDisplayed;
    }

    void performLayout(boolean initial, boolean updateInputWindows) {
        if (!this.isLayoutNeeded()) {
            return;
        }
        this.clearLayoutNeeded();
        int dw = this.mDisplayInfo.logicalWidth;
        int dh = this.mDisplayInfo.logicalHeight;
        this.mService.mPolicy.beginLayoutLw(this.isDefaultDisplay, dw, dh, this.mService.mRotation, this.getConfiguration().uiMode);
        if (this.isDefaultDisplay) {
            this.mService.mSystemDecorLayer = this.mService.mPolicy.getSystemDecorLayerLw();
            this.mService.mScreenRect.set(0, 0, dw, dh);
        }
        this.mService.mPolicy.getContentRectLw(this.mContentRect);
        int seq = this.mService.mLayoutSeq + 1;
        if (seq < 0) {
            seq = 0;
        }
        this.mService.mLayoutSeq = seq;
        this.mTmpWindow = null;
        this.mTmpInitial = initial;
        this.forAllWindows(this.mPerformLayout, true);
        this.mTmpWindow2 = this.mTmpWindow;
        this.mTmpWindow = null;
        this.forAllWindows(this.mPerformLayoutAttached, true);
        this.mService.mInputMonitor.layoutInputConsumers(dw, dh);
        this.mService.mInputMonitor.setUpdateInputWindowsNeededLw();
        if (updateInputWindows) {
            this.mService.mInputMonitor.updateInputWindowsLw(false);
        }
        this.mService.mPolicy.finishLayoutLw();
        this.mService.mH.sendEmptyMessage(41);
    }

    Bitmap screenshotApplications(IBinder appToken, int width, int height, boolean includeFullDisplay, float frameScale, Bitmap.Config config, boolean wallpaperOnly, boolean includeDecor) {
        Bitmap bitmap = (Bitmap)this.screenshotApplications(appToken, width, height, includeFullDisplay, frameScale, wallpaperOnly, includeDecor, DisplayContent$$Lambda$75.get$Lambda());
        if (bitmap == null) {
            return null;
        }
        Bitmap ret = bitmap.createAshmemBitmap(config);
        bitmap.recycle();
        return ret;
    }

    GraphicBuffer screenshotApplicationsToBuffer(IBinder appToken, int width, int height, boolean includeFullDisplay, float frameScale, boolean wallpaperOnly, boolean includeDecor) {
        return (GraphicBuffer)this.screenshotApplications(appToken, width, height, includeFullDisplay, frameScale, wallpaperOnly, includeDecor, DisplayContent$$Lambda$76.get$Lambda());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> E screenshotApplications(IBinder appToken, int width, int height, boolean includeFullDisplay, float frameScale, boolean wallpaperOnly, boolean includeDecor, Screenshoter<E> screenshoter) {
        E bitmap;
        boolean includeImeInScreenshot;
        int dw = this.mDisplayInfo.logicalWidth;
        int dh = this.mDisplayInfo.logicalHeight;
        if (dw == 0 || dh == 0) {
            return null;
        }
        this.mScreenshotApplicationState.reset(appToken == null && !wallpaperOnly);
        Rect frame = new Rect();
        Rect stackBounds = new Rect();
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken imeTargetAppToken = this.mService.mInputMethodTarget != null ? this.mService.mInputMethodTarget.mAppToken : null;
            includeImeInScreenshot = imeTargetAppToken != null && imeTargetAppToken.appToken != null && imeTargetAppToken.appToken.asBinder() == appToken && !this.mService.mInputMethodTarget.isInMultiWindowMode();
        }
        int aboveAppLayer = (this.mService.mPolicy.getWindowLayerFromTypeLw(2) + 1) * 10000 + 1000;
        MutableBoolean mutableIncludeFullDisplay = new MutableBoolean(includeFullDisplay);
        HashMap<IBinder, WindowState> hashMap2 = this.mService.mWindowMap;
        synchronized (hashMap2) {
            this.mScreenshotApplicationState.appWin = null;
            this.forAllWindows(DisplayContent$$Lambda$77.get$Lambda(this, aboveAppLayer, wallpaperOnly, includeImeInScreenshot, appToken, mutableIncludeFullDisplay, includeDecor, frame, stackBounds), true);
            WindowState appWin = this.mScreenshotApplicationState.appWin;
            boolean screenshotReady = this.mScreenshotApplicationState.screenshotReady;
            int maxLayer = this.mScreenshotApplicationState.maxLayer;
            int minLayer = this.mScreenshotApplicationState.minLayer;
            if (appToken != null && appWin == null) {
                return null;
            }
            if (!screenshotReady) {
                Slog.i(TAG, "Failed to capture screenshot of " + appToken + " appWin=" + (appWin == null ? "null" : appWin + " drawState=" + appWin.mWinAnimator.mDrawState));
                return null;
            }
            if (maxLayer == 0) {
                return null;
            }
            if (!mutableIncludeFullDisplay.value) {
                if (!frame.intersect(0, 0, dw, dh)) {
                    frame.setEmpty();
                }
            } else {
                frame.set(0, 0, dw, dh);
            }
            if (frame.isEmpty()) {
                return null;
            }
            if (width < 0) {
                width = (int)((float)frame.width() * frameScale);
            }
            if (height < 0) {
                height = (int)((float)frame.height() * frameScale);
            }
            Rect crop = new Rect(frame);
            if ((float)width / (float)frame.width() < (float)height / (float)frame.height()) {
                int cropWidth = (int)((float)width / (float)height * (float)frame.height());
                crop.right = crop.left + cropWidth;
            } else {
                int cropHeight = (int)((float)height / (float)width * (float)frame.width());
                crop.bottom = crop.top + cropHeight;
            }
            int rot = this.mDisplay.getRotation();
            if (rot == 1 || rot == 3) {
                rot = rot == 1 ? 3 : 1;
            }
            DisplayContent.convertCropForSurfaceFlinger(crop, rot, dw, dh);
            ScreenRotationAnimation screenRotationAnimation = this.mService.mAnimator.getScreenRotationAnimationLocked(0);
            boolean inRotation = screenRotationAnimation != null && screenRotationAnimation.isAnimating();
            SurfaceControl.openTransaction();
            SurfaceControl.closeTransactionSync();
            bitmap = screenshoter.screenshot(crop, width, height, minLayer, maxLayer, inRotation, rot);
            if (bitmap == null) {
                Slog.w(TAG, "Screenshot failure taking screenshot for (" + dw + "x" + dh + ") to layer " + maxLayer);
                return null;
            }
        }
        return bitmap;
    }

    private static void convertCropForSurfaceFlinger(Rect crop, int rot, int dw, int dh) {
        if (rot == 1) {
            int tmp = crop.top;
            crop.top = dw - crop.right;
            crop.right = crop.bottom;
            crop.bottom = dw - crop.left;
            crop.left = tmp;
        } else if (rot == 2) {
            int tmp = crop.top;
            crop.top = dh - crop.bottom;
            crop.bottom = dh - tmp;
            tmp = crop.right;
            crop.right = dw - crop.left;
            crop.left = dw - tmp;
        } else if (rot == 3) {
            int tmp = crop.top;
            crop.top = crop.left;
            crop.left = dh - crop.bottom;
            crop.bottom = crop.right;
            crop.right = dh - tmp;
        }
    }

    void onSeamlessRotationTimeout() {
        this.mTmpWindow = null;
        this.forAllWindows(DisplayContent$$Lambda$78.get$Lambda(this), true);
        if (this.mTmpWindow != null) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
        }
    }

    void setExitingTokensHasVisible(boolean hasVisible) {
        for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
            this.mExitingTokens.get((int)i).hasVisible = hasVisible;
        }
        this.mTaskStackContainers.setExitingTokensHasVisible(hasVisible);
    }

    void removeExistingTokensIfPossible() {
        for (int i = this.mExitingTokens.size() - 1; i >= 0; --i) {
            WindowToken token = this.mExitingTokens.get(i);
            if (token.hasVisible) continue;
            this.mExitingTokens.remove(i);
        }
        this.mTaskStackContainers.removeExistingAppTokensIfPossible();
    }

    final /* synthetic */ void lambda$onSeamlessRotationTimeout$87$DisplayContent(WindowState w) {
        if (!w.mSeamlesslyRotated) {
            return;
        }
        this.mTmpWindow = w;
        w.setDisplayLayoutNeeded();
        this.mService.markForSeamlessRotation(w, false);
    }

    static final /* synthetic */ void lambda$screenshotApplications$86$DisplayContent(WindowState w) {
        WindowSurfaceController controller = w.mWinAnimator.mSurfaceController;
        Slog.i(TAG, w + ": " + w.mLayer + " animLayer=" + w.mWinAnimator.mAnimLayer + " surfaceLayer=" + (controller == null ? "null" : Integer.valueOf(controller.getLayer())));
    }

    final /* synthetic */ boolean lambda$screenshotApplications$85$DisplayContent(int n, boolean bl, boolean bl2, IBinder iBinder, MutableBoolean mutableBoolean, boolean bl3, Rect rect, Rect rect2, WindowState w) {
        boolean foundTargetWs;
        if (!w.mHasSurface) {
            return false;
        }
        if (w.mLayer >= n) {
            return false;
        }
        if (bl && !w.mIsWallpaper) {
            return false;
        }
        if (w.mIsImWindow) {
            if (!bl2) {
                return false;
            }
        } else if (w.mIsWallpaper) {
            if (bl) {
                this.mScreenshotApplicationState.appWin = w;
            }
            if (this.mScreenshotApplicationState.appWin == null) {
                return false;
            }
        } else if (iBinder != null) {
            if (w.mAppToken == null || w.mAppToken.token != iBinder) {
                return false;
            }
            this.mScreenshotApplicationState.appWin = w;
        }
        WindowStateAnimator winAnim = w.mWinAnimator;
        int layer = winAnim.mSurfaceController.getLayer();
        if (this.mScreenshotApplicationState.maxLayer < layer) {
            this.mScreenshotApplicationState.maxLayer = layer;
        }
        if (this.mScreenshotApplicationState.minLayer > layer) {
            this.mScreenshotApplicationState.minLayer = layer;
        }
        if (!mutableBoolean.value && bl3) {
            TaskStack stack = w.getStack();
            if (stack != null) {
                stack.getBounds(rect);
            }
        } else if (!mutableBoolean.value && !w.mIsWallpaper) {
            Rect wf = w.mFrame;
            Rect cr = w.mContentInsets;
            int left = wf.left + cr.left;
            int top = wf.top + cr.top;
            int right = wf.right - cr.right;
            int bottom = wf.bottom - cr.bottom;
            rect.union(left, top, right, bottom);
            w.getVisibleBounds(rect2);
            if (!Rect.intersects(rect, rect2)) {
                rect.setEmpty();
            }
        }
        boolean bl4 = foundTargetWs = w.mAppToken != null && w.mAppToken.token == iBinder || this.mScreenshotApplicationState.appWin != null && bl;
        if (foundTargetWs && winAnim.getShown()) {
            this.mScreenshotApplicationState.screenshotReady = true;
        }
        return w.isObscuringDisplay();
    }

    final /* synthetic */ void lambda$waitForAllWindowsDrawn$84$DisplayContent(WindowManagerPolicy windowManagerPolicy, WindowState w) {
        boolean keyguard = windowManagerPolicy.isKeyguardHostWindow(w.mAttrs);
        if (w.isVisibleLw() && (w.mAppToken != null || keyguard)) {
            w.mWinAnimator.mDrawState = 1;
            w.mLastContentInsets.set(-1, -1, -1, -1);
            this.mService.mWaitingForDrawn.add(w);
        }
    }

    final /* synthetic */ void lambda$onWindowFreezeTimeout$83$DisplayContent(WindowState w) {
        if (!w.mOrientationChanging) {
            return;
        }
        w.mOrientationChanging = false;
        w.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mService.mDisplayFreezeTime);
        Slog.w(TAG, "Force clearing orientation change: " + w);
    }

    static final /* synthetic */ void lambda$updateSystemUiVisibility$82$DisplayContent(int n, int n2, WindowState w) {
        try {
            int curValue = w.mSystemUiVisibility;
            int diff = (curValue ^ n) & n2;
            int newValue = curValue & ~diff | n & diff;
            if (newValue != curValue) {
                ++w.mSeq;
                w.mSystemUiVisibility = newValue;
            }
            if (newValue != curValue || w.mAttrs.hasSystemUiListeners) {
                w.mClient.dispatchSystemUiVisibilityChanged(w.mSeq, n, newValue, diff);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static final /* synthetic */ boolean lambda$hasSecureWindowOnScreen$81$DisplayContent(WindowState w) {
        return w.isOnScreen() && (w.mAttrs.flags & 0x2000) != 0;
    }

    final /* synthetic */ boolean lambda$checkWaitingForWindows$80$DisplayContent(WindowState w) {
        if (w.isVisibleLw() && !w.mObscured && !w.isDrawnLw()) {
            return true;
        }
        if (w.isDrawnLw()) {
            if (w.mAttrs.type == 2021) {
                this.mHaveBootMsg = true;
            } else if (w.mAttrs.type == 2 || w.mAttrs.type == 4) {
                this.mHaveApp = true;
            } else if (w.mAttrs.type == 2013) {
                this.mHaveWallpaper = true;
            } else if (w.mAttrs.type == 2000) {
                this.mHaveKeyguard = this.mService.mPolicy.isKeyguardDrawnLw();
            }
        }
        return false;
    }

    static final /* synthetic */ void lambda$startKeyguardExitOnNonAppWindows$79$DisplayContent(WindowManagerPolicy windowManagerPolicy, boolean bl, boolean bl2, WindowState w) {
        if (w.mAppToken == null && windowManagerPolicy.canBeHiddenByKeyguardLw(w)) {
            w.mWinAnimator.setAnimation(windowManagerPolicy.createHiddenByKeyguardExit(bl, bl2));
        }
    }

    static final /* synthetic */ void lambda$disableSurfaceTrace$78$DisplayContent(WindowState w) {
        w.mWinAnimator.disableSurfaceTrace();
    }

    static final /* synthetic */ void lambda$enableSurfaceTrace$77$DisplayContent(FileDescriptor fileDescriptor, WindowState w) {
        w.mWinAnimator.enableSurfaceTrace(fileDescriptor);
    }

    static final /* synthetic */ void lambda$dumpWindowAnimators$76$DisplayContent(PrintWriter printWriter, String string2, int[] nArray, WindowState w) {
        WindowStateAnimator wAnim = w.mWinAnimator;
        printWriter.println(string2 + "Window #" + nArray[0] + ": " + wAnim);
        nArray[0] = nArray[0] + 1;
    }

    final /* synthetic */ boolean lambda$getNeedsMenu$75$DisplayContent(WindowState windowState, WindowManagerPolicy.WindowState windowState2, WindowState w) {
        if (w == windowState) {
            this.mTmpWindow = w;
        }
        if (this.mTmpWindow == null) {
            return false;
        }
        if (w.mAttrs.needsMenuKey != 0) {
            return true;
        }
        return w == windowState2;
    }

    final /* synthetic */ void lambda$destroyLeakedSurfaces$74$DisplayContent(WindowState w) {
        WindowStateAnimator wsa = w.mWinAnimator;
        if (wsa.mSurfaceController == null) {
            return;
        }
        if (!this.mService.mSessions.contains(wsa.mSession)) {
            Slog.w(TAG, "LEAKED SURFACE (session doesn't exist): " + w + " surface=" + wsa.mSurfaceController + " token=" + w.mToken + " pid=" + w.mSession.mPid + " uid=" + w.mSession.mUid);
            wsa.destroySurface();
            this.mService.mForceRemoves.add(w);
            this.mTmpWindow = w;
        } else if (w.mAppToken != null && w.mAppToken.clientHidden) {
            Slog.w(TAG, "LEAKED SURFACE (app token hidden): " + w + " surface=" + wsa.mSurfaceController + " token=" + w.mAppToken + " saved=" + w.hasSavedSurface());
            wsa.destroySurface();
            this.mTmpWindow = w;
        }
    }

    static final /* synthetic */ boolean lambda$canAddToastWindowForUid$73$DisplayContent(int n, WindowState w) {
        return w.mAttrs.type == 2005 && w.mOwnerUid == n && !w.mPermanentlyHidden && !w.mWindowRemovalAllowed;
    }

    static final /* synthetic */ boolean lambda$canAddToastWindowForUid$72$DisplayContent(int n, WindowState w) {
        return w.mOwnerUid == n && w.isFocused();
    }

    final /* synthetic */ boolean lambda$getTouchableWinAtPointLocked$71$DisplayContent(int n, int n2, WindowState w) {
        int flags = w.mAttrs.flags;
        if (!w.isVisibleLw()) {
            return false;
        }
        if ((flags & 0x10) != 0) {
            return false;
        }
        w.getVisibleBounds(this.mTmpRect);
        if (!this.mTmpRect.contains(n, n2)) {
            return false;
        }
        w.getTouchableRegion(this.mTmpRegion);
        int touchFlags = flags & 0x28;
        return this.mTmpRegion.contains(n, n2) || touchFlags == 0;
    }

    static final /* synthetic */ boolean lambda$getLayerForAnimationBackground$70$DisplayContent(WindowState w) {
        return w.mIsWallpaper && w.isVisibleNow();
    }

    final /* synthetic */ void lambda$new$69$DisplayContent(WindowState w) {
        boolean updateAllDrawn;
        AppWindowToken atoken;
        WindowSurfacePlacer surfacePlacer = this.mService.mWindowPlacerLocked;
        boolean obscuredChanged = w.mObscured != this.mTmpApplySurfaceChangesTransactionState.obscured;
        RootWindowContainer root = this.mService.mRoot;
        boolean someoneLosingFocus = !this.mService.mLosingFocus.isEmpty();
        w.mObscured = this.mTmpApplySurfaceChangesTransactionState.obscured;
        if (!this.mTmpApplySurfaceChangesTransactionState.obscured) {
            boolean isDisplayed = w.isDisplayedLw();
            if (isDisplayed && w.isObscuringDisplay()) {
                root.mObscuringWindow = w;
                this.mTmpApplySurfaceChangesTransactionState.obscured = true;
            }
            this.mTmpApplySurfaceChangesTransactionState.displayHasContent |= root.handleNotObscuredLocked(w, this.mTmpApplySurfaceChangesTransactionState.obscured, this.mTmpApplySurfaceChangesTransactionState.syswin);
            if (w.mHasSurface && isDisplayed) {
                int type = w.mAttrs.type;
                if (type == 2008 || type == 2010 || (w.mAttrs.privateFlags & 0x400) != 0) {
                    this.mTmpApplySurfaceChangesTransactionState.syswin = true;
                }
                if (this.mTmpApplySurfaceChangesTransactionState.preferredRefreshRate == 0.0f && w.mAttrs.preferredRefreshRate != 0.0f) {
                    this.mTmpApplySurfaceChangesTransactionState.preferredRefreshRate = w.mAttrs.preferredRefreshRate;
                }
                if (this.mTmpApplySurfaceChangesTransactionState.preferredModeId == 0 && w.mAttrs.preferredDisplayModeId != 0) {
                    this.mTmpApplySurfaceChangesTransactionState.preferredModeId = w.mAttrs.preferredDisplayModeId;
                }
            }
        }
        w.applyDimLayerIfNeeded();
        if (this.isDefaultDisplay && obscuredChanged && w.isVisibleLw() && this.mWallpaperController.isWallpaperTarget(w)) {
            this.mWallpaperController.updateWallpaperVisibility();
        }
        w.handleWindowMovedIfNeeded();
        WindowStateAnimator winAnimator = w.mWinAnimator;
        w.mContentChanged = false;
        if (w.mHasSurface) {
            boolean committed = winAnimator.commitFinishDrawingLocked();
            if (this.isDefaultDisplay && committed) {
                if (w.mAttrs.type == 2023) {
                    this.pendingLayoutChanges |= 1;
                }
                if ((w.mAttrs.flags & 0x100000) != 0) {
                    root.mWallpaperMayChange = true;
                    this.pendingLayoutChanges |= 4;
                }
            }
            if (!winAnimator.isAnimationStarting() && !winAnimator.isWaitingForOpening()) {
                winAnimator.computeShownFrameLocked();
            }
            winAnimator.setSurfaceBoundariesLocked(this.mTmpRecoveringMemory);
        }
        if ((atoken = w.mAppToken) != null && (updateAllDrawn = atoken.updateDrawnWindowStates(w)) && !this.mTmpUpdateAllDrawn.contains(atoken)) {
            this.mTmpUpdateAllDrawn.add(atoken);
        }
        if (this.isDefaultDisplay && someoneLosingFocus && w == this.mService.mCurrentFocus && w.isDisplayedLw()) {
            this.mTmpApplySurfaceChangesTransactionState.focusDisplayed = true;
        }
        w.updateResizingWindowIfNeeded();
    }

    final /* synthetic */ void lambda$new$68$DisplayContent(WindowState w) {
        this.mService.mPolicy.applyPostLayoutPolicyLw(w, w.mAttrs, w.getParentWindow(), this.mService.mInputMethodTarget);
    }

    final /* synthetic */ boolean lambda$new$67$DisplayContent(WindowState w) {
        return w.canBeImeTarget();
    }

    final /* synthetic */ void lambda$new$66$DisplayContent(WindowState w) {
        if (w.mLayoutAttached) {
            if (this.mTmpWindow != null && this.mService.mPolicy.canBeHiddenByKeyguardLw(w)) {
                return;
            }
            if (w.mViewVisibility != 8 && w.mRelayoutCalled || !w.mHaveFrame || w.mLayoutNeeded) {
                if (this.mTmpInitial) {
                    w.mContentChanged = false;
                }
                w.mLayoutNeeded = false;
                w.prelayout();
                this.mService.mPolicy.layoutWindowLw(w, w.getParentWindow());
                w.mLayoutSeq = this.mService.mLayoutSeq;
            }
        } else if (w.mAttrs.type == 2023) {
            this.mTmpWindow = this.mTmpWindow2;
        }
    }

    final /* synthetic */ void lambda$new$65$DisplayContent(WindowState w) {
        boolean gone;
        boolean bl = gone = this.mTmpWindow != null && this.mService.mPolicy.canBeHiddenByKeyguardLw(w) || w.isGoneForLayoutLw();
        if ((!gone || !w.mHaveFrame || w.mLayoutNeeded || (w.isConfigChanged() || w.setReportResizeHints()) && !w.isGoneForLayoutLw() && ((w.mAttrs.privateFlags & 0x400) != 0 || w.mHasSurface && w.mAppToken != null && w.mAppToken.layoutConfigChanges)) && !w.mLayoutAttached) {
            if (this.mTmpInitial) {
                w.mContentChanged = false;
            }
            if (w.mAttrs.type == 2023) {
                this.mTmpWindow = w;
            }
            w.mLayoutNeeded = false;
            w.prelayout();
            this.mService.mPolicy.layoutWindowLw(w, null);
            w.mLayoutSeq = this.mService.mLayoutSeq;
            Task task = w.getTask();
            if (task != null) {
                this.mDimLayerController.updateDimLayer(task);
            }
        }
    }

    static final /* synthetic */ void lambda$new$64$DisplayContent(WindowState w) {
        w.mWinAnimator.prepareSurfaceLocked(true);
    }

    final /* synthetic */ boolean lambda$new$63$DisplayContent(WindowState w) {
        AppWindowToken focusedApp = this.mService.mFocusedApp;
        if (!w.canReceiveKeys()) {
            return false;
        }
        AppWindowToken wtoken = w.mAppToken;
        if (wtoken != null && (wtoken.removed || wtoken.sendingToBottom)) {
            return false;
        }
        if (focusedApp == null) {
            this.mTmpWindow = w;
            return true;
        }
        if (!focusedApp.windowsAreFocusable()) {
            this.mTmpWindow = w;
            return true;
        }
        if (wtoken != null && w.mAttrs.type != 3 && focusedApp.compareTo(wtoken) > 0) {
            this.mTmpWindow = null;
            return true;
        }
        this.mTmpWindow = w;
        return true;
    }

    final /* synthetic */ void lambda$new$62$DisplayContent(WindowState w) {
        int lostFocusUid = this.mTmpWindow.mOwnerUid;
        WindowManagerService.H handler = this.mService.mH;
        if (w.mAttrs.type == 2005 && w.mOwnerUid == lostFocusUid && !handler.hasMessages(52, w)) {
            handler.sendMessageDelayed(handler.obtainMessage(52, w), w.mAttrs.hideTimeoutMilliseconds);
        }
    }

    final /* synthetic */ void lambda$new$61$DisplayContent(WindowState w) {
        w.adjustAnimLayer(this.mInputMethodAnimLayerAdjustment);
    }

    final /* synthetic */ void lambda$new$60$DisplayContent(WindowState w) {
        AppWindowAnimator appAnimator;
        WindowStateAnimator winAnimator = w.mWinAnimator;
        if (winAnimator.mSurfaceController == null || !winAnimator.hasSurface()) {
            return;
        }
        int flags = w.mAttrs.flags;
        if (winAnimator.mAnimating) {
            if (winAnimator.mAnimation != null) {
                TaskStack stack;
                int color2;
                if ((flags & 0x100000) != 0 && winAnimator.mAnimation.getDetachWallpaper()) {
                    this.mTmpWindow = w;
                }
                if ((color2 = winAnimator.mAnimation.getBackgroundColor()) != 0 && (stack = w.getStack()) != null) {
                    stack.setAnimationBackground(winAnimator, color2);
                }
            }
            this.mTmpWindowAnimator.setAnimating(true);
        }
        if ((appAnimator = winAnimator.mAppAnimator) != null && appAnimator.animation != null && appAnimator.animating) {
            TaskStack stack;
            int color3;
            if ((flags & 0x100000) != 0 && appAnimator.animation.getDetachWallpaper()) {
                this.mTmpWindow = w;
            }
            if ((color3 = appAnimator.animation.getBackgroundColor()) != 0 && (stack = w.getStack()) != null) {
                stack.setAnimationBackground(winAnimator, color3);
            }
        }
    }

    final /* synthetic */ void lambda$new$59$DisplayContent(WindowState w) {
        AppWindowAnimator appAnimator;
        WindowStateAnimator winAnimator = w.mWinAnimator;
        if (winAnimator.hasSurface()) {
            boolean nowAnimating;
            boolean wasAnimating = winAnimator.mWasAnimating;
            winAnimator.mWasAnimating = nowAnimating = winAnimator.stepAnimationLocked(this.mTmpWindowAnimator.mCurrentTime);
            this.mTmpWindowAnimator.orAnimating(nowAnimating);
            if (wasAnimating && !winAnimator.mAnimating && this.mWallpaperController.isWallpaperTarget(w)) {
                this.mTmpWindowAnimator.mBulkUpdateParams |= 2;
                this.pendingLayoutChanges |= 4;
            }
        }
        AppWindowToken atoken = w.mAppToken;
        if (winAnimator.mDrawState == 3 && (atoken == null || atoken.allDrawn) && w.performShowLocked()) {
            this.pendingLayoutChanges |= 8;
        }
        if ((appAnimator = winAnimator.mAppAnimator) != null && appAnimator.thumbnail != null) {
            if (appAnimator.thumbnailTransactionSeq != this.mTmpWindowAnimator.mAnimTransactionSequence) {
                appAnimator.thumbnailTransactionSeq = this.mTmpWindowAnimator.mAnimTransactionSequence;
                appAnimator.thumbnailLayer = 0;
            }
            if (appAnimator.thumbnailLayer < winAnimator.mAnimLayer) {
                appAnimator.thumbnailLayer = winAnimator.mAnimLayer;
            }
        }
    }

    @FunctionalInterface
    private static interface Screenshoter<E> {
        public E screenshot(Rect var1, int var2, int var3, int var4, int var5, boolean var6, int var7);
    }

    private final class NonAppWindowContainers
    extends DisplayChildWindowContainer<WindowToken> {
        private final Comparator<WindowToken> mWindowComparator = DisplayContent$NonAppWindowContainers$$Lambda$79.get$Lambda(this);
        private final Predicate<WindowState> mGetOrientingWindow = DisplayContent$NonAppWindowContainers$$Lambda$80.get$Lambda();
        private final String mName;

        NonAppWindowContainers(String name) {
            this.mName = name;
        }

        void addChild(WindowToken token) {
            this.addChild(token, this.mWindowComparator);
        }

        @Override
        int getOrientation() {
            WindowManagerPolicy policy = DisplayContent.this.mService.mPolicy;
            WindowState win = this.getWindow(this.mGetOrientingWindow);
            if (win != null) {
                int req = win.mAttrs.screenOrientation;
                if (policy.isKeyguardHostWindow(win.mAttrs)) {
                    DisplayContent.this.mService.mLastKeyguardForcedOrientation = req;
                }
                DisplayContent.this.mService.mLastWindowForcedOrientation = req;
                return DisplayContent.this.mService.mLastWindowForcedOrientation;
            }
            DisplayContent.this.mService.mLastWindowForcedOrientation = -1;
            if (policy.isKeyguardShowingAndNotOccluded()) {
                return DisplayContent.this.mService.mLastKeyguardForcedOrientation;
            }
            return -2;
        }

        @Override
        String getName() {
            return this.mName;
        }

        static final /* synthetic */ boolean lambda$new$89$DisplayContent$NonAppWindowContainers(WindowState w) {
            if (!w.isVisibleLw() || !w.mPolicyVisibilityAfterAnim) {
                return false;
            }
            int req = w.mAttrs.screenOrientation;
            return req != -1 && req != 3 && req != -2;
        }

        final /* synthetic */ int lambda$new$88$DisplayContent$NonAppWindowContainers(WindowToken token1, WindowToken token2) {
            return DisplayContent.this.mService.mPolicy.getWindowLayerFromTypeLw(token1.windowType, token1.mOwnerCanManageAppTokens) < DisplayContent.this.mService.mPolicy.getWindowLayerFromTypeLw(token2.windowType, token2.mOwnerCanManageAppTokens) ? -1 : 1;
        }
    }

    private final class TaskStackContainers
    extends DisplayChildWindowContainer<TaskStack> {
        private TaskStackContainers() {
        }

        void addStackToDisplay(TaskStack stack, boolean onTop) {
            if (stack.mStackId == 0) {
                if (DisplayContent.this.mHomeStack != null) {
                    throw new IllegalArgumentException("attachStack: HOME_STACK_ID (0) not first.");
                }
                DisplayContent.this.mHomeStack = stack;
            }
            this.addChild(stack, onTop);
            stack.onDisplayChanged(DisplayContent.this);
        }

        void removeStackFromDisplay(TaskStack stack) {
            this.removeChild(stack);
            stack.onRemovedFromDisplay();
        }

        private void addChild(TaskStack stack, boolean toTop) {
            int addIndex = this.findPositionForStack(toTop ? this.mChildren.size() : 0, stack, true);
            this.addChild(stack, addIndex);
            DisplayContent.this.setLayoutNeeded();
        }

        @Override
        void positionChildAt(int position, TaskStack child, boolean includingParents) {
            if (ActivityManager.StackId.isAlwaysOnTop(child.mStackId) && position != Integer.MAX_VALUE) {
                Slog.w(DisplayContent.TAG, "Ignoring move of always-on-top stack=" + this + " to bottom");
                int currentPosition = this.mChildren.indexOf(child);
                super.positionChildAt(currentPosition, child, false);
                return;
            }
            int targetPosition = this.findPositionForStack(position, child, false);
            super.positionChildAt(targetPosition, child, includingParents);
            DisplayContent.this.setLayoutNeeded();
        }

        private int findPositionForStack(int requestedPosition, TaskStack stack, boolean adding) {
            boolean toTop;
            int topChildPosition = this.mChildren.size() - 1;
            boolean bl = toTop = requestedPosition == Integer.MAX_VALUE;
            boolean bl2 = adding ? requestedPosition >= topChildPosition + 1 : requestedPosition >= topChildPosition;
            int targetPosition = requestedPosition;
            if ((toTop |= bl2) && DisplayContent.this.isStackVisible(4) && stack.mStackId != 4) {
                TaskStack topStack = (TaskStack)this.mChildren.get(topChildPosition);
                if (topStack.mStackId != 4) {
                    throw new IllegalStateException("Pinned stack isn't top stack??? " + this.mChildren);
                }
                targetPosition = adding ? topChildPosition : topChildPosition - 1;
            }
            return targetPosition;
        }

        @Override
        boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
            if (traverseTopToBottom) {
                if (super.forAllWindows(callback, traverseTopToBottom)) {
                    return true;
                }
                if (this.forAllExitingAppTokenWindows(callback, traverseTopToBottom)) {
                    return true;
                }
            } else {
                if (this.forAllExitingAppTokenWindows(callback, traverseTopToBottom)) {
                    return true;
                }
                if (super.forAllWindows(callback, traverseTopToBottom)) {
                    return true;
                }
            }
            return false;
        }

        private boolean forAllExitingAppTokenWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
            if (traverseTopToBottom) {
                for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                    AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                    for (int j = appTokens.size() - 1; j >= 0; --j) {
                        if (!((AppWindowToken)appTokens.get(j)).forAllWindowsUnchecked(callback, traverseTopToBottom)) continue;
                        return true;
                    }
                }
            } else {
                int count = this.mChildren.size();
                for (int i = 0; i < count; ++i) {
                    AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                    int appTokensCount = appTokens.size();
                    for (int j = 0; j < appTokensCount; ++j) {
                        if (!((AppWindowToken)appTokens.get(j)).forAllWindowsUnchecked(callback, traverseTopToBottom)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        void setExitingTokensHasVisible(boolean hasVisible) {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                for (int j = appTokens.size() - 1; j >= 0; --j) {
                    ((AppWindowToken)appTokens.get((int)j)).hasVisible = hasVisible;
                }
            }
        }

        void removeExistingAppTokensIfPossible() {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                AppTokenList appTokens = ((TaskStack)this.mChildren.get((int)i)).mExitingAppTokens;
                for (int j = appTokens.size() - 1; j >= 0; --j) {
                    AppWindowToken token = (AppWindowToken)appTokens.get(j);
                    if (token.hasVisible || DisplayContent.this.mService.mClosingApps.contains(token) || token.mIsExiting && !token.isEmpty()) continue;
                    token.mAppAnimator.clearAnimation();
                    token.mAppAnimator.animating = false;
                    token.removeIfPossible();
                }
            }
        }

        @Override
        int getOrientation() {
            if (DisplayContent.this.isStackVisible(3) || DisplayContent.this.isStackVisible(2)) {
                int orientation;
                if (DisplayContent.this.mHomeStack != null && DisplayContent.this.mHomeStack.isVisible() && DisplayContent.this.mDividerControllerLocked.isMinimizedDock() && (orientation = DisplayContent.this.mHomeStack.getOrientation()) != -2) {
                    return orientation;
                }
                return -1;
            }
            int orientation = super.getOrientation();
            if (orientation != -2 && orientation != 3) {
                return orientation;
            }
            return DisplayContent.this.mService.mLastOrientation;
        }
    }

    static class DisplayChildWindowContainer<E extends WindowContainer>
    extends WindowContainer<E> {
        DisplayChildWindowContainer() {
        }

        int size() {
            return this.mChildren.size();
        }

        E get(int index) {
            return (E)((WindowContainer)this.mChildren.get(index));
        }

        @Override
        boolean fillsParent() {
            return true;
        }

        @Override
        boolean isVisible() {
            return true;
        }
    }

    private static final class ScreenshotApplicationState {
        WindowState appWin;
        int maxLayer;
        int minLayer;
        boolean screenshotReady;

        private ScreenshotApplicationState() {
        }

        void reset(boolean screenshotReady) {
            this.appWin = null;
            this.maxLayer = 0;
            this.minLayer = 0;
            this.screenshotReady = screenshotReady;
            this.minLayer = screenshotReady ? 0 : Integer.MAX_VALUE;
        }
    }

    private static final class ApplySurfaceChangesTransactionState {
        boolean displayHasContent;
        boolean obscured;
        boolean syswin;
        boolean focusDisplayed;
        float preferredRefreshRate;
        int preferredModeId;

        private ApplySurfaceChangesTransactionState() {
        }

        void reset() {
            this.displayHasContent = false;
            this.obscured = false;
            this.syswin = false;
            this.focusDisplayed = false;
            this.preferredRefreshRate = 0.0f;
            this.preferredModeId = 0;
        }
    }

    static final class TaskForResizePointSearchResult {
        boolean searchDone;
        Task taskForResize;

        TaskForResizePointSearchResult() {
        }

        void reset() {
            this.searchDone = false;
            this.taskForResize = null;
        }
    }
}

