/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.RemoteAction;
import android.content.pm.ParceledListSlice;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.util.Slog;
import android.util.TypedValue;
import android.view.DisplayInfo;
import android.view.Gravity;
import android.view.IPinnedStackController;
import android.view.IPinnedStackListener;
import com.android.internal.policy.PipSnapAlgorithm;
import com.android.server.UiThread;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.PinnedStackController$PinnedStackControllerCallback$$Lambda$26;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

class PinnedStackController {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private final Handler mHandler = UiThread.getHandler();
    private IPinnedStackListener mPinnedStackListener;
    private final PinnedStackListenerDeathHandler mPinnedStackListenerDeathHandler = new PinnedStackListenerDeathHandler();
    private final PinnedStackControllerCallback mCallbacks = new PinnedStackControllerCallback();
    private final PipSnapAlgorithm mSnapAlgorithm;
    private boolean mIsMinimized;
    private boolean mIsImeShowing;
    private int mImeHeight;
    private ArrayList<RemoteAction> mActions = new ArrayList();
    private float mAspectRatio = -1.0f;
    private final DisplayInfo mDisplayInfo = new DisplayInfo();
    private final Rect mStableInsets = new Rect();
    private int mDefaultStackGravity;
    private Size mDefaultStackSize;
    private Point mScreenEdgeInsets;
    private float mMinAspectRatio;
    private float mMaxAspectRatio;
    private final DisplayMetrics mTmpMetrics = new DisplayMetrics();
    private final Rect mTmpInsets = new Rect();
    private final Rect mTmpRect = new Rect();
    private final Point mTmpDisplaySize = new Point();

    PinnedStackController(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mDisplayContent = displayContent;
        this.mSnapAlgorithm = new PipSnapAlgorithm(service.mContext);
        this.mDisplayInfo.copyFrom(this.mDisplayContent.getDisplayInfo());
        this.reloadResources();
    }

    void onConfigurationChanged() {
        this.reloadResources();
        this.notifyMovementBoundsChanged(false);
    }

    void reloadResources() {
        Resources res = this.mService.mContext.getResources();
        Size defaultSizeDp = Size.parseSize(res.getString(17039627));
        Size screenEdgeInsetsDp = Size.parseSize(res.getString(17039626));
        this.mDefaultStackGravity = res.getInteger(17694768);
        this.mDisplayContent.getDisplay().getRealMetrics(this.mTmpMetrics);
        this.mDefaultStackSize = new Size(this.dpToPx(defaultSizeDp.getWidth(), this.mTmpMetrics), this.dpToPx(defaultSizeDp.getHeight(), this.mTmpMetrics));
        this.mScreenEdgeInsets = new Point(this.dpToPx(screenEdgeInsetsDp.getWidth(), this.mTmpMetrics), this.dpToPx(screenEdgeInsetsDp.getHeight(), this.mTmpMetrics));
        this.mMinAspectRatio = res.getFloat(17104954);
        this.mMaxAspectRatio = res.getFloat(17104953);
    }

    void registerPinnedStackListener(IPinnedStackListener listener) {
        try {
            listener.asBinder().linkToDeath(this.mPinnedStackListenerDeathHandler, 0);
            listener.onListenerRegistered(this.mCallbacks);
            this.mPinnedStackListener = listener;
            this.notifyImeVisibilityChanged(this.mIsImeShowing, this.mImeHeight);
            this.notifyMovementBoundsChanged(false);
            this.notifyActionsChanged(this.mActions);
            this.notifyMinimizeChanged(this.mIsMinimized);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register pinned stack listener", e);
        }
    }

    public boolean isValidPictureInPictureAspectRatio(float aspectRatio) {
        return this.mMinAspectRatio <= aspectRatio && aspectRatio <= this.mMaxAspectRatio;
    }

    Rect transformBoundsToAspectRatio(Rect stackBounds, float aspectRatio) {
        float snapFraction = this.mSnapAlgorithm.getSnapFraction(stackBounds, this.getMovementBounds(stackBounds));
        float radius = PointF.length(stackBounds.width(), stackBounds.height());
        int height = (int)Math.round(Math.sqrt(radius * radius / (aspectRatio * aspectRatio + 1.0f)));
        int width = Math.round((float)height * aspectRatio);
        int left = (int)((float)stackBounds.centerX() - (float)width / 2.0f);
        int top = (int)((float)stackBounds.centerY() - (float)height / 2.0f);
        stackBounds.set(left, top, left + width, top + height);
        this.mSnapAlgorithm.applySnapFraction(stackBounds, this.getMovementBounds(stackBounds), snapFraction);
        if (this.mIsMinimized) {
            this.applyMinimizedOffset(stackBounds, this.getMovementBounds(stackBounds));
        }
        return stackBounds;
    }

    Rect getDefaultBounds() {
        Rect insetBounds = new Rect();
        this.getInsetBounds(insetBounds);
        Rect defaultBounds = new Rect();
        Gravity.apply(this.mDefaultStackGravity, this.mDefaultStackSize.getWidth(), this.mDefaultStackSize.getHeight(), insetBounds, 0, 0, defaultBounds);
        return defaultBounds;
    }

    private Rect getMovementBounds(Rect stackBounds) {
        return this.getMovementBounds(stackBounds, true);
    }

    private Rect getMovementBounds(Rect stackBounds, boolean adjustForIme) {
        Rect movementBounds = new Rect();
        this.getInsetBounds(movementBounds);
        this.mSnapAlgorithm.getMovementBounds(stackBounds, movementBounds, movementBounds, adjustForIme && this.mIsImeShowing ? this.mImeHeight : 0);
        return movementBounds;
    }

    Rect onDisplayChanged(Rect preChangeStackBounds, Rect preChangeTargetBounds, DisplayContent displayContent) {
        Rect postChangeStackBounds = new Rect(preChangeTargetBounds);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        if (!this.mDisplayInfo.equals(displayInfo)) {
            Rect preChangeMovementBounds = this.getMovementBounds(preChangeStackBounds);
            float snapFraction = this.mSnapAlgorithm.getSnapFraction(preChangeStackBounds, preChangeMovementBounds);
            this.mDisplayInfo.copyFrom(displayInfo);
            Rect postChangeMovementBounds = this.getMovementBounds(preChangeStackBounds, false);
            this.mSnapAlgorithm.applySnapFraction(postChangeStackBounds, postChangeMovementBounds, snapFraction);
            if (this.mIsMinimized) {
                this.applyMinimizedOffset(postChangeStackBounds, postChangeMovementBounds);
            }
            this.notifyMovementBoundsChanged(false);
        }
        return postChangeStackBounds;
    }

    void setAdjustedForIme(boolean adjustedForIme, int imeHeight) {
        if (this.mIsImeShowing == adjustedForIme && this.mImeHeight == imeHeight) {
            return;
        }
        this.mIsImeShowing = adjustedForIme;
        this.mImeHeight = imeHeight;
        this.notifyImeVisibilityChanged(adjustedForIme, imeHeight);
        this.notifyMovementBoundsChanged(true);
    }

    void setAspectRatio(float aspectRatio) {
        if (Float.compare(this.mAspectRatio, aspectRatio) != 0) {
            this.mAspectRatio = aspectRatio;
            this.notifyMovementBoundsChanged(false);
        }
    }

    void setActions(List<RemoteAction> actions) {
        this.mActions.clear();
        if (actions != null) {
            this.mActions.addAll(actions);
        }
        this.notifyActionsChanged(this.mActions);
    }

    private void notifyImeVisibilityChanged(boolean imeVisible, int imeHeight) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onImeVisibilityChanged(imeVisible, imeHeight);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering bounds changed event.", e);
            }
        }
    }

    private void notifyMinimizeChanged(boolean isMinimized) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onMinimizedStateChanged(isMinimized);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering minimize changed event.", e);
            }
        }
    }

    private void notifyActionsChanged(List<RemoteAction> actions) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onActionsChanged(new ParceledListSlice<RemoteAction>(actions));
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering actions changed event.", e);
            }
        }
    }

    private void notifyMovementBoundsChanged(boolean fromImeAdjustement) {
        if (this.mPinnedStackListener != null) {
            try {
                Rect insetBounds = new Rect();
                this.getInsetBounds(insetBounds);
                Rect normalBounds = this.getDefaultBounds();
                if (this.isValidPictureInPictureAspectRatio(this.mAspectRatio)) {
                    this.transformBoundsToAspectRatio(normalBounds, this.mAspectRatio);
                }
                this.mPinnedStackListener.onMovementBoundsChanged(insetBounds, normalBounds, fromImeAdjustement);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering actions changed event.", e);
            }
        }
    }

    private void getInsetBounds(Rect outRect) {
        this.mService.mPolicy.getStableInsetsLw(this.mDisplayInfo.rotation, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight, this.mTmpInsets);
        outRect.set(this.mTmpInsets.left + this.mScreenEdgeInsets.x, this.mTmpInsets.top + this.mScreenEdgeInsets.y, this.mDisplayInfo.logicalWidth - this.mTmpInsets.right - this.mScreenEdgeInsets.x, this.mDisplayInfo.logicalHeight - this.mTmpInsets.bottom - this.mScreenEdgeInsets.y);
    }

    private void applyMinimizedOffset(Rect stackBounds, Rect movementBounds) {
        this.mTmpDisplaySize.set(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
        this.mService.getStableInsetsLocked(this.mDisplayContent.getDisplayId(), this.mStableInsets);
        this.mSnapAlgorithm.applyMinimizedOffset(stackBounds, movementBounds, this.mTmpDisplaySize, this.mStableInsets);
    }

    private int dpToPx(float dpValue, DisplayMetrics dm) {
        return (int)TypedValue.applyDimension(1, dpValue, dm);
    }

    void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "PinnedStackController");
        pw.print(prefix + "  defaultBounds=");
        this.getDefaultBounds().printShortString(pw);
        pw.println();
        this.mService.getStackBounds(4, this.mTmpRect);
        pw.print(prefix + "  movementBounds=");
        this.getMovementBounds(this.mTmpRect).printShortString(pw);
        pw.println();
        pw.println(prefix + "  mIsImeShowing=" + this.mIsImeShowing);
        pw.println(prefix + "  mIsMinimized=" + this.mIsMinimized);
        if (this.mActions.isEmpty()) {
            pw.println(prefix + "  mActions=[]");
        } else {
            pw.println(prefix + "  mActions=[");
            for (int i = 0; i < this.mActions.size(); ++i) {
                RemoteAction action = this.mActions.get(i);
                pw.print(prefix + "    Action[" + i + "]: ");
                action.dump("", pw);
            }
            pw.println(prefix + "  ]");
        }
    }

    private class PinnedStackListenerDeathHandler
    implements IBinder.DeathRecipient {
        private PinnedStackListenerDeathHandler() {
        }

        @Override
        public void binderDied() {
            PinnedStackController.this.mPinnedStackListener = null;
        }
    }

    private class PinnedStackControllerCallback
    extends IPinnedStackController.Stub {
        private PinnedStackControllerCallback() {
        }

        @Override
        public void setIsMinimized(boolean isMinimized) {
            PinnedStackController.this.mHandler.post(PinnedStackController$PinnedStackControllerCallback$$Lambda$26.get$Lambda(this, isMinimized));
        }

        final /* synthetic */ void lambda$setIsMinimized$96$PinnedStackController$PinnedStackControllerCallback(boolean bl) {
            PinnedStackController.this.mIsMinimized = bl;
            PinnedStackController.this.mSnapAlgorithm.setMinimized(bl);
        }
    }
}

