/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.RemoteAction;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Slog;
import android.util.SparseArray;
import android.view.DisplayInfo;
import com.android.server.UiThread;
import com.android.server.wm.BoundsAnimationController;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.PinnedStackController;
import com.android.server.wm.StackWindowListener;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskWindowContainerController;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowManagerService;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;

public class StackWindowController
extends WindowContainerController<TaskStack, StackWindowListener> {
    final int mStackId;
    private final H mHandler;
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpStableInsets = new Rect();
    private final Rect mTmpNonDecorInsets = new Rect();
    private final Rect mTmpDisplayBounds = new Rect();

    public StackWindowController(int stackId, StackWindowListener listener, int displayId, boolean onTop, Rect outBounds) {
        this(stackId, listener, displayId, onTop, outBounds, WindowManagerService.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackWindowController(int stackId, StackWindowListener listener, int displayId, boolean onTop, Rect outBounds, WindowManagerService service) {
        super(listener, service);
        this.mStackId = stackId;
        this.mHandler = new H(new WeakReference<StackWindowController>(this), service.mH.getLooper());
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent dc = this.mRoot.getDisplayContent(displayId);
            if (dc == null) {
                throw new IllegalArgumentException("Trying to add stackId=" + stackId + " to unknown displayId=" + displayId);
            }
            TaskStack stack = dc.addStackToDisplay(stackId, onTop);
            stack.setController(this);
            this.getRawBounds(outBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContainer() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer != null) {
                ((TaskStack)this.mContainer).removeIfPossible();
                super.removeContainer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparent(int displayId, Rect outStackBounds) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                throw new IllegalArgumentException("Trying to move unknown stackId=" + this.mStackId + " to displayId=" + displayId);
            }
            DisplayContent targetDc = this.mRoot.getDisplayContent(displayId);
            if (targetDc == null) {
                throw new IllegalArgumentException("Trying to move stackId=" + this.mStackId + " to unknown displayId=" + displayId);
            }
            targetDc.moveStackToDisplay((TaskStack)this.mContainer);
            this.getRawBounds(outStackBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionChildAt(TaskWindowContainerController child, int position, Rect bounds, Configuration overrideConfig) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (child.mContainer == null) {
                return;
            }
            if (this.mContainer == null) {
                return;
            }
            ((Task)child.mContainer).positionAt(position, bounds, overrideConfig);
            ((TaskStack)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionChildAtTop(TaskWindowContainerController child, boolean includingParents) {
        if (child == null) {
            return;
        }
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task childTask = (Task)child.mContainer;
            if (childTask == null) {
                Slog.e("WindowManager", "positionChildAtTop: task=" + child + " not found");
                return;
            }
            ((TaskStack)this.mContainer).positionChildAt(Integer.MAX_VALUE, childTask, includingParents);
            if (this.mService.mAppTransition.isTransitionSet()) {
                childTask.setSendingToBottom(false);
            }
            ((TaskStack)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionChildAtBottom(TaskWindowContainerController child) {
        if (child == null) {
            return;
        }
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task childTask = (Task)child.mContainer;
            if (childTask == null) {
                Slog.e("WindowManager", "positionChildAtBottom: task=" + child + " not found");
                return;
            }
            ((TaskStack)this.mContainer).positionChildAt(Integer.MIN_VALUE, childTask, false);
            if (this.mService.mAppTransition.isTransitionSet()) {
                childTask.setSendingToBottom(true);
            }
            ((TaskStack)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resize(Rect bounds, SparseArray<Configuration> configs, SparseArray<Rect> taskBounds, SparseArray<Rect> taskTempInsetBounds) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                throw new IllegalArgumentException("resizeStack: stack " + this + " not found.");
            }
            ((TaskStack)this.mContainer).prepareFreezingTaskBounds();
            if (((TaskStack)this.mContainer).setBounds(bounds, configs, taskBounds, taskTempInsetBounds) && ((TaskStack)this.mContainer).isVisible()) {
                ((TaskStack)this.mContainer).getDisplayContent().setLayoutNeeded();
                this.mService.mWindowPlacerLocked.performSurfacePlacement();
            }
            return ((TaskStack)this.mContainer).getRawFullscreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animateResizePinnedStack(final Rect bounds, final int animationDuration) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                throw new IllegalArgumentException("Pinned stack container not found :(");
            }
            final Rect originalBounds = new Rect();
            ((TaskStack)this.mContainer).getBounds(originalBounds);
            ((TaskStack)this.mContainer).setAnimatingBounds(bounds);
            UiThread.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    StackWindowController.this.mService.mBoundsAnimationController.animateBounds((BoundsAnimationController.AnimateBoundsUser)((Object)StackWindowController.this.mContainer), originalBounds, bounds, animationDuration);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPictureInPictureAspectRatio(float aspectRatio) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            PinnedStackController pinnedStackController;
            if (!this.mService.mSupportsPictureInPicture || this.mContainer == null) {
                return;
            }
            int displayId = ((TaskStack)this.mContainer).getDisplayContent().getDisplayId();
            Rect toBounds = this.mService.getPictureInPictureBounds(displayId, aspectRatio);
            Rect targetBounds = new Rect();
            ((TaskStack)this.mContainer).getAnimatingBounds(targetBounds);
            if (!toBounds.equals(targetBounds)) {
                this.animateResizePinnedStack(toBounds, -1);
            }
            pinnedStackController.setAspectRatio((pinnedStackController = ((TaskStack)this.mContainer).getDisplayContent().getPinnedStackController()).isValidPictureInPictureAspectRatio(aspectRatio) ? aspectRatio : -1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPictureInPictureActions(List<RemoteAction> actions) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mService.mSupportsPictureInPicture || this.mContainer == null) {
                return;
            }
            ((TaskStack)this.mContainer).getDisplayContent().getPinnedStackController().setActions(actions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStackDockedModeBounds(Rect outBounds, Rect outTempBounds, Rect outTempInsetBounds, boolean ignoreVisibility) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer != null) {
                ((TaskStack)this.mContainer).getStackDockedModeBoundsLocked(outBounds, outTempBounds, outTempInsetBounds, ignoreVisibility);
                return;
            }
            outBounds.setEmpty();
            outTempBounds.setEmpty();
            outTempInsetBounds.setEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareFreezingTaskBounds() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                throw new IllegalArgumentException("prepareFreezingTaskBounds: stack " + this + " not found.");
            }
            ((TaskStack)this.mContainer).prepareFreezingTaskBounds();
        }
    }

    private void getRawBounds(Rect outBounds) {
        if (((TaskStack)this.mContainer).getRawFullscreen()) {
            outBounds.setEmpty();
        } else {
            ((TaskStack)this.mContainer).getRawBounds(outBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBounds(Rect outBounds) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer != null) {
                ((TaskStack)this.mContainer).getBounds(outBounds);
                return;
            }
            outBounds.setEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBoundsForNewConfiguration(Rect outBounds, Rect outTempBounds) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            ((TaskStack)this.mContainer).getBoundsForNewConfiguration(outBounds, outTempBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustConfigurationForBounds(Rect bounds, Rect insetBounds, Rect nonDecorBounds, Rect stableBounds, boolean overrideWidth, boolean overrideHeight, float density, Configuration config, Configuration parentConfig) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int height;
            int width;
            TaskStack stack = (TaskStack)this.mContainer;
            DisplayContent displayContent = stack.getDisplayContent();
            DisplayInfo di = displayContent.getDisplayInfo();
            this.mService.mPolicy.getStableInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, this.mTmpStableInsets);
            this.mService.mPolicy.getNonDecorInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, this.mTmpNonDecorInsets);
            this.mTmpDisplayBounds.set(0, 0, di.logicalWidth, di.logicalHeight);
            if (ActivityManager.StackId.tasksAreFloating(this.mStackId)) {
                if (bounds.width() == this.mTmpDisplayBounds.width() && bounds.height() == this.mTmpDisplayBounds.height()) {
                    stableBounds.inset(this.mTmpStableInsets);
                    nonDecorBounds.inset(this.mTmpNonDecorInsets);
                }
                width = (int)((float)stableBounds.width() / density);
                height = (int)((float)stableBounds.height() / density);
            } else {
                this.intersectDisplayBoundsExcludeInsets(nonDecorBounds, insetBounds != null ? insetBounds : bounds, this.mTmpNonDecorInsets, this.mTmpDisplayBounds, overrideWidth, overrideHeight);
                this.intersectDisplayBoundsExcludeInsets(stableBounds, insetBounds != null ? insetBounds : bounds, this.mTmpStableInsets, this.mTmpDisplayBounds, overrideWidth, overrideHeight);
                width = Math.min((int)((float)stableBounds.width() / density), parentConfig.screenWidthDp);
                height = Math.min((int)((float)stableBounds.height() / density), parentConfig.screenHeightDp);
            }
            config.screenWidthDp = width;
            config.screenHeightDp = height;
            config.smallestScreenWidthDp = this.getSmallestWidthForTaskBounds(insetBounds != null ? insetBounds : bounds, density);
        }
    }

    private void intersectDisplayBoundsExcludeInsets(Rect inOutBounds, Rect inInsetBounds, Rect stableInsets, Rect displayBounds, boolean overrideWidth, boolean overrideHeight) {
        this.mTmpRect.set(inInsetBounds);
        this.mService.intersectDisplayInsetBounds(displayBounds, stableInsets, this.mTmpRect);
        int leftInset = this.mTmpRect.left - inInsetBounds.left;
        int topInset = this.mTmpRect.top - inInsetBounds.top;
        int rightInset = overrideWidth ? 0 : inInsetBounds.right - this.mTmpRect.right;
        int bottomInset = overrideHeight ? 0 : inInsetBounds.bottom - this.mTmpRect.bottom;
        inOutBounds.inset(leftInset, topInset, rightInset, bottomInset);
    }

    private int getSmallestWidthForTaskBounds(Rect bounds, float density) {
        DisplayContent displayContent = ((TaskStack)this.mContainer).getDisplayContent();
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        if (bounds == null || bounds.width() == displayInfo.logicalWidth && bounds.height() == displayInfo.logicalHeight) {
            return displayContent.getConfiguration().smallestScreenWidthDp;
        }
        if (ActivityManager.StackId.tasksAreFloating(this.mStackId)) {
            return (int)((float)Math.min(bounds.width(), bounds.height()) / density);
        }
        return displayContent.getDockedDividerController().getSmallestWidthDpForBounds(bounds);
    }

    void requestResize(Rect bounds) {
        this.mHandler.obtainMessage(0, bounds).sendToTarget();
    }

    public String toString() {
        return "{StackWindowController stackId=" + this.mStackId + "}";
    }

    private static final class H
    extends Handler {
        static final int REQUEST_RESIZE = 0;
        private final WeakReference<StackWindowController> mController;

        H(WeakReference<StackWindowController> controller, Looper looper) {
            super(looper);
            this.mController = controller;
        }

        @Override
        public void handleMessage(Message msg) {
            StackWindowListener listener;
            StackWindowController controller = (StackWindowController)this.mController.get();
            StackWindowListener stackWindowListener = listener = controller != null ? (StackWindowListener)controller.mListener : null;
            if (listener == null) {
                return;
            }
            switch (msg.what) {
                case 0: {
                    listener.requestResize((Rect)msg.obj);
                }
            }
        }
    }
}

