/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.os.IBinder;
import android.util.ArrayMap;
import android.util.LruCache;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.Task;
import com.android.server.wm.TaskSnapshotLoader;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

class TaskSnapshotCache {
    private static final int RETRIEVAL_CACHE_SIZE = 4;
    private final WindowManagerService mService;
    private final TaskSnapshotLoader mLoader;
    private final ArrayMap<AppWindowToken, Integer> mAppTaskMap = new ArrayMap();
    private final ArrayMap<Integer, CacheEntry> mRunningCache = new ArrayMap();
    private final LruCache<Integer, ActivityManager.TaskSnapshot> mRetrievalCache = new LruCache(4);

    TaskSnapshotCache(WindowManagerService service, TaskSnapshotLoader loader) {
        this.mService = service;
        this.mLoader = loader;
    }

    void putSnapshot(Task task, ActivityManager.TaskSnapshot snapshot) {
        CacheEntry entry = this.mRunningCache.get(task.mTaskId);
        if (entry != null) {
            this.mAppTaskMap.remove(entry.topApp);
        }
        AppWindowToken top = (AppWindowToken)task.getTopChild();
        this.mAppTaskMap.put(top, task.mTaskId);
        this.mRunningCache.put(task.mTaskId, new CacheEntry(snapshot, (AppWindowToken)task.getTopChild()));
        this.mRetrievalCache.put(task.mTaskId, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActivityManager.TaskSnapshot getSnapshot(int taskId, int userId, boolean restoreFromDisk) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            CacheEntry entry = this.mRunningCache.get(taskId);
            if (entry != null) {
                return entry.snapshot;
            }
            ActivityManager.TaskSnapshot snapshot = this.mRetrievalCache.get(taskId);
            if (snapshot != null) {
                return snapshot;
            }
        }
        if (!restoreFromDisk) {
            return null;
        }
        return this.tryRestoreFromDisk(taskId, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityManager.TaskSnapshot tryRestoreFromDisk(int taskId, int userId) {
        ActivityManager.TaskSnapshot snapshot = this.mLoader.loadTask(taskId, userId);
        if (snapshot == null) {
            return null;
        }
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mRetrievalCache.put(taskId, snapshot);
        }
        return snapshot;
    }

    void onAppRemoved(AppWindowToken wtoken) {
        Integer taskId = this.mAppTaskMap.get(wtoken);
        if (taskId != null) {
            this.removeRunningEntry(taskId);
        }
        if (wtoken.mTask != null) {
            this.mRetrievalCache.remove(wtoken.mTask.mTaskId);
        }
    }

    void onAppDied(AppWindowToken wtoken) {
        Integer taskId = this.mAppTaskMap.get(wtoken);
        if (taskId != null) {
            this.removeRunningEntry(taskId);
        }
    }

    void onTaskRemoved(int taskId) {
        this.removeRunningEntry(taskId);
        this.mRetrievalCache.remove(taskId);
    }

    private void removeRunningEntry(int taskId) {
        CacheEntry entry = this.mRunningCache.get(taskId);
        if (entry != null) {
            this.mAppTaskMap.remove(entry.topApp);
            this.mRunningCache.remove(taskId);
        }
    }

    void dump(PrintWriter pw, String prefix) {
        String doublePrefix = prefix + "  ";
        String triplePrefix = doublePrefix + "  ";
        String quadruplePrefix = triplePrefix + "  ";
        pw.println(prefix + "SnapshotCache");
        pw.println(doublePrefix + "RunningCache");
        for (int i = this.mRunningCache.size() - 1; i >= 0; --i) {
            CacheEntry entry = this.mRunningCache.valueAt(i);
            pw.println(triplePrefix + "Entry taskId=" + this.mRunningCache.keyAt(i));
            pw.println(quadruplePrefix + "topApp=" + entry.topApp);
            pw.println(quadruplePrefix + "snapshot=" + entry.snapshot);
        }
        pw.println(doublePrefix + "RetrievalCache");
        Map<Integer, ActivityManager.TaskSnapshot> retrievalSnapshot = this.mRetrievalCache.snapshot();
        for (Map.Entry<Integer, ActivityManager.TaskSnapshot> entry : retrievalSnapshot.entrySet()) {
            pw.println(triplePrefix + "Entry taskId=" + entry.getKey());
            pw.println(quadruplePrefix + "snapshot=" + entry.getValue());
        }
    }

    private static final class CacheEntry {
        final ActivityManager.TaskSnapshot snapshot;
        final AppWindowToken topApp;

        CacheEntry(ActivityManager.TaskSnapshot snapshot, AppWindowToken topApp) {
            this.snapshot = snapshot;
            this.topApp = topApp;
        }
    }
}

