/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.graphics.GraphicBuffer;
import android.util.ArraySet;
import android.view.WindowManagerPolicy;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.Task;
import com.android.server.wm.TaskSnapshotCache;
import com.android.server.wm.TaskSnapshotController$$Lambda$22;
import com.android.server.wm.TaskSnapshotLoader;
import com.android.server.wm.TaskSnapshotPersister;
import com.android.server.wm.TaskSnapshotSurface;
import com.android.server.wm.WindowManagerService;
import com.google.android.collect.Sets;
import java.io.PrintWriter;

class TaskSnapshotController {
    private final WindowManagerService mService;
    private final TaskSnapshotCache mCache;
    private final TaskSnapshotPersister mPersister = new TaskSnapshotPersister(TaskSnapshotController$$Lambda$22.get$Lambda());
    private final TaskSnapshotLoader mLoader = new TaskSnapshotLoader(this.mPersister);
    private final ArraySet<Task> mTmpTasks = new ArraySet();

    TaskSnapshotController(WindowManagerService service) {
        this.mService = service;
        this.mCache = new TaskSnapshotCache(this.mService, this.mLoader);
    }

    void systemReady() {
        this.mPersister.start();
    }

    void onTransitionStarting() {
        if (!ActivityManager.ENABLE_TASK_SNAPSHOTS) {
            return;
        }
        this.handleClosingApps(this.mService.mClosingApps);
    }

    void notifyAppVisibilityChanged(AppWindowToken appWindowToken, boolean visible) {
        if (!ActivityManager.ENABLE_TASK_SNAPSHOTS) {
            return;
        }
        if (!visible) {
            this.handleClosingApps(Sets.newArraySet(appWindowToken));
        }
    }

    private void handleClosingApps(ArraySet<AppWindowToken> closingApps) {
        this.getClosingTasks(closingApps, this.mTmpTasks);
        for (int i = this.mTmpTasks.size() - 1; i >= 0; --i) {
            ActivityManager.TaskSnapshot snapshot;
            Task task = this.mTmpTasks.valueAt(i);
            if (!this.canSnapshotTask(task) || (snapshot = this.snapshotTask(task)) == null) continue;
            this.mCache.putSnapshot(task, snapshot);
            this.mPersister.persistSnapshot(task.mTaskId, task.mUserId, snapshot);
            if (task.getController() == null) continue;
            task.getController().reportSnapshotChanged(snapshot);
        }
    }

    ActivityManager.TaskSnapshot getSnapshot(int taskId, int userId, boolean restoreFromDisk) {
        return this.mCache.getSnapshot(taskId, userId, restoreFromDisk);
    }

    WindowManagerPolicy.StartingSurface createStartingSurface(AppWindowToken token, GraphicBuffer snapshot) {
        return TaskSnapshotSurface.create(this.mService, token, snapshot);
    }

    private ActivityManager.TaskSnapshot snapshotTask(Task task) {
        AppWindowToken top = (AppWindowToken)task.getTopChild();
        if (top == null) {
            return null;
        }
        GraphicBuffer buffer = top.mDisplayContent.screenshotApplicationsToBuffer(top.token, -1, -1, false, 1.0f, false, true);
        if (buffer == null) {
            return null;
        }
        return new ActivityManager.TaskSnapshot(buffer, top.getConfiguration().orientation, top.findMainWindow().mStableInsets);
    }

    void getClosingTasks(ArraySet<AppWindowToken> closingApps, ArraySet<Task> outClosingTasks) {
        outClosingTasks.clear();
        for (int i = closingApps.size() - 1; i >= 0; --i) {
            AppWindowToken atoken = closingApps.valueAt(i);
            if (atoken.mTask == null || atoken.mTask.isVisible()) continue;
            outClosingTasks.add(closingApps.valueAt((int)i).mTask);
        }
    }

    private boolean canSnapshotTask(Task task) {
        return !ActivityManager.StackId.isHomeOrRecentsStack(task.mStack.mStackId);
    }

    void onAppRemoved(AppWindowToken wtoken) {
        this.mCache.onAppRemoved(wtoken);
    }

    void onAppDied(AppWindowToken wtoken) {
        this.mCache.onAppDied(wtoken);
    }

    void notifyTaskRemovedFromRecents(int taskId, int userId) {
        this.mCache.onTaskRemoved(taskId);
        this.mPersister.onTaskRemovedFromRecents(taskId, userId);
    }

    void removeObsoleteTaskFiles(ArraySet<Integer> persistentTaskIds, int[] runningUserIds) {
        this.mPersister.removeObsoleteFiles(persistentTaskIds, runningUserIds);
    }

    void dump(PrintWriter pw, String prefix) {
        this.mCache.dump(pw, prefix);
    }
}

