/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.os.Process;
import android.os.SystemClock;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.AtomicFile;
import com.android.server.wm.nano.WindowManagerProtos;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;

class TaskSnapshotPersister {
    private static final String TAG = "WindowManager";
    private static final String SNAPSHOTS_DIRNAME = "snapshots";
    private static final long DELAY_MS = 100L;
    private static final String PROTO_EXTENSION = ".proto";
    private static final String BITMAP_EXTENSION = ".png";
    @GuardedBy(value="mLock")
    private final ArrayDeque<WriteQueueItem> mWriteQueue = new ArrayDeque();
    @GuardedBy(value="mLock")
    private boolean mQueueIdling;
    private boolean mStarted;
    private final Object mLock = new Object();
    private final DirectoryResolver mDirectoryResolver;
    @GuardedBy(value="mLock")
    private final ArraySet<Integer> mPersistedTaskIdsSinceLastRemoveObsolete = new ArraySet();
    private Thread mPersister = new Thread("TaskSnapshotPersister"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority(10);
            while (true) {
                WriteQueueItem next;
                Object object = TaskSnapshotPersister.this.mLock;
                synchronized (object) {
                    next = (WriteQueueItem)TaskSnapshotPersister.this.mWriteQueue.poll();
                }
                if (next != null) {
                    next.write();
                    SystemClock.sleep(100L);
                }
                object = TaskSnapshotPersister.this.mLock;
                synchronized (object) {
                    if (!TaskSnapshotPersister.this.mWriteQueue.isEmpty()) {
                        continue;
                    }
                    try {
                        TaskSnapshotPersister.this.mQueueIdling = true;
                        TaskSnapshotPersister.this.mLock.wait();
                        TaskSnapshotPersister.this.mQueueIdling = false;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    };

    TaskSnapshotPersister(DirectoryResolver resolver) {
        this.mDirectoryResolver = resolver;
    }

    void start() {
        if (!this.mStarted) {
            this.mStarted = true;
            this.mPersister.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistSnapshot(int taskId, int userId, ActivityManager.TaskSnapshot snapshot) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPersistedTaskIdsSinceLastRemoveObsolete.add(taskId);
            this.sendToQueueLocked(new StoreWriteQueueItem(taskId, userId, snapshot));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTaskRemovedFromRecents(int taskId, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPersistedTaskIdsSinceLastRemoveObsolete.remove(taskId);
            this.sendToQueueLocked(new DeleteWriteQueueItem(taskId, userId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObsoleteFiles(ArraySet<Integer> persistentTaskIds, int[] runningUserIds) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPersistedTaskIdsSinceLastRemoveObsolete.clear();
            this.sendToQueueLocked(new RemoveObsoleteFilesQueueItem(persistentTaskIds, runningUserIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForQueueEmpty() {
        while (true) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mWriteQueue.isEmpty() && this.mQueueIdling) {
                    return;
                }
            }
            SystemClock.sleep(100L);
        }
    }

    @GuardedBy(value="mLock")
    private void sendToQueueLocked(WriteQueueItem item) {
        this.mWriteQueue.offer(item);
        this.mLock.notifyAll();
    }

    private File getDirectory(int userId) {
        return new File(this.mDirectoryResolver.getSystemDirectoryForUser(userId), SNAPSHOTS_DIRNAME);
    }

    File getProtoFile(int taskId, int userId) {
        return new File(this.getDirectory(userId), taskId + PROTO_EXTENSION);
    }

    File getBitmapFile(int taskId, int userId) {
        return new File(this.getDirectory(userId), taskId + BITMAP_EXTENSION);
    }

    private boolean createDirectory(int userId) {
        File dir = this.getDirectory(userId);
        return dir.exists() || dir.mkdirs();
    }

    private void deleteSnapshot(int taskId, int userId) {
        File protoFile = this.getProtoFile(taskId, userId);
        File bitmapFile = this.getBitmapFile(taskId, userId);
        protoFile.delete();
        bitmapFile.delete();
    }

    class RemoveObsoleteFilesQueueItem
    extends WriteQueueItem {
        private final ArraySet<Integer> mPersistentTaskIds;
        private final int[] mRunningUserIds;

        RemoveObsoleteFilesQueueItem(ArraySet<Integer> persistentTaskIds, int[] runningUserIds) {
            this.mPersistentTaskIds = persistentTaskIds;
            this.mRunningUserIds = runningUserIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void write() {
            ArraySet newPersistedTaskIds;
            Object object = TaskSnapshotPersister.this.mLock;
            synchronized (object) {
                newPersistedTaskIds = new ArraySet(TaskSnapshotPersister.this.mPersistedTaskIdsSinceLastRemoveObsolete);
            }
            for (Object userId : (Object)this.mRunningUserIds) {
                File dir = TaskSnapshotPersister.this.getDirectory((int)userId);
                String[] files = dir.list();
                if (files == null) continue;
                for (String file : files) {
                    int taskId = this.getTaskId(file);
                    if (this.mPersistentTaskIds.contains(taskId) || newPersistedTaskIds.contains(taskId)) continue;
                    new File(dir, file).delete();
                }
            }
        }

        int getTaskId(String fileName) {
            if (!fileName.endsWith(TaskSnapshotPersister.PROTO_EXTENSION) && !fileName.endsWith(TaskSnapshotPersister.BITMAP_EXTENSION)) {
                return -1;
            }
            int end = fileName.lastIndexOf(46);
            if (end == -1) {
                return -1;
            }
            try {
                return Integer.parseInt(fileName.substring(0, end));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
    }

    private class DeleteWriteQueueItem
    extends WriteQueueItem {
        private final int mTaskId;
        private final int mUserId;

        DeleteWriteQueueItem(int taskId, int userId) {
            this.mTaskId = taskId;
            this.mUserId = userId;
        }

        @Override
        void write() {
            TaskSnapshotPersister.this.deleteSnapshot(this.mTaskId, this.mUserId);
        }
    }

    private class StoreWriteQueueItem
    extends WriteQueueItem {
        private final int mTaskId;
        private final int mUserId;
        private final ActivityManager.TaskSnapshot mSnapshot;

        StoreWriteQueueItem(int taskId, int userId, ActivityManager.TaskSnapshot snapshot) {
            this.mTaskId = taskId;
            this.mUserId = userId;
            this.mSnapshot = snapshot;
        }

        @Override
        void write() {
            if (!TaskSnapshotPersister.this.createDirectory(this.mUserId)) {
                Slog.e(TaskSnapshotPersister.TAG, "Unable to create snapshot directory for user dir=" + TaskSnapshotPersister.this.getDirectory(this.mUserId));
            }
            boolean failed = false;
            if (!this.writeProto()) {
                failed = true;
            }
            if (!this.writeBuffer()) {
                this.writeBuffer();
                failed = true;
            }
            if (failed) {
                TaskSnapshotPersister.this.deleteSnapshot(this.mTaskId, this.mUserId);
            }
        }

        boolean writeProto() {
            WindowManagerProtos.TaskSnapshotProto proto = new WindowManagerProtos.TaskSnapshotProto();
            proto.orientation = this.mSnapshot.getOrientation();
            proto.insetLeft = this.mSnapshot.getContentInsets().left;
            proto.insetTop = this.mSnapshot.getContentInsets().top;
            proto.insetRight = this.mSnapshot.getContentInsets().right;
            proto.insetBottom = this.mSnapshot.getContentInsets().bottom;
            byte[] bytes = WindowManagerProtos.TaskSnapshotProto.toByteArray(proto);
            File file = TaskSnapshotPersister.this.getProtoFile(this.mTaskId, this.mUserId);
            AtomicFile atomicFile = new AtomicFile(file);
            FileOutputStream fos = null;
            try {
                fos = atomicFile.startWrite();
                fos.write(bytes);
                atomicFile.finishWrite(fos);
            }
            catch (IOException e) {
                atomicFile.failWrite(fos);
                Slog.e(TaskSnapshotPersister.TAG, "Unable to open " + file + " for persisting. " + e);
                return false;
            }
            return true;
        }

        boolean writeBuffer() {
            File file = TaskSnapshotPersister.this.getBitmapFile(this.mTaskId, this.mUserId);
            Bitmap bitmap = Bitmap.createHardwareBitmap(this.mSnapshot.getSnapshot());
            try {
                FileOutputStream fos = new FileOutputStream(file);
                bitmap.compress(Bitmap.CompressFormat.PNG, 0, fos);
                fos.close();
            }
            catch (IOException e) {
                Slog.e(TaskSnapshotPersister.TAG, "Unable to open " + file + " for persisting. " + e);
                return false;
            }
            return true;
        }
    }

    private abstract class WriteQueueItem {
        private WriteQueueItem() {
        }

        abstract void write();
    }

    static interface DirectoryResolver {
        public File getSystemDirectoryForUser(int var1);
    }
}

