/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.GraphicBuffer;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Slog;
import android.view.IWindowSession;
import android.view.Surface;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowManagerPolicy;
import com.android.internal.view.BaseIWindow;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.HashMap;

class TaskSnapshotSurface
implements WindowManagerPolicy.StartingSurface {
    private static final String TAG = "WindowManager";
    private static final int MSG_REPORT_DRAW = 0;
    private static final String TITLE_FORMAT = "SnapshotStartingWindow for taskId=%s";
    private final Window mWindow;
    private final Surface mSurface;
    private final IWindowSession mSession;
    private final WindowManagerService mService;
    private boolean mHasDrawn;
    private boolean mReportNextDraw;
    private Paint mFillBackgroundPaint = new Paint();
    private static Handler sHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    boolean hasDrawn;
                    TaskSnapshotSurface surface = (TaskSnapshotSurface)msg.obj;
                    HashMap<IBinder, WindowState> hashMap = ((TaskSnapshotSurface)surface).mService.mWindowMap;
                    synchronized (hashMap) {
                        hasDrawn = surface.mHasDrawn;
                        if (!hasDrawn) {
                            surface.mReportNextDraw = true;
                        }
                    }
                    if (!hasDrawn) break;
                    surface.reportDrawn();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TaskSnapshotSurface create(WindowManagerService service, AppWindowToken token, GraphicBuffer snapshot) {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        Window window = new Window();
        IWindowSession session = WindowManagerGlobal.getWindowSession();
        window.setSession(session);
        Surface surface = new Surface();
        Rect tmpRect = new Rect();
        Rect tmpFrame = new Rect();
        Configuration tmpConfiguration = new Configuration();
        int fillBackgroundColor = -1;
        HashMap<IBinder, WindowState> hashMap = service.mWindowMap;
        synchronized (hashMap) {
            ActivityManager.TaskDescription taskDescription;
            layoutParams.type = 3;
            layoutParams.format = snapshot.getFormat();
            layoutParams.flags = -2147417832;
            layoutParams.privateFlags = 524288;
            layoutParams.token = token.token;
            layoutParams.width = -1;
            layoutParams.height = -1;
            layoutParams.systemUiVisibility = 1536;
            layoutParams.setTitle(String.format(TITLE_FORMAT, token.mTask.mTaskId));
            if (token.mTask != null && (taskDescription = token.mTask.getTaskDescription()) != null) {
                fillBackgroundColor = taskDescription.getBackgroundColor();
            }
        }
        try {
            int res = session.addToDisplay(window, window.mSeq, layoutParams, 0, token.getDisplayContent().getDisplayId(), tmpRect, tmpRect, tmpRect, null);
            if (res < 0) {
                Slog.w(TAG, "Failed to add snapshot starting window res=" + res);
                return null;
            }
        }
        catch (RemoteException res) {
            // empty catch block
        }
        TaskSnapshotSurface snapshotSurface = new TaskSnapshotSurface(service, window, surface, fillBackgroundColor);
        window.setOuter(snapshotSurface);
        try {
            session.relayout(window, window.mSeq, layoutParams, -1, -1, 0, 0, tmpFrame, tmpRect, tmpRect, tmpRect, tmpRect, tmpRect, tmpRect, tmpConfiguration, surface);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        snapshotSurface.drawSnapshot(snapshot);
        return snapshotSurface;
    }

    TaskSnapshotSurface(WindowManagerService service, Window window, Surface surface, int fillBackgroundColor) {
        this.mService = service;
        this.mSession = WindowManagerGlobal.getWindowSession();
        this.mWindow = window;
        this.mSurface = surface;
        this.mFillBackgroundPaint.setColor(fillBackgroundColor);
    }

    @Override
    public void remove() {
        try {
            this.mSession.remove(this.mWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSnapshot(GraphicBuffer snapshot) {
        boolean reportNextDraw;
        Canvas c = this.mSurface.lockHardwareCanvas();
        Bitmap b = Bitmap.createHardwareBitmap(snapshot);
        this.fillEmptyBackground(c, b);
        c.drawBitmap(b, 0.0f, 0.0f, null);
        this.mSurface.unlockCanvasAndPost(c);
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mHasDrawn = true;
            reportNextDraw = this.mReportNextDraw;
        }
        if (reportNextDraw) {
            this.reportDrawn();
        }
        this.mSurface.release();
    }

    void fillEmptyBackground(Canvas c, Bitmap b) {
        boolean fillVertically;
        boolean fillHorizontally = c.getWidth() > b.getWidth();
        boolean bl = fillVertically = c.getHeight() > b.getHeight();
        if (fillHorizontally) {
            c.drawRect(b.getWidth(), 0.0f, c.getWidth(), fillVertically ? (float)b.getHeight() : (float)c.getHeight(), this.mFillBackgroundPaint);
        }
        if (fillVertically) {
            c.drawRect(0.0f, b.getHeight(), c.getWidth(), c.getHeight(), this.mFillBackgroundPaint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportDrawn() {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            this.mReportNextDraw = false;
        }
        try {
            this.mSession.finishDrawing(this.mWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static class Window
    extends BaseIWindow {
        private TaskSnapshotSurface mOuter;

        private Window() {
        }

        public void setOuter(TaskSnapshotSurface outer) {
            this.mOuter = outer;
        }

        @Override
        public void resized(Rect frame, Rect overscanInsets, Rect contentInsets, Rect visibleInsets, Rect stableInsets, Rect outsets, boolean reportDraw, Configuration newConfig, Rect backDropFrame, boolean forceLayout, boolean alwaysConsumeNavBar, int displayId) {
            if (reportDraw) {
                sHandler.obtainMessage(0, this.mOuter).sendToTarget();
            }
        }
    }
}

