/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.EventLog;
import android.util.Slog;
import com.android.server.wm.AppWindowContainerController;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskWindowContainerListener;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class TaskWindowContainerController
extends WindowContainerController<Task, TaskWindowContainerListener> {
    private final int mTaskId;
    private final H mHandler;

    public TaskWindowContainerController(int taskId, TaskWindowContainerListener listener, StackWindowController stackController, int userId, Rect bounds, Configuration overrideConfig, int resizeMode, boolean supportsPictureInPicture, boolean homeTask, boolean toTop, boolean showForAllUsers, ActivityManager.TaskDescription taskDescription) {
        this(taskId, listener, stackController, userId, bounds, overrideConfig, resizeMode, supportsPictureInPicture, homeTask, toTop, showForAllUsers, taskDescription, WindowManagerService.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskWindowContainerController(int taskId, TaskWindowContainerListener listener, StackWindowController stackController, int userId, Rect bounds, Configuration overrideConfig, int resizeMode, boolean supportsPictureInPicture, boolean homeTask, boolean toTop, boolean showForAllUsers, ActivityManager.TaskDescription taskDescription, WindowManagerService service) {
        super(listener, service);
        this.mTaskId = taskId;
        this.mHandler = new H(new WeakReference<TaskWindowContainerController>(this), service.mH.getLooper());
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = (TaskStack)stackController.mContainer;
            if (stack == null) {
                throw new IllegalArgumentException("TaskWindowContainerController: invalid stack=" + stackController);
            }
            EventLog.writeEvent(31001, taskId, stack.mStackId);
            Task task = this.createTask(taskId, stack, userId, bounds, overrideConfig, resizeMode, supportsPictureInPicture, homeTask, taskDescription);
            int position = toTop ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            stack.addTask(task, position, showForAllUsers, true);
        }
    }

    Task createTask(int taskId, TaskStack stack, int userId, Rect bounds, Configuration overrideConfig, int resizeMode, boolean supportsPictureInPicture, boolean homeTask, ActivityManager.TaskDescription taskDescription) {
        return new Task(taskId, stack, userId, this.mService, bounds, overrideConfig, resizeMode, supportsPictureInPicture, homeTask, taskDescription, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContainer() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                return;
            }
            ((Task)this.mContainer).removeIfPossible();
            super.removeContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionChildAt(AppWindowContainerController childController, int position) {
        HashMap<IBinder, WindowState> hashMap = this.mService.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken aToken = (AppWindowToken)childController.mContainer;
            if (aToken == null) {
                Slog.w("WindowManager", "Attempted to position of non-existing app : " + childController);
                return;
            }
            Task task = (Task)this.mContainer;
            if (task == null) {
                throw new IllegalArgumentException("positionChildAt: invalid task=" + this);
            }
            task.positionChildAt(position, aToken, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparent(StackWindowController stackController, int position) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                return;
            }
            TaskStack stack = (TaskStack)stackController.mContainer;
            if (stack == null) {
                throw new IllegalArgumentException("reparent: could not find stack=" + stackController);
            }
            ((Task)this.mContainer).reparent(stack, position);
            ((Task)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResizeable(int resizeMode) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer != null) {
                ((Task)this.mContainer).setResizeable(resizeMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(Rect bounds, Configuration overrideConfig, boolean relayout, boolean forced) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                throw new IllegalArgumentException("resizeTask: taskId " + this.mTaskId + " not found.");
            }
            if (((Task)this.mContainer).resizeLocked(bounds, overrideConfig, forced) && relayout) {
                ((Task)this.mContainer).getDisplayContent().layoutAndAssignWindowLayersIfNeeded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBounds(Rect bounds) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer != null) {
                ((Task)this.mContainer).getBounds(bounds);
                return;
            }
            bounds.setEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskDockedResizing(boolean resizing) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "setTaskDockedResizing: taskId " + this.mTaskId + " not found.");
                return;
            }
            ((Task)this.mContainer).setDragResizing(resizing, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWindowTransition() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "cancelWindowTransition: taskId " + this.mTaskId + " not found.");
                return;
            }
            ((Task)this.mContainer).cancelTaskWindowTransition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelThumbnailTransition() {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "cancelThumbnailTransition: taskId " + this.mTaskId + " not found.");
                return;
            }
            ((Task)this.mContainer).cancelTaskThumbnailTransition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskDescription(ActivityManager.TaskDescription taskDescription) {
        HashMap hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mContainer == null) {
                Slog.w("WindowManager", "setTaskDescription: taskId " + this.mTaskId + " not found.");
                return;
            }
            ((Task)this.mContainer).setTaskDescription(taskDescription);
        }
    }

    void reportSnapshotChanged(ActivityManager.TaskSnapshot snapshot) {
        this.mHandler.obtainMessage(0, snapshot).sendToTarget();
    }

    void requestResize(Rect bounds, int resizeMode) {
        this.mHandler.obtainMessage(1, resizeMode, 0, bounds).sendToTarget();
    }

    public String toString() {
        return "{TaskWindowContainerController taskId=" + this.mTaskId + "}";
    }

    private static final class H
    extends Handler {
        static final int REPORT_SNAPSHOT_CHANGED = 0;
        static final int REQUEST_RESIZE = 1;
        private final WeakReference<TaskWindowContainerController> mController;

        H(WeakReference<TaskWindowContainerController> controller, Looper looper) {
            super(looper);
            this.mController = controller;
        }

        @Override
        public void handleMessage(Message msg) {
            TaskWindowContainerListener listener;
            TaskWindowContainerController controller = (TaskWindowContainerController)this.mController.get();
            TaskWindowContainerListener taskWindowContainerListener = listener = controller != null ? (TaskWindowContainerListener)controller.mListener : null;
            if (listener == null) {
                return;
            }
            switch (msg.what) {
                case 0: {
                    listener.onSnapshotChanged((ActivityManager.TaskSnapshot)msg.obj);
                    break;
                }
                case 1: {
                    listener.requestResize((Rect)msg.obj, msg.arg1);
                }
            }
        }
    }
}

