/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.IBinder;
import com.android.server.wm.RootWindowContainer;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowContainerListener;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.HashMap;

class WindowContainerController<E extends WindowContainer, I extends WindowContainerListener> {
    final WindowManagerService mService;
    final RootWindowContainer mRoot;
    final HashMap<IBinder, WindowState> mWindowMap;
    E mContainer;
    final I mListener;

    WindowContainerController(I listener, WindowManagerService service) {
        this.mListener = listener;
        this.mService = service;
        this.mRoot = this.mService != null ? this.mService.mRoot : null;
        this.mWindowMap = this.mService != null ? this.mService.mWindowMap : null;
    }

    void setContainer(E container) {
        if (this.mContainer != null && container != null) {
            throw new IllegalArgumentException("Can't set container=" + container + " for controller=" + this + " Already set to=" + this.mContainer);
        }
        this.mContainer = container;
    }

    void removeContainer() {
        if (this.mContainer != null) {
            ((WindowContainer)this.mContainer).setController(null);
            this.mContainer = null;
        }
    }

    boolean checkCallingPermission(String permission2, String func) {
        return this.mService.checkCallingPermission(permission2, func);
    }
}

