/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.Slog;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowLayersController$$Lambda$47;
import com.android.server.wm.WindowLayersController$$Lambda$48;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import java.util.ArrayDeque;
import java.util.function.Consumer;

class WindowLayersController {
    private final WindowManagerService mService;
    private int mHighestApplicationLayer = 0;
    private ArrayDeque<WindowState> mPinnedWindows = new ArrayDeque();
    private ArrayDeque<WindowState> mDockedWindows = new ArrayDeque();
    private ArrayDeque<WindowState> mAssistantWindows = new ArrayDeque();
    private ArrayDeque<WindowState> mInputMethodWindows = new ArrayDeque();
    private WindowState mDockDivider = null;
    private ArrayDeque<WindowState> mReplacingWindows = new ArrayDeque();
    private int mCurBaseLayer;
    private int mCurLayer;
    private boolean mAnyLayerChanged;
    private int mHighestLayerInImeTargetBaseLayer;
    private WindowState mImeTarget;
    private boolean mAboveImeTarget;
    private ArrayDeque<WindowState> mAboveImeTargetAppWindows = new ArrayDeque();
    private final Consumer<WindowState> mAssignWindowLayersConsumer = WindowLayersController$$Lambda$47.get$Lambda(this);

    WindowLayersController(WindowManagerService service) {
        this.mService = service;
    }

    final void assignWindowLayers(DisplayContent dc) {
        this.reset();
        dc.forAllWindows(this.mAssignWindowLayersConsumer, false);
        this.adjustSpecialWindows();
        if (this.mService.mAccessibilityController != null && this.mAnyLayerChanged && dc.getDisplayId() == 0) {
            this.mService.mAccessibilityController.onWindowLayersChangedLocked();
        }
    }

    private void logDebugLayers(DisplayContent dc) {
        dc.forAllWindows(WindowLayersController$$Lambda$48.get$Lambda(), false);
    }

    private void reset() {
        this.mHighestApplicationLayer = 0;
        this.mPinnedWindows.clear();
        this.mInputMethodWindows.clear();
        this.mDockedWindows.clear();
        this.mAssistantWindows.clear();
        this.mReplacingWindows.clear();
        this.mDockDivider = null;
        this.mCurBaseLayer = 0;
        this.mCurLayer = 0;
        this.mAnyLayerChanged = false;
        this.mImeTarget = this.mService.mInputMethodTarget;
        this.mHighestLayerInImeTargetBaseLayer = this.mImeTarget != null ? this.mImeTarget.mBaseLayer : 0;
        this.mAboveImeTarget = false;
        this.mAboveImeTargetAppWindows.clear();
    }

    private void collectSpecialWindows(WindowState w) {
        Task task;
        if (w.mAttrs.type == 2034) {
            this.mDockDivider = w;
            return;
        }
        if (w.mWillReplaceWindow) {
            this.mReplacingWindows.add(w);
        }
        if (w.mIsImWindow) {
            this.mInputMethodWindows.add(w);
            return;
        }
        if (this.mImeTarget != null) {
            if (w.getParentWindow() == this.mImeTarget && w.mSubLayer > 0) {
                this.mAboveImeTargetAppWindows.add(w);
            } else if (this.mAboveImeTarget && w.mAppToken != null) {
                this.mAboveImeTargetAppWindows.add(w);
            }
            if (w == this.mImeTarget) {
                this.mAboveImeTarget = true;
            }
        }
        if ((task = w.getTask()) == null) {
            return;
        }
        TaskStack stack = task.mStack;
        if (stack == null) {
            return;
        }
        if (stack.mStackId == 4) {
            this.mPinnedWindows.add(w);
        } else if (stack.mStackId == 3) {
            this.mDockedWindows.add(w);
        } else if (stack.mStackId == 6) {
            this.mAssistantWindows.add(w);
        }
    }

    private void adjustSpecialWindows() {
        int layer = this.mHighestApplicationLayer + 5;
        while (!this.mDockedWindows.isEmpty()) {
            layer = this.assignAndIncreaseLayerIfNeeded(this.mDockedWindows.remove(), layer);
        }
        layer = this.assignAndIncreaseLayerIfNeeded(this.mDockDivider, layer);
        while (!this.mReplacingWindows.isEmpty()) {
            layer = this.assignAndIncreaseLayerIfNeeded(this.mReplacingWindows.remove(), layer);
        }
        while (!this.mAssistantWindows.isEmpty()) {
            layer = this.assignAndIncreaseLayerIfNeeded(this.mAssistantWindows.remove(), layer);
        }
        while (!this.mPinnedWindows.isEmpty()) {
            layer = this.assignAndIncreaseLayerIfNeeded(this.mPinnedWindows.remove(), layer);
        }
        if (this.mImeTarget != null) {
            if (this.mImeTarget.mAppToken == null) {
                layer = this.mHighestLayerInImeTargetBaseLayer + 5;
            }
            while (!this.mInputMethodWindows.isEmpty()) {
                layer = this.assignAndIncreaseLayerIfNeeded(this.mInputMethodWindows.remove(), layer);
            }
            while (!this.mAboveImeTargetAppWindows.isEmpty()) {
                layer = this.assignAndIncreaseLayerIfNeeded(this.mAboveImeTargetAppWindows.remove(), layer);
            }
        }
    }

    private int assignAndIncreaseLayerIfNeeded(WindowState win, int layer) {
        if (win != null) {
            this.assignAnimLayer(win, layer);
            layer += 5;
        }
        return layer;
    }

    private void assignAnimLayer(WindowState w, int layer) {
        w.mLayer = layer;
        w.mWinAnimator.mAnimLayer = w.getAnimLayerAdjustment() + w.getSpecialWindowAnimLayerAdjustment();
        if (w.mAppToken != null && w.mAppToken.mAppAnimator.thumbnailForceAboveLayer > 0 && w.mWinAnimator.mAnimLayer > w.mAppToken.mAppAnimator.thumbnailForceAboveLayer) {
            w.mAppToken.mAppAnimator.thumbnailForceAboveLayer = w.mWinAnimator.mAnimLayer;
        }
    }

    static final /* synthetic */ void lambda$logDebugLayers$94$WindowLayersController(WindowState w) {
        WindowStateAnimator winAnimator = w.mWinAnimator;
        Slog.v("WindowManager", "Assign layer " + w + ": " + "mBase=" + w.mBaseLayer + " mLayer=" + w.mLayer + (w.mAppToken == null ? "" : " mAppLayer=" + w.mAppToken.mAppAnimator.animLayerAdjustment) + " =mAnimLayer=" + winAnimator.mAnimLayer);
    }

    final /* synthetic */ void lambda$new$93$WindowLayersController(WindowState w) {
        boolean layerChanged = false;
        int oldLayer = w.mLayer;
        if (w.mBaseLayer == this.mCurBaseLayer) {
            this.mCurLayer += 5;
        } else {
            this.mCurBaseLayer = this.mCurLayer = w.mBaseLayer;
        }
        this.assignAnimLayer(w, this.mCurLayer);
        if (w.mLayer != oldLayer || w.mWinAnimator.mAnimLayer != oldLayer) {
            layerChanged = true;
            this.mAnyLayerChanged = true;
        }
        if (w.mAppToken != null) {
            this.mHighestApplicationLayer = Math.max(this.mHighestApplicationLayer, w.mWinAnimator.mAnimLayer);
        }
        if (this.mImeTarget != null && w.mBaseLayer == this.mImeTarget.mBaseLayer) {
            this.mHighestLayerInImeTargetBaseLayer = Math.max(this.mHighestLayerInImeTargetBaseLayer, w.mWinAnimator.mAnimLayer);
        }
        this.collectSpecialWindows(w);
        if (layerChanged) {
            w.scheduleAnimationIfDimming();
        }
    }
}

