/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.ValueAnimator;
import android.annotation.IntDef;
import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerInternal;
import android.hardware.input.InputManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.SystemService;
import android.os.Trace;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.TypedValue;
import android.view.AppTransitionAnimationSpec;
import android.view.Choreographer;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.IDockedStackListener;
import android.view.IInputFilter;
import android.view.IOnKeyguardExitResult;
import android.view.IPinnedStackListener;
import android.view.IRotationWatcher;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.MagnificationSpec;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.WindowContentFrameStats;
import android.view.WindowManager;
import android.view.WindowManagerInternal;
import android.view.WindowManagerPolicy;
import android.view.animation.Animation;
import android.view.inputmethod.InputMethodManagerInternal;
import com.android.internal.app.IAssistScreenshotReceiver;
import com.android.internal.os.IResultReceiver;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IShortcutService;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.WindowManagerPolicyThread;
import com.android.server.DisplayThread;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.UiThread;
import com.android.server.Watchdog;
import com.android.server.input.InputManagerService;
import com.android.server.power.ShutdownThread;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.BoundsAnimationController;
import com.android.server.wm.CircularDisplayMask;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplaySettings;
import com.android.server.wm.DragState;
import com.android.server.wm.EmulatorDisplayOverlay;
import com.android.server.wm.InputMonitor;
import com.android.server.wm.KeyguardDisableHandler;
import com.android.server.wm.PinnedStackController;
import com.android.server.wm.PointerEventDispatcher;
import com.android.server.wm.RootWindowContainer;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Session;
import com.android.server.wm.StrictModeFlash;
import com.android.server.wm.Task;
import com.android.server.wm.TaskPositioner;
import com.android.server.wm.TaskSnapshotController;
import com.android.server.wm.TaskStack;
import com.android.server.wm.UnknownAppVisibilityController;
import com.android.server.wm.ViewServer;
import com.android.server.wm.WallpaperWindowToken;
import com.android.server.wm.Watermark;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowManagerService$$Lambda$29;
import com.android.server.wm.WindowManagerService$$Lambda$30;
import com.android.server.wm.WindowManagerService$$Lambda$31;
import com.android.server.wm.WindowManagerService$$Lambda$32;
import com.android.server.wm.WindowManagerService$$Lambda$33;
import com.android.server.wm.WindowManagerService$$Lambda$34;
import com.android.server.wm.WindowManagerService$$Lambda$35;
import com.android.server.wm.WindowManagerService$$Lambda$36;
import com.android.server.wm.WindowManagerService$$Lambda$37;
import com.android.server.wm.WindowManagerService$$Lambda$38;
import com.android.server.wm.WindowManagerService$$Lambda$39;
import com.android.server.wm.WindowManagerService$$Lambda$40;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowSurfaceController;
import com.android.server.wm.WindowSurfacePlacer;
import com.android.server.wm.WindowToken;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class WindowManagerService
extends IWindowManager.Stub
implements Watchdog.Monitor,
WindowManagerPolicy.WindowManagerFuncs {
    private static final String TAG = "WindowManager";
    static final int LAYOUT_REPEAT_THRESHOLD = 4;
    static final boolean PROFILE_ORIENTATION = false;
    static final boolean localLOGV = false;
    static final int TYPE_LAYER_MULTIPLIER = 10000;
    static final int TYPE_LAYER_OFFSET = 1000;
    static final int WINDOW_LAYER_MULTIPLIER = 5;
    static final int LAYER_OFFSET_DIM = 1;
    static final int LAYER_OFFSET_THUMBNAIL = 4;
    static final int MAX_ANIMATION_DURATION = 10000;
    static final int WINDOW_FREEZE_TIMEOUT_DURATION = 2000;
    static final int SEAMLESS_ROTATION_TIMEOUT_DURATION = 2000;
    static final int WINDOW_REPLACEMENT_TIMEOUT_DURATION = 2000;
    static final int LAST_ANR_LIFETIME_DURATION_MSECS = 0x6DDD00;
    static final boolean CUSTOM_SCREEN_ROTATION = true;
    private static final int INPUT_DEVICES_READY_FOR_SAFE_MODE_DETECTION_TIMEOUT_MILLIS = 1000;
    static final long DEFAULT_INPUT_DISPATCHING_TIMEOUT_NANOS = 5000000000L;
    private static final int BOOT_ANIMATION_POLL_INTERVAL = 200;
    private static final String BOOT_ANIMATION_SERVICE = "bootanim";
    static final int UPDATE_FOCUS_NORMAL = 0;
    static final int UPDATE_FOCUS_WILL_ASSIGN_LAYERS = 1;
    static final int UPDATE_FOCUS_PLACING_SURFACES = 2;
    static final int UPDATE_FOCUS_WILL_PLACE_SURFACES = 3;
    private static final String SYSTEM_SECURE = "ro.secure";
    private static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    private static final String DENSITY_OVERRIDE = "ro.config.density_override";
    private static final String SIZE_OVERRIDE = "ro.config.size_override";
    private static final int MAX_SCREENSHOT_RETRIES = 3;
    private static final String PROPERTY_EMULATOR_CIRCULAR = "ro.emulator.circular";
    private static final boolean ALWAYS_KEEP_CURRENT = true;
    private static final float DRAG_SHADOW_ALPHA_TRANSPARENT = 0.7071f;
    private static final int WINDOW_ANIMATION_SCALE = 0;
    private static final int TRANSITION_ANIMATION_SCALE = 1;
    private static final int ANIMATION_DURATION_SCALE = 2;
    private final KeyguardDisableHandler mKeyguardDisableHandler;
    static final String ACTION_REVOKE_SYSTEM_ALERT_WINDOW_PERMISSION = "com.android.server.wm.ACTION_REVOKE_SYSTEM_ALERT_WINDOW_PERMISSION";
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED": {
                    WindowManagerService.this.mKeyguardDisableHandler.sendEmptyMessage(3);
                    break;
                }
                case "android.intent.action.USER_REMOVED": {
                    int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                    if (userId == -10000) break;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        WindowManagerService.this.mScreenCaptureDisabled.remove(userId);
                        break;
                    }
                }
                case "com.android.server.wm.ACTION_REVOKE_SYSTEM_ALERT_WINDOW_PERMISSION": {
                    String packageName = intent.getStringExtra("android.intent.extra.PACKAGE_NAME");
                    int uid = intent.getIntExtra("android.intent.extra.UID", -1);
                    if (packageName == null || uid == -1) break;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        WindowManagerService.this.mAppOps.setMode(24, uid, packageName, 1);
                        break;
                    }
                }
            }
        }
    };
    final WindowSurfacePlacer mWindowPlacerLocked;
    int mCurrentUserId;
    int[] mCurrentProfileIds = new int[0];
    final Context mContext;
    final boolean mHaveInputMethods;
    final boolean mHasPermanentDpad;
    final long mDrawLockTimeoutMillis;
    final boolean mAllowAnimationsInLowPowerMode;
    final boolean mAllowBootMessages;
    final boolean mLimitedAlphaCompositing;
    final WindowManagerPolicy mPolicy;
    final IActivityManager mActivityManager;
    final ActivityManagerInternal mAmInternal;
    final AppOpsManager mAppOps;
    final DisplaySettings mDisplaySettings;
    final ArraySet<Session> mSessions = new ArraySet();
    final HashMap<IBinder, WindowState> mWindowMap = new HashMap();
    final ArrayList<AppWindowToken> mFinishedStarting = new ArrayList();
    final ArrayList<AppWindowToken> mFinishedEarlyAnim = new ArrayList();
    final ArrayList<AppWindowToken> mWindowReplacementTimeouts = new ArrayList();
    final ArrayList<WindowState> mResizingWindows = new ArrayList();
    final ArrayList<WindowState> mPendingRemove = new ArrayList();
    WindowState[] mPendingRemoveTmp = new WindowState[20];
    final ArrayList<WindowState> mDestroySurface = new ArrayList();
    final ArrayList<WindowState> mDestroyPreservedSurface = new ArrayList();
    ArrayList<WindowState> mLosingFocus = new ArrayList();
    final ArrayList<WindowState> mForceRemoves = new ArrayList();
    ArrayList<WindowState> mWaitingForDrawn = new ArrayList();
    Runnable mWaitingForDrawnCallback;
    SparseArray<Boolean> mScreenCaptureDisabled = new SparseArray();
    IInputMethodManager mInputMethodManager;
    AccessibilityController mAccessibilityController;
    final SurfaceSession mFxSession;
    Watermark mWatermark;
    StrictModeFlash mStrictModeFlash;
    CircularDisplayMask mCircularDisplayMask;
    EmulatorDisplayOverlay mEmulatorDisplayOverlay;
    final float[] mTmpFloats = new float[9];
    final Rect mTmpRect = new Rect();
    final Rect mTmpRect2 = new Rect();
    final Rect mTmpRect3 = new Rect();
    final RectF mTmpRectF = new RectF();
    final Matrix mTmpTransform = new Matrix();
    boolean mDisplayReady;
    boolean mSafeMode;
    boolean mDisplayEnabled = false;
    boolean mSystemBooted = false;
    boolean mForceDisplayEnabled = false;
    boolean mShowingBootMessages = false;
    boolean mBootAnimationStopped = false;
    WindowState mLastWakeLockHoldingWindow = null;
    WindowState mLastWakeLockObscuringWindow = null;
    String mLastANRState;
    RootWindowContainer mRoot;
    int mRotation = 0;
    int mLastOrientation = -1;
    boolean mAltOrientation = false;
    int mDockedStackCreateMode = 0;
    Rect mDockedStackCreateBounds;
    private final SparseIntArray mTmpTaskIds = new SparseIntArray();
    boolean mForceResizableTasks = false;
    boolean mSupportsPictureInPicture = false;
    ArrayList<RotationWatcher> mRotationWatchers = new ArrayList();
    int mDeferredRotationPauseCount;
    int mSystemDecorLayer = 0;
    final Rect mScreenRect = new Rect();
    boolean mDisplayFrozen = false;
    long mDisplayFreezeTime = 0L;
    int mLastDisplayFreezeDuration = 0;
    Object mLastFinishedFreezeSource = null;
    boolean mWaitingForConfig = false;
    boolean mSwitchingUser = false;
    static final int WINDOWS_FREEZING_SCREENS_NONE = 0;
    static final int WINDOWS_FREEZING_SCREENS_ACTIVE = 1;
    static final int WINDOWS_FREEZING_SCREENS_TIMEOUT = 2;
    int mWindowsFreezingScreen = 0;
    boolean mClientFreezingScreen = false;
    int mAppsFreezingScreen = 0;
    int mLastWindowForcedOrientation = -1;
    int mLastKeyguardForcedOrientation = -1;
    int mLayoutSeq = 0;
    int mLastStatusBarVisibility = 0;
    int mLastDispatchedSystemUiVisibility = 0;
    boolean mFocusMayChange;
    private final PowerManager.WakeLock mScreenFrozenLock;
    final AppTransition mAppTransition;
    boolean mSkipAppTransitionAnimation = false;
    final ArraySet<AppWindowToken> mOpeningApps = new ArraySet();
    final ArraySet<AppWindowToken> mClosingApps = new ArraySet();
    final UnknownAppVisibilityController mUnknownAppVisibilityController = new UnknownAppVisibilityController(this);
    final TaskSnapshotController mTaskSnapshotController = new TaskSnapshotController(this);
    boolean mIsTouchDevice;
    final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mRealDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mTmpDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mCompatDisplayMetrics = new DisplayMetrics();
    final H mH = new H();
    final Choreographer mChoreographer = Choreographer.getInstance();
    WindowState mCurrentFocus = null;
    WindowState mLastFocus = null;
    WindowState mInputMethodTarget = null;
    boolean mInputMethodTargetWaitingAnim;
    WindowState mInputMethodWindow = null;
    boolean mHardKeyboardAvailable;
    WindowManagerInternal.OnHardKeyboardStatusChangeListener mHardKeyboardStatusChangeListener;
    SettingsObserver mSettingsObserver;
    int mSeamlessRotationCount = 0;
    boolean mAnimateWallpaperWithTarget;
    AppWindowToken mFocusedApp = null;
    PowerManager mPowerManager;
    PowerManagerInternal mPowerManagerInternal;
    private float mWindowAnimationScaleSetting = 1.0f;
    private float mTransitionAnimationScaleSetting = 1.0f;
    private float mAnimatorDurationScaleSetting = 1.0f;
    private boolean mAnimationsDisabled = false;
    final InputManagerService mInputManager;
    final DisplayManagerInternal mDisplayManagerInternal;
    final DisplayManager mDisplayManager;
    private final Display[] mDisplays;
    private Session mHoldingScreenOn;
    private PowerManager.WakeLock mHoldingScreenWakeLock;
    boolean mTurnOnScreen;
    boolean mAllowTheaterModeWakeFromLayout;
    TaskPositioner mTaskPositioner;
    DragState mDragState = null;
    private int mExitAnimId;
    private int mEnterAnimId;
    boolean mAnimationScheduled;
    int mTransactionSequence;
    final WindowAnimator mAnimator;
    final BoundsAnimationController mBoundsAnimationController;
    private final PointerEventDispatcher mPointerEventDispatcher;
    private WindowContentFrameStats mTempWindowRenderStats;
    boolean mInTouchMode;
    private ViewServer mViewServer;
    final ArrayList<WindowChangeListener> mWindowChangeListeners = new ArrayList();
    boolean mWindowsChanged = false;
    final Configuration mTempConfiguration = new Configuration();
    float mCompatibleScreenScale;
    final boolean mOnlyCore;
    final List<IBinder> mNoAnimationNotifyOnTransitionFinished = new ArrayList<IBinder>();
    final WindowManagerInternal.AppTransitionListener mActivityManagerAppTransitionNotifier = new WindowManagerInternal.AppTransitionListener(){

        @Override
        public void onAppTransitionCancelledLocked(int transit) {
            WindowManagerService.this.mH.sendEmptyMessage(48);
        }

        @Override
        public void onAppTransitionFinishedLocked(IBinder token) {
            WindowManagerService.this.mH.sendEmptyMessage(49);
            AppWindowToken atoken = WindowManagerService.this.mRoot.getAppWindowToken(token);
            if (atoken == null) {
                return;
            }
            if (atoken.mLaunchTaskBehind) {
                try {
                    WindowManagerService.this.mActivityManager.notifyLaunchTaskBehindComplete(atoken.token);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                atoken.mLaunchTaskBehind = false;
            } else {
                atoken.updateReportedVisibilityLocked();
                if (atoken.mEnteringAnimation) {
                    atoken.mEnteringAnimation = false;
                    try {
                        WindowManagerService.this.mActivityManager.notifyEnterAnimationComplete(atoken.token);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    };
    final ArrayList<AppFreezeListener> mAppFreezeListeners = new ArrayList();
    private static WindowManagerService sInstance;
    final InputMonitor mInputMonitor = new InputMonitor(this);
    private boolean mEventDispatchingEnabled;
    MousePositionTracker mMousePositionTracker = new MousePositionTracker();

    int getDragLayerLocked() {
        return this.mPolicy.getWindowLayerFromTypeLw(2016) * 10000 + 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openSurfaceTransaction() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mRoot.mSurfaceTraceEnabled) {
                this.mRoot.mRemoteEventTrace.openSurfaceTransaction();
            }
            SurfaceControl.openTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSurfaceTransaction() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mRoot.mSurfaceTraceEnabled) {
                this.mRoot.mRemoteEventTrace.closeSurfaceTransaction();
            }
            SurfaceControl.closeTransaction();
        }
    }

    static WindowManagerService getInstance() {
        return sInstance;
    }

    public static WindowManagerService main(Context context, InputManagerService im, boolean haveInputMethods, boolean showBootMsgs, boolean onlyCore, WindowManagerPolicy policy) {
        DisplayThread.getHandler().runWithScissors(WindowManagerService$$Lambda$29.get$Lambda(context, im, haveInputMethods, showBootMsgs, onlyCore, policy), 0L);
        return sInstance;
    }

    private void initPolicy() {
        UiThread.getHandler().runWithScissors(new Runnable(){

            @Override
            public void run() {
                WindowManagerPolicyThread.set(Thread.currentThread(), Looper.myLooper());
                WindowManagerService.this.mPolicy.init(WindowManagerService.this.mContext, WindowManagerService.this, WindowManagerService.this);
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowManagerService(Context context, InputManagerService inputManager, boolean haveInputMethods, boolean showBootMsgs, boolean onlyCore, WindowManagerPolicy policy) {
        Display[] inputChannel;
        this.mRoot = new RootWindowContainer(this);
        this.mContext = context;
        this.mHaveInputMethods = haveInputMethods;
        this.mAllowBootMessages = showBootMsgs;
        this.mOnlyCore = onlyCore;
        this.mLimitedAlphaCompositing = context.getResources().getBoolean(17956988);
        this.mHasPermanentDpad = context.getResources().getBoolean(17956961);
        this.mInTouchMode = context.getResources().getBoolean(17956913);
        this.mDrawLockTimeoutMillis = context.getResources().getInteger(17694777);
        this.mAllowAnimationsInLowPowerMode = context.getResources().getBoolean(17956871);
        this.mInputManager = inputManager;
        this.mDisplayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
        this.mDisplaySettings = new DisplaySettings();
        this.mDisplaySettings.readSettingsLocked();
        this.mWindowPlacerLocked = new WindowSurfacePlacer(this);
        this.mPolicy = policy;
        LocalServices.addService(WindowManagerPolicy.class, this.mPolicy);
        this.mPointerEventDispatcher = this.mInputManager != null ? ((inputChannel = this.mInputManager.monitorInput(TAG)) != null ? new PointerEventDispatcher((InputChannel)inputChannel) : null) : null;
        this.mFxSession = new SurfaceSession();
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
        for (Display display : this.mDisplays = this.mDisplayManager.getDisplays()) {
            this.createDisplayContentLocked(display);
        }
        this.mKeyguardDisableHandler = new KeyguardDisableHandler(this.mContext, this.mPolicy);
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        if (this.mPowerManagerInternal != null) {
            this.mPowerManagerInternal.registerLowPowerModeObserver(WindowManagerService$$Lambda$30.get$Lambda(this));
            this.mAnimationsDisabled = this.mPowerManagerInternal.getLowPowerModeEnabled();
        }
        this.mScreenFrozenLock = this.mPowerManager.newWakeLock(1, "SCREEN_FROZEN");
        this.mScreenFrozenLock.setReferenceCounted(false);
        this.mAppTransition = new AppTransition(context, this);
        this.mAppTransition.registerListenerLocked(this.mActivityManagerAppTransitionNotifier);
        this.mBoundsAnimationController = new BoundsAnimationController(this.mAppTransition, UiThread.getHandler());
        this.mActivityManager = ActivityManager.getService();
        this.mAmInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        AppOpsManager.OnOpChangedInternalListener opListener = new AppOpsManager.OnOpChangedInternalListener(){

            @Override
            public void onOpChanged(int op, String packageName) {
                WindowManagerService.this.updateAppOpsState();
            }
        };
        this.mAppOps.startWatchingMode(24, null, (AppOpsManager.OnOpChangedListener)opListener);
        this.mAppOps.startWatchingMode(45, null, (AppOpsManager.OnOpChangedListener)opListener);
        this.mWindowAnimationScaleSetting = Settings.Global.getFloat(context.getContentResolver(), "window_animation_scale", this.mWindowAnimationScaleSetting);
        this.mTransitionAnimationScaleSetting = Settings.Global.getFloat(context.getContentResolver(), "transition_animation_scale", context.getResources().getFloat(17104948));
        this.setAnimatorDurationScale(Settings.Global.getFloat(context.getContentResolver(), "animator_duration_scale", this.mAnimatorDurationScaleSetting));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction(ACTION_REVOKE_SYSTEM_ALERT_WINDOW_PERMISSION);
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        this.mSettingsObserver = new SettingsObserver();
        this.mHoldingScreenWakeLock = this.mPowerManager.newWakeLock(0x2000000A, TAG);
        this.mHoldingScreenWakeLock.setReferenceCounted(false);
        this.mAnimator = new WindowAnimator(this);
        this.mAllowTheaterModeWakeFromLayout = context.getResources().getBoolean(17956884);
        LocalServices.addService(WindowManagerInternal.class, new LocalService());
        this.initPolicy();
        Watchdog.getInstance().addMonitor(this);
        this.openSurfaceTransaction();
        try {
            this.createWatermarkInTransaction();
        }
        finally {
            this.closeSurfaceTransaction();
        }
        this.showEmulatorDisplayOverlayIfNeeded();
    }

    public InputMonitor getInputMonitor() {
        return this.mInputMonitor;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Window Manager Crash", e);
            }
            throw e;
        }
    }

    static boolean excludeWindowTypeFromTapOutTask(int windowType) {
        switch (windowType) {
            case 2000: 
            case 2012: 
            case 2019: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, Rect outContentInsets, Rect outStableInsets, Rect outOutsets, InputChannel outInputChannel) {
        long origId;
        int[] appOp = new int[1];
        int res = this.mPolicy.checkAddPermission(attrs, appOp);
        if (res != 0) {
            return res;
        }
        boolean reportNewConfig = false;
        WindowState parentWindow = null;
        int callingUid = Binder.getCallingUid();
        int type = attrs.type;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int startOpResult;
            boolean openInputChannels;
            if (!this.mDisplayReady) {
                throw new IllegalStateException("Display has not been initialialized");
            }
            DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
            if (displayContent == null) {
                Slog.w(TAG, "Attempted to add window to a display that does not exist: " + displayId + ".  Aborting.");
                return -9;
            }
            if (!displayContent.hasAccess(session.mUid) && !this.mDisplayManagerInternal.isUidPresentOnDisplay(session.mUid, displayId)) {
                Slog.w(TAG, "Attempted to add window to a display for which the application does not have access: " + displayId + ".  Aborting.");
                return -9;
            }
            if (this.mWindowMap.containsKey(client.asBinder())) {
                Slog.w(TAG, "Window " + client + " is already added");
                return -5;
            }
            if (type >= 1000 && type <= 1999) {
                parentWindow = this.windowForClientLocked(null, attrs.token, false);
                if (parentWindow == null) {
                    Slog.w(TAG, "Attempted to add window with token that is not a window: " + attrs.token + ".  Aborting.");
                    return -2;
                }
                if (parentWindow.mAttrs.type >= 1000 && parentWindow.mAttrs.type <= 1999) {
                    Slog.w(TAG, "Attempted to add window with token that is a sub-window: " + attrs.token + ".  Aborting.");
                    return -2;
                }
            }
            if (type == 2030 && !displayContent.isPrivate()) {
                Slog.w(TAG, "Attempted to add private presentation window to a non-private display.  Aborting.");
                return -8;
            }
            AppWindowToken atoken = null;
            boolean hasParent = parentWindow != null;
            WindowToken token = displayContent.getWindowToken(hasParent ? parentWindow.mAttrs.token : attrs.token);
            int rootType = hasParent ? parentWindow.mAttrs.type : type;
            boolean addToastWindowRequiresToken = false;
            if (token == null) {
                if (rootType >= 1 && rootType <= 99) {
                    Slog.w(TAG, "Attempted to add application window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (rootType == 2011) {
                    Slog.w(TAG, "Attempted to add input method window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (rootType == 2031) {
                    Slog.w(TAG, "Attempted to add voice interaction window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (rootType == 2013) {
                    Slog.w(TAG, "Attempted to add wallpaper window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (rootType == 2023) {
                    Slog.w(TAG, "Attempted to add Dream window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (rootType == 2035) {
                    Slog.w(TAG, "Attempted to add QS dialog window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (rootType == 2032) {
                    Slog.w(TAG, "Attempted to add Accessibility overlay window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2005 && this.doesAddToastWindowRequireToken(attrs.packageName, callingUid, parentWindow)) {
                    Slog.w(TAG, "Attempted to add a toast window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                token = new WindowToken(this, attrs.token, type, false, displayContent, session.mCanAddInternalSystemWindow);
            } else if (rootType >= 1 && rootType <= 99) {
                atoken = token.asAppWindowToken();
                if (atoken == null) {
                    Slog.w(TAG, "Attempted to add window with non-application token " + token + ".  Aborting.");
                    return -3;
                }
                if (atoken.removed) {
                    Slog.w(TAG, "Attempted to add window with exiting application token " + token + ".  Aborting.");
                    return -4;
                }
                if (rootType == 3 && (attrs.privateFlags & 0x80000) == 0 && atoken.firstWindowDrawn) {
                    return -6;
                }
            } else if (rootType == 2011) {
                if (token.windowType != 2011) {
                    Slog.w(TAG, "Attempted to add input method window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (rootType == 2031) {
                if (token.windowType != 2031) {
                    Slog.w(TAG, "Attempted to add voice interaction window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (rootType == 2013) {
                if (token.windowType != 2013) {
                    Slog.w(TAG, "Attempted to add wallpaper window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (rootType == 2023) {
                if (token.windowType != 2023) {
                    Slog.w(TAG, "Attempted to add Dream window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (rootType == 2032) {
                if (token.windowType != 2032) {
                    Slog.w(TAG, "Attempted to add Accessibility overlay window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2005) {
                addToastWindowRequiresToken = this.doesAddToastWindowRequireToken(attrs.packageName, callingUid, parentWindow);
                if (addToastWindowRequiresToken && token.windowType != 2005) {
                    Slog.w(TAG, "Attempted to add a toast window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2035) {
                if (token.windowType != 2035) {
                    Slog.w(TAG, "Attempted to add QS dialog window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (token.asAppWindowToken() != null) {
                Slog.w(TAG, "Non-null appWindowToken for system window of rootType=" + rootType);
                attrs.token = null;
                token = new WindowToken(this, null, type, false, displayContent, session.mCanAddInternalSystemWindow);
            }
            WindowState win = new WindowState(this, session, client, token, parentWindow, appOp[0], seq, attrs, viewVisibility, session.mUid, session.mCanAddInternalSystemWindow);
            if (win.mDeathRecipient == null) {
                Slog.w(TAG, "Adding window client " + client.asBinder() + " that is dead, aborting.");
                return -4;
            }
            if (win.getDisplayContent() == null) {
                Slog.w(TAG, "Adding window to Display that has been removed.");
                return -9;
            }
            this.mPolicy.adjustWindowParamsLw(win.mAttrs);
            win.setShowToOwnerOnlyLocked(this.mPolicy.checkShowToOwnerOnly(attrs));
            res = this.mPolicy.prepareAddWindowLw(win, attrs);
            if (res != 0) {
                return res;
            }
            boolean bl = openInputChannels = outInputChannel != null && (attrs.inputFeatures & 2) == 0;
            if (openInputChannels) {
                win.openInputChannel(outInputChannel);
            }
            if (type == 2005) {
                if (!this.getDefaultDisplayContentLocked().canAddToastWindowForUid(callingUid)) {
                    Slog.w(TAG, "Adding more than one toast window for UID at a time.");
                    return -5;
                }
                if (addToastWindowRequiresToken || (attrs.flags & 8) == 0 || this.mCurrentFocus == null || this.mCurrentFocus.mOwnerUid != callingUid) {
                    this.mH.sendMessageDelayed(this.mH.obtainMessage(52, win), win.mAttrs.hideTimeoutMilliseconds);
                }
            }
            res = 0;
            if (WindowManagerService.excludeWindowTypeFromTapOutTask(type)) {
                displayContent.mTapExcludedWindows.add(win);
            }
            origId = Binder.clearCallingIdentity();
            win.attach();
            this.mWindowMap.put(client.asBinder(), win);
            if (win.mAppOp != -1 && (startOpResult = this.mAppOps.startOpNoThrow(win.mAppOp, win.getOwningUid(), win.getOwningPackage())) != 0 && startOpResult != 3) {
                win.setAppOpVisibilityLw(false);
            }
            AppWindowToken aToken = token.asAppWindowToken();
            if (type == 3 && aToken != null) {
                aToken.startingWindow = win;
            }
            boolean imMayMove = true;
            win.mToken.addWindow(win);
            if (type == 2011) {
                win.mGivenInsetsPending = true;
                this.setInputMethodWindowLocked(win);
                imMayMove = false;
            } else if (type == 2012) {
                displayContent.computeImeTarget(true);
                imMayMove = false;
            } else if (type == 2013) {
                displayContent.mWallpaperController.clearLastWallpaperTimeoutTime();
                displayContent.pendingLayoutChanges |= 4;
            } else if ((attrs.flags & 0x100000) != 0) {
                displayContent.pendingLayoutChanges |= 4;
            } else if (displayContent.mWallpaperController.isBelowWallpaperTarget(win)) {
                displayContent.pendingLayoutChanges |= 4;
            }
            win.applyAdjustForImeIfNeeded();
            if (type == 2034) {
                this.mRoot.getDisplayContent(displayId).getDockedDividerController().setWindow(win);
            }
            WindowStateAnimator winAnimator = win.mWinAnimator;
            winAnimator.mEnterAnimationPending = true;
            winAnimator.mEnteringAnimation = true;
            if (atoken != null && atoken.isVisible() && !this.prepareWindowReplacementTransition(atoken)) {
                this.prepareNoneTransitionForRelaunching(atoken);
            }
            if (displayContent.isDefaultDisplay) {
                Rect taskBounds;
                DisplayInfo displayInfo = displayContent.getDisplayInfo();
                if (atoken != null && atoken.mTask != null) {
                    taskBounds = this.mTmpRect;
                    atoken.mTask.getBounds(this.mTmpRect);
                } else {
                    taskBounds = null;
                }
                if (this.mPolicy.getInsetHintLw(win.mAttrs, taskBounds, this.mRotation, displayInfo.logicalWidth, displayInfo.logicalHeight, outContentInsets, outStableInsets, outOutsets)) {
                    res |= 4;
                }
            } else {
                outContentInsets.setEmpty();
                outStableInsets.setEmpty();
            }
            if (this.mInTouchMode) {
                res |= 1;
            }
            if (win.mAppToken == null || !win.mAppToken.clientHidden) {
                res |= 2;
            }
            this.mInputMonitor.setUpdateInputWindowsNeededLw();
            boolean focusChanged = false;
            if (win.canReceiveKeys() && (focusChanged = this.updateFocusedWindowLocked(1, false))) {
                imMayMove = false;
            }
            if (imMayMove) {
                displayContent.computeImeTarget(true);
            }
            displayContent.assignWindowLayers(false);
            if (focusChanged) {
                this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, false);
            }
            this.mInputMonitor.updateInputWindowsLw(false);
            if (win.isVisibleOrAdding() && this.updateOrientationFromAppTokensLocked(false, displayId)) {
                reportNewConfig = true;
            }
        }
        if (reportNewConfig) {
            this.sendNewConfiguration(displayId);
        }
        Binder.restoreCallingIdentity(origId);
        return res;
    }

    private boolean doesAddToastWindowRequireToken(String packageName, int callingUid, WindowState attachedWindow) {
        if (attachedWindow != null) {
            return attachedWindow.mAppToken != null && attachedWindow.mAppToken.mTargetSdk > 25;
        }
        try {
            ApplicationInfo appInfo = this.mContext.getPackageManager().getApplicationInfoAsUser(packageName, 0, UserHandle.getUserId(callingUid));
            if (appInfo.uid != callingUid) {
                throw new SecurityException("Package " + packageName + " not in UID " + callingUid);
            }
            if (appInfo.targetSdkVersion > 25) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean prepareWindowReplacementTransition(AppWindowToken atoken) {
        atoken.clearAllDrawn();
        WindowState replacedWindow = atoken.getReplacingWindow();
        if (replacedWindow == null) {
            return false;
        }
        Rect frame = replacedWindow.mVisibleFrame;
        this.mOpeningApps.add(atoken);
        this.prepareAppTransition(18, true);
        this.mAppTransition.overridePendingAppTransitionClipReveal(frame.left, frame.top, frame.width(), frame.height());
        this.executeAppTransition();
        return true;
    }

    private void prepareNoneTransitionForRelaunching(AppWindowToken atoken) {
        if (this.mDisplayFrozen && !this.mOpeningApps.contains(atoken) && atoken.isRelaunching()) {
            this.mOpeningApps.add(atoken);
            this.prepareAppTransition(0, false);
            this.executeAppTransition();
        }
    }

    boolean isScreenCaptureDisabledLocked(int userId) {
        Boolean disabled = this.mScreenCaptureDisabled.get(userId);
        if (disabled == null) {
            return false;
        }
        return disabled;
    }

    boolean isSecureLocked(WindowState w) {
        if ((w.mAttrs.flags & 0x2000) != 0) {
            return true;
        }
        return this.isScreenCaptureDisabledLocked(UserHandle.getUserId(w.mOwnerUid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableSurfaceTrace(ParcelFileDescriptor pfd) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 2000 && callingUid != 0) {
            throw new SecurityException("Only shell can call enableSurfaceTrace");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mRoot.enableSurfaceTrace(pfd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableSurfaceTrace() {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 2000 && callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("Only shell can call disableSurfaceTrace");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mRoot.disableSurfaceTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScreenCaptureDisabled(int userId, boolean disabled) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("Only system can call setScreenCaptureDisabled.");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mScreenCaptureDisabled.put(userId, disabled);
            this.mRoot.setSecureSurfaceState(userId, disabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWindow(Session session, IWindow client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return;
            }
            win.removeIfPossible();
        }
    }

    void postWindowRemoveCleanupLocked(WindowState win) {
        this.mWindowMap.remove(win.mClient.asBinder());
        if (win.mAppOp != -1) {
            this.mAppOps.finishOp(win.mAppOp, win.getOwningUid(), win.getOwningPackage());
        }
        this.mPendingRemove.remove(win);
        this.mResizingWindows.remove(win);
        this.mWindowsChanged = true;
        if (this.mInputMethodWindow == win) {
            this.setInputMethodWindowLocked(null);
        }
        WindowToken token = win.mToken;
        AppWindowToken atoken = win.mAppToken;
        if (token.isEmpty()) {
            if (!token.mPersistOnEmpty) {
                token.removeImmediately();
            } else if (atoken != null) {
                atoken.firstWindowDrawn = false;
                atoken.clearAllDrawn();
            }
        }
        if (atoken != null) {
            atoken.postWindowRemoveStartingWindowCleanup(win);
        }
        DisplayContent dc = win.getDisplayContent();
        if (win.mAttrs.type == 2013) {
            dc.mWallpaperController.clearLastWallpaperTimeoutTime();
            dc.pendingLayoutChanges |= 4;
        } else if ((win.mAttrs.flags & 0x100000) != 0) {
            dc.pendingLayoutChanges |= 4;
        }
        if (dc != null && !this.mWindowPlacerLocked.isInLayout()) {
            dc.assignWindowLayers(true);
            this.mWindowPlacerLocked.performSurfacePlacement();
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
        }
        this.mInputMonitor.updateInputWindowsLw(true);
    }

    void setInputMethodWindowLocked(WindowState win) {
        this.mInputMethodWindow = win;
        DisplayContent dc = win != null ? win.getDisplayContent() : this.getDefaultDisplayContentLocked();
        dc.computeImeTarget(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAppOpsState() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mRoot.updateAppOpsState();
        }
    }

    static void logSurface(WindowState w, String msg, boolean withStackTrace) {
        String str = "  SURFACE " + msg + ": " + w;
        if (withStackTrace) {
            WindowManagerService.logWithStack(TAG, str);
        } else {
            Slog.i(TAG, str);
        }
    }

    static void logSurface(SurfaceControl s, String title, String msg) {
        String str = "  SURFACE " + s + ": " + msg + " / " + title;
        Slog.i(TAG, str);
    }

    static void logWithStack(String tag, String s) {
        Throwable e = null;
        Slog.i(tag, s, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransparentRegionWindow(Session session, IWindow client, Region region) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null && w.mHasSurface) {
                    w.mWinAnimator.setTransparentRegionHintLocked(region);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInsetsWindow(Session session, IWindow client, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null) {
                    w.mGivenInsetsPending = false;
                    w.mGivenContentInsets.set(contentInsets);
                    w.mGivenVisibleInsets.set(visibleInsets);
                    w.mGivenTouchableRegion.set(touchableRegion);
                    w.mTouchableInsets = touchableInsets;
                    if (w.mGlobalScale != 1.0f) {
                        w.mGivenContentInsets.scale(w.mGlobalScale);
                        w.mGivenVisibleInsets.scale(w.mGlobalScale);
                        w.mGivenTouchableRegion.scale(w.mGlobalScale);
                    }
                    w.setDisplayLayoutNeeded();
                    this.mWindowPlacerLocked.performSurfacePlacement();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWindowDisplayFrame(Session session, IWindow client, Rect outDisplayFrame) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                outDisplayFrame.setEmpty();
                return;
            }
            outDisplayFrame.set(win.mDisplayFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window;
            if (this.mAccessibilityController != null && (window = this.mWindowMap.get(token)) != null && window.getDisplayId() == 0) {
                this.mAccessibilityController.onRectangleOnScreenRequestedLocked(rectangle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWindowId getWindowId(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window = this.mWindowMap.get(token);
            return window != null ? window.mWindowId : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pokeDrawLock(Session session, IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window = this.windowForClientLocked(session, token, false);
            if (window != null) {
                window.pokeDrawLockLw(this.mDrawLockTimeoutMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repositionChild(Session session, IWindow client, int left, int top, int right, int bottom, long frameNumber, Rect outFrame) {
        Trace.traceBegin(32L, "repositionChild");
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win;
                block14: {
                    win = this.windowForClientLocked(session, client, false);
                    if (win != null) break block14;
                    return;
                }
                if (!win.isChildWindow()) {
                    throw new IllegalArgumentException("repositionChild called but window is notattached to a parent win=" + win);
                }
                win.mAttrs.x = left;
                win.mAttrs.y = top;
                win.mAttrs.width = right - left;
                win.mAttrs.height = bottom - top;
                win.setWindowScale(win.mRequestedWidth, win.mRequestedHeight);
                if (win.mHasSurface) {
                    this.openSurfaceTransaction();
                    try {
                        win.applyGravityAndUpdateFrame(win.mContainingFrame, win.mDisplayFrame);
                        win.mWinAnimator.computeShownFrameLocked();
                        win.mWinAnimator.setSurfaceBoundariesLocked(false);
                        if (frameNumber > 0L) {
                            win.mWinAnimator.deferTransactionUntilParentFrame(frameNumber);
                        }
                    }
                    finally {
                        this.closeSurfaceTransaction();
                    }
                }
                outFrame = win.mCompatFrame;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
            Trace.traceEnd(32L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int relayoutWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, Rect outFrame, Rect outOverscanInsets, Rect outContentInsets, Rect outVisibleInsets, Rect outStableInsets, Rect outOutsets, Rect outBackdropFrame, Configuration outConfig, Surface outSurface) {
        boolean configChanged;
        int displayId;
        int result = 0;
        boolean hasStatusBarPermission = this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") == 0;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return 0;
            }
            displayId = win.getDisplayId();
            WindowStateAnimator winAnimator = win.mWinAnimator;
            if (viewVisibility != 8) {
                win.setRequestedSize(requestedWidth, requestedHeight);
            }
            int attrChanges = 0;
            int flagChanges = 0;
            if (attrs != null) {
                this.mPolicy.adjustWindowParamsLw(attrs);
                if (seq == win.mSeq) {
                    int systemUiVisibility = attrs.systemUiVisibility | attrs.subtreeSystemUiVisibility;
                    if ((systemUiVisibility & 0x3FF0000) != 0 && !hasStatusBarPermission) {
                        systemUiVisibility &= 0xFC00FFFF;
                    }
                    win.mSystemUiVisibility = systemUiVisibility;
                }
                if (win.mAttrs.type != attrs.type) {
                    throw new IllegalArgumentException("Window type can not be changed after the window is added.");
                }
                if ((attrs.privateFlags & 0x2000) != 0) {
                    attrs.x = win.mAttrs.x;
                    attrs.y = win.mAttrs.y;
                    attrs.width = win.mAttrs.width;
                    attrs.height = win.mAttrs.height;
                }
                flagChanges = win.mAttrs.flags ^= attrs.flags;
                attrChanges = win.mAttrs.copyFrom(attrs);
                if ((attrChanges & 0x4001) != 0) {
                    win.mLayoutNeeded = true;
                }
                if (win.mAppToken != null && ((flagChanges & 0x80000) != 0 || (flagChanges & 0x400000) != 0)) {
                    win.mAppToken.checkKeyguardFlagsChanged();
                }
                if ((attrChanges & 0x2000000) != 0 && this.mAccessibilityController != null && win.getDisplayId() == 0) {
                    this.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
                }
            }
            winAnimator.mSurfaceDestroyDeferred = (flags & 2) != 0;
            boolean bl = win.mEnforceSizeCompat = (win.mAttrs.privateFlags & 0x80) != 0;
            if ((attrChanges & 0x80) != 0) {
                winAnimator.mAlpha = attrs.alpha;
            }
            win.setWindowScale(win.mRequestedWidth, win.mRequestedHeight);
            if (win.mAttrs.surfaceInsets.left != 0 || win.mAttrs.surfaceInsets.top != 0 || win.mAttrs.surfaceInsets.right != 0 || win.mAttrs.surfaceInsets.bottom != 0) {
                winAnimator.setOpaqueLocked(false);
            }
            boolean imMayMove = (flagChanges & 0x20008) != 0;
            boolean isDefaultDisplay = win.isDefaultDisplay();
            boolean focusMayChange = isDefaultDisplay && (win.mViewVisibility != viewVisibility || (flagChanges & 8) != 0 || !win.mRelayoutCalled);
            boolean wallpaperMayMove = win.mViewVisibility != viewVisibility && (win.mAttrs.flags & 0x100000) != 0;
            wallpaperMayMove |= (flagChanges & 0x100000) != 0;
            if ((flagChanges & 0x2000) != 0 && winAnimator.mSurfaceController != null) {
                winAnimator.mSurfaceController.setSecure(this.isSecureLocked(win));
            }
            win.mRelayoutCalled = true;
            win.mInRelayout = true;
            int oldVisibility = win.mViewVisibility;
            win.mViewVisibility = viewVisibility;
            if (!(viewVisibility != 0 || win.mAppToken != null && win.mAttrs.type != 3 && win.mAppToken.clientHidden)) {
                result = win.relayoutVisibleWindow(outConfig, result, attrChanges, oldVisibility);
                try {
                    result = this.createSurfaceControl(outSurface, result, win, winAnimator);
                }
                catch (Exception e) {
                    this.mInputMonitor.updateInputWindowsLw(true);
                    Slog.w(TAG, "Exception thrown when creating surface for client " + client + " (" + win.mAttrs.getTitle() + ")", e);
                    Binder.restoreCallingIdentity(origId);
                    return 0;
                }
                if ((result & 2) != 0) {
                    focusMayChange = isDefaultDisplay;
                }
                if (win.mAttrs.type == 2011 && this.mInputMethodWindow == null) {
                    this.setInputMethodWindowLocked(win);
                    imMayMove = true;
                }
                win.adjustStartingWindowFlags();
            } else {
                boolean usingSavedSurfaceBeforeVisible;
                winAnimator.mEnterAnimationPending = false;
                winAnimator.mEnteringAnimation = false;
                boolean bl2 = usingSavedSurfaceBeforeVisible = oldVisibility != 0 && win.isAnimatingWithSavedSurface();
                if (winAnimator.hasSurface() && !win.mAnimatingExit && !usingSavedSurfaceBeforeVisible) {
                    if (!win.mWillReplaceWindow) {
                        focusMayChange = this.tryStartExitingAnimation(win, winAnimator, isDefaultDisplay, focusMayChange);
                    }
                    result |= 4;
                }
                if (viewVisibility == 0 && winAnimator.hasSurface()) {
                    winAnimator.mSurfaceController.getSurface(outSurface);
                } else {
                    try {
                        Trace.traceBegin(32L, "wmReleaseOutSurface_" + win.mAttrs.getTitle());
                        outSurface.release();
                    }
                    finally {
                        Trace.traceEnd(32L);
                    }
                }
            }
            if (focusMayChange && this.updateFocusedWindowLocked(3, false)) {
                imMayMove = false;
            }
            boolean toBeDisplayed = (result & 2) != 0;
            DisplayContent dc = win.getDisplayContent();
            if (imMayMove) {
                dc.computeImeTarget(true);
                if (toBeDisplayed) {
                    dc.assignWindowLayers(false);
                }
            }
            if (wallpaperMayMove) {
                win.getDisplayContent().pendingLayoutChanges |= 4;
            }
            if (win.mAppToken != null) {
                this.mUnknownAppVisibilityController.notifyRelayouted(win.mAppToken);
            }
            win.setDisplayLayoutNeeded();
            win.mGivenInsetsPending = (flags & 1) != 0;
            configChanged = this.updateOrientationFromAppTokensLocked(false, displayId);
            this.mWindowPlacerLocked.performSurfacePlacement(true);
            if (toBeDisplayed && win.mIsWallpaper) {
                DisplayInfo displayInfo = win.getDisplayContent().getDisplayInfo();
                dc.mWallpaperController.updateWallpaperOffset(win, displayInfo.logicalWidth, displayInfo.logicalHeight, false);
            }
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
            if (winAnimator.mReportSurfaceResized) {
                winAnimator.mReportSurfaceResized = false;
                result |= 0x20;
            }
            if (this.mPolicy.isNavBarForcedShownLw(win)) {
                result |= 0x40;
            }
            if (!win.isGoneForLayoutLw()) {
                win.mResizedWhileGone = false;
            }
            outFrame.set(win.mCompatFrame);
            outOverscanInsets.set(win.mOverscanInsets);
            outContentInsets.set(win.mContentInsets);
            outVisibleInsets.set(win.mVisibleInsets);
            outStableInsets.set(win.mStableInsets);
            outOutsets.set(win.mOutsets);
            outBackdropFrame.set(win.getBackdropFrame(win.mFrame));
            result |= this.mInTouchMode ? 1 : 0;
            this.mInputMonitor.updateInputWindowsLw(true);
            win.mInRelayout = false;
        }
        if (configChanged) {
            this.sendNewConfiguration(displayId);
        }
        Binder.restoreCallingIdentity(origId);
        return result;
    }

    private boolean tryStartExitingAnimation(WindowState win, WindowStateAnimator winAnimator, boolean isDefaultDisplay, boolean focusMayChange) {
        int transit = 2;
        if (win.mAttrs.type == 3) {
            transit = 5;
        }
        if (win.isWinVisibleLw() && winAnimator.applyAnimationLocked(transit, false)) {
            focusMayChange = isDefaultDisplay;
            win.mAnimatingExit = true;
            win.mWinAnimator.mAnimating = true;
        } else if (win.mWinAnimator.isAnimationSet()) {
            win.mAnimatingExit = true;
            win.mWinAnimator.mAnimating = true;
        } else if (win.getDisplayContent().mWallpaperController.isWallpaperTarget(win)) {
            win.mAnimatingExit = true;
            win.mWinAnimator.mAnimating = true;
        } else {
            if (this.mInputMethodWindow == win) {
                this.setInputMethodWindowLocked(null);
            }
            win.destroyOrSaveSurface();
        }
        if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
            this.mAccessibilityController.onWindowTransitionLocked(win, transit);
        }
        return focusMayChange;
    }

    private int createSurfaceControl(Surface outSurface, int result, WindowState win, WindowStateAnimator winAnimator) {
        WindowSurfaceController surfaceController;
        if (!win.mHasSurface) {
            result |= 4;
        }
        if ((surfaceController = winAnimator.createSurfaceLocked(win.mAttrs.type, win.mOwnerUid)) != null) {
            surfaceController.getSurface(outSurface);
        } else {
            Slog.w(TAG, "Failed to create surface control for " + win);
            outSurface.release();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDeferredDestroyWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win;
                block8: {
                    win = this.windowForClientLocked(session, client, false);
                    if (win != null && !win.mWillReplaceWindow) break block8;
                    return;
                }
                win.mWinAnimator.destroyDeferredSurfaceLocked();
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean outOfMemoryWindow(Session session, IWindow client) {
        WindowState win;
        long origId;
        block6: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                // MONITORENTER : hashMap
                win = this.windowForClientLocked(session, client, false);
                if (win != null) break block6;
                bl = false;
                // MONITOREXIT : hashMap
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        boolean bl = this.mRoot.reclaimSomeSurfaceMemory(win.mWinAnimator, "from-client", false);
        // MONITOREXIT : hashMap
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishDrawingWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win = this.windowForClientLocked(session, client, false);
                if (win != null && win.mWinAnimator.finishDrawingLocked()) {
                    if ((win.mAttrs.flags & 0x100000) != 0) {
                        win.getDisplayContent().pendingLayoutChanges |= 4;
                    }
                    win.setDisplayLayoutNeeded();
                    this.mWindowPlacerLocked.requestTraversal();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    boolean applyAnimationLocked(AppWindowToken atoken, WindowManager.LayoutParams lp, int transit, boolean enter, boolean isVoiceInteraction) {
        Trace.traceBegin(32L, "WM#applyAnimationLocked");
        if (this.okToDisplay()) {
            boolean freeform;
            DisplayContent displayContent = atoken.mTask.getDisplayContent();
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            int width = displayInfo.appWidth;
            int height = displayInfo.appHeight;
            WindowState win = atoken.findMainWindow();
            Rect frame = new Rect(0, 0, width, height);
            Rect displayFrame = new Rect(0, 0, displayInfo.logicalWidth, displayInfo.logicalHeight);
            Rect insets = new Rect();
            Rect surfaceInsets = null;
            boolean bl = freeform = win != null && win.inFreeformWorkspace();
            if (win != null) {
                if (freeform) {
                    frame.set(win.mFrame);
                } else {
                    frame.set(win.mContainingFrame);
                }
                surfaceInsets = win.getAttrs().surfaceInsets;
                insets.set(win.mContentInsets);
            }
            if (atoken.mLaunchTaskBehind) {
                enter = false;
            }
            Configuration displayConfig = displayContent.getConfiguration();
            Animation a = this.mAppTransition.loadAnimation(lp, transit, enter, displayConfig.uiMode, displayConfig.orientation, frame, displayFrame, insets, surfaceInsets, isVoiceInteraction, freeform, atoken.mTask.mTaskId);
            if (a != null) {
                int containingWidth = frame.width();
                int containingHeight = frame.height();
                atoken.mAppAnimator.setAnimation(a, containingWidth, containingHeight, width, height, this.mAppTransition.canSkipFirstFrame(), this.mAppTransition.getAppStackClipMode(), transit, this.mAppTransition.getTransitFlags());
            }
        } else {
            atoken.mAppAnimator.clearAnimation();
        }
        Trace.traceEnd(32L);
        return atoken.mAppAnimator.animation != null;
    }

    boolean checkCallingPermission(String permission2, String func) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return true;
        }
        if (this.mContext.checkCallingPermission(permission2) == 0) {
            return true;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w(TAG, msg);
        return false;
    }

    boolean okToDisplay() {
        return !this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWindowToken(IBinder binder, int type, int displayId) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addWindowToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent dc = this.mRoot.getDisplayContentOrCreate(displayId);
            WindowToken token = dc.getWindowToken(binder);
            if (token != null) {
                Slog.w(TAG, "addWindowToken: Attempted to add binder token: " + binder + " for already created window token: " + token + " displayId=" + displayId);
                return;
            }
            if (type == 2013) {
                new WallpaperWindowToken(this, binder, true, dc, true);
            } else {
                new WindowToken(this, binder, type, true, dc, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void removeWindowToken(IBinder binder, int displayId) {
        DisplayContent dc;
        long origId;
        block10: {
            if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeWindowToken()")) {
                throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
            }
            origId = Binder.clearCallingIdentity();
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            // MONITORENTER : hashMap
            dc = this.mRoot.getDisplayContent(displayId);
            if (dc != null) break block10;
            Slog.w(TAG, "removeWindowToken: Attempted to remove token: " + binder + " for non-exiting displayId=" + displayId);
            // MONITOREXIT : hashMap
            Binder.restoreCallingIdentity(origId);
            return;
        }
        WindowToken token = dc.removeWindowToken(binder);
        if (token == null) {
            Slog.w(TAG, "removeWindowToken: Attempted to remove non-existing token: " + binder);
            // MONITOREXIT : hashMap
            Binder.restoreCallingIdentity(origId);
            return;
        }
        try {
            this.mInputMonitor.updateInputWindowsLw(true);
            // MONITOREXIT : hashMap
            return;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration updateOrientationFromAppTokens(Configuration currentConfig, IBinder freezeThisOneIfNeeded, int displayId) {
        Configuration config;
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "updateOrientationFromAppTokens()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                config = this.updateOrientationFromAppTokensLocked(currentConfig, freezeThisOneIfNeeded, displayId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return config;
    }

    private Configuration updateOrientationFromAppTokensLocked(Configuration currentConfig, IBinder freezeThisOneIfNeeded, int displayId) {
        if (!this.mDisplayReady) {
            return null;
        }
        Configuration config = null;
        if (this.updateOrientationFromAppTokensLocked(false, displayId)) {
            AppWindowToken atoken;
            if (freezeThisOneIfNeeded != null && !this.mRoot.mOrientationChangeComplete && (atoken = this.mRoot.getAppWindowToken(freezeThisOneIfNeeded)) != null) {
                atoken.startFreezingScreen();
            }
            config = this.computeNewConfigurationLocked(displayId);
        } else if (currentConfig != null) {
            this.mTempConfiguration.unset();
            this.mTempConfiguration.updateFrom(currentConfig);
            this.computeScreenConfigurationLocked(this.mTempConfiguration, displayId);
            if (currentConfig.diff(this.mTempConfiguration) != 0) {
                this.mWaitingForConfig = true;
                DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
                displayContent.setLayoutNeeded();
                int[] anim2 = new int[2];
                if (displayContent.isDimming()) {
                    anim2[1] = 0;
                    anim2[0] = 0;
                } else {
                    this.mPolicy.selectRotationAnimationLw(anim2);
                }
                this.startFreezingDisplayLocked(false, anim2[0], anim2[1]);
                config = new Configuration(this.mTempConfiguration);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOrientationFromAppTokensLocked(boolean inTransaction, int displayId) {
        long ident = Binder.clearCallingIdentity();
        try {
            int req = this.mRoot.getDisplayContent(displayId).getOrientation();
            if (req != this.mLastOrientation) {
                this.mLastOrientation = req;
                this.mPolicy.setCurrentOrientationLw(req);
                if (this.updateRotationUncheckedLocked(inTransaction, displayId)) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    boolean rotationNeedsUpdateLocked() {
        boolean altOrientation;
        int rotation = this.mPolicy.rotationForOrientationLw(this.mLastOrientation, this.mRotation);
        boolean bl = altOrientation = !this.mPolicy.rotationHasCompatibleMetricsLw(this.mLastOrientation, rotation);
        return this.mRotation != rotation || this.mAltOrientation != altOrientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] setNewDisplayOverrideConfiguration(Configuration overrideConfig, int displayId) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setNewDisplayOverrideConfiguration()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWaitingForConfig) {
                this.mWaitingForConfig = false;
                this.mLastFinishedFreezeSource = "new-config";
            }
            return this.mRoot.setDisplayOverrideConfigurationIfNeeded(overrideConfig, displayId);
        }
    }

    void setFocusTaskRegionLocked(AppWindowToken previousFocus) {
        DisplayContent previousDisplayContent;
        Task focusedTask = this.mFocusedApp != null ? this.mFocusedApp.mTask : null;
        Task previousTask = previousFocus != null ? previousFocus.mTask : null;
        DisplayContent focusedDisplayContent = focusedTask != null ? focusedTask.getDisplayContent() : null;
        DisplayContent displayContent = previousDisplayContent = previousTask != null ? previousTask.getDisplayContent() : null;
        if (previousDisplayContent != null && previousDisplayContent != focusedDisplayContent) {
            previousDisplayContent.setTouchExcludeRegion(null);
        }
        if (focusedDisplayContent != null) {
            focusedDisplayContent.setTouchExcludeRegion(focusedTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusedApp(IBinder token, boolean moveFocusNow) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setFocusedApp()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean changed;
            AppWindowToken newFocus;
            if (token == null) {
                newFocus = null;
            } else {
                newFocus = this.mRoot.getAppWindowToken(token);
                if (newFocus == null) {
                    Slog.w(TAG, "Attempted to set focus to non-existing app token: " + token);
                }
            }
            boolean bl = changed = this.mFocusedApp != newFocus;
            if (changed) {
                AppWindowToken prev = this.mFocusedApp;
                this.mFocusedApp = newFocus;
                this.mInputMonitor.setFocusedAppLw(newFocus);
                this.setFocusTaskRegionLocked(prev);
            }
            if (moveFocusNow && changed) {
                long origId = Binder.clearCallingIdentity();
                this.updateFocusedWindowLocked(0, true);
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    @Override
    public void prepareAppTransition(int transit, boolean alwaysKeepCurrent) {
        this.prepareAppTransition(transit, alwaysKeepCurrent, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareAppTransition(int transit, boolean alwaysKeepCurrent, int flags, boolean forceOverride) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "prepareAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean prepared = this.mAppTransition.prepareAppTransitionLocked(transit, alwaysKeepCurrent, flags, forceOverride);
            if (prepared && this.okToDisplay()) {
                this.mSkipAppTransitionAnimation = false;
            }
        }
    }

    @Override
    public int getPendingAppTransition() {
        return this.mAppTransition.getAppTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransition(String packageName, int enterAnim, int exitAnim, IRemoteCallback startedCallback) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransition(packageName, enterAnim, exitAnim, startedCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionScaleUp(int startX, int startY, int startWidth, int startHeight) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionScaleUp(startX, startY, startWidth, startHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionClipReveal(int startX, int startY, int startWidth, int startHeight) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionClipReveal(startX, startY, startWidth, startHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionThumb(Bitmap srcThumb, int startX, int startY, IRemoteCallback startedCallback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionThumb(srcThumb, startX, startY, startedCallback, scaleUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionAspectScaledThumb(Bitmap srcThumb, int startX, int startY, int targetWidth, int targetHeight, IRemoteCallback startedCallback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionAspectScaledThumb(srcThumb, startX, startY, targetWidth, targetHeight, startedCallback, scaleUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionMultiThumb(AppTransitionAnimationSpec[] specs, IRemoteCallback onAnimationStartedCallback, IRemoteCallback onAnimationFinishedCallback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionMultiThumb(specs, onAnimationStartedCallback, onAnimationFinishedCallback, scaleUp);
            this.prolongAnimationsFromSpecs(specs, scaleUp);
        }
    }

    void prolongAnimationsFromSpecs(AppTransitionAnimationSpec[] specs, boolean scaleUp) {
        this.mTmpTaskIds.clear();
        for (int i = specs.length - 1; i >= 0; --i) {
            this.mTmpTaskIds.put(specs[i].taskId, 0);
        }
        for (WindowState win : this.mWindowMap.values()) {
            AppWindowToken appToken;
            Task task = win.getTask();
            if (task == null || this.mTmpTaskIds.get(task.mTaskId, -1) == -1 || !task.inFreeformWorkspace() || (appToken = win.mAppToken) == null || appToken.mAppAnimator == null) continue;
            appToken.mAppAnimator.startProlongAnimation(scaleUp ? 2 : 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionInPlace(String packageName, int anim2) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overrideInPlaceAppTransition(packageName, anim2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback callback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionMultiThumbFuture(specsFuture, callback, scaleUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endProlongedAnimations() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            for (WindowState win : this.mWindowMap.values()) {
                AppWindowToken appToken = win.mAppToken;
                if (appToken == null || appToken.mAppAnimator == null) continue;
                appToken.mAppAnimator.endProlongedAnimation();
            }
            this.mAppTransition.notifyProlongedAnimationsEnded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAppTransition() {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "executeAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mAppTransition.isTransitionSet()) {
                this.mAppTransition.setReady();
                long origId = Binder.clearCallingIdentity();
                try {
                    this.mWindowPlacerLocked.performSurfacePlacement();
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppFullscreen(IBinder token, boolean toOpaque) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.mRoot.getAppWindowToken(token);
            if (atoken != null) {
                atoken.setFillsParent(toOpaque);
                this.setWindowOpaqueLocked(token, toOpaque);
                this.mWindowPlacerLocked.requestTraversal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowOpaque(IBinder token, boolean isOpaque) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.setWindowOpaqueLocked(token, isOpaque);
        }
    }

    private void setWindowOpaqueLocked(IBinder token, boolean isOpaque) {
        WindowState win;
        AppWindowToken wtoken = this.mRoot.getAppWindowToken(token);
        if (wtoken != null && (win = wtoken.findMainWindow()) != null) {
            win.mWinAnimator.setOpaqueLocked(isOpaque);
        }
    }

    void updateTokenInPlaceLocked(AppWindowToken wtoken, int transit) {
        if (transit != -1) {
            if (wtoken.mAppAnimator.animation == AppWindowAnimator.sDummyAnimation) {
                wtoken.mAppAnimator.setNullAnimation();
            }
            this.applyAnimationLocked(wtoken, null, transit, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDockedStackCreateState(int mode, Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.setDockedStackCreateStateLocked(mode, bounds);
        }
    }

    void setDockedStackCreateStateLocked(int mode, Rect bounds) {
        this.mDockedStackCreateMode = mode;
        this.mDockedStackCreateBounds = bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rect getPictureInPictureBounds(int displayId, float aspectRatio) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Rect stackBounds;
            if (!this.mSupportsPictureInPicture) {
                return null;
            }
            DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
            if (displayContent == null) {
                return null;
            }
            PinnedStackController pinnedStackController = displayContent.getPinnedStackController();
            TaskStack stack = displayContent.getStackById(4);
            if (stack != null) {
                stackBounds = new Rect();
                stack.getAnimatingBounds(stackBounds);
            } else {
                stackBounds = pinnedStackController.getDefaultBounds();
            }
            if (pinnedStackController.isValidPictureInPictureAspectRatio(aspectRatio)) {
                return pinnedStackController.transformBoundsToAspectRatio(stackBounds, aspectRatio);
            }
            return stackBounds;
        }
    }

    public boolean isValidPictureInPictureAspectRatio(int displayId, float aspectRatio) {
        DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
        return displayContent.getPinnedStackController().isValidPictureInPictureAspectRatio(aspectRatio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStackBounds(int stackId, Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mRoot.getStackById(stackId);
            if (stack != null) {
                stack.getBounds(bounds);
                return;
            }
            bounds.setEmpty();
        }
    }

    @Override
    public void notifyShowingDreamChanged() {
        this.notifyKeyguardFlagsChanged(null);
    }

    @Override
    public WindowManagerPolicy.WindowState getInputMethodWindowLw() {
        return this.mInputMethodWindow;
    }

    @Override
    public void notifyKeyguardTrustedChanged() {
        this.mH.sendEmptyMessage(57);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferSurfaceLayout() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowPlacerLocked.deferLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueSurfaceLayout() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowPlacerLocked.continueLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsShowWhenLockedWindow(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.mRoot.getAppWindowToken(token);
            return wtoken != null && wtoken.containsShowWhenLockedWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDismissKeyguardWindow(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.mRoot.getAppWindowToken(token);
            return wtoken != null && wtoken.containsDismissKeyguardWindow();
        }
    }

    void notifyKeyguardFlagsChanged(Runnable callback) {
        Runnable wrappedCallback = callback != null ? WindowManagerService$$Lambda$31.get$Lambda(this, callback) : null;
        this.mH.obtainMessage(56, wrappedCallback).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKeyguardTrusted() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mPolicy.isKeyguardTrustedLw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startFreezingScreen(int exitAnim, int enterAnim) {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "startFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mClientFreezingScreen) {
                this.mClientFreezingScreen = true;
                long origId = Binder.clearCallingIdentity();
                try {
                    this.startFreezingDisplayLocked(false, exitAnim, enterAnim);
                    this.mH.removeMessages(30);
                    this.mH.sendEmptyMessageDelayed(30, 5000L);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopFreezingScreen() {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "stopFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mClientFreezingScreen) {
                this.mClientFreezingScreen = false;
                this.mLastFinishedFreezeSource = "client";
                long origId = Binder.clearCallingIdentity();
                try {
                    this.stopFreezingDisplayLocked();
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    @Override
    public void disableKeyguard(IBinder token, String tag) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (Binder.getCallingUid() != 1000 && this.isKeyguardSecure()) {
            Log.d(TAG, "current mode is SecurityMode, ignore disableKeyguard");
            return;
        }
        if (!this.isCurrentProfileLocked(UserHandle.getCallingUserId())) {
            Log.d(TAG, "non-current profiles, ignore disableKeyguard");
            return;
        }
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(1, new Pair<IBinder, String>(token, tag)));
    }

    @Override
    public void reenableKeyguard(IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(2, token));
    }

    @Override
    public void exitKeyguardSecurely(final IOnKeyguardExitResult callback) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback == null");
        }
        this.mPolicy.exitKeyguardSecurely(new WindowManagerPolicy.OnKeyguardExitResult(){

            @Override
            public void onKeyguardExitResult(boolean success) {
                try {
                    callback.onKeyguardExitResult(success);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean inKeyguardRestrictedInputMode() {
        return this.mPolicy.inKeyguardRestrictedKeyInputMode();
    }

    @Override
    public boolean isKeyguardLocked() {
        return this.mPolicy.isKeyguardLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeyguardSecure() {
        int userId = UserHandle.getCallingUserId();
        long origId = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mPolicy.isKeyguardSecure(userId);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShowingDream() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mPolicy.isShowingDreamLw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismissKeyguard(IKeyguardDismissCallback callback) {
        this.checkCallingPermission("android.permission.CONTROL_KEYGUARD", "dismissKeyguard");
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mPolicy.dismissKeyguardLw(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onKeyguardOccludedChanged(boolean occluded) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mPolicy.onKeyguardOccludedChangedLw(occluded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSwitchingUser(boolean switching) {
        if (!this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "setSwitchingUser()")) {
            throw new SecurityException("Requires INTERACT_ACROSS_USERS_FULL permission");
        }
        this.mPolicy.setSwitchingUser(switching);
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mSwitchingUser = switching;
        }
    }

    void showGlobalActions() {
        this.mPolicy.showGlobalActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSystemDialogs(String reason) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mRoot.closeSystemDialogs(reason);
        }
    }

    static float fixScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 20.0f) {
            scale = 20.0f;
        }
        return Math.abs(scale);
    }

    @Override
    public void setAnimationScale(int which, float scale) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        scale = WindowManagerService.fixScale(scale);
        switch (which) {
            case 0: {
                this.mWindowAnimationScaleSetting = scale;
                break;
            }
            case 1: {
                this.mTransitionAnimationScaleSetting = scale;
                break;
            }
            case 2: {
                this.mAnimatorDurationScaleSetting = scale;
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    @Override
    public void setAnimationScales(float[] scales) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        if (scales != null) {
            if (scales.length >= 1) {
                this.mWindowAnimationScaleSetting = WindowManagerService.fixScale(scales[0]);
            }
            if (scales.length >= 2) {
                this.mTransitionAnimationScaleSetting = WindowManagerService.fixScale(scales[1]);
            }
            if (scales.length >= 3) {
                this.mAnimatorDurationScaleSetting = WindowManagerService.fixScale(scales[2]);
                this.dispatchNewAnimatorScaleLocked(null);
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    private void setAnimatorDurationScale(float scale) {
        this.mAnimatorDurationScaleSetting = scale;
        ValueAnimator.setDurationScale(scale);
    }

    public float getWindowAnimationScaleLocked() {
        return this.mAnimationsDisabled ? 0.0f : this.mWindowAnimationScaleSetting;
    }

    public float getTransitionAnimationScaleLocked() {
        return this.mAnimationsDisabled ? 0.0f : this.mTransitionAnimationScaleSetting;
    }

    @Override
    public float getAnimationScale(int which) {
        switch (which) {
            case 0: {
                return this.mWindowAnimationScaleSetting;
            }
            case 1: {
                return this.mTransitionAnimationScaleSetting;
            }
            case 2: {
                return this.mAnimatorDurationScaleSetting;
            }
        }
        return 0.0f;
    }

    @Override
    public float[] getAnimationScales() {
        return new float[]{this.mWindowAnimationScaleSetting, this.mTransitionAnimationScaleSetting, this.mAnimatorDurationScaleSetting};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getCurrentAnimatorScale() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mAnimationsDisabled ? 0.0f : this.mAnimatorDurationScaleSetting;
        }
    }

    void dispatchNewAnimatorScaleLocked(Session session) {
        this.mH.obtainMessage(34, session).sendToTarget();
    }

    @Override
    public void registerPointerEventListener(WindowManagerPolicy.PointerEventListener listener) {
        this.mPointerEventDispatcher.registerInputEventListener(listener);
    }

    @Override
    public void unregisterPointerEventListener(WindowManagerPolicy.PointerEventListener listener) {
        this.mPointerEventDispatcher.unregisterInputEventListener(listener);
    }

    boolean canDispatchPointerEvents() {
        return this.mPointerEventDispatcher != null;
    }

    @Override
    public int getLidState() {
        int sw = this.mInputManager.getSwitchState(-1, -256, 0);
        if (sw > 0) {
            return 0;
        }
        if (sw == 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public void lockDeviceNow() {
        this.lockNow(null);
    }

    @Override
    public int getCameraLensCoverState() {
        int sw = this.mInputManager.getSwitchState(-1, -256, 9);
        if (sw > 0) {
            return 1;
        }
        if (sw == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public void switchInputMethod(boolean forwardDirection) {
        InputMethodManagerInternal inputMethodManagerInternal = LocalServices.getService(InputMethodManagerInternal.class);
        if (inputMethodManagerInternal != null) {
            inputMethodManagerInternal.switchInputMethod(forwardDirection);
        }
    }

    @Override
    public void shutdown(boolean confirm) {
        ShutdownThread.shutdown(this.mContext, "userrequested", confirm);
    }

    @Override
    public void reboot(boolean confirm) {
        ShutdownThread.reboot(this.mContext, "userrequested", confirm);
    }

    @Override
    public void rebootSafeMode(boolean confirm) {
        ShutdownThread.rebootSafeMode(this.mContext, confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentProfileIds(int[] currentProfileIds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mCurrentProfileIds = currentProfileIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUser(int newUserId, int[] currentProfileIds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mCurrentUserId = newUserId;
            this.mCurrentProfileIds = currentProfileIds;
            this.mAppTransition.setCurrentUser(newUserId);
            this.mPolicy.setCurrentUserLw(newUserId);
            this.mPolicy.enableKeyguard(true);
            this.mRoot.switchUser();
            this.mWindowPlacerLocked.performSurfacePlacement();
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            TaskStack stack = displayContent.getDockedStackIgnoringVisibility();
            displayContent.mDividerControllerLocked.notifyDockedStackExistsChanged(stack != null && stack.hasTaskForUser(newUserId));
            if (this.mDisplayReady) {
                int forcedDensity = this.getForcedDisplayDensityForUserLocked(newUserId);
                int targetDensity = forcedDensity != 0 ? forcedDensity : displayContent.mInitialDisplayDensity;
                this.setForcedDisplayDensityLocked(displayContent, targetDensity);
            }
        }
    }

    boolean isCurrentProfileLocked(int userId) {
        if (userId == this.mCurrentUserId) {
            return true;
        }
        for (int i = 0; i < this.mCurrentProfileIds.length; ++i) {
            if (this.mCurrentProfileIds[i] != userId) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableScreenAfterBoot() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mSystemBooted) {
                return;
            }
            this.mSystemBooted = true;
            this.hideBootMessagesLocked();
            this.mH.sendEmptyMessageDelayed(23, 30000L);
        }
        this.mPolicy.systemBooted();
        this.performEnableScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableScreenIfNeeded() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.enableScreenIfNeededLocked();
        }
    }

    void enableScreenIfNeededLocked() {
        if (this.mDisplayEnabled) {
            return;
        }
        if (!this.mSystemBooted && !this.mShowingBootMessages) {
            return;
        }
        this.mH.sendEmptyMessage(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBootTimeout() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled) {
                return;
            }
            Slog.w(TAG, "***** BOOT TIMEOUT: forcing display enabled");
            this.mForceDisplayEnabled = true;
        }
        this.performEnableScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performEnableScreen() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled) {
                return;
            }
            if (!this.mSystemBooted && !this.mShowingBootMessages) {
                return;
            }
            if (!this.mForceDisplayEnabled && this.getDefaultDisplayContentLocked().checkWaitingForWindows()) {
                return;
            }
            if (!this.mBootAnimationStopped) {
                Trace.asyncTraceBegin(32L, "Stop bootanim", 0);
                try {
                    IBinder surfaceFlinger = ServiceManager.getService("SurfaceFlinger");
                    if (surfaceFlinger != null) {
                        Parcel data = Parcel.obtain();
                        data.writeInterfaceToken("android.ui.ISurfaceComposer");
                        surfaceFlinger.transact(1, data, null, 0);
                        data.recycle();
                    }
                }
                catch (RemoteException ex) {
                    Slog.e(TAG, "Boot completed: SurfaceFlinger is dead!");
                }
                this.mBootAnimationStopped = true;
            }
            if (!this.mForceDisplayEnabled && !this.checkBootAnimationCompleteLocked()) {
                return;
            }
            EventLog.writeEvent(31007, SystemClock.uptimeMillis());
            Trace.asyncTraceEnd(32L, "Stop bootanim", 0);
            this.mDisplayEnabled = true;
            this.mInputMonitor.setEventDispatchingLw(this.mEventDispatchingEnabled);
        }
        try {
            this.mActivityManager.bootAnimationComplete();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mPolicy.enableScreenAfterBoot();
        this.updateRotationUnchecked(false, false);
    }

    private boolean checkBootAnimationCompleteLocked() {
        if (SystemService.isRunning(BOOT_ANIMATION_SERVICE)) {
            this.mH.removeMessages(37);
            this.mH.sendEmptyMessageDelayed(37, 200L);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showBootMessage(CharSequence msg, boolean always) {
        boolean first = false;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mAllowBootMessages) {
                return;
            }
            if (!this.mShowingBootMessages) {
                if (!always) {
                    return;
                }
                first = true;
            }
            if (this.mSystemBooted) {
                return;
            }
            this.mShowingBootMessages = true;
            this.mPolicy.showBootMessage(msg, always);
        }
        if (first) {
            this.performEnableScreen();
        }
    }

    public void hideBootMessagesLocked() {
        if (this.mShowingBootMessages) {
            this.mShowingBootMessages = false;
            this.mPolicy.hideBootMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInTouchMode(boolean mode) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mInTouchMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCircularDisplayMaskIfNeeded() {
        if (this.mContext.getResources().getConfiguration().isScreenRound() && this.mContext.getResources().getBoolean(17957049)) {
            int currentUserId;
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                currentUserId = this.mCurrentUserId;
            }
            int inversionState = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_inversion_enabled", 0, currentUserId);
            int showMask = inversionState == 1 ? 0 : 1;
            Message m = this.mH.obtainMessage(35);
            m.arg1 = showMask;
            this.mH.sendMessage(m);
        }
    }

    public void showEmulatorDisplayOverlayIfNeeded() {
        if (this.mContext.getResources().getBoolean(17957045) && SystemProperties.getBoolean(PROPERTY_EMULATOR_CIRCULAR, false) && Build.IS_EMULATOR) {
            this.mH.sendMessage(this.mH.obtainMessage(36));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCircularMask(boolean visible) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.openSurfaceTransaction();
            try {
                if (visible) {
                    if (this.mCircularDisplayMask == null) {
                        int screenOffset = this.mContext.getResources().getInteger(17694895);
                        int maskThickness = this.mContext.getResources().getDimensionPixelSize(17104946);
                        this.mCircularDisplayMask = new CircularDisplayMask(this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession, this.mPolicy.getWindowLayerFromTypeLw(2018) * 10000 + 10, screenOffset, maskThickness);
                    }
                    this.mCircularDisplayMask.setVisibility(true);
                } else if (this.mCircularDisplayMask != null) {
                    this.mCircularDisplayMask.setVisibility(false);
                    this.mCircularDisplayMask = null;
                }
            }
            finally {
                this.closeSurfaceTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEmulatorDisplayOverlay() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.openSurfaceTransaction();
            try {
                if (this.mEmulatorDisplayOverlay == null) {
                    this.mEmulatorDisplayOverlay = new EmulatorDisplayOverlay(this.mContext, this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession, this.mPolicy.getWindowLayerFromTypeLw(2018) * 10000 + 10);
                }
                this.mEmulatorDisplayOverlay.setVisibility(true);
            }
            finally {
                this.closeSurfaceTransaction();
            }
        }
    }

    @Override
    public void showStrictModeViolation(boolean on) {
        int pid = Binder.getCallingPid();
        this.mH.sendMessage(this.mH.obtainMessage(25, on ? 1 : 0, pid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStrictModeViolation(int arg, int pid) {
        boolean on = arg != 0;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (on && !this.mRoot.canShowStrictModeViolation(pid)) {
                return;
            }
            SurfaceControl.openTransaction();
            try {
                if (this.mStrictModeFlash == null) {
                    this.mStrictModeFlash = new StrictModeFlash(this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession);
                }
                this.mStrictModeFlash.setVisibility(on);
            }
            finally {
                SurfaceControl.closeTransaction();
            }
        }
    }

    @Override
    public void setStrictModeVisualIndicatorPreference(String value) {
        SystemProperties.set("persist.sys.strictmode.visual", value);
    }

    @Override
    public Bitmap screenshotWallpaper() {
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "screenshotWallpaper()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        try {
            Trace.traceBegin(32L, "screenshotWallpaper");
            Bitmap bitmap = this.screenshotApplications(null, 0, -1, -1, true, 1.0f, Bitmap.Config.ARGB_8888, true, false);
            return bitmap;
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    @Override
    public boolean requestAssistScreenshot(IAssistScreenshotReceiver receiver) {
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "requestAssistScreenshot()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        FgThread.getHandler().post(WindowManagerService$$Lambda$32.get$Lambda(this, receiver));
        return true;
    }

    public ActivityManager.TaskSnapshot getTaskSnapshot(int taskId, int userId) {
        return this.mTaskSnapshotController.getSnapshot(taskId, userId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObsoleteTaskFiles(ArraySet<Integer> persistentTaskIds, int[] runningUserIds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mTaskSnapshotController.removeObsoleteTaskFiles(persistentTaskIds, runningUserIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap screenshotApplications(IBinder appToken, int displayId, int width, int height, boolean includeFullDisplay, float frameScale, Bitmap.Config config, boolean wallpaperOnly, boolean includeDecor) {
        DisplayContent displayContent;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
            if (displayContent == null) {
                return null;
            }
        }
        return displayContent.screenshotApplications(appToken, width, height, includeFullDisplay, frameScale, config, wallpaperOnly, includeDecor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeRotation(int rotation) {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "freezeRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        if (rotation < -1 || rotation > 3) {
            throw new IllegalArgumentException("Rotation argument must be -1 or a valid rotation constant.");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(1, rotation == -1 ? this.mRotation : rotation);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    @Override
    public void thawRotation() {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "thawRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(0, 777);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    @Override
    public void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) {
        this.updateRotationUnchecked(alwaysSendConfiguration, forceRelayout);
    }

    void pauseRotationLocked() {
        ++this.mDeferredRotationPauseCount;
    }

    void resumeRotationLocked() {
        if (this.mDeferredRotationPauseCount > 0) {
            --this.mDeferredRotationPauseCount;
            if (this.mDeferredRotationPauseCount == 0) {
                boolean displayId = false;
                boolean changed = this.updateRotationUncheckedLocked(false, 0);
                if (changed) {
                    this.mH.obtainMessage(18, 0).sendToTarget();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRotationUnchecked(boolean alwaysSendConfiguration, boolean forceRelayout) {
        long origId = Binder.clearCallingIdentity();
        try {
            boolean rotationChanged;
            int displayId = 0;
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                rotationChanged = this.updateRotationUncheckedLocked(false, displayId);
                if (!rotationChanged || forceRelayout) {
                    this.getDefaultDisplayContentLocked().setLayoutNeeded();
                    this.mWindowPlacerLocked.performSurfacePlacement();
                }
            }
            if (rotationChanged || alwaysSendConfiguration) {
                this.sendNewConfiguration(displayId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateRotationUncheckedLocked(boolean inTransaction, int displayId) {
        boolean altOrientation;
        boolean rotateSeamlessly;
        if (this.mDeferredRotationPauseCount > 0) {
            return false;
        }
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
            return false;
        }
        if (this.mDisplayFrozen) {
            return false;
        }
        if (!this.mDisplayEnabled) {
            return false;
        }
        DisplayContent dc = this.mRoot.getDisplayContent(displayId);
        int oldRotation = this.mRotation;
        int rotation = this.mPolicy.rotationForOrientationLw(this.mLastOrientation, this.mRotation);
        if (this.mPolicy.shouldRotateSeamlessly(oldRotation, rotation)) {
            WindowState seamlessRotated = dc.getWindow(WindowManagerService$$Lambda$33.get$Lambda());
            if (seamlessRotated != null) {
                return false;
            }
            WindowState cantSeamlesslyRotate = dc.getWindow(WindowManagerService$$Lambda$34.get$Lambda());
            rotateSeamlessly = cantSeamlesslyRotate == null;
        } else {
            rotateSeamlessly = false;
        }
        boolean bl = altOrientation = !this.mPolicy.rotationHasCompatibleMetricsLw(this.mLastOrientation, rotation);
        if (this.mRotation == rotation && this.mAltOrientation == altOrientation) {
            return false;
        }
        if (DisplayContent.deltaRotation(rotation, this.mRotation) != 2) {
            this.mWaitingForConfig = true;
        }
        this.mRotation = rotation;
        this.mAltOrientation = altOrientation;
        this.mPolicy.setRotationLw(this.mRotation);
        this.mWindowsFreezingScreen = 1;
        this.mH.removeMessages(11);
        this.mH.sendEmptyMessageDelayed(11, 2000L);
        dc.setLayoutNeeded();
        int[] anim2 = new int[2];
        if (dc.isDimming()) {
            anim2[1] = 0;
            anim2[0] = 0;
        } else {
            this.mPolicy.selectRotationAnimationLw(anim2);
        }
        if (!rotateSeamlessly) {
            this.startFreezingDisplayLocked(inTransaction, anim2[0], anim2[1]);
            screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        } else {
            screenRotationAnimation = null;
            this.mSeamlessRotationCount = 0;
        }
        this.updateDisplayAndOrientationLocked(dc.getConfiguration().uiMode, displayId);
        DisplayInfo displayInfo = dc.getDisplayInfo();
        if (!inTransaction) {
            this.openSurfaceTransaction();
        }
        try {
            if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot() && screenRotationAnimation.setRotationInTransaction(rotation, this.mFxSession, 10000L, this.getTransitionAnimationScaleLocked(), displayInfo.logicalWidth, displayInfo.logicalHeight)) {
                this.scheduleAnimationLocked();
            }
            if (rotateSeamlessly) {
                dc.forAllWindows(WindowManagerService$$Lambda$35.get$Lambda(this, oldRotation), true);
            }
            this.mDisplayManagerInternal.performTraversalInTransactionFromWindowManager();
        }
        finally {
            if (!inTransaction) {
                this.closeSurfaceTransaction();
            }
        }
        dc.forAllWindows(WindowManagerService$$Lambda$36.get$Lambda(this, rotateSeamlessly), true);
        if (rotateSeamlessly) {
            this.mH.removeMessages(54);
            this.mH.sendEmptyMessageDelayed(54, 2000L);
        }
        for (int i = this.mRotationWatchers.size() - 1; i >= 0; --i) {
            try {
                this.mRotationWatchers.get((int)i).watcher.onRotationChanged(rotation);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (screenRotationAnimation == null && this.mAccessibilityController != null && dc.getDisplayId() == 0) {
            this.mAccessibilityController.onRotationChangedLocked(this.getDefaultDisplayContentLocked(), rotation);
        }
        return true;
    }

    @Override
    public int getRotation() {
        return this.mRotation;
    }

    @Override
    public boolean isRotationFrozen() {
        return this.mPolicy.getUserRotationMode() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int watchRotation(IRotationWatcher watcher) {
        final IBinder watcherBinder = watcher.asBinder();
        IBinder.DeathRecipient dr = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                synchronized (hashMap) {
                    for (int i = 0; i < WindowManagerService.this.mRotationWatchers.size(); ++i) {
                        if (watcherBinder != WindowManagerService.this.mRotationWatchers.get((int)i).watcher.asBinder()) continue;
                        RotationWatcher removed = WindowManagerService.this.mRotationWatchers.remove(i);
                        IBinder binder = removed.watcher.asBinder();
                        if (binder != null) {
                            binder.unlinkToDeath(this, 0);
                        }
                        --i;
                    }
                }
            }
        };
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            try {
                watcher.asBinder().linkToDeath(dr, 0);
                this.mRotationWatchers.add(new RotationWatcher(watcher, dr));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return this.mRotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRotationWatcher(IRotationWatcher watcher) {
        IBinder watcherBinder = watcher.asBinder();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            for (int i = 0; i < this.mRotationWatchers.size(); ++i) {
                RotationWatcher rotationWatcher = this.mRotationWatchers.get(i);
                if (watcherBinder != rotationWatcher.watcher.asBinder()) continue;
                RotationWatcher removed = this.mRotationWatchers.remove(i);
                IBinder binder = removed.watcher.asBinder();
                if (binder != null) {
                    binder.unlinkToDeath(removed.deathRecipient, 0);
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredOptionsPanelGravity() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int rotation = this.getRotation();
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            if (displayContent.mInitialDisplayWidth < displayContent.mInitialDisplayHeight) {
                switch (rotation) {
                    default: {
                        return 81;
                    }
                    case 1: {
                        return 85;
                    }
                    case 2: {
                        return 81;
                    }
                    case 3: 
                }
                return 8388691;
            }
            switch (rotation) {
                default: {
                    return 85;
                }
                case 1: {
                    return 81;
                }
                case 2: {
                    return 8388691;
                }
                case 3: 
            }
            return 81;
        }
    }

    @Override
    public boolean startViewServer(int port) {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "startViewServer")) {
            return false;
        }
        if (port < 1024) {
            return false;
        }
        if (this.mViewServer != null) {
            if (!this.mViewServer.isRunning()) {
                try {
                    return this.mViewServer.start();
                }
                catch (IOException e) {
                    Slog.w(TAG, "View server did not start");
                }
            }
            return false;
        }
        try {
            this.mViewServer = new ViewServer(this, port);
            return this.mViewServer.start();
        }
        catch (IOException e) {
            Slog.w(TAG, "View server did not start");
            return false;
        }
    }

    private boolean isSystemSecure() {
        return "1".equals(SystemProperties.get(SYSTEM_SECURE, "1")) && "0".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
    }

    @Override
    public boolean stopViewServer() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "stopViewServer")) {
            return false;
        }
        if (this.mViewServer != null) {
            return this.mViewServer.stop();
        }
        return false;
    }

    @Override
    public boolean isViewServerRunning() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "isViewServerRunning")) {
            return false;
        }
        return this.mViewServer != null && this.mViewServer.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerListWindows(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        ArrayList windows = new ArrayList();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mRoot.forAllWindows(WindowManagerService$$Lambda$37.get$Lambda(windows), false);
        }
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            int count = windows.size();
            for (int i = 0; i < count; ++i) {
                WindowState w = (WindowState)windows.get(i);
                out.write(Integer.toHexString(System.identityHashCode(w)));
                out.write(32);
                out.append(w.mAttrs.getTitle());
                out.write(10);
            }
            out.write("DONE.\n");
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerGetFocusedWindow(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        WindowState focusedWindow = this.getFocusedWindow();
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            if (focusedWindow != null) {
                out.write(Integer.toHexString(System.identityHashCode(focusedWindow)));
                out.write(32);
                out.append(focusedWindow.mAttrs.getTitle());
            }
            out.write(10);
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerWindowCommand(Socket client, String command, String parameters) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean success = true;
        Parcel data = null;
        Parcel reply = null;
        BufferedWriter out = null;
        try {
            int index = parameters.indexOf(32);
            if (index == -1) {
                index = parameters.length();
            }
            String code = parameters.substring(0, index);
            int hashCode = (int)Long.parseLong(code, 16);
            parameters = index < parameters.length() ? parameters.substring(index + 1) : "";
            WindowState window = this.findWindow(hashCode);
            if (window == null) {
                boolean bl = false;
                return bl;
            }
            data = Parcel.obtain();
            data.writeInterfaceToken("android.view.IWindow");
            data.writeString(command);
            data.writeString(parameters);
            data.writeInt(1);
            ParcelFileDescriptor.fromSocket(client).writeToParcel(data, 0);
            reply = Parcel.obtain();
            IBinder binder = window.mClient.asBinder();
            binder.transact(1, data, reply, 0);
            reply.readException();
            if (!client.isOutputShutdown()) {
                out = new BufferedWriter(new OutputStreamWriter(client.getOutputStream()));
                out.write("DONE\n");
                out.flush();
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Could not send command " + command + " with parameters " + parameters, e);
            success = false;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWindowsChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].windowsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFocusChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].focusChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState findWindow(int hashCode) {
        if (hashCode == -1) {
            return this.getFocusedWindow();
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mRoot.getWindow(WindowManagerService$$Lambda$38.get$Lambda(hashCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNewConfiguration(int displayId) {
        block6: {
            try {
                boolean configUpdated = this.mActivityManager.updateDisplayOverrideConfiguration(null, displayId);
                if (configUpdated) break block6;
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    if (this.mWaitingForConfig) {
                        this.mWaitingForConfig = false;
                        this.mLastFinishedFreezeSource = "config-unchanged";
                        this.mRoot.getDisplayContent(displayId).setLayoutNeeded();
                        this.mWindowPlacerLocked.performSurfacePlacement();
                    }
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration computeNewConfiguration(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.computeNewConfigurationLocked(displayId);
        }
    }

    private Configuration computeNewConfigurationLocked(int displayId) {
        if (!this.mDisplayReady) {
            return null;
        }
        Configuration config = new Configuration();
        this.computeScreenConfigurationLocked(config, displayId);
        return config;
    }

    private void adjustDisplaySizeRanges(DisplayInfo displayInfo, int displayId, int rotation, int uiMode, int dw, int dh) {
        int height;
        int width = this.mPolicy.getConfigDisplayWidth(dw, dh, rotation, uiMode, displayId);
        if (width < displayInfo.smallestNominalAppWidth) {
            displayInfo.smallestNominalAppWidth = width;
        }
        if (width > displayInfo.largestNominalAppWidth) {
            displayInfo.largestNominalAppWidth = width;
        }
        if ((height = this.mPolicy.getConfigDisplayHeight(dw, dh, rotation, uiMode, displayId)) < displayInfo.smallestNominalAppHeight) {
            displayInfo.smallestNominalAppHeight = height;
        }
        if (height > displayInfo.largestNominalAppHeight) {
            displayInfo.largestNominalAppHeight = height;
        }
    }

    private int reduceConfigLayout(int curLayout, int rotation, float density, int dw, int dh, int uiMode, int displayId) {
        int h;
        int shortSize;
        int w = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation, uiMode, displayId);
        int longSize = w;
        if (longSize < (shortSize = (h = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation, uiMode, displayId)))) {
            int tmp = longSize;
            longSize = shortSize;
            shortSize = tmp;
        }
        longSize = (int)((float)longSize / density);
        shortSize = (int)((float)shortSize / density);
        return Configuration.reduceScreenLayout(curLayout, longSize, shortSize);
    }

    private void computeSizeRangesAndScreenLayout(DisplayInfo displayInfo, int displayId, boolean rotated, int uiMode, int dw, int dh, float density, Configuration outConfig) {
        int unrotDh;
        int unrotDw;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        displayInfo.smallestNominalAppWidth = 0x40000000;
        displayInfo.smallestNominalAppHeight = 0x40000000;
        displayInfo.largestNominalAppWidth = 0;
        displayInfo.largestNominalAppHeight = 0;
        this.adjustDisplaySizeRanges(displayInfo, displayId, 0, uiMode, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, displayId, 1, uiMode, unrotDh, unrotDw);
        this.adjustDisplaySizeRanges(displayInfo, displayId, 2, uiMode, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, displayId, 3, uiMode, unrotDh, unrotDw);
        int sl = Configuration.resetScreenLayout(outConfig.screenLayout);
        sl = this.reduceConfigLayout(sl, 0, density, unrotDw, unrotDh, uiMode, displayId);
        sl = this.reduceConfigLayout(sl, 1, density, unrotDh, unrotDw, uiMode, displayId);
        sl = this.reduceConfigLayout(sl, 2, density, unrotDw, unrotDh, uiMode, displayId);
        sl = this.reduceConfigLayout(sl, 3, density, unrotDh, unrotDw, uiMode, displayId);
        outConfig.smallestScreenWidthDp = (int)((float)displayInfo.smallestNominalAppWidth / density);
        outConfig.screenLayout = sl;
    }

    private int reduceCompatConfigWidthSize(int curSize, int rotation, int uiMode, DisplayMetrics dm, int dw, int dh, int displayId) {
        dm.noncompatWidthPixels = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation, uiMode, displayId);
        dm.noncompatHeightPixels = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation, uiMode, displayId);
        float scale = CompatibilityInfo.computeCompatibleScaling(dm, null);
        int size = (int)((float)dm.noncompatWidthPixels / scale / dm.density + 0.5f);
        if (curSize == 0 || size < curSize) {
            curSize = size;
        }
        return curSize;
    }

    private int computeCompatSmallestWidth(boolean rotated, int uiMode, DisplayMetrics dm, int dw, int dh, int displayId) {
        int unrotDh;
        int unrotDw;
        this.mTmpDisplayMetrics.setTo(dm);
        DisplayMetrics tmpDm = this.mTmpDisplayMetrics;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        int sw = this.reduceCompatConfigWidthSize(0, 0, uiMode, tmpDm, unrotDw, unrotDh, displayId);
        sw = this.reduceCompatConfigWidthSize(sw, 1, uiMode, tmpDm, unrotDh, unrotDw, displayId);
        sw = this.reduceCompatConfigWidthSize(sw, 2, uiMode, tmpDm, unrotDw, unrotDh, displayId);
        sw = this.reduceCompatConfigWidthSize(sw, 3, uiMode, tmpDm, unrotDh, unrotDw, displayId);
        return sw;
    }

    private DisplayInfo updateDisplayAndOrientationLocked(int uiMode, int displayId) {
        DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        int realdw = rotated ? displayContent.mBaseDisplayHeight : displayContent.mBaseDisplayWidth;
        int realdh = rotated ? displayContent.mBaseDisplayWidth : displayContent.mBaseDisplayHeight;
        int dw = realdw;
        int dh = realdh;
        if (this.mAltOrientation) {
            if (realdw > realdh) {
                int maxw = (int)((float)realdh / 1.3f);
                if (maxw < realdw) {
                    dw = maxw;
                }
            } else {
                int maxh = (int)((float)realdw / 1.3f);
                if (maxh < realdh) {
                    dh = maxh;
                }
            }
        }
        int appWidth = this.mPolicy.getNonDecorDisplayWidth(dw, dh, this.mRotation, uiMode, displayId);
        int appHeight = this.mPolicy.getNonDecorDisplayHeight(dw, dh, this.mRotation, uiMode, displayId);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        displayInfo.rotation = this.mRotation;
        displayInfo.logicalWidth = dw;
        displayInfo.logicalHeight = dh;
        displayInfo.logicalDensityDpi = displayContent.mBaseDisplayDensity;
        displayInfo.appWidth = appWidth;
        displayInfo.appHeight = appHeight;
        displayInfo.getLogicalMetrics(this.mRealDisplayMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
        displayInfo.getAppMetrics(this.mDisplayMetrics);
        displayInfo.flags = displayContent.mDisplayScalingDisabled ? (displayInfo.flags |= 0x40000000) : (displayInfo.flags &= 0xBFFFFFFF);
        this.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(displayContent.getDisplayId(), displayInfo);
        displayContent.mBaseDisplayRect.set(0, 0, dw, dh);
        this.mCompatibleScreenScale = CompatibilityInfo.computeCompatibleScaling(this.mDisplayMetrics, this.mCompatDisplayMetrics);
        return displayInfo;
    }

    private void computeScreenConfigurationLocked(Configuration config, int displayId) {
        boolean hardKeyboardAvailable;
        DisplayInfo displayInfo = this.updateDisplayAndOrientationLocked(config.uiMode, displayId);
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        config.orientation = dw <= dh ? 1 : 2;
        config.screenWidthDp = (int)((float)this.mPolicy.getConfigDisplayWidth(dw, dh, this.mRotation, config.uiMode, displayId) / this.mDisplayMetrics.density);
        config.screenHeightDp = (int)((float)this.mPolicy.getConfigDisplayHeight(dw, dh, this.mRotation, config.uiMode, displayId) / this.mDisplayMetrics.density);
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        this.computeSizeRangesAndScreenLayout(displayInfo, displayId, rotated, config.uiMode, dw, dh, this.mDisplayMetrics.density, config);
        config.screenLayout = config.screenLayout & 0xFFFFFCFF | ((displayInfo.flags & 0x10) != 0 ? 512 : 256);
        config.compatScreenWidthDp = (int)((float)config.screenWidthDp / this.mCompatibleScreenScale);
        config.compatScreenHeightDp = (int)((float)config.screenHeightDp / this.mCompatibleScreenScale);
        config.compatSmallestScreenWidthDp = this.computeCompatSmallestWidth(rotated, config.uiMode, this.mDisplayMetrics, dw, dh, displayId);
        config.densityDpi = displayInfo.logicalDensityDpi;
        config.colorMode = (displayInfo.isHdr() ? 8 : 4) | (displayInfo.isWideColorGamut() ? 2 : 1);
        config.touchscreen = 1;
        config.keyboard = 1;
        config.navigation = 1;
        int keyboardPresence = 0;
        int navigationPresence = 0;
        InputDevice[] devices = this.mInputManager.getInputDevices();
        int len = devices != null ? devices.length : 0;
        for (int i = 0; i < len; ++i) {
            int presenceFlag;
            InputDevice device = devices[i];
            if (device.isVirtual()) continue;
            int sources = device.getSources();
            int n = presenceFlag = device.isExternal() ? 2 : 1;
            if (this.mIsTouchDevice) {
                if ((sources & 0x1002) == 4098) {
                    config.touchscreen = 3;
                }
            } else {
                config.touchscreen = 1;
            }
            if ((sources & 0x10004) == 65540) {
                config.navigation = 3;
                navigationPresence |= presenceFlag;
            } else if ((sources & 0x201) == 513 && config.navigation == 1) {
                config.navigation = 2;
                navigationPresence |= presenceFlag;
            }
            if (device.getKeyboardType() != 2) continue;
            config.keyboard = 2;
            keyboardPresence |= presenceFlag;
        }
        if (config.navigation == 1 && this.mHasPermanentDpad) {
            config.navigation = 2;
            navigationPresence |= 1;
        }
        boolean bl = hardKeyboardAvailable = config.keyboard != 1;
        if (hardKeyboardAvailable != this.mHardKeyboardAvailable) {
            this.mHardKeyboardAvailable = hardKeyboardAvailable;
            this.mH.removeMessages(22);
            this.mH.sendEmptyMessage(22);
        }
        config.keyboardHidden = 1;
        config.hardKeyboardHidden = 1;
        config.navigationHidden = 1;
        this.mPolicy.adjustConfigurationLw(config, keyboardPresence, navigationPresence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyHardKeyboardStatusChange() {
        boolean available;
        WindowManagerInternal.OnHardKeyboardStatusChangeListener listener;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            listener = this.mHardKeyboardStatusChangeListener;
            available = this.mHardKeyboardAvailable;
        }
        if (listener != null) {
            listener.onHardKeyboardStatusChange(available);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startMovingTask(IWindow window, float startX, float startY) {
        WindowState win = null;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            win = this.windowForClientLocked(null, window, false);
            if (!this.startPositioningLocked(win, false, false, startX, startY)) {
                return false;
            }
        }
        try {
            this.mActivityManager.setFocusedTask(win.getTask().mTaskId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTapOutsideTask(DisplayContent displayContent, int x, int y) {
        int taskId = -1;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = displayContent.findTaskForResizePoint(x, y);
            if (task != null) {
                if (!this.startPositioningLocked(task.getTopVisibleAppMainWindow(), true, task.preserveOrientationOnResize(), x, y)) {
                    return;
                }
                taskId = task.mTaskId;
            } else {
                taskId = displayContent.taskIdFromPoint(x, y);
            }
        }
        if (taskId >= 0) {
            try {
                this.mActivityManager.setFocusedTask(taskId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private boolean startPositioningLocked(WindowState win, boolean resize, boolean preserveOrientation, float startX, float startY) {
        if (win == null || win.getAppToken() == null) {
            Slog.w(TAG, "startPositioningLocked: Bad window " + win);
            return false;
        }
        if (win.mInputChannel == null) {
            Slog.wtf(TAG, "startPositioningLocked: " + win + " has no input channel, " + " probably being removed");
            return false;
        }
        DisplayContent displayContent = win.getDisplayContent();
        if (displayContent == null) {
            Slog.w(TAG, "startPositioningLocked: Invalid display content " + win);
            return false;
        }
        Display display = displayContent.getDisplay();
        this.mTaskPositioner = new TaskPositioner(this);
        this.mTaskPositioner.register(display);
        this.mInputMonitor.updateInputWindowsLw(true);
        WindowState transferFocusFromWin = win;
        if (this.mCurrentFocus != null && this.mCurrentFocus != win && this.mCurrentFocus.mAppToken == win.mAppToken) {
            transferFocusFromWin = this.mCurrentFocus;
        }
        if (!this.mInputManager.transferTouchFocus(transferFocusFromWin.mInputChannel, this.mTaskPositioner.mServerChannel)) {
            Slog.e(TAG, "startPositioningLocked: Unable to transfer touch focus");
            this.mTaskPositioner.unregister();
            this.mTaskPositioner = null;
            this.mInputMonitor.updateInputWindowsLw(true);
            return false;
        }
        this.mTaskPositioner.startDrag(win, resize, preserveOrientation, startX, startY);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishPositioning() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mTaskPositioner != null) {
                this.mTaskPositioner.unregister();
                this.mTaskPositioner = null;
                this.mInputMonitor.updateInputWindowsLw(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBinder prepareDragSurface(IWindow window, SurfaceSession session, int flags, int width, int height, Surface outSurface) {
        int callerPid = Binder.getCallingPid();
        int callerUid = Binder.getCallingUid();
        long origId = Binder.clearCallingIdentity();
        Binder token = null;
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                block11: {
                    try {
                        if (this.mDragState == null) {
                            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                            Display display = displayContent.getDisplay();
                            SurfaceControl surface = new SurfaceControl(session, "drag surface", width, height, -3, 4);
                            surface.setLayerStack(display.getLayerStack());
                            float alpha = 1.0f;
                            if ((flags & 0x200) == 0) {
                                alpha = 0.7071f;
                            }
                            surface.setAlpha(alpha);
                            outSurface.copyFrom(surface);
                            IBinder winBinder = window.asBinder();
                            token = new Binder();
                            this.mDragState = new DragState(this, token, surface, flags, winBinder);
                            this.mDragState.mPid = callerPid;
                            this.mDragState.mUid = callerUid;
                            this.mDragState.mOriginalAlpha = alpha;
                            this.mDragState.mToken = new Binder();
                            token = this.mDragState.mToken;
                            this.mH.removeMessages(20, winBinder);
                            Message msg = this.mH.obtainMessage(20, winBinder);
                            this.mH.sendMessageDelayed(msg, 5000L);
                        } else {
                            Slog.w(TAG, "Drag already in progress");
                        }
                    }
                    catch (Surface.OutOfResourcesException e) {
                        Slog.e(TAG, "Can't allocate drag surface w=" + width + " h=" + height, e);
                        if (this.mDragState == null) break block11;
                        this.mDragState.reset();
                        this.mDragState = null;
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventDispatching(boolean enabled) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setEventDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mEventDispatchingEnabled = enabled;
            if (this.mDisplayEnabled) {
                this.mInputMonitor.setEventDispatchingLw(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState getFocusedWindow() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.getFocusedWindowLocked();
        }
    }

    private WindowState getFocusedWindowLocked() {
        return this.mCurrentFocus;
    }

    TaskStack getImeFocusStackLocked() {
        return this.mFocusedApp != null && this.mFocusedApp.mTask != null ? this.mFocusedApp.mTask.mStack : null;
    }

    public boolean detectSafeMode() {
        if (!this.mInputMonitor.waitForInputDevicesReady(1000L)) {
            Slog.w(TAG, "Devices still not ready after waiting 1000 milliseconds before attempting to detect safe mode.");
        }
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "safe_boot_disallowed", 0) != 0) {
            return false;
        }
        int menuState = this.mInputManager.getKeyCodeState(-1, -256, 82);
        int sState = this.mInputManager.getKeyCodeState(-1, -256, 47);
        int dpadState = this.mInputManager.getKeyCodeState(-1, 513, 23);
        int trackballState = this.mInputManager.getScanCodeState(-1, 65540, 272);
        int volumeDownState = this.mInputManager.getKeyCodeState(-1, -256, 25);
        this.mSafeMode = menuState > 0 || sState > 0 || dpadState > 0 || trackballState > 0 || volumeDownState > 0;
        try {
            if (SystemProperties.getInt("persist.sys.safemode", 0) != 0 || SystemProperties.getInt("ro.sys.safemode", 0) != 0) {
                this.mSafeMode = true;
                SystemProperties.set("persist.sys.safemode", "");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.mSafeMode) {
            Log.i(TAG, "SAFE MODE ENABLED (menu=" + menuState + " s=" + sState + " dpad=" + dpadState + " trackball=" + trackballState + ")");
            SystemProperties.set("ro.sys.safemode", "1");
        } else {
            Log.i(TAG, "SAFE MODE not enabled");
        }
        this.mPolicy.setSafeMode(this.mSafeMode);
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayReady() {
        for (Display display : this.mDisplays) {
            this.displayReady(display.getDisplayId());
        }
        HashMap<IBinder, WindowState> remoteException = this.mWindowMap;
        synchronized (remoteException) {
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            this.readForcedDisplayPropertiesLocked(displayContent);
            this.mDisplayReady = true;
        }
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException2) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mIsTouchDevice = this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
            this.configureDisplayPolicyLocked(this.getDefaultDisplayContentLocked());
        }
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException2) {
            // empty catch block
        }
        this.updateCircularDisplayMaskIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayReady(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
            if (displayContent != null) {
                this.mAnimator.addDisplayLocked(displayId);
                displayContent.initializeDisplayBaseInfo();
            }
        }
    }

    public void systemReady() {
        this.mPolicy.systemReady();
        this.mTaskSnapshotController.systemReady();
    }

    void destroyPreservedSurfaceLocked() {
        for (int i = this.mDestroyPreservedSurface.size() - 1; i >= 0; --i) {
            WindowState w = this.mDestroyPreservedSurface.get(i);
            w.mWinAnimator.destroyPreservedSurfaceLocked();
        }
        this.mDestroyPreservedSurface.clear();
    }

    void stopUsingSavedSurfaceLocked() {
        for (int i = this.mFinishedEarlyAnim.size() - 1; i >= 0; --i) {
            AppWindowToken wtoken = this.mFinishedEarlyAnim.get(i);
            wtoken.stopUsingSavedSurfaceLocked();
        }
        this.mFinishedEarlyAnim.clear();
    }

    @Override
    public IWindowSession openSession(IWindowSessionCallback callback, IInputMethodClient client, IInputContext inputContext) {
        if (client == null) {
            throw new IllegalArgumentException("null client");
        }
        if (inputContext == null) {
            throw new IllegalArgumentException("null inputContext");
        }
        Session session = new Session(this, callback, client, inputContext);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inputMethodClientHasFocus(IInputMethodClient client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.getDefaultDisplayContentLocked().inputMethodClientHasFocus(client)) {
                return true;
            }
            if (this.mCurrentFocus != null && this.mCurrentFocus.mSession.mClient != null && this.mCurrentFocus.mSession.mClient.asBinder() == client.asBinder()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getInitialDisplaySize(int displayId, Point size) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                size.x = displayContent.mInitialDisplayWidth;
                size.y = displayContent.mInitialDisplayHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBaseDisplaySize(int displayId, Point size) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                size.x = displayContent.mBaseDisplayWidth;
                size.y = displayContent.mBaseDisplayHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplaySize(int displayId, int width, int height) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                int MIN_WIDTH = 200;
                int MIN_HEIGHT = 200;
                int MAX_SCALE = 2;
                DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
                if (displayContent != null) {
                    width = Math.min(Math.max(width, 200), displayContent.mInitialDisplayWidth * 2);
                    height = Math.min(Math.max(height, 200), displayContent.mInitialDisplayHeight * 2);
                    this.setForcedDisplaySizeLocked(displayContent, width, height);
                    Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", width + "," + height);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplayScalingMode(int displayId, int mode) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
                if (displayContent != null) {
                    if (mode < 0 || mode > 1) {
                        mode = 0;
                    }
                    this.setForcedDisplayScalingModeLocked(displayContent, mode);
                    Settings.Global.putInt(this.mContext.getContentResolver(), "display_scaling_force", mode);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void setForcedDisplayScalingModeLocked(DisplayContent displayContent, int mode) {
        Slog.i(TAG, "Using display scaling mode: " + (mode == 0 ? "auto" : "off"));
        displayContent.mDisplayScalingDisabled = mode != 0;
        this.reconfigureDisplayLocked(displayContent);
    }

    private void readForcedDisplayPropertiesLocked(DisplayContent displayContent) {
        int mode;
        int density;
        int pos;
        String sizeStr = Settings.Global.getString(this.mContext.getContentResolver(), "display_size_forced");
        if (sizeStr == null || sizeStr.length() == 0) {
            sizeStr = SystemProperties.get(SIZE_OVERRIDE, null);
        }
        if (sizeStr != null && sizeStr.length() > 0 && (pos = sizeStr.indexOf(44)) > 0 && sizeStr.lastIndexOf(44) == pos) {
            try {
                int width = Integer.parseInt(sizeStr.substring(0, pos));
                int height = Integer.parseInt(sizeStr.substring(pos + 1));
                if (displayContent.mBaseDisplayWidth != width || displayContent.mBaseDisplayHeight != height) {
                    Slog.i(TAG, "FORCED DISPLAY SIZE: " + width + "x" + height);
                    displayContent.mBaseDisplayWidth = width;
                    displayContent.mBaseDisplayHeight = height;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((density = this.getForcedDisplayDensityForUserLocked(this.mCurrentUserId)) != 0) {
            displayContent.mBaseDisplayDensity = density;
        }
        if ((mode = Settings.Global.getInt(this.mContext.getContentResolver(), "display_scaling_force", 0)) != 0) {
            Slog.i(TAG, "FORCED DISPLAY SCALING DISABLED");
            displayContent.mDisplayScalingDisabled = true;
        }
    }

    private void setForcedDisplaySizeLocked(DisplayContent displayContent, int width, int height) {
        Slog.i(TAG, "Using new display size: " + width + "x" + height);
        displayContent.mBaseDisplayWidth = width;
        displayContent.mBaseDisplayHeight = height;
        this.reconfigureDisplayLocked(displayContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearForcedDisplaySize(int displayId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
                if (displayContent != null) {
                    this.setForcedDisplaySizeLocked(displayContent, displayContent.mInitialDisplayWidth, displayContent.mInitialDisplayHeight);
                    Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", "");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInitialDisplayDensity(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                return displayContent.mInitialDisplayDensity;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBaseDisplayDensity(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                return displayContent.mBaseDisplayDensity;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplayDensityForUser(int displayId, int density, int userId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        int targetUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "setForcedDisplayDensityForUser", null);
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
                if (displayContent != null && this.mCurrentUserId == targetUserId) {
                    this.setForcedDisplayDensityLocked(displayContent, density);
                }
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "display_density_forced", Integer.toString(density), targetUserId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearForcedDisplayDensityForUser(int displayId, int userId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        int callingUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "clearForcedDisplayDensityForUser", null);
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
                if (displayContent != null && this.mCurrentUserId == callingUserId) {
                    this.setForcedDisplayDensityLocked(displayContent, displayContent.mInitialDisplayDensity);
                }
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "display_density_forced", "", callingUserId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private int getForcedDisplayDensityForUserLocked(int userId) {
        String densityStr = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "display_density_forced", userId);
        if (densityStr == null || densityStr.length() == 0) {
            densityStr = SystemProperties.get(DENSITY_OVERRIDE, null);
        }
        if (densityStr != null && densityStr.length() > 0) {
            try {
                return Integer.parseInt(densityStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void setForcedDisplayDensityLocked(DisplayContent displayContent, int density) {
        displayContent.mBaseDisplayDensity = density;
        this.reconfigureDisplayLocked(displayContent);
    }

    void reconfigureDisplayLocked(DisplayContent displayContent) {
        if (!this.mDisplayReady) {
            return;
        }
        this.configureDisplayPolicyLocked(displayContent);
        displayContent.setLayoutNeeded();
        int displayId = displayContent.getDisplayId();
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false, displayId);
        Configuration currentDisplayConfig = displayContent.getConfiguration();
        this.mTempConfiguration.setTo(currentDisplayConfig);
        this.computeScreenConfigurationLocked(this.mTempConfiguration, displayId);
        if (configChanged |= currentDisplayConfig.diff(this.mTempConfiguration) != 0) {
            this.mWaitingForConfig = true;
            this.startFreezingDisplayLocked(false, 0, 0);
            this.mH.obtainMessage(18, displayId).sendToTarget();
        }
        this.mWindowPlacerLocked.performSurfacePlacement();
    }

    void configureDisplayPolicyLocked(DisplayContent displayContent) {
        this.mPolicy.setInitialDisplaySize(displayContent.getDisplay(), displayContent.mBaseDisplayWidth, displayContent.mBaseDisplayHeight, displayContent.mBaseDisplayDensity);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        this.mPolicy.setDisplayOverscan(displayContent.getDisplay(), displayInfo.overscanLeft, displayInfo.overscanTop, displayInfo.overscanRight, displayInfo.overscanBottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDisplaysInFocusOrder(SparseIntArray displaysInFocusOrder) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mRoot.getDisplaysInFocusOrder(displaysInFocusOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOverscan(int displayId, int left, int top, int right, int bottom) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
                if (displayContent != null) {
                    this.setOverscanLocked(displayContent, left, top, right, bottom);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void setOverscanLocked(DisplayContent displayContent, int left, int top, int right, int bottom) {
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        displayInfo.overscanLeft = left;
        displayInfo.overscanTop = top;
        displayInfo.overscanRight = right;
        displayInfo.overscanBottom = bottom;
        this.mDisplaySettings.setOverscanLocked(displayInfo.uniqueId, displayInfo.name, left, top, right, bottom);
        this.mDisplaySettings.writeSettingsLocked();
        this.reconfigureDisplayLocked(displayContent);
    }

    final WindowState windowForClientLocked(Session session, IWindow client, boolean throwOnError) {
        return this.windowForClientLocked(session, client.asBinder(), throwOnError);
    }

    final WindowState windowForClientLocked(Session session, IBinder client, boolean throwOnError) {
        WindowState win = this.mWindowMap.get(client);
        if (win == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " does not exist");
            if (throwOnError) {
                throw ex;
            }
            Slog.w(TAG, "Failed looking up window", ex);
            return null;
        }
        if (session != null && win.mSession != session) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " is in session " + win.mSession + ", not " + session);
            if (throwOnError) {
                throw ex;
            }
            Slog.w(TAG, "Failed looking up window", ex);
            return null;
        }
        return win;
    }

    void makeWindowFreezingScreenIfNeededLocked(WindowState w) {
        if (!this.okToDisplay() && this.mWindowsFreezingScreen != 2) {
            w.mOrientationChanging = true;
            w.mLastFreezeDuration = 0;
            this.mRoot.mOrientationChangeComplete = false;
            if (this.mWindowsFreezingScreen == 0) {
                this.mWindowsFreezingScreen = 1;
                this.mH.removeMessages(11);
                this.mH.sendEmptyMessageDelayed(11, 2000L);
            }
        }
    }

    int handleAnimatingStoppedAndTransitionLocked() {
        int changes = 0;
        this.mAppTransition.setIdle();
        for (int i = this.mNoAnimationNotifyOnTransitionFinished.size() - 1; i >= 0; --i) {
            IBinder token = this.mNoAnimationNotifyOnTransitionFinished.get(i);
            this.mAppTransition.notifyAppTransitionFinishedLocked(token);
        }
        this.mNoAnimationNotifyOnTransitionFinished.clear();
        DisplayContent dc = this.getDefaultDisplayContentLocked();
        dc.mWallpaperController.hideDeferredWallpapersIfNeeded();
        dc.onAppTransitionDone();
        dc.computeImeTarget(true);
        this.mRoot.mWallpaperMayChange = true;
        this.mFocusMayChange = true;
        return changes |= 1;
    }

    void checkDrawnWindowsLocked() {
        if (this.mWaitingForDrawn.isEmpty() || this.mWaitingForDrawnCallback == null) {
            return;
        }
        for (int j = this.mWaitingForDrawn.size() - 1; j >= 0; --j) {
            WindowState win = this.mWaitingForDrawn.get(j);
            if (win.mRemoved || !win.mHasSurface || !win.mPolicyVisibility) {
                this.mWaitingForDrawn.remove(win);
                continue;
            }
            if (!win.hasDrawnLw()) continue;
            this.mWaitingForDrawn.remove(win);
        }
        if (this.mWaitingForDrawn.isEmpty()) {
            this.mH.removeMessages(24);
            this.mH.sendEmptyMessage(33);
        }
    }

    void setHoldScreenLocked(Session newHoldScreen) {
        boolean hold;
        boolean bl = hold = newHoldScreen != null;
        if (hold && this.mHoldingScreenOn != newHoldScreen) {
            this.mHoldingScreenWakeLock.setWorkSource(new WorkSource(newHoldScreen.mUid));
        }
        this.mHoldingScreenOn = newHoldScreen;
        boolean state = this.mHoldingScreenWakeLock.isHeld();
        if (hold != state) {
            if (hold) {
                this.mLastWakeLockHoldingWindow = this.mRoot.mHoldScreenWindow;
                this.mLastWakeLockObscuringWindow = null;
                this.mHoldingScreenWakeLock.acquire();
                this.mPolicy.keepScreenOnStartedLw();
            } else {
                this.mLastWakeLockHoldingWindow = null;
                this.mLastWakeLockObscuringWindow = this.mRoot.mObscuringWindow;
                this.mPolicy.keepScreenOnStoppedLw();
                this.mHoldingScreenWakeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestTraversal() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowPlacerLocked.requestTraversal();
        }
    }

    void scheduleAnimationLocked() {
        if (!this.mAnimationScheduled) {
            this.mAnimationScheduled = true;
            this.mChoreographer.postFrameCallback(this.mAnimator.mAnimationFrameCallback);
        }
    }

    boolean updateFocusedWindowLocked(int mode, boolean updateInputWindows) {
        WindowState newFocus = this.mRoot.computeFocusedWindow();
        if (this.mCurrentFocus != newFocus) {
            Trace.traceBegin(32L, "wmUpdateFocus");
            this.mH.removeMessages(2);
            this.mH.sendEmptyMessage(2);
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            boolean imWindowChanged = false;
            if (this.mInputMethodWindow != null) {
                WindowState prevTarget = this.mInputMethodTarget;
                WindowState newTarget = displayContent.computeImeTarget(true);
                boolean bl = imWindowChanged = prevTarget != newTarget;
                if (mode != 1 && mode != 3) {
                    int prevImeAnimLayer = this.mInputMethodWindow.mWinAnimator.mAnimLayer;
                    displayContent.assignWindowLayers(false);
                    imWindowChanged |= prevImeAnimLayer != this.mInputMethodWindow.mWinAnimator.mAnimLayer;
                }
            }
            if (imWindowChanged) {
                this.mWindowsChanged = true;
                displayContent.setLayoutNeeded();
                newFocus = this.mRoot.computeFocusedWindow();
            }
            WindowState oldFocus = this.mCurrentFocus;
            this.mCurrentFocus = newFocus;
            this.mLosingFocus.remove(newFocus);
            int focusChanged = this.mPolicy.focusChangedLw(oldFocus, newFocus);
            if (imWindowChanged && oldFocus != this.mInputMethodWindow) {
                if (mode == 2) {
                    displayContent.performLayout(true, updateInputWindows);
                    focusChanged &= 0xFFFFFFFE;
                } else if (mode == 3) {
                    displayContent.assignWindowLayers(false);
                }
            }
            if ((focusChanged & 1) != 0) {
                displayContent.setLayoutNeeded();
                if (mode == 2) {
                    displayContent.performLayout(true, updateInputWindows);
                }
            }
            if (mode != 1) {
                this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, updateInputWindows);
            }
            displayContent.adjustForImeIfNeeded();
            displayContent.scheduleToastWindowsTimeoutIfNeededLocked(oldFocus, newFocus);
            Trace.traceEnd(32L);
            return true;
        }
        return false;
    }

    void startFreezingDisplayLocked(boolean inTransaction, int exitAnim, int enterAnim) {
        if (this.mDisplayFrozen) {
            return;
        }
        if (!this.mDisplayReady || !this.mPolicy.isScreenOn()) {
            return;
        }
        this.mScreenFrozenLock.acquire();
        this.mDisplayFrozen = true;
        this.mDisplayFreezeTime = SystemClock.elapsedRealtime();
        this.mLastFinishedFreezeSource = null;
        this.mInputMonitor.freezeInputDispatchingLw();
        this.mPolicy.setLastInputMethodWindowLw(null, null);
        if (this.mAppTransition.isTransitionSet()) {
            this.mAppTransition.freeze();
        }
        this.mExitAnimId = exitAnim;
        this.mEnterAnimId = enterAnim;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        int displayId = displayContent.getDisplayId();
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null) {
            screenRotationAnimation.kill();
        }
        boolean isSecure = displayContent.hasSecureWindowOnScreen();
        displayContent.updateDisplayInfo();
        screenRotationAnimation = new ScreenRotationAnimation(this.mContext, displayContent, this.mFxSession, inTransaction, this.mPolicy.isDefaultOrientationForced(), isSecure, this);
        this.mAnimator.setScreenRotationAnimationLocked(displayId, screenRotationAnimation);
    }

    void stopFreezingDisplayLocked() {
        if (!this.mDisplayFrozen) {
            return;
        }
        if (this.mWaitingForConfig || this.mAppsFreezingScreen > 0 || this.mWindowsFreezingScreen == 1 || this.mClientFreezingScreen || !this.mOpeningApps.isEmpty()) {
            return;
        }
        this.mDisplayFrozen = false;
        this.mLastDisplayFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
        StringBuilder sb = new StringBuilder(128);
        sb.append("Screen frozen for ");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, sb);
        if (this.mLastFinishedFreezeSource != null) {
            sb.append(" due to ");
            sb.append(this.mLastFinishedFreezeSource);
        }
        Slog.i(TAG, sb.toString());
        this.mH.removeMessages(17);
        this.mH.removeMessages(30);
        boolean updateRotation = false;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        int displayId = displayContent.getDisplayId();
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot()) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            boolean isDimming = displayContent.isDimming();
            if (!this.mPolicy.validateRotationAnimationLw(this.mExitAnimId, this.mEnterAnimId, isDimming)) {
                this.mEnterAnimId = 0;
                this.mExitAnimId = 0;
            }
            if (screenRotationAnimation.dismiss(this.mFxSession, 10000L, this.getTransitionAnimationScaleLocked(), displayInfo.logicalWidth, displayInfo.logicalHeight, this.mExitAnimId, this.mEnterAnimId)) {
                this.scheduleAnimationLocked();
            } else {
                screenRotationAnimation.kill();
                this.mAnimator.setScreenRotationAnimationLocked(displayId, null);
                updateRotation = true;
            }
        } else {
            if (screenRotationAnimation != null) {
                screenRotationAnimation.kill();
                this.mAnimator.setScreenRotationAnimationLocked(displayId, null);
            }
            updateRotation = true;
        }
        this.mInputMonitor.thawInputDispatchingLw();
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false, displayId);
        this.mH.removeMessages(15);
        this.mH.sendEmptyMessageDelayed(15, 2000L);
        this.mScreenFrozenLock.release();
        if (updateRotation) {
            configChanged |= this.updateRotationUncheckedLocked(false, displayId);
        }
        if (configChanged) {
            this.mH.obtainMessage(18, displayId).sendToTarget();
        }
    }

    static int getPropertyInt(String[] tokens, int index, int defUnits, int defDps, DisplayMetrics dm) {
        String str;
        if (index < tokens.length && (str = tokens[index]) != null && str.length() > 0) {
            try {
                int val = Integer.parseInt(str);
                return val;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (defUnits == 0) {
            return defDps;
        }
        int val = (int)TypedValue.applyDimension(defUnits, defDps, dm);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWatermarkInTransaction() {
        if (this.mWatermark != null) {
            return;
        }
        File file = new File("/system/etc/setup.conf");
        FileInputStream in = null;
        FilterInputStream ind = null;
        try {
            String[] toks;
            in = new FileInputStream(file);
            ind = new DataInputStream(in);
            String line = ((DataInputStream)ind).readLine();
            if (line != null && (toks = line.split("%")) != null && toks.length > 0) {
                this.mWatermark = new Watermark(this.getDefaultDisplayContentLocked().getDisplay(), this.mRealDisplayMetrics, this.mFxSession, toks);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (ind != null) {
                try {
                    ind.close();
                }
                catch (IOException iOException) {}
            } else if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecentsVisibility(boolean visible) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mPolicy.setRecentsVisibilityLw(visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTvPipVisibility(boolean visible) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mPolicy.setTvPipVisibilityLw(visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusBarVisibilityChanged(int visibility) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mLastStatusBarVisibility = visibility;
            visibility = this.mPolicy.adjustSystemUiVisibilityLw(visibility);
            this.updateStatusBarVisibilityLocked(visibility);
        }
    }

    private boolean updateStatusBarVisibilityLocked(int visibility) {
        if (this.mLastDispatchedSystemUiVisibility == visibility) {
            return false;
        }
        int globalDiff = (visibility ^ this.mLastDispatchedSystemUiVisibility) & 7 & ~visibility;
        this.mLastDispatchedSystemUiVisibility = visibility;
        this.mInputManager.setSystemUiVisibility(visibility);
        this.getDefaultDisplayContentLocked().updateSystemUiVisibility(visibility, globalDiff);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reevaluateStatusBarVisibility() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int visibility = this.mPolicy.adjustSystemUiVisibilityLw(this.mLastStatusBarVisibility);
            if (this.updateStatusBarVisibilityLocked(visibility)) {
                this.mWindowPlacerLocked.requestTraversal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowManagerPolicy.InputConsumer createInputConsumer(Looper looper, String name, InputEventReceiver.Factory inputEventReceiverFactory) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mInputMonitor.createInputConsumer(looper, name, inputEventReceiverFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createInputConsumer(String name, InputChannel inputChannel) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mInputMonitor.createInputConsumer(name, inputChannel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyInputConsumer(String name) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mInputMonitor.destroyInputConsumer(name);
        }
    }

    @Override
    public boolean hasNavigationBar() {
        return this.mPolicy.hasNavigationBar();
    }

    @Override
    public void lockNow(Bundle options) {
        this.mPolicy.lockNow(options);
    }

    public void showRecentApps(boolean fromHome) {
        this.mPolicy.showRecentApps(fromHome);
    }

    @Override
    public boolean isSafeModeEnabled() {
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearWindowContentFrameStats(IBinder token) {
        if (!this.checkCallingPermission("android.permission.FRAME_STATS", "clearWindowContentFrameStats()")) {
            throw new SecurityException("Requires FRAME_STATS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState windowState = this.mWindowMap.get(token);
            if (windowState == null) {
                return false;
            }
            WindowSurfaceController surfaceController = windowState.mWinAnimator.mSurfaceController;
            if (surfaceController == null) {
                return false;
            }
            return surfaceController.clearWindowContentFrameStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowContentFrameStats getWindowContentFrameStats(IBinder token) {
        if (!this.checkCallingPermission("android.permission.FRAME_STATS", "getWindowContentFrameStats()")) {
            throw new SecurityException("Requires FRAME_STATS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowContentFrameStats stats;
            WindowState windowState = this.mWindowMap.get(token);
            if (windowState == null) {
                return null;
            }
            WindowSurfaceController surfaceController = windowState.mWinAnimator.mSurfaceController;
            if (surfaceController == null) {
                return null;
            }
            if (this.mTempWindowRenderStats == null) {
                this.mTempWindowRenderStats = new WindowContentFrameStats();
            }
            if (!surfaceController.getWindowContentFrameStats(stats = this.mTempWindowRenderStats)) {
                return null;
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppRelaunching(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindow = this.mRoot.getAppWindowToken(token);
            if (appWindow != null) {
                appWindow.startRelaunching();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppRelaunchingFinished(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindow = this.mRoot.getAppWindowToken(token);
            if (appWindow != null) {
                appWindow.finishRelaunching();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppRelaunchesCleared(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindow = this.mRoot.getAppWindowToken(token);
            if (appWindow != null) {
                appWindow.clearRelaunching();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAppResumedFinished(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindow = this.mRoot.getAppWindowToken(token);
            if (appWindow != null) {
                this.mUnknownAppVisibilityController.notifyAppResumedFinished(appWindow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskRemovedFromRecents(int taskId, int userId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mTaskSnapshotController.notifyTaskRemovedFromRecents(taskId, userId);
        }
    }

    @Override
    public int getDockedDividerInsetsLw() {
        return this.getDefaultDisplayContentLocked().getDockedDividerController().getContentInsets();
    }

    private void dumpPolicyLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER POLICY STATE (dumpsys window policy)");
        this.mPolicy.dump("    ", pw, args);
    }

    private void dumpAnimatorLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER ANIMATOR STATE (dumpsys window animator)");
        this.mAnimator.dumpLocked(pw, "    ", dumpAll);
    }

    private void dumpTokensLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER TOKENS (dumpsys window tokens)");
        this.mRoot.dumpTokens(pw, dumpAll);
        if (!this.mOpeningApps.isEmpty() || !this.mClosingApps.isEmpty()) {
            pw.println();
            if (this.mOpeningApps.size() > 0) {
                pw.print("  mOpeningApps=");
                pw.println(this.mOpeningApps);
            }
            if (this.mClosingApps.size() > 0) {
                pw.print("  mClosingApps=");
                pw.println(this.mClosingApps);
            }
        }
    }

    private void dumpSessionsLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER SESSIONS (dumpsys window sessions)");
        for (int i = 0; i < this.mSessions.size(); ++i) {
            Session s = this.mSessions.valueAt(i);
            pw.print("  Session ");
            pw.print(s);
            pw.println(':');
            s.dump(pw, "    ");
        }
    }

    private void dumpWindowsLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        pw.println("WINDOW MANAGER WINDOWS (dumpsys window windows)");
        this.dumpWindowsNoHeaderLocked(pw, dumpAll, windows);
    }

    private void dumpWindowsNoHeaderLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        WindowState w;
        int i;
        this.mRoot.dumpWindowsNoHeader(pw, dumpAll, windows);
        if (this.mPendingRemove.size() > 0) {
            pw.println();
            pw.println("  Remove pending for:");
            for (i = this.mPendingRemove.size() - 1; i >= 0; --i) {
                w = this.mPendingRemove.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Remove #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mForceRemoves != null && this.mForceRemoves.size() > 0) {
            pw.println();
            pw.println("  Windows force removing:");
            for (i = this.mForceRemoves.size() - 1; i >= 0; --i) {
                w = this.mForceRemoves.get(i);
                pw.print("  Removing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mDestroySurface.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to destroy their surface:");
            for (i = this.mDestroySurface.size() - 1; i >= 0; --i) {
                w = this.mDestroySurface.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Destroy #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mLosingFocus.size() > 0) {
            pw.println();
            pw.println("  Windows losing focus:");
            for (i = this.mLosingFocus.size() - 1; i >= 0; --i) {
                w = this.mLosingFocus.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Losing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mResizingWindows.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to resize:");
            for (i = this.mResizingWindows.size() - 1; i >= 0; --i) {
                w = this.mResizingWindows.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Resizing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mWaitingForDrawn.size() > 0) {
            pw.println();
            pw.println("  Clients waiting for these windows to be drawn:");
            for (i = this.mWaitingForDrawn.size() - 1; i >= 0; --i) {
                WindowState win = this.mWaitingForDrawn.get(i);
                pw.print("  Waiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(win);
            }
        }
        pw.println();
        pw.print("  mGlobalConfiguration=");
        pw.println(this.mRoot.getConfiguration());
        pw.print("  mHasPermanentDpad=");
        pw.println(this.mHasPermanentDpad);
        pw.print("  mCurrentFocus=");
        pw.println(this.mCurrentFocus);
        if (this.mLastFocus != this.mCurrentFocus) {
            pw.print("  mLastFocus=");
            pw.println(this.mLastFocus);
        }
        pw.print("  mFocusedApp=");
        pw.println(this.mFocusedApp);
        if (this.mInputMethodTarget != null) {
            pw.print("  mInputMethodTarget=");
            pw.println(this.mInputMethodTarget);
        }
        pw.print("  mInTouchMode=");
        pw.print(this.mInTouchMode);
        pw.print(" mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        pw.print("  mLastDisplayFreezeDuration=");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, pw);
        if (this.mLastFinishedFreezeSource != null) {
            pw.print(" due to ");
            pw.print(this.mLastFinishedFreezeSource);
        }
        pw.println();
        pw.print("  mLastWakeLockHoldingWindow=");
        pw.print(this.mLastWakeLockHoldingWindow);
        pw.print(" mLastWakeLockObscuringWindow=");
        pw.print(this.mLastWakeLockObscuringWindow);
        pw.println();
        this.mInputMonitor.dump(pw, "  ");
        this.mUnknownAppVisibilityController.dump(pw, "  ");
        this.mTaskSnapshotController.dump(pw, "  ");
        if (dumpAll) {
            pw.print("  mSystemDecorLayer=");
            pw.print(this.mSystemDecorLayer);
            pw.print(" mScreenRect=");
            pw.println(this.mScreenRect.toShortString());
            if (this.mLastStatusBarVisibility != 0) {
                pw.print("  mLastStatusBarVisibility=0x");
                pw.println(Integer.toHexString(this.mLastStatusBarVisibility));
            }
            if (this.mInputMethodWindow != null) {
                pw.print("  mInputMethodWindow=");
                pw.println(this.mInputMethodWindow);
            }
            this.mWindowPlacerLocked.dump(pw, "  ");
            this.mRoot.mWallpaperController.dump(pw, "  ");
            pw.print("  mSystemBooted=");
            pw.print(this.mSystemBooted);
            pw.print(" mDisplayEnabled=");
            pw.println(this.mDisplayEnabled);
            this.mRoot.dumpLayoutNeededDisplayIds(pw);
            pw.print("  mTransactionSequence=");
            pw.println(this.mTransactionSequence);
            pw.print("  mDisplayFrozen=");
            pw.print(this.mDisplayFrozen);
            pw.print(" windows=");
            pw.print(this.mWindowsFreezingScreen);
            pw.print(" client=");
            pw.print(this.mClientFreezingScreen);
            pw.print(" apps=");
            pw.print(this.mAppsFreezingScreen);
            pw.print(" waitingForConfig=");
            pw.println(this.mWaitingForConfig);
            pw.print("  mRotation=");
            pw.print(this.mRotation);
            pw.print(" mAltOrientation=");
            pw.println(this.mAltOrientation);
            pw.print("  mLastWindowForcedOrientation=");
            pw.print(this.mLastWindowForcedOrientation);
            pw.print(" mLastOrientation=");
            pw.println(this.mLastOrientation);
            pw.print("  mDeferredRotationPauseCount=");
            pw.println(this.mDeferredRotationPauseCount);
            pw.print("  Animation settings: disabled=");
            pw.print(this.mAnimationsDisabled);
            pw.print(" window=");
            pw.print(this.mWindowAnimationScaleSetting);
            pw.print(" transition=");
            pw.print(this.mTransitionAnimationScaleSetting);
            pw.print(" animator=");
            pw.println(this.mAnimatorDurationScaleSetting);
            pw.print(" mSkipAppTransitionAnimation=");
            pw.println(this.mSkipAppTransitionAnimation);
            pw.println("  mLayoutToAnim:");
            this.mAppTransition.dump(pw, "    ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dumpWindows(PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        ArrayList<WindowState> windows = new ArrayList<WindowState>();
        if ("apps".equals(name) || "visible".equals(name) || "visible-apps".equals(name)) {
            boolean appsOnly = name.contains("apps");
            boolean visibleOnly = name.contains("visible");
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                if (appsOnly) {
                    this.mRoot.dumpDisplayContents(pw);
                }
                this.mRoot.forAllWindows(WindowManagerService$$Lambda$39.get$Lambda(visibleOnly, appsOnly, windows), true);
            }
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mRoot.getWindowsByName(windows, name);
        }
        if (windows.size() <= 0) {
            return false;
        }
        HashMap<IBinder, WindowState> hashMap2 = this.mWindowMap;
        synchronized (hashMap2) {
            this.dumpWindowsLocked(pw, dumpAll, windows);
        }
        return true;
    }

    private void dumpLastANRLocked(PrintWriter pw) {
        pw.println("WINDOW MANAGER LAST ANR (dumpsys window lastanr)");
        if (this.mLastANRState == null) {
            pw.println("  <no ANR has occurred since boot>");
        } else {
            pw.println(this.mLastANRState);
        }
    }

    void saveANRStateLocked(AppWindowToken appWindowToken, WindowState windowState, String reason) {
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
        pw.println("  ANR time: " + DateFormat.getInstance().format(new Date()));
        if (appWindowToken != null) {
            pw.println("  Application at fault: " + appWindowToken.stringName);
        }
        if (windowState != null) {
            pw.println("  Window at fault: " + windowState.mAttrs.getTitle());
        }
        if (reason != null) {
            pw.println("  Reason: " + reason);
        }
        ((PrintWriter)pw).println();
        this.dumpWindowsNoHeaderLocked(pw, true, null);
        ((PrintWriter)pw).println();
        pw.println("Last ANR continued");
        this.mRoot.dumpDisplayContents(pw);
        ((PrintWriter)pw).close();
        this.mLastANRState = sw.toString();
        this.mH.removeMessages(38);
        this.mH.sendEmptyMessageDelayed(38, 0x6DDD00L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WindowManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        boolean dumpAll = false;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("Window manager dump options:");
                pw.println("  [-a] [-h] [cmd] ...");
                pw.println("  cmd may be one of:");
                pw.println("    l[astanr]: last ANR information");
                pw.println("    p[policy]: policy state");
                pw.println("    a[animator]: animator state");
                pw.println("    s[essions]: active sessions");
                pw.println("    surfaces: active surfaces (debugging enabled only)");
                pw.println("    d[isplays]: active display contents");
                pw.println("    t[okens]: token list");
                pw.println("    w[indows]: window list");
                pw.println("  cmd may also be a NAME to dump windows.  NAME may");
                pw.println("    be a partial substring in a window name, a");
                pw.println("    Window hex object identifier, or");
                pw.println("    \"all\" for all windows, or");
                pw.println("    \"visible\" for the visible windows.");
                pw.println("    \"visible-apps\" for the visible app windows.");
                pw.println("  -a: include all available server state.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("lastanr".equals(cmd) || "l".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpLastANRLocked(pw);
                }
                return;
            }
            if ("policy".equals(cmd) || "p".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpPolicyLocked(pw, args, true);
                }
                return;
            }
            if ("animator".equals(cmd) || "a".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpAnimatorLocked(pw, args, true);
                }
                return;
            }
            if ("sessions".equals(cmd) || "s".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpSessionsLocked(pw, true);
                }
                return;
            }
            if ("surfaces".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    WindowSurfaceController.SurfaceTrace.dumpAllSurfaces(pw, null);
                }
                return;
            }
            if ("displays".equals(cmd) || "d".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.mRoot.dumpDisplayContents(pw);
                }
                return;
            }
            if ("tokens".equals(cmd) || "t".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpTokensLocked(pw, true);
                }
                return;
            }
            if ("windows".equals(cmd) || "w".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(pw, true, null);
                }
                return;
            }
            if ("all".equals(cmd) || "a".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(pw, true, null);
                }
                return;
            }
            if ("containers".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    StringBuilder output = new StringBuilder();
                    this.mRoot.dumpChildrenNames(output, " ");
                    pw.println(output.toString());
                    pw.println(" ");
                    this.mRoot.forAllWindows(WindowManagerService$$Lambda$40.get$Lambda(pw), true);
                }
                return;
            }
            if (!this.dumpWindows(pw, cmd, args, opti, dumpAll)) {
                pw.println("Bad window command, or no windows match: " + cmd);
                pw.println("Use -h for help.");
            }
            return;
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpLastANRLocked(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPolicyLocked(pw, args, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpAnimatorLocked(pw, args, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpSessionsLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            WindowSurfaceController.SurfaceTrace.dumpAllSurfaces(pw, dumpAll ? "-------------------------------------------------------------------------------" : null);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.mRoot.dumpDisplayContents(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpTokensLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpWindowsLocked(pw, dumpAll, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
        }
    }

    private void createDisplayContentLocked(Display display) {
        if (display == null) {
            throw new IllegalArgumentException("getDisplayContent: display must not be null");
        }
        this.mRoot.getDisplayContentOrCreate(display.getDisplayId());
    }

    DisplayContent getDefaultDisplayContentLocked() {
        return this.mRoot.getDisplayContentOrCreate(0);
    }

    private DisplayInfo getDefaultDisplayInfoLocked() {
        return this.getDefaultDisplayContentLocked().getDisplayInfo();
    }

    public void onDisplayAdded(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(27, displayId, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDisplayAdded(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Display display = this.mDisplayManager.getDisplay(displayId);
            if (display != null) {
                this.createDisplayContentLocked(display);
                this.displayReady(displayId);
            }
            this.mWindowPlacerLocked.requestTraversal();
        }
    }

    public void onDisplayRemoved(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(28, displayId, 0));
    }

    private void handleDisplayRemovedLocked(int displayId) {
        DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
        if (displayContent != null) {
            displayContent.removeIfPossible();
        }
        this.mAnimator.removeDisplayLocked(displayId);
        this.mWindowPlacerLocked.requestTraversal();
    }

    public void onDisplayChanged(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(29, displayId, 0));
    }

    private void handleDisplayChangedLocked(int displayId) {
        DisplayContent displayContent = this.mRoot.getDisplayContentOrCreate(displayId);
        if (displayContent != null) {
            displayContent.updateDisplayInfo();
        }
        this.mWindowPlacerLocked.requestTraversal();
    }

    @Override
    public Object getWindowManagerLock() {
        return this.mWindowMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWillReplaceWindow(IBinder token, boolean animate) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindowToken = this.mRoot.getAppWindowToken(token);
            if (appWindowToken == null || !appWindowToken.hasContentToDisplay()) {
                Slog.w(TAG, "Attempted to set replacing window on non-existing app token " + token);
                return;
            }
            appWindowToken.setWillReplaceWindows(animate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWillReplaceWindows(IBinder token, boolean childrenOnly) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindowToken = this.mRoot.getAppWindowToken(token);
            if (appWindowToken == null || !appWindowToken.hasContentToDisplay()) {
                Slog.w(TAG, "Attempted to set replacing window on non-existing app token " + token);
                return;
            }
            if (childrenOnly) {
                appWindowToken.setWillReplaceChildWindows();
            } else {
                appWindowToken.setWillReplaceWindows(false);
            }
            this.scheduleClearWillReplaceWindows(token, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleClearWillReplaceWindows(IBinder token, boolean replacing) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken appWindowToken = this.mRoot.getAppWindowToken(token);
            if (appWindowToken == null) {
                Slog.w(TAG, "Attempted to reset replacing window on non-existing app token " + token);
                return;
            }
            if (replacing) {
                this.scheduleWindowReplacementTimeouts(appWindowToken);
            } else {
                appWindowToken.clearWillReplaceWindows();
            }
        }
    }

    void scheduleWindowReplacementTimeouts(AppWindowToken appWindowToken) {
        if (!this.mWindowReplacementTimeouts.contains(appWindowToken)) {
            this.mWindowReplacementTimeouts.add(appWindowToken);
        }
        this.mH.removeMessages(46);
        this.mH.sendEmptyMessageDelayed(46, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDockedStackSide() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack dockedStack = this.getDefaultDisplayContentLocked().getDockedStackIgnoringVisibility();
            return dockedStack == null ? -1 : dockedStack.getDockSide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDockedStackResizing(boolean resizing) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getDefaultDisplayContentLocked().getDockedDividerController().setResizing(resizing);
            this.requestTraversal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDockedStackDividerTouchRegion(Rect touchRegion) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getDefaultDisplayContentLocked().getDockedDividerController().setTouchRegion(touchRegion);
            this.setFocusTaskRegionLocked(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResizeDimLayer(boolean visible, int targetStackId, float alpha) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getDefaultDisplayContentLocked().getDockedDividerController().setResizeDimLayer(visible, targetStackId, alpha);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForceResizableTasks(boolean forceResizableTasks) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mForceResizableTasks = forceResizableTasks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSupportsPictureInPicture(boolean supportsPictureInPicture) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mSupportsPictureInPicture = supportsPictureInPicture;
        }
    }

    static int dipToPixel(int dip, DisplayMetrics displayMetrics) {
        return (int)TypedValue.applyDimension(1, dip, displayMetrics);
    }

    @Override
    public void registerDockedStackListener(IDockedStackListener listener) {
        if (!this.checkCallingPermission("android.permission.REGISTER_WINDOW_MANAGER_LISTENERS", "registerDockedStackListener()")) {
            return;
        }
        this.getDefaultDisplayContentLocked().mDividerControllerLocked.registerDockedStackListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPinnedStackListener(int displayId, IPinnedStackListener listener) {
        if (!this.checkCallingPermission("android.permission.REGISTER_WINDOW_MANAGER_LISTENERS", "registerPinnedStackListener()")) {
            return;
        }
        if (!this.mSupportsPictureInPicture) {
            return;
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.mRoot.getDisplayContent(displayId);
            displayContent.getPinnedStackController().registerPinnedStackListener(listener);
        }
    }

    @Override
    public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) {
        try {
            WindowState focusedWindow = this.getFocusedWindow();
            if (focusedWindow != null && focusedWindow.mClient != null) {
                this.getFocusedWindow().mClient.requestAppKeyboardShortcuts(receiver, deviceId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.getStableInsetsLocked(displayId, outInsets);
        }
    }

    void getStableInsetsLocked(int displayId, Rect outInsets) {
        outInsets.setEmpty();
        DisplayContent dc = this.mRoot.getDisplayContent(displayId);
        if (dc != null) {
            DisplayInfo di = dc.getDisplayInfo();
            this.mPolicy.getStableInsetsLw(di.rotation, di.logicalWidth, di.logicalHeight, outInsets);
        }
    }

    void intersectDisplayInsetBounds(Rect display, Rect insets, Rect inOutBounds) {
        this.mTmpRect3.set(display);
        this.mTmpRect3.inset(insets);
        inOutBounds.intersect(this.mTmpRect3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePointerIcon(IWindow client) {
        float mouseY;
        float mouseX;
        Object object = this.mMousePositionTracker;
        synchronized (object) {
            if (!this.mMousePositionTracker.mLatestEventWasMouse) {
                return;
            }
            mouseX = this.mMousePositionTracker.mLatestMouseX;
            mouseY = this.mMousePositionTracker.mLatestMouseY;
        }
        object = this.mWindowMap;
        synchronized (object) {
            if (this.mDragState != null) {
                return;
            }
            WindowState callingWin = this.windowForClientLocked(null, client, false);
            if (callingWin == null) {
                Slog.w(TAG, "Bad requesting window " + client);
                return;
            }
            DisplayContent displayContent = callingWin.getDisplayContent();
            if (displayContent == null) {
                return;
            }
            WindowState windowUnderPointer = displayContent.getTouchableWinAtPointLocked(mouseX, mouseY);
            if (windowUnderPointer != callingWin) {
                return;
            }
            try {
                windowUnderPointer.mClient.updatePointerIcon(windowUnderPointer.translateToWindowX(mouseX), windowUnderPointer.translateToWindowY(mouseY));
            }
            catch (RemoteException e) {
                Slog.w(TAG, "unable to update pointer icon");
            }
        }
    }

    void restorePointerIconLocked(DisplayContent displayContent, float latestX, float latestY) {
        this.mMousePositionTracker.updatePosition(latestX, latestY);
        WindowState windowUnderPointer = displayContent.getTouchableWinAtPointLocked(latestX, latestY);
        if (windowUnderPointer != null) {
            try {
                windowUnderPointer.mClient.updatePointerIcon(windowUnderPointer.translateToWindowX(latestX), windowUnderPointer.translateToWindowY(latestY));
            }
            catch (RemoteException e) {
                Slog.w(TAG, "unable to restore pointer icon");
            }
        } else {
            InputManager.getInstance().setPointerIconType(1000);
        }
    }

    @Override
    public void registerShortcutKey(long shortcutCode, IShortcutService shortcutKeyReceiver) throws RemoteException {
        if (!this.checkCallingPermission("android.permission.REGISTER_WINDOW_MANAGER_LISTENERS", "registerShortcutKey")) {
            throw new SecurityException("Requires REGISTER_WINDOW_MANAGER_LISTENERS permission");
        }
        this.mPolicy.registerShortcutKey(shortcutCode, shortcutKeyReceiver);
    }

    void markForSeamlessRotation(WindowState w, boolean seamlesslyRotated) {
        int displayId;
        if (seamlesslyRotated == w.mSeamlesslyRotated) {
            return;
        }
        w.mSeamlesslyRotated = seamlesslyRotated;
        this.mSeamlessRotationCount = seamlesslyRotated ? ++this.mSeamlessRotationCount : --this.mSeamlessRotationCount;
        if (this.mSeamlessRotationCount == 0 && this.updateRotationUncheckedLocked(false, displayId = w.getDisplayId())) {
            this.mH.obtainMessage(18, displayId).sendToTarget();
        }
    }

    void registerAppFreezeListener(AppFreezeListener listener) {
        if (!this.mAppFreezeListeners.contains(listener)) {
            this.mAppFreezeListeners.add(listener);
        }
    }

    void unregisterAppFreezeListener(AppFreezeListener listener) {
        this.mAppFreezeListeners.remove(listener);
    }

    static final /* synthetic */ void lambda$dump$20$WindowManagerService(PrintWriter printWriter, WindowState w) {
        printWriter.println(w);
    }

    static final /* synthetic */ void lambda$dumpWindows$19$WindowManagerService(boolean bl, boolean bl2, ArrayList arrayList, WindowState w) {
        if (!(bl && !w.mWinAnimator.getShown() || bl2 && w.mAppToken == null)) {
            arrayList.add(w);
        }
    }

    static final /* synthetic */ boolean lambda$findWindow$18$WindowManagerService(int n, WindowState w) {
        return System.identityHashCode(w) == n;
    }

    static final /* synthetic */ void lambda$viewServerListWindows$17$WindowManagerService(ArrayList arrayList, WindowState w) {
        arrayList.add(w);
    }

    final /* synthetic */ void lambda$updateRotationUncheckedLocked$16$WindowManagerService(boolean bl, WindowState w) {
        if (w.mAppToken != null) {
            w.mAppToken.destroySavedSurfaces();
        }
        if (w.mHasSurface && !bl) {
            w.mOrientationChanging = true;
            this.mRoot.mOrientationChangeComplete = false;
            w.mLastFreezeDuration = 0;
        }
        w.mReportOrientationChanged = true;
    }

    final /* synthetic */ void lambda$updateRotationUncheckedLocked$15$WindowManagerService(int n, WindowState w) {
        w.mWinAnimator.seamlesslyRotateWindow(n, this.mRotation);
    }

    static final /* synthetic */ boolean lambda$updateRotationUncheckedLocked$14$WindowManagerService(WindowState w) {
        return w.isChildWindow() && w.isVisibleNow() && !w.mWinAnimator.mSurfaceController.getTransformToDisplayInverse();
    }

    static final /* synthetic */ boolean lambda$updateRotationUncheckedLocked$13$WindowManagerService(WindowState w) {
        return w.mSeamlesslyRotated;
    }

    final /* synthetic */ void lambda$requestAssistScreenshot$12$WindowManagerService(IAssistScreenshotReceiver iAssistScreenshotReceiver) {
        Bitmap bm = this.screenshotApplications(null, 0, -1, -1, true, 1.0f, Bitmap.Config.ARGB_8888, false, false);
        try {
            iAssistScreenshotReceiver.send(bm);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$notifyKeyguardFlagsChanged$11$WindowManagerService(Runnable runnable) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void lambda$new$10$WindowManagerService(boolean enabled) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mAnimationsDisabled != enabled && !this.mAllowAnimationsInLowPowerMode) {
                this.mAnimationsDisabled = enabled;
                this.dispatchNewAnimatorScaleLocked(null);
            }
        }
    }

    static final /* synthetic */ void lambda$main$9$WindowManagerService(Context context, InputManagerService inputManagerService, boolean bl, boolean bl2, boolean bl3, WindowManagerPolicy windowManagerPolicy) {
        sInstance = new WindowManagerService(context, inputManagerService, bl, bl2, bl3, windowManagerPolicy);
    }

    private final class LocalService
    extends WindowManagerInternal {
        private LocalService() {
        }

        @Override
        public void requestTraversalFromDisplayManager() {
            WindowManagerService.this.requestTraversal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMagnificationSpec(MagnificationSpec spec) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    throw new IllegalStateException("Magnification callbacks not set!");
                }
                WindowManagerService.this.mAccessibilityController.setMagnificationSpecLocked(spec);
            }
            if (Binder.getCallingPid() != Process.myPid()) {
                spec.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getMagnificationRegion(Region magnificationRegion) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    throw new IllegalStateException("Magnification callbacks not set!");
                }
                WindowManagerService.this.mAccessibilityController.getMagnificationRegionLocked(magnificationRegion);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MagnificationSpec getCompatibleMagnificationSpecForWindow(IBinder windowToken) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = WindowManagerService.this.mWindowMap.get(windowToken);
                if (windowState == null) {
                    return null;
                }
                MagnificationSpec spec = null;
                if (WindowManagerService.this.mAccessibilityController != null) {
                    spec = WindowManagerService.this.mAccessibilityController.getMagnificationSpecForWindowLocked(windowState);
                }
                if ((spec == null || spec.isNop()) && windowState.mGlobalScale == 1.0f) {
                    return null;
                }
                spec = spec == null ? MagnificationSpec.obtain() : MagnificationSpec.obtain(spec);
                spec.scale *= windowState.mGlobalScale;
                return spec;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMagnificationCallbacks(WindowManagerInternal.MagnificationCallbacks callbacks) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    WindowManagerService.this.mAccessibilityController = new AccessibilityController(WindowManagerService.this);
                }
                WindowManagerService.this.mAccessibilityController.setMagnificationCallbacksLocked(callbacks);
                if (!WindowManagerService.this.mAccessibilityController.hasCallbacksLocked()) {
                    WindowManagerService.this.mAccessibilityController = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setWindowsForAccessibilityCallback(WindowManagerInternal.WindowsForAccessibilityCallback callback) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    WindowManagerService.this.mAccessibilityController = new AccessibilityController(WindowManagerService.this);
                }
                WindowManagerService.this.mAccessibilityController.setWindowsForAccessibilityCallback(callback);
                if (!WindowManagerService.this.mAccessibilityController.hasCallbacksLocked()) {
                    WindowManagerService.this.mAccessibilityController = null;
                }
            }
        }

        @Override
        public void setInputFilter(IInputFilter filter) {
            WindowManagerService.this.mInputManager.setInputFilter(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IBinder getFocusedWindowToken() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = WindowManagerService.this.getFocusedWindowLocked();
                if (windowState != null) {
                    return windowState.mClient.asBinder();
                }
                return null;
            }
        }

        @Override
        public boolean isKeyguardLocked() {
            return WindowManagerService.this.isKeyguardLocked();
        }

        @Override
        public void showGlobalActions() {
            WindowManagerService.this.showGlobalActions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getWindowFrame(IBinder token, Rect outBounds) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = WindowManagerService.this.mWindowMap.get(token);
                if (windowState != null) {
                    outBounds.set(windowState.mFrame);
                } else {
                    outBounds.setEmpty();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitForAllWindowsDrawn(Runnable callback, long timeout) {
            boolean allWindowsDrawn = false;
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mWaitingForDrawnCallback = callback;
                WindowManagerService.this.getDefaultDisplayContentLocked().waitForAllWindowsDrawn();
                WindowManagerService.this.mWindowPlacerLocked.requestTraversal();
                WindowManagerService.this.mH.removeMessages(24);
                if (WindowManagerService.this.mWaitingForDrawn.isEmpty()) {
                    allWindowsDrawn = true;
                } else {
                    WindowManagerService.this.mH.sendEmptyMessageDelayed(24, timeout);
                    WindowManagerService.this.checkDrawnWindowsLocked();
                }
            }
            if (allWindowsDrawn) {
                callback.run();
            }
        }

        @Override
        public void addWindowToken(IBinder token, int type, int displayId) {
            WindowManagerService.this.addWindowToken(token, type, displayId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeWindowToken(IBinder binder, boolean removeWindows, int displayId) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (removeWindows) {
                    DisplayContent dc = WindowManagerService.this.mRoot.getDisplayContent(displayId);
                    if (dc == null) {
                        Slog.w(WindowManagerService.TAG, "removeWindowToken: Attempted to remove token: " + binder + " for non-exiting displayId=" + displayId);
                        return;
                    }
                    WindowToken token = dc.removeWindowToken(binder);
                    if (token == null) {
                        Slog.w(WindowManagerService.TAG, "removeWindowToken: Attempted to remove non-existing token: " + binder);
                        return;
                    }
                    token.removeAllWindowsIfPossible();
                }
                WindowManagerService.this.removeWindowToken(binder, displayId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerAppTransitionListener(WindowManagerInternal.AppTransitionListener listener) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mAppTransition.registerListenerLocked(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInputMethodWindowVisibleHeight() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                return WindowManagerService.this.mPolicy.getInputMethodWindowVisibleHeightLw();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveLastInputMethodWindowForTransition() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mInputMethodWindow != null) {
                    WindowManagerService.this.mPolicy.setLastInputMethodWindowLw(WindowManagerService.this.mInputMethodWindow, WindowManagerService.this.mInputMethodTarget);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearLastInputMethodWindowForTransition() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mPolicy.setLastInputMethodWindowLw(null, null);
            }
        }

        @Override
        public void updateInputMethodWindowStatus(IBinder imeToken, boolean imeWindowVisible, IBinder targetWindowToken) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isHardKeyboardAvailable() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                return WindowManagerService.this.mHardKeyboardAvailable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOnHardKeyboardStatusChangeListener(WindowManagerInternal.OnHardKeyboardStatusChangeListener listener) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mHardKeyboardStatusChangeListener = listener;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isStackVisible(int stackId) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent dc = WindowManagerService.this.getDefaultDisplayContentLocked();
                return dc.isStackVisible(stackId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDockedDividerResizing() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                return WindowManagerService.this.getDefaultDisplayContentLocked().getDockedDividerController().isResizing();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void computeWindowsForAccessibility() {
            AccessibilityController accessibilityController;
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                accessibilityController = WindowManagerService.this.mAccessibilityController;
            }
            if (accessibilityController != null) {
                accessibilityController.performComputeChangedWindowsNotLocked();
            }
        }
    }

    private static class MousePositionTracker
    implements WindowManagerPolicy.PointerEventListener {
        private boolean mLatestEventWasMouse;
        private float mLatestMouseX;
        private float mLatestMouseY;

        private MousePositionTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updatePosition(float x, float y) {
            MousePositionTracker mousePositionTracker = this;
            synchronized (mousePositionTracker) {
                this.mLatestEventWasMouse = true;
                this.mLatestMouseX = x;
                this.mLatestMouseY = y;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPointerEvent(MotionEvent motionEvent) {
            if (motionEvent.isFromSource(8194)) {
                this.updatePosition(motionEvent.getRawX(), motionEvent.getRawY());
            } else {
                MousePositionTracker mousePositionTracker = this;
                synchronized (mousePositionTracker) {
                    this.mLatestEventWasMouse = false;
                }
            }
        }
    }

    final class H
    extends Handler {
        public static final int REPORT_FOCUS_CHANGE = 2;
        public static final int REPORT_LOSING_FOCUS = 3;
        public static final int DO_TRAVERSAL = 4;
        public static final int WINDOW_FREEZE_TIMEOUT = 11;
        public static final int APP_TRANSITION_TIMEOUT = 13;
        public static final int PERSIST_ANIMATION_SCALE = 14;
        public static final int FORCE_GC = 15;
        public static final int ENABLE_SCREEN = 16;
        public static final int APP_FREEZE_TIMEOUT = 17;
        public static final int SEND_NEW_CONFIGURATION = 18;
        public static final int REPORT_WINDOWS_CHANGE = 19;
        public static final int DRAG_START_TIMEOUT = 20;
        public static final int DRAG_END_TIMEOUT = 21;
        public static final int REPORT_HARD_KEYBOARD_STATUS_CHANGE = 22;
        public static final int BOOT_TIMEOUT = 23;
        public static final int WAITING_FOR_DRAWN_TIMEOUT = 24;
        public static final int SHOW_STRICT_MODE_VIOLATION = 25;
        public static final int DO_ANIMATION_CALLBACK = 26;
        public static final int DO_DISPLAY_ADDED = 27;
        public static final int DO_DISPLAY_REMOVED = 28;
        public static final int DO_DISPLAY_CHANGED = 29;
        public static final int CLIENT_FREEZE_TIMEOUT = 30;
        public static final int TAP_OUTSIDE_TASK = 31;
        public static final int NOTIFY_ACTIVITY_DRAWN = 32;
        public static final int ALL_WINDOWS_DRAWN = 33;
        public static final int NEW_ANIMATOR_SCALE = 34;
        public static final int SHOW_CIRCULAR_DISPLAY_MASK = 35;
        public static final int SHOW_EMULATOR_DISPLAY_OVERLAY = 36;
        public static final int CHECK_IF_BOOT_ANIMATION_FINISHED = 37;
        public static final int RESET_ANR_MESSAGE = 38;
        public static final int WALLPAPER_DRAW_PENDING_TIMEOUT = 39;
        public static final int FINISH_TASK_POSITIONING = 40;
        public static final int UPDATE_DOCKED_STACK_DIVIDER = 41;
        public static final int TEAR_DOWN_DRAG_AND_DROP_INPUT = 44;
        public static final int WINDOW_REPLACEMENT_TIMEOUT = 46;
        public static final int NOTIFY_APP_TRANSITION_STARTING = 47;
        public static final int NOTIFY_APP_TRANSITION_CANCELLED = 48;
        public static final int NOTIFY_APP_TRANSITION_FINISHED = 49;
        public static final int NOTIFY_STARTING_WINDOW_DRAWN = 50;
        public static final int UPDATE_ANIMATION_SCALE = 51;
        public static final int WINDOW_HIDE_TIMEOUT = 52;
        public static final int NOTIFY_DOCKED_STACK_MINIMIZED_CHANGED = 53;
        public static final int SEAMLESS_ROTATION_TIMEOUT = 54;
        public static final int RESTORE_POINTER_ICON = 55;
        public static final int NOTIFY_KEYGUARD_FLAGS_CHANGED = 56;
        public static final int NOTIFY_KEYGUARD_TRUSTED_CHANGED = 57;
        public static final int SET_HAS_OVERLAY_UI = 58;
        public static final int UNUSED = 0;

        H() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    WindowState newFocus;
                    WindowState lastFocus;
                    AccessibilityController accessibilityController = null;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        if (WindowManagerService.this.mAccessibilityController != null && WindowManagerService.this.getDefaultDisplayContentLocked().getDisplayId() == 0) {
                            accessibilityController = WindowManagerService.this.mAccessibilityController;
                        }
                        if ((lastFocus = WindowManagerService.this.mLastFocus) == (newFocus = WindowManagerService.this.mCurrentFocus)) {
                            return;
                        }
                        WindowManagerService.this.mLastFocus = newFocus;
                        if (newFocus != null && lastFocus != null && !newFocus.isDisplayedLw()) {
                            WindowManagerService.this.mLosingFocus.add(lastFocus);
                            lastFocus = null;
                        }
                    }
                    if (accessibilityController != null) {
                        accessibilityController.onWindowFocusChangedNotLocked();
                    }
                    if (newFocus != null) {
                        newFocus.reportFocusChangedSerialized(true, WindowManagerService.this.mInTouchMode);
                        WindowManagerService.this.notifyFocusChanged();
                    }
                    if (lastFocus == null) break;
                    lastFocus.reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    break;
                }
                case 3: {
                    ArrayList<WindowState> losers;
                    HashMap<IBinder, WindowState> newFocus = WindowManagerService.this.mWindowMap;
                    synchronized (newFocus) {
                        losers = WindowManagerService.this.mLosingFocus;
                        WindowManagerService.this.mLosingFocus = new ArrayList();
                    }
                    int N = losers.size();
                    for (int i = 0; i < N; ++i) {
                        losers.get(i).reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    }
                    break;
                }
                case 4: {
                    HashMap<IBinder, WindowState> losers = WindowManagerService.this.mWindowMap;
                    synchronized (losers) {
                        WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        break;
                    }
                }
                case 11: {
                    HashMap<IBinder, WindowState> losers = WindowManagerService.this.mWindowMap;
                    synchronized (losers) {
                        WindowManagerService.this.getDefaultDisplayContentLocked().onWindowFreezeTimeout();
                        break;
                    }
                }
                case 13: {
                    HashMap<IBinder, WindowState> losers = WindowManagerService.this.mWindowMap;
                    synchronized (losers) {
                        if (WindowManagerService.this.mAppTransition.isTransitionSet() || !WindowManagerService.this.mOpeningApps.isEmpty() || !WindowManagerService.this.mClosingApps.isEmpty()) {
                            WindowManagerService.this.mAppTransition.setTimeout();
                            WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        }
                        break;
                    }
                }
                case 14: {
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "window_animation_scale", WindowManagerService.this.mWindowAnimationScaleSetting);
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "transition_animation_scale", WindowManagerService.this.mTransitionAnimationScaleSetting);
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "animator_duration_scale", WindowManagerService.this.mAnimatorDurationScaleSetting);
                    break;
                }
                case 51: {
                    int mode = msg.arg1;
                    switch (mode) {
                        case 0: {
                            WindowManagerService.this.mWindowAnimationScaleSetting = Settings.Global.getFloat(WindowManagerService.this.mContext.getContentResolver(), "window_animation_scale", WindowManagerService.this.mWindowAnimationScaleSetting);
                            break;
                        }
                        case 1: {
                            WindowManagerService.this.mTransitionAnimationScaleSetting = Settings.Global.getFloat(WindowManagerService.this.mContext.getContentResolver(), "transition_animation_scale", WindowManagerService.this.mTransitionAnimationScaleSetting);
                            break;
                        }
                        case 2: {
                            WindowManagerService.this.mAnimatorDurationScaleSetting = Settings.Global.getFloat(WindowManagerService.this.mContext.getContentResolver(), "animator_duration_scale", WindowManagerService.this.mAnimatorDurationScaleSetting);
                            WindowManagerService.this.dispatchNewAnimatorScaleLocked(null);
                        }
                    }
                    break;
                }
                case 15: {
                    HashMap<IBinder, WindowState> mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        if (WindowManagerService.this.mAnimator.isAnimating() || WindowManagerService.this.mAnimationScheduled) {
                            this.sendEmptyMessageDelayed(15, 2000L);
                            return;
                        }
                        if (WindowManagerService.this.mDisplayFrozen) {
                            return;
                        }
                    }
                    Runtime.getRuntime().gc();
                    break;
                }
                case 16: {
                    WindowManagerService.this.performEnableScreen();
                    break;
                }
                case 17: {
                    HashMap<IBinder, WindowState> mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        Slog.w(WindowManagerService.TAG, "App freeze timeout expired.");
                        WindowManagerService.this.mWindowsFreezingScreen = 2;
                        for (int i = WindowManagerService.this.mAppFreezeListeners.size() - 1; i >= 0; --i) {
                            WindowManagerService.this.mAppFreezeListeners.get(i).onAppFreezeTimeout();
                        }
                        break;
                    }
                }
                case 30: {
                    HashMap<IBinder, WindowState> mode = WindowManagerService.this.mWindowMap;
                    synchronized (mode) {
                        if (WindowManagerService.this.mClientFreezingScreen) {
                            WindowManagerService.this.mClientFreezingScreen = false;
                            WindowManagerService.this.mLastFinishedFreezeSource = "client-timeout";
                            WindowManagerService.this.stopFreezingDisplayLocked();
                        }
                        break;
                    }
                }
                case 18: {
                    this.removeMessages(18, msg.obj);
                    int displayId = (Integer)msg.obj;
                    if (WindowManagerService.this.mRoot.getDisplayContent(displayId) == null) break;
                    WindowManagerService.this.sendNewConfiguration(displayId);
                    break;
                }
                case 19: {
                    if (!WindowManagerService.this.mWindowsChanged) break;
                    HashMap<IBinder, WindowState> displayId = WindowManagerService.this.mWindowMap;
                    synchronized (displayId) {
                        WindowManagerService.this.mWindowsChanged = false;
                    }
                    WindowManagerService.this.notifyWindowsChanged();
                    break;
                }
                case 20: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.unregister();
                            WindowManagerService.this.mDragState.reset();
                            WindowManagerService.this.mDragState = null;
                        }
                        break;
                    }
                }
                case 21: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.mDragResult = false;
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                        break;
                    }
                }
                case 44: {
                    DragState.InputInterceptor interceptor = (DragState.InputInterceptor)msg.obj;
                    if (interceptor == null) break;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        interceptor.tearDown();
                        break;
                    }
                }
                case 22: {
                    WindowManagerService.this.notifyHardKeyboardStatusChange();
                    break;
                }
                case 23: {
                    WindowManagerService.this.performBootTimeout();
                    break;
                }
                case 24: {
                    Runnable callback = null;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        Slog.w(WindowManagerService.TAG, "Timeout waiting for drawn: undrawn=" + WindowManagerService.this.mWaitingForDrawn);
                        WindowManagerService.this.mWaitingForDrawn.clear();
                        callback = WindowManagerService.this.mWaitingForDrawnCallback;
                        WindowManagerService.this.mWaitingForDrawnCallback = null;
                    }
                    if (callback == null) break;
                    callback.run();
                    break;
                }
                case 25: {
                    WindowManagerService.this.showStrictModeViolation(msg.arg1, msg.arg2);
                    break;
                }
                case 35: {
                    WindowManagerService.this.showCircularMask(msg.arg1 == 1);
                    break;
                }
                case 36: {
                    WindowManagerService.this.showEmulatorDisplayOverlay();
                    break;
                }
                case 26: {
                    try {
                        ((IRemoteCallback)msg.obj).sendResult(null);
                    }
                    catch (RemoteException callback) {}
                    break;
                }
                case 27: {
                    WindowManagerService.this.handleDisplayAdded(msg.arg1);
                    break;
                }
                case 28: {
                    HashMap<IBinder, WindowState> callback = WindowManagerService.this.mWindowMap;
                    synchronized (callback) {
                        WindowManagerService.this.handleDisplayRemovedLocked(msg.arg1);
                        break;
                    }
                }
                case 29: {
                    HashMap<IBinder, WindowState> callback = WindowManagerService.this.mWindowMap;
                    synchronized (callback) {
                        WindowManagerService.this.handleDisplayChangedLocked(msg.arg1);
                        break;
                    }
                }
                case 31: {
                    WindowManagerService.this.handleTapOutsideTask((DisplayContent)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 40: {
                    WindowManagerService.this.finishPositioning();
                    break;
                }
                case 32: {
                    try {
                        WindowManagerService.this.mActivityManager.notifyActivityDrawn((IBinder)msg.obj);
                    }
                    catch (RemoteException callback) {}
                    break;
                }
                case 33: {
                    Runnable callback;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        callback = WindowManagerService.this.mWaitingForDrawnCallback;
                        WindowManagerService.this.mWaitingForDrawnCallback = null;
                    }
                    if (callback != null) {
                        callback.run();
                    }
                }
                case 34: {
                    float scale = WindowManagerService.this.getCurrentAnimatorScale();
                    ValueAnimator.setDurationScale(scale);
                    Session session = (Session)msg.obj;
                    if (session != null) {
                        try {
                            session.mCallback.onAnimatorScaleChanged(scale);
                        }
                        catch (RemoteException i) {}
                        break;
                    }
                    ArrayList<IWindowSessionCallback> callbacks = new ArrayList<IWindowSessionCallback>();
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        for (int i = 0; i < WindowManagerService.this.mSessions.size(); ++i) {
                            callbacks.add(WindowManagerService.this.mSessions.valueAt((int)i).mCallback);
                        }
                    }
                    for (int i = 0; i < callbacks.size(); ++i) {
                        try {
                            ((IWindowSessionCallback)callbacks.get(i)).onAnimatorScaleChanged(scale);
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    break;
                }
                case 37: {
                    boolean bootAnimationComplete;
                    HashMap<IBinder, WindowState> session = WindowManagerService.this.mWindowMap;
                    synchronized (session) {
                        bootAnimationComplete = WindowManagerService.this.checkBootAnimationCompleteLocked();
                    }
                    if (!bootAnimationComplete) break;
                    WindowManagerService.this.performEnableScreen();
                    break;
                }
                case 38: {
                    HashMap<IBinder, WindowState> bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        WindowManagerService.this.mLastANRState = null;
                        break;
                    }
                }
                case 39: {
                    HashMap<IBinder, WindowState> bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        if (WindowManagerService.this.mRoot.mWallpaperController.processWallpaperDrawPendingTimeout()) {
                            WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        }
                    }
                }
                case 41: {
                    HashMap<IBinder, WindowState> bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        DisplayContent displayContent = WindowManagerService.this.getDefaultDisplayContentLocked();
                        displayContent.getDockedDividerController().reevaluateVisibility(false);
                        displayContent.adjustForImeIfNeeded();
                        break;
                    }
                }
                case 46: {
                    HashMap<IBinder, WindowState> bootAnimationComplete = WindowManagerService.this.mWindowMap;
                    synchronized (bootAnimationComplete) {
                        for (int i = WindowManagerService.this.mWindowReplacementTimeouts.size() - 1; i >= 0; --i) {
                            AppWindowToken token = WindowManagerService.this.mWindowReplacementTimeouts.get(i);
                            token.onWindowReplacementTimeout();
                        }
                        WindowManagerService.this.mWindowReplacementTimeouts.clear();
                    }
                }
                case 47: {
                    WindowManagerService.this.mAmInternal.notifyAppTransitionStarting(msg.arg1);
                    break;
                }
                case 48: {
                    WindowManagerService.this.mAmInternal.notifyAppTransitionCancelled();
                    break;
                }
                case 49: {
                    WindowManagerService.this.mAmInternal.notifyAppTransitionFinished();
                    break;
                }
                case 50: {
                    WindowManagerService.this.mAmInternal.notifyStartingWindowDrawn();
                    break;
                }
                case 52: {
                    WindowState window = (WindowState)msg.obj;
                    HashMap<IBinder, WindowState> i = WindowManagerService.this.mWindowMap;
                    synchronized (i) {
                        window.mAttrs.flags &= 0xFFFFFF7F;
                        window.hidePermanentlyLw();
                        window.setDisplayLayoutNeeded();
                        WindowManagerService.this.mWindowPlacerLocked.performSurfacePlacement();
                        break;
                    }
                }
                case 53: {
                    WindowManagerService.this.mAmInternal.notifyDockedStackMinimizedChanged(msg.arg1 == 1);
                    break;
                }
                case 55: {
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        WindowManagerService.this.restorePointerIconLocked((DisplayContent)msg.obj, msg.arg1, msg.arg2);
                        break;
                    }
                }
                case 54: {
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        DisplayContent dc = WindowManagerService.this.getDefaultDisplayContentLocked();
                        dc.onSeamlessRotationTimeout();
                        break;
                    }
                }
                case 56: {
                    WindowManagerService.this.mAmInternal.notifyKeyguardFlagsChanged((Runnable)msg.obj);
                    break;
                }
                case 57: {
                    WindowManagerService.this.mAmInternal.notifyKeyguardTrustedChanged();
                    break;
                }
                case 58: {
                    WindowManagerService.this.mAmInternal.setHasOverlayUi(msg.arg1, msg.arg2 == 1);
                }
            }
        }
    }

    static interface AppFreezeListener {
        public void onAppFreezeTimeout();
    }

    public static interface WindowChangeListener {
        public void windowsChanged();

        public void focusChanged();
    }

    final class DragInputEventReceiver
    extends InputEventReceiver {
        private boolean mStylusButtonDownAtStart;
        private boolean mIsStartEvent;
        private boolean mMuteInput;

        public DragInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
            this.mIsStartEvent = true;
            this.mMuteInput = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInputEvent(InputEvent event) {
            block29: {
                boolean handled = false;
                try {
                    HashMap<IBinder, WindowState> hashMap;
                    boolean isStylusButtonDown;
                    if (WindowManagerService.this.mDragState == null) {
                        handled = true;
                        return;
                    }
                    if (!(event instanceof MotionEvent) || (event.getSource() & 2) == 0 || this.mMuteInput) break block29;
                    MotionEvent motionEvent = (MotionEvent)event;
                    boolean endDrag = false;
                    float newX = motionEvent.getRawX();
                    float newY = motionEvent.getRawY();
                    boolean bl = isStylusButtonDown = (motionEvent.getButtonState() & 0x20) != 0;
                    if (this.mIsStartEvent) {
                        if (isStylusButtonDown) {
                            this.mStylusButtonDownAtStart = true;
                        }
                        this.mIsStartEvent = false;
                    }
                    switch (motionEvent.getAction()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            if (this.mStylusButtonDownAtStart && !isStylusButtonDown) {
                                this.mMuteInput = true;
                                hashMap = WindowManagerService.this.mWindowMap;
                                synchronized (hashMap) {
                                    endDrag = WindowManagerService.this.mDragState.notifyDropLw(newX, newY);
                                    break;
                                }
                            }
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                WindowManagerService.this.mDragState.notifyMoveLw(newX, newY);
                                break;
                            }
                        }
                        case 1: {
                            this.mMuteInput = true;
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                endDrag = WindowManagerService.this.mDragState.notifyDropLw(newX, newY);
                                break;
                            }
                        }
                        case 3: {
                            this.mMuteInput = true;
                            endDrag = true;
                        }
                    }
                    if (endDrag) {
                        hashMap = WindowManagerService.this.mWindowMap;
                        synchronized (hashMap) {
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                        this.mStylusButtonDownAtStart = false;
                        this.mIsStartEvent = true;
                    }
                    handled = true;
                }
                catch (Exception e) {
                    Slog.e(WindowManagerService.TAG, "Exception caught by drag handleMotion", e);
                }
                finally {
                    this.finishInputEvent(event, handled);
                }
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri mDisplayInversionEnabledUri;
        private final Uri mWindowAnimationScaleUri;
        private final Uri mTransitionAnimationScaleUri;
        private final Uri mAnimationDurationScaleUri;

        public SettingsObserver() {
            super(new Handler());
            this.mDisplayInversionEnabledUri = Settings.Secure.getUriFor("accessibility_display_inversion_enabled");
            this.mWindowAnimationScaleUri = Settings.Global.getUriFor("window_animation_scale");
            this.mTransitionAnimationScaleUri = Settings.Global.getUriFor("transition_animation_scale");
            this.mAnimationDurationScaleUri = Settings.Global.getUriFor("animator_duration_scale");
            ContentResolver resolver = WindowManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.mDisplayInversionEnabledUri, false, this, -1);
            resolver.registerContentObserver(this.mWindowAnimationScaleUri, false, this, -1);
            resolver.registerContentObserver(this.mTransitionAnimationScaleUri, false, this, -1);
            resolver.registerContentObserver(this.mAnimationDurationScaleUri, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (uri == null) {
                return;
            }
            if (this.mDisplayInversionEnabledUri.equals(uri)) {
                WindowManagerService.this.updateCircularDisplayMaskIfNeeded();
            } else {
                int mode;
                if (this.mWindowAnimationScaleUri.equals(uri)) {
                    mode = 0;
                } else if (this.mTransitionAnimationScaleUri.equals(uri)) {
                    mode = 1;
                } else if (this.mAnimationDurationScaleUri.equals(uri)) {
                    mode = 2;
                } else {
                    return;
                }
                Message m = WindowManagerService.this.mH.obtainMessage(51, mode, 0);
                WindowManagerService.this.mH.sendMessage(m);
            }
        }
    }

    class RotationWatcher {
        IRotationWatcher watcher;
        IBinder.DeathRecipient deathRecipient;

        RotationWatcher(IRotationWatcher w, IBinder.DeathRecipient d) {
            this.watcher = w;
            this.deathRecipient = d;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    private static @interface UpdateAnimationScaleMode {
    }
}

