/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PixelFormat;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Trace;
import android.util.Slog;
import android.view.DisplayInfo;
import android.view.MagnificationSpec;
import android.view.Surface;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.Transformation;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Session;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowSurfaceController;
import java.io.FileDescriptor;
import java.io.PrintWriter;

class WindowStateAnimator {
    static final String TAG = "WindowManager";
    static final int WINDOW_FREEZE_LAYER = 2000000;
    static final int STACK_CLIP_AFTER_ANIM = 0;
    static final int STACK_CLIP_BEFORE_ANIM = 1;
    static final int STACK_CLIP_NONE = 2;
    final WindowManagerService mService;
    final WindowState mWin;
    private final WindowStateAnimator mParentWinAnimator;
    final WindowAnimator mAnimator;
    AppWindowAnimator mAppAnimator;
    final Session mSession;
    final WindowManagerPolicy mPolicy;
    final Context mContext;
    final boolean mIsWallpaper;
    private final WallpaperController mWallpaperControllerLocked;
    boolean mAnimating;
    boolean mLocalAnimating;
    Animation mAnimation;
    boolean mAnimationIsEntrance;
    boolean mHasTransformation;
    boolean mHasLocalTransformation;
    final Transformation mTransformation = new Transformation();
    boolean mWasAnimating;
    int mAnimLayer;
    int mLastLayer;
    long mAnimationStartTime;
    long mLastAnimationTime;
    int mStackClip = 1;
    boolean mSurfaceResized;
    boolean mReportSurfaceResized;
    WindowSurfaceController mSurfaceController;
    private WindowSurfaceController mPendingDestroySurface;
    boolean mSurfaceDestroyDeferred;
    private boolean mDestroyPreservedSurfaceUponRedraw;
    float mShownAlpha = 0.0f;
    float mAlpha = 0.0f;
    float mLastAlpha = 0.0f;
    boolean mHasClipRect;
    Rect mClipRect = new Rect();
    Rect mTmpClipRect = new Rect();
    Rect mTmpFinalClipRect = new Rect();
    Rect mLastClipRect = new Rect();
    Rect mLastFinalClipRect = new Rect();
    Rect mTmpStackBounds = new Rect();
    private final Rect mSystemDecorRect = new Rect();
    private final Rect mLastSystemDecorRect = new Rect();
    private int mAnimDx;
    private int mAnimDy;
    private boolean mAnimateMove = false;
    float mDsDx = 1.0f;
    float mDtDx = 0.0f;
    float mDsDy = 0.0f;
    float mDtDy = 1.0f;
    float mLastDsDx = 1.0f;
    float mLastDtDx = 0.0f;
    float mLastDsDy = 0.0f;
    float mLastDtDy = 1.0f;
    boolean mHaveMatrix;
    boolean mEnterAnimationPending;
    boolean mEnteringAnimation;
    private boolean mAnimationStartDelayed;
    int mSurfaceFormat;
    static final int NO_SURFACE = 0;
    static final int DRAW_PENDING = 1;
    static final int COMMIT_DRAW_PENDING = 2;
    static final int READY_TO_SHOW = 3;
    static final int HAS_DRAWN = 4;
    int mDrawState;
    boolean mLastHidden;
    int mAttrType;
    static final long PENDING_TRANSACTION_FINISH_WAIT_TIME = 100L;
    boolean mForceScaleUntilResize;
    float mExtraHScale = 1.0f;
    float mExtraVScale = 1.0f;
    private final Rect mTmpSize = new Rect();

    String drawStateToString() {
        switch (this.mDrawState) {
            case 0: {
                return "NO_SURFACE";
            }
            case 1: {
                return "DRAW_PENDING";
            }
            case 2: {
                return "COMMIT_DRAW_PENDING";
            }
            case 3: {
                return "READY_TO_SHOW";
            }
            case 4: {
                return "HAS_DRAWN";
            }
        }
        return Integer.toString(this.mDrawState);
    }

    WindowStateAnimator(WindowState win) {
        WindowManagerService service;
        this.mService = service = win.mService;
        this.mAnimator = service.mAnimator;
        this.mPolicy = service.mPolicy;
        this.mContext = service.mContext;
        DisplayContent displayContent = win.getDisplayContent();
        if (displayContent != null) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            this.mAnimDx = displayInfo.appWidth;
            this.mAnimDy = displayInfo.appHeight;
        } else {
            Slog.w(TAG, "WindowStateAnimator ctor: Display has been removed");
        }
        this.mWin = win;
        this.mParentWinAnimator = !win.isChildWindow() ? null : win.getParentWindow().mWinAnimator;
        this.mAppAnimator = win.mAppToken == null ? null : win.mAppToken.mAppAnimator;
        this.mSession = win.mSession;
        this.mAttrType = win.mAttrs.type;
        this.mIsWallpaper = win.mIsWallpaper;
        this.mWallpaperControllerLocked = this.mService.mRoot.mWallpaperController;
    }

    public void setAnimation(Animation anim2, long startTime, int stackClip) {
        this.mAnimating = false;
        this.mLocalAnimating = false;
        this.mAnimation = anim2;
        this.mAnimation.restrictDuration(10000L);
        this.mAnimation.scaleCurrentDuration(this.mService.getWindowAnimationScaleLocked());
        this.mTransformation.clear();
        this.mTransformation.setAlpha(this.mLastHidden ? 0.0f : 1.0f);
        this.mHasLocalTransformation = true;
        this.mAnimationStartTime = startTime;
        this.mStackClip = stackClip;
    }

    public void setAnimation(Animation anim2, int stackClip) {
        this.setAnimation(anim2, -1L, stackClip);
    }

    public void setAnimation(Animation anim2) {
        this.setAnimation(anim2, -1L, 0);
    }

    public void clearAnimation() {
        if (this.mAnimation != null) {
            this.mAnimating = true;
            this.mLocalAnimating = false;
            this.mAnimation.cancel();
            this.mAnimation = null;
            this.mStackClip = 1;
        }
    }

    boolean isAnimationSet() {
        return this.mAnimation != null || this.mParentWinAnimator != null && this.mParentWinAnimator.mAnimation != null || this.mAppAnimator != null && this.mAppAnimator.isAnimating();
    }

    boolean isAnimationStarting() {
        return this.isAnimationSet() && !this.mAnimating;
    }

    boolean isDummyAnimation() {
        return this.mAppAnimator != null && this.mAppAnimator.animation == AppWindowAnimator.sDummyAnimation;
    }

    boolean isWindowAnimationSet() {
        return this.mAnimation != null;
    }

    boolean isWaitingForOpening() {
        return this.mService.mAppTransition.isTransitionSet() && this.isDummyAnimation() && this.mService.mOpeningApps.contains(this.mWin.mAppToken);
    }

    void cancelExitAnimationForNextAnimationLocked() {
        if (this.mAnimation != null) {
            this.mAnimation.cancel();
            this.mAnimation = null;
            this.mLocalAnimating = false;
            this.mWin.destroyOrSaveSurface();
        }
    }

    private boolean stepAnimation(long currentTime) {
        if (this.mAnimation == null || !this.mLocalAnimating) {
            return false;
        }
        currentTime = this.getAnimationFrameTime(this.mAnimation, currentTime);
        this.mTransformation.clear();
        boolean more = this.mAnimation.getTransformation(currentTime, this.mTransformation);
        if (this.mAnimationStartDelayed && this.mAnimationIsEntrance) {
            this.mTransformation.setAlpha(0.0f);
        }
        return more;
    }

    boolean stepAnimationLocked(long currentTime) {
        this.mWasAnimating = this.mAnimating;
        DisplayContent displayContent = this.mWin.getDisplayContent();
        if (displayContent != null && this.mService.okToDisplay()) {
            if (this.mWin.isDrawnLw() && this.mAnimation != null) {
                this.mHasTransformation = true;
                this.mHasLocalTransformation = true;
                if (!this.mLocalAnimating) {
                    DisplayInfo displayInfo = displayContent.getDisplayInfo();
                    if (this.mAnimateMove) {
                        this.mAnimateMove = false;
                        this.mAnimation.initialize(this.mWin.mFrame.width(), this.mWin.mFrame.height(), this.mAnimDx, this.mAnimDy);
                    } else {
                        this.mAnimation.initialize(this.mWin.mFrame.width(), this.mWin.mFrame.height(), displayInfo.appWidth, displayInfo.appHeight);
                    }
                    this.mAnimDx = displayInfo.appWidth;
                    this.mAnimDy = displayInfo.appHeight;
                    this.mAnimation.setStartTime(this.mAnimationStartTime != -1L ? this.mAnimationStartTime : currentTime);
                    this.mLocalAnimating = true;
                    this.mAnimating = true;
                }
                if (this.mAnimation != null && this.mLocalAnimating) {
                    this.mLastAnimationTime = currentTime;
                    if (this.stepAnimation(currentTime)) {
                        return true;
                    }
                }
            }
            this.mHasLocalTransformation = false;
            if ((!this.mLocalAnimating || this.mAnimationIsEntrance) && this.mAppAnimator != null && this.mAppAnimator.animation != null) {
                this.mAnimating = true;
                this.mHasTransformation = true;
                this.mTransformation.clear();
                return false;
            }
            if (this.mHasTransformation) {
                this.mAnimating = true;
            } else if (this.isAnimationSet()) {
                this.mAnimating = true;
            }
        } else if (this.mAnimation != null) {
            this.mAnimating = true;
        }
        if (!this.mAnimating && !this.mLocalAnimating) {
            return false;
        }
        this.mAnimating = false;
        this.mLocalAnimating = false;
        if (this.mAnimation != null) {
            this.mAnimation.cancel();
            this.mAnimation = null;
        }
        if (this.mAnimator.mWindowDetachedWallpaper == this.mWin) {
            this.mAnimator.mWindowDetachedWallpaper = null;
        }
        this.mAnimLayer = this.mWin.getSpecialWindowAnimLayerAdjustment();
        this.mHasTransformation = false;
        this.mHasLocalTransformation = false;
        this.mStackClip = 1;
        this.mWin.checkPolicyVisibilityChange();
        this.mTransformation.clear();
        if (this.mAttrType == 2000 && this.mWin.mPolicyVisibility && displayContent != null) {
            displayContent.setLayoutNeeded();
        }
        this.mWin.onExitAnimationDone();
        int displayId = this.mWin.getDisplayId();
        this.mAnimator.setPendingLayoutChanges(displayId, 8);
        if (this.mWin.mAppToken != null) {
            this.mWin.mAppToken.updateReportedVisibilityLocked();
        }
        return false;
    }

    void hide(String reason) {
        if (!this.mLastHidden) {
            this.mLastHidden = true;
            if (this.mSurfaceController != null) {
                this.mSurfaceController.hideInTransaction(reason);
            }
        }
    }

    boolean finishDrawingLocked() {
        boolean startingWindow = this.mWin.mAttrs.type == 3;
        boolean layoutNeeded = this.mWin.clearAnimatingWithSavedSurface();
        if (this.mDrawState == 1) {
            this.mDrawState = 2;
            layoutNeeded = true;
        }
        return layoutNeeded;
    }

    boolean commitFinishDrawingLocked() {
        if (this.mDrawState != 2 && this.mDrawState != 3) {
            return false;
        }
        this.mDrawState = 3;
        boolean result = false;
        AppWindowToken atoken = this.mWin.mAppToken;
        if (atoken == null || atoken.allDrawn || this.mWin.mAttrs.type == 3) {
            result = this.mWin.performShowLocked();
        }
        return result;
    }

    void preserveSurfaceLocked() {
        if (this.mDestroyPreservedSurfaceUponRedraw) {
            this.mSurfaceDestroyDeferred = false;
            this.destroySurfaceLocked();
            this.mSurfaceDestroyDeferred = true;
            return;
        }
        if (this.mSurfaceController != null) {
            this.mSurfaceController.setLayer(this.mAnimLayer + 1);
        }
        this.mDestroyPreservedSurfaceUponRedraw = true;
        this.mSurfaceDestroyDeferred = true;
        this.destroySurfaceLocked();
    }

    void destroyPreservedSurfaceLocked() {
        if (!this.mDestroyPreservedSurfaceUponRedraw) {
            return;
        }
        this.destroyDeferredSurfaceLocked();
        this.mDestroyPreservedSurfaceUponRedraw = false;
    }

    void markPreservedSurfaceForDestroy() {
        if (this.mDestroyPreservedSurfaceUponRedraw && !this.mService.mDestroyPreservedSurface.contains(this.mWin)) {
            this.mService.mDestroyPreservedSurface.add(this.mWin);
        }
    }

    WindowSurfaceController createSurfaceLocked(int windowType, int ownerUid) {
        WindowState w = this.mWin;
        if (w.restoreSavedSurface()) {
            return this.mSurfaceController;
        }
        if (this.mSurfaceController != null) {
            return this.mSurfaceController;
        }
        w.setHasSurface(false);
        this.mDrawState = 1;
        if (w.mAppToken != null) {
            if (w.mAppToken.mAppAnimator.animation == null) {
                w.mAppToken.clearAllDrawn();
            } else {
                w.mAppToken.deferClearAllDrawn = true;
            }
        }
        this.mService.makeWindowFreezingScreenIfNeededLocked(w);
        int flags = 4;
        WindowManager.LayoutParams attrs = w.mAttrs;
        if (this.mService.isSecureLocked(w)) {
            flags |= 0x80;
        }
        this.mTmpSize.set(w.mFrame.left + w.mXOffset, w.mFrame.top + w.mYOffset, 0, 0);
        this.calculateSurfaceBounds(w, attrs);
        int width = this.mTmpSize.width();
        int height = this.mTmpSize.height();
        this.mLastSystemDecorRect.set(0, 0, 0, 0);
        this.mHasClipRect = false;
        this.mClipRect.set(0, 0, 0, 0);
        this.mLastClipRect.set(0, 0, 0, 0);
        try {
            int format;
            boolean isHwAccelerated = (attrs.flags & 0x1000000) != 0;
            int n = format = isHwAccelerated ? -3 : attrs.format;
            if (!PixelFormat.formatHasAlpha(attrs.format) && attrs.surfaceInsets.left == 0 && attrs.surfaceInsets.top == 0 && attrs.surfaceInsets.right == 0 && attrs.surfaceInsets.bottom == 0 && !w.isDragResizing()) {
                flags |= 0x400;
            }
            this.mSurfaceController = new WindowSurfaceController(this.mSession.mSurfaceSession, attrs.getTitle().toString(), width, height, format, flags, this, windowType, ownerUid);
            w.setHasSurface(true);
        }
        catch (Surface.OutOfResourcesException e) {
            Slog.w(TAG, "OutOfResourcesException creating surface");
            this.mService.mRoot.reclaimSomeSurfaceMemory(this, "create", true);
            this.mDrawState = 0;
            return null;
        }
        catch (Exception e) {
            Slog.e(TAG, "Exception creating surface", e);
            this.mDrawState = 0;
            return null;
        }
        int layerStack = w.getDisplayContent().getDisplay().getLayerStack();
        this.mSurfaceController.setPositionAndLayer(this.mTmpSize.left, this.mTmpSize.top, layerStack, this.mAnimLayer);
        this.mLastHidden = true;
        return this.mSurfaceController;
    }

    private void calculateSurfaceBounds(WindowState w, WindowManager.LayoutParams attrs) {
        if ((attrs.flags & 0x4000) != 0) {
            this.mTmpSize.right = this.mTmpSize.left + w.mRequestedWidth;
            this.mTmpSize.bottom = this.mTmpSize.top + w.mRequestedHeight;
        } else if (w.isDragResizing()) {
            if (w.getResizeMode() == 0) {
                this.mTmpSize.left = 0;
                this.mTmpSize.top = 0;
            }
            DisplayInfo displayInfo = w.getDisplayInfo();
            this.mTmpSize.right = this.mTmpSize.left + displayInfo.logicalWidth;
            this.mTmpSize.bottom = this.mTmpSize.top + displayInfo.logicalHeight;
        } else {
            this.mTmpSize.right = this.mTmpSize.left + w.mCompatFrame.width();
            this.mTmpSize.bottom = this.mTmpSize.top + w.mCompatFrame.height();
        }
        if (this.mTmpSize.width() < 1) {
            this.mTmpSize.right = this.mTmpSize.left + 1;
        }
        if (this.mTmpSize.height() < 1) {
            this.mTmpSize.bottom = this.mTmpSize.top + 1;
        }
        this.mTmpSize.left -= attrs.surfaceInsets.left;
        this.mTmpSize.top -= attrs.surfaceInsets.top;
        this.mTmpSize.right += attrs.surfaceInsets.right;
        this.mTmpSize.bottom += attrs.surfaceInsets.bottom;
    }

    boolean hasSurface() {
        return !this.mWin.hasSavedSurface() && this.mSurfaceController != null && this.mSurfaceController.hasSurface();
    }

    void destroySurfaceLocked() {
        AppWindowToken wtoken = this.mWin.mAppToken;
        if (wtoken != null && this.mWin == wtoken.startingWindow) {
            wtoken.startingDisplayed = false;
        }
        this.mWin.clearHasSavedSurface();
        if (this.mSurfaceController == null) {
            return;
        }
        if (!this.mDestroyPreservedSurfaceUponRedraw) {
            this.mWin.mHidden = true;
        }
        try {
            if (this.mSurfaceDestroyDeferred) {
                if (this.mSurfaceController != null && this.mPendingDestroySurface != this.mSurfaceController) {
                    if (this.mPendingDestroySurface != null) {
                        this.mPendingDestroySurface.destroyInTransaction();
                    }
                    this.mPendingDestroySurface = this.mSurfaceController;
                }
            } else {
                this.destroySurface();
            }
            if (!this.mDestroyPreservedSurfaceUponRedraw) {
                this.mWallpaperControllerLocked.hideWallpapers(this.mWin);
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Exception thrown when destroying Window " + this + " surface " + this.mSurfaceController + " session " + this.mSession + ": " + e.toString());
        }
        this.mWin.setHasSurface(false);
        if (this.mSurfaceController != null) {
            this.mSurfaceController.setShown(false);
        }
        this.mSurfaceController = null;
        this.mDrawState = 0;
    }

    void destroyDeferredSurfaceLocked() {
        try {
            if (this.mPendingDestroySurface != null) {
                this.mPendingDestroySurface.destroyInTransaction();
                if (!this.mDestroyPreservedSurfaceUponRedraw) {
                    this.mWallpaperControllerLocked.hideWallpapers(this.mWin);
                }
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Exception thrown when destroying Window " + this + " surface " + this.mPendingDestroySurface + " session " + this.mSession + ": " + e.toString());
        }
        this.mSurfaceDestroyDeferred = false;
        this.mPendingDestroySurface = null;
    }

    void applyMagnificationSpec(MagnificationSpec spec, Matrix transform) {
        int surfaceInsetLeft = this.mWin.mAttrs.surfaceInsets.left;
        int surfaceInsetTop = this.mWin.mAttrs.surfaceInsets.top;
        if (spec != null && !spec.isNop()) {
            float scale = spec.scale;
            transform.postScale(scale, scale);
            transform.postTranslate(spec.offsetX, spec.offsetY);
            transform.postTranslate(-((float)surfaceInsetLeft * scale - (float)surfaceInsetLeft), -((float)surfaceInsetTop * scale - (float)surfaceInsetTop));
        }
    }

    void computeShownFrameLocked() {
        int displayId;
        ScreenRotationAnimation screenRotationAnimation;
        boolean selfTransformation = this.mHasLocalTransformation;
        Transformation attachedTransformation = this.mParentWinAnimator != null && this.mParentWinAnimator.mHasLocalTransformation ? this.mParentWinAnimator.mTransformation : null;
        Transformation appTransformation = this.mAppAnimator != null && this.mAppAnimator.hasTransformation ? this.mAppAnimator.transformation : null;
        WindowState wallpaperTarget = this.mWallpaperControllerLocked.getWallpaperTarget();
        if (this.mIsWallpaper && wallpaperTarget != null && this.mService.mAnimateWallpaperWithTarget) {
            AppWindowAnimator wpAppAnimator;
            WindowStateAnimator wallpaperAnimator = wallpaperTarget.mWinAnimator;
            if (wallpaperAnimator.mHasLocalTransformation && wallpaperAnimator.mAnimation != null && !wallpaperAnimator.mAnimation.getDetachWallpaper()) {
                attachedTransformation = wallpaperAnimator.mTransformation;
            }
            AppWindowAnimator appWindowAnimator = wpAppAnimator = wallpaperTarget.mAppToken == null ? null : wallpaperTarget.mAppToken.mAppAnimator;
            if (wpAppAnimator != null && wpAppAnimator.hasTransformation && wpAppAnimator.animation != null && !wpAppAnimator.animation.getDetachWallpaper()) {
                appTransformation = wpAppAnimator.transformation;
            }
        }
        boolean screenAnimation = (screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId = this.mWin.getDisplayId())) != null && screenRotationAnimation.isAnimating();
        this.mHasClipRect = false;
        if (selfTransformation || attachedTransformation != null || appTransformation != null || screenAnimation) {
            Rect frame = this.mWin.mFrame;
            float[] tmpFloats = this.mService.mTmpFloats;
            Matrix tmpMatrix = this.mWin.mTmpMatrix;
            if (screenAnimation && screenRotationAnimation.isRotating()) {
                float w = frame.width();
                float h = frame.height();
                if (w >= 1.0f && h >= 1.0f) {
                    tmpMatrix.setScale(1.0f + 2.0f / w, 1.0f + 2.0f / h, w / 2.0f, h / 2.0f);
                } else {
                    tmpMatrix.reset();
                }
            } else {
                tmpMatrix.reset();
            }
            tmpMatrix.postScale(this.mWin.mGlobalScale, this.mWin.mGlobalScale);
            if (selfTransformation) {
                tmpMatrix.postConcat(this.mTransformation.getMatrix());
            }
            if (attachedTransformation != null) {
                tmpMatrix.postConcat(attachedTransformation.getMatrix());
            }
            if (appTransformation != null) {
                tmpMatrix.postConcat(appTransformation.getMatrix());
            }
            tmpMatrix.postTranslate(frame.left + this.mWin.mXOffset, frame.top + this.mWin.mYOffset);
            if (screenAnimation) {
                tmpMatrix.postConcat(screenRotationAnimation.getEnterTransformation().getMatrix());
            }
            if (this.mService.mAccessibilityController != null && displayId == 0) {
                MagnificationSpec spec = this.mService.mAccessibilityController.getMagnificationSpecForWindowLocked(this.mWin);
                this.applyMagnificationSpec(spec, tmpMatrix);
            }
            this.mHaveMatrix = true;
            tmpMatrix.getValues(tmpFloats);
            this.mDsDx = tmpFloats[0];
            this.mDtDx = tmpFloats[3];
            this.mDsDy = tmpFloats[1];
            this.mDtDy = tmpFloats[4];
            float x = tmpFloats[2];
            float y = tmpFloats[5];
            this.mWin.mShownPosition.set(Math.round(x), Math.round(y));
            this.mShownAlpha = this.mAlpha;
            if (!this.mService.mLimitedAlphaCompositing || !PixelFormat.formatHasAlpha(this.mWin.mAttrs.format) || this.mWin.isIdentityMatrix(this.mDsDx, this.mDtDx, this.mDsDy, this.mDtDy) && x == (float)frame.left && y == (float)frame.top) {
                if (selfTransformation) {
                    this.mShownAlpha *= this.mTransformation.getAlpha();
                }
                if (attachedTransformation != null) {
                    this.mShownAlpha *= attachedTransformation.getAlpha();
                }
                if (appTransformation != null) {
                    this.mShownAlpha *= appTransformation.getAlpha();
                    if (appTransformation.hasClipRect()) {
                        this.mClipRect.set(appTransformation.getClipRect());
                        this.mHasClipRect = true;
                        if (this.mWin.layoutInParentFrame()) {
                            this.mClipRect.offset(this.mWin.mContainingFrame.left - this.mWin.mFrame.left, this.mWin.mContainingFrame.top - this.mWin.mFrame.top);
                        }
                    }
                }
                if (screenAnimation) {
                    this.mShownAlpha *= screenRotationAnimation.getEnterTransformation().getAlpha();
                }
            }
            return;
        }
        if (this.mIsWallpaper && this.mService.mRoot.mWallpaperActionPending) {
            return;
        }
        if (this.mWin.isDragResizeChanged()) {
            return;
        }
        MagnificationSpec spec = null;
        if (this.mService.mAccessibilityController != null && displayId == 0) {
            spec = this.mService.mAccessibilityController.getMagnificationSpecForWindowLocked(this.mWin);
        }
        if (spec != null) {
            Rect frame = this.mWin.mFrame;
            float[] tmpFloats = this.mService.mTmpFloats;
            Matrix tmpMatrix = this.mWin.mTmpMatrix;
            tmpMatrix.setScale(this.mWin.mGlobalScale, this.mWin.mGlobalScale);
            tmpMatrix.postTranslate(frame.left + this.mWin.mXOffset, frame.top + this.mWin.mYOffset);
            this.applyMagnificationSpec(spec, tmpMatrix);
            tmpMatrix.getValues(tmpFloats);
            this.mHaveMatrix = true;
            this.mDsDx = tmpFloats[0];
            this.mDtDx = tmpFloats[3];
            this.mDsDy = tmpFloats[1];
            this.mDtDy = tmpFloats[4];
            float x = tmpFloats[2];
            float y = tmpFloats[5];
            this.mWin.mShownPosition.set(Math.round(x), Math.round(y));
            this.mShownAlpha = this.mAlpha;
        } else {
            this.mWin.mShownPosition.set(this.mWin.mFrame.left, this.mWin.mFrame.top);
            if (this.mWin.mXOffset != 0 || this.mWin.mYOffset != 0) {
                this.mWin.mShownPosition.offset(this.mWin.mXOffset, this.mWin.mYOffset);
            }
            this.mShownAlpha = this.mAlpha;
            this.mHaveMatrix = false;
            this.mDsDx = this.mWin.mGlobalScale;
            this.mDtDx = 0.0f;
            this.mDsDy = 0.0f;
            this.mDtDy = this.mWin.mGlobalScale;
        }
    }

    private boolean useFinalClipRect() {
        return this.isAnimationSet() && this.resolveStackClip() == 0 || this.mDestroyPreservedSurfaceUponRedraw || this.mWin.inPinnedWorkspace();
    }

    private boolean calculateFinalCrop(Rect finalClipRect) {
        WindowState w = this.mWin;
        DisplayContent displayContent = w.getDisplayContent();
        finalClipRect.setEmpty();
        if (displayContent == null) {
            return false;
        }
        if (!this.shouldCropToStackBounds() || !this.useFinalClipRect()) {
            return false;
        }
        TaskStack stack = w.getTask().mStack;
        stack.getDimBounds(finalClipRect);
        w.expandForSurfaceInsets(finalClipRect);
        return true;
    }

    private boolean calculateCrop(Rect clipRect) {
        WindowState w = this.mWin;
        DisplayContent displayContent = w.getDisplayContent();
        clipRect.setEmpty();
        if (displayContent == null) {
            return false;
        }
        if (w.inPinnedWorkspace()) {
            return false;
        }
        if (w.mAttrs.type == 2013) {
            return false;
        }
        w.calculatePolicyCrop(this.mSystemDecorRect);
        boolean fullscreen = w.fillsDisplay();
        boolean isFreeformResizing = w.isDragResizing() && w.getResizeMode() == 0;
        clipRect.set(this.mHasClipRect && !fullscreen ? this.mClipRect : this.mSystemDecorRect);
        if (isFreeformResizing && !w.isChildWindow()) {
            clipRect.offset(w.mShownPosition.x, w.mShownPosition.y);
        }
        w.expandForSurfaceInsets(clipRect);
        if (this.mHasClipRect && fullscreen) {
            clipRect.intersect(this.mClipRect);
        }
        clipRect.offset(w.mAttrs.surfaceInsets.left, w.mAttrs.surfaceInsets.top);
        if (!this.useFinalClipRect()) {
            this.adjustCropToStackBounds(clipRect, isFreeformResizing);
        }
        w.transformClipRectFromScreenToSurfaceSpace(clipRect);
        if (w.hasJustMovedInStack() && this.mLastClipRect.isEmpty() && !clipRect.isEmpty()) {
            clipRect.setEmpty();
        }
        return true;
    }

    private void applyCrop(Rect clipRect, Rect finalClipRect, boolean recoveringMemory) {
        if (clipRect != null) {
            if (!clipRect.equals(this.mLastClipRect)) {
                this.mLastClipRect.set(clipRect);
                this.mSurfaceController.setCropInTransaction(clipRect, recoveringMemory);
            }
        } else {
            this.mSurfaceController.clearCropInTransaction(recoveringMemory);
        }
        if (finalClipRect == null) {
            finalClipRect = this.mService.mTmpRect;
            finalClipRect.setEmpty();
        }
        if (!finalClipRect.equals(this.mLastFinalClipRect)) {
            this.mLastFinalClipRect.set(finalClipRect);
            this.mSurfaceController.setFinalCropInTransaction(finalClipRect);
            if (this.mDestroyPreservedSurfaceUponRedraw && this.mPendingDestroySurface != null) {
                this.mPendingDestroySurface.setFinalCropInTransaction(finalClipRect);
            }
        }
    }

    private int resolveStackClip() {
        if (this.mAppAnimator != null && this.mAppAnimator.animation != null) {
            return this.mAppAnimator.getStackClip();
        }
        return this.mStackClip;
    }

    private boolean shouldCropToStackBounds() {
        WindowState w = this.mWin;
        DisplayContent displayContent = w.getDisplayContent();
        if (displayContent != null && !displayContent.isDefaultDisplay) {
            return false;
        }
        Task task = w.getTask();
        if (task == null || !task.cropWindowsToStackBounds()) {
            return false;
        }
        int stackClip = this.resolveStackClip();
        return !this.isAnimationSet() || stackClip != 2;
    }

    private void adjustCropToStackBounds(Rect clipRect, boolean isFreeformResizing) {
        int frameY;
        WindowState w = this.mWin;
        if (!this.shouldCropToStackBounds()) {
            return;
        }
        TaskStack stack = w.getTask().mStack;
        stack.getDimBounds(this.mTmpStackBounds);
        Rect surfaceInsets = w.getAttrs().surfaceInsets;
        int frameX = isFreeformResizing ? (int)this.mSurfaceController.getX() : w.mFrame.left + this.mWin.mXOffset - surfaceInsets.left;
        int n = frameY = isFreeformResizing ? (int)this.mSurfaceController.getY() : w.mFrame.top + this.mWin.mYOffset - surfaceInsets.top;
        if (ActivityManager.StackId.hasWindowShadow(stack.mStackId) && !ActivityManager.StackId.isTaskResizeAllowed(stack.mStackId)) {
            this.mTmpStackBounds.inset(-surfaceInsets.left, -surfaceInsets.top, -surfaceInsets.right, -surfaceInsets.bottom);
        }
        clipRect.left = Math.max(0, Math.max(this.mTmpStackBounds.left, frameX + clipRect.left) - frameX);
        clipRect.top = Math.max(0, Math.max(this.mTmpStackBounds.top, frameY + clipRect.top) - frameY);
        clipRect.right = Math.max(0, Math.min(this.mTmpStackBounds.right, frameX + clipRect.right) - frameX);
        clipRect.bottom = Math.max(0, Math.min(this.mTmpStackBounds.bottom, frameY + clipRect.bottom) - frameY);
    }

    void setSurfaceBoundariesLocked(boolean recoveringMemory) {
        WindowState w = this.mWin;
        Task task = w.getTask();
        if (w.isResizedWhileNotDragResizing() && !w.isGoneForLayoutLw()) {
            return;
        }
        this.mTmpSize.set(w.mShownPosition.x, w.mShownPosition.y, 0, 0);
        this.calculateSurfaceBounds(w, w.getAttrs());
        this.mExtraHScale = 1.0f;
        this.mExtraVScale = 1.0f;
        boolean wasForceScaled = this.mForceScaleUntilResize;
        boolean wasSeamlesslyRotated = w.mSeamlesslyRotated;
        this.mSurfaceResized = !w.mRelayoutCalled || w.mInRelayout ? this.mSurfaceController.setSizeInTransaction(this.mTmpSize.width(), this.mTmpSize.height(), recoveringMemory) : false;
        this.mForceScaleUntilResize = this.mForceScaleUntilResize && !this.mSurfaceResized;
        this.mService.markForSeamlessRotation(w, w.mSeamlesslyRotated && !this.mSurfaceResized);
        Rect clipRect = null;
        Rect finalClipRect = null;
        if (this.calculateCrop(this.mTmpClipRect)) {
            clipRect = this.mTmpClipRect;
        }
        if (this.calculateFinalCrop(this.mTmpFinalClipRect)) {
            finalClipRect = this.mTmpFinalClipRect;
        }
        float surfaceWidth = this.mSurfaceController.getWidth();
        float surfaceHeight = this.mSurfaceController.getHeight();
        if (this.isForceScaled()) {
            int hInsets = w.getAttrs().surfaceInsets.left + w.getAttrs().surfaceInsets.right;
            int vInsets = w.getAttrs().surfaceInsets.top + w.getAttrs().surfaceInsets.bottom;
            if (!this.mForceScaleUntilResize) {
                this.mSurfaceController.forceScaleableInTransaction(true);
            }
            task.mStack.getDimBounds(this.mTmpStackBounds);
            this.mExtraHScale = (float)this.mTmpStackBounds.width() / (surfaceWidth - (float)hInsets);
            this.mExtraVScale = (float)this.mTmpStackBounds.height() / (surfaceHeight - (float)vInsets);
            int posX = (int)((float)this.mTmpSize.left - (float)w.mAttrs.x * (1.0f - this.mExtraHScale));
            int posY = (int)((float)this.mTmpSize.top - (float)w.mAttrs.y * (1.0f - this.mExtraVScale));
            posX = (int)((float)posX + (float)w.getAttrs().surfaceInsets.left * (1.0f - this.mExtraHScale));
            posY = (int)((float)posY + (float)w.getAttrs().surfaceInsets.top * (1.0f - this.mExtraVScale));
            this.mSurfaceController.setPositionInTransaction((float)Math.floor(posX), (float)Math.floor(posY), recoveringMemory);
            clipRect = null;
            finalClipRect = null;
            this.mForceScaleUntilResize = true;
        } else if (!w.mSeamlesslyRotated) {
            this.mSurfaceController.setPositionInTransaction(this.mTmpSize.left, this.mTmpSize.top, recoveringMemory);
        }
        if (wasForceScaled && !this.mForceScaleUntilResize || wasSeamlesslyRotated && !w.mSeamlesslyRotated) {
            this.mSurfaceController.setGeometryAppliesWithResizeInTransaction(true);
            this.mSurfaceController.forceScaleableInTransaction(false);
        }
        if (!w.mSeamlesslyRotated) {
            this.applyCrop(clipRect, finalClipRect, recoveringMemory);
            this.mSurfaceController.setMatrixInTransaction(this.mDsDx * w.mHScale * this.mExtraHScale, this.mDtDx * w.mVScale * this.mExtraVScale, this.mDsDy * w.mHScale * this.mExtraHScale, this.mDtDy * w.mVScale * this.mExtraVScale, recoveringMemory);
        }
        if (this.mSurfaceResized) {
            this.mReportSurfaceResized = true;
            this.mAnimator.setPendingLayoutChanges(w.getDisplayId(), 4);
            w.applyDimLayerIfNeeded();
        }
    }

    void prepareSurfaceLocked(boolean recoveringMemory) {
        WindowState w = this.mWin;
        if (!this.hasSurface()) {
            if (w.mOrientationChanging) {
                w.mOrientationChanging = false;
            }
            return;
        }
        if (this.isWaitingForOpening()) {
            return;
        }
        boolean displayed = false;
        this.computeShownFrameLocked();
        this.setSurfaceBoundariesLocked(recoveringMemory);
        if (this.mIsWallpaper && !this.mWin.mWallpaperVisible) {
            this.hide("prepareSurfaceLocked");
        } else if (w.isParentWindowHidden() || !w.isOnScreen()) {
            this.hide("prepareSurfaceLocked");
            this.mWallpaperControllerLocked.hideWallpapers(w);
            if (w.mOrientationChanging) {
                w.mOrientationChanging = false;
            }
        } else if (this.mLastLayer != this.mAnimLayer || this.mLastAlpha != this.mShownAlpha || this.mLastDsDx != this.mDsDx || this.mLastDtDx != this.mDtDx || this.mLastDsDy != this.mDsDy || this.mLastDtDy != this.mDtDy || w.mLastHScale != w.mHScale || w.mLastVScale != w.mVScale || this.mLastHidden) {
            displayed = true;
            this.mLastAlpha = this.mShownAlpha;
            this.mLastLayer = this.mAnimLayer;
            this.mLastDsDx = this.mDsDx;
            this.mLastDtDx = this.mDtDx;
            this.mLastDsDy = this.mDsDy;
            this.mLastDtDy = this.mDtDy;
            w.mLastHScale = w.mHScale;
            w.mLastVScale = w.mVScale;
            boolean prepared = this.mSurfaceController.prepareToShowInTransaction(this.mShownAlpha, this.mAnimLayer, this.mDsDx * w.mHScale * this.mExtraHScale, this.mDtDx * w.mVScale * this.mExtraVScale, this.mDsDy * w.mHScale * this.mExtraHScale, this.mDtDy * w.mVScale * this.mExtraVScale, recoveringMemory);
            if (prepared && this.mLastHidden && this.mDrawState == 4) {
                if (this.showSurfaceRobustlyLocked()) {
                    this.markPreservedSurfaceForDestroy();
                    this.mAnimator.requestRemovalOfReplacedWindows(w);
                    this.mLastHidden = false;
                    if (this.mIsWallpaper) {
                        w.dispatchWallpaperVisibility(true);
                    }
                    this.mAnimator.setPendingLayoutChanges(w.getDisplayId(), 8);
                } else {
                    w.mOrientationChanging = false;
                }
            }
            if (this.hasSurface()) {
                w.mToken.hasVisible = true;
            }
        } else {
            displayed = true;
        }
        if (displayed) {
            if (w.mOrientationChanging) {
                if (!w.isDrawnLw()) {
                    this.mAnimator.mBulkUpdateParams &= 0xFFFFFFF7;
                    this.mAnimator.mLastWindowFreezeSource = w;
                } else {
                    w.mOrientationChanging = false;
                }
            }
            w.mToken.hasVisible = true;
        }
    }

    void setTransparentRegionHintLocked(Region region) {
        if (this.mSurfaceController == null) {
            Slog.w(TAG, "setTransparentRegionHint: null mSurface after mHasSurface true");
            return;
        }
        this.mSurfaceController.setTransparentRegionHint(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWallpaperOffset(Point shownPosition) {
        WindowManager.LayoutParams attrs = this.mWin.getAttrs();
        int left = shownPosition.x - attrs.surfaceInsets.left;
        int top = shownPosition.y - attrs.surfaceInsets.top;
        try {
            this.mService.openSurfaceTransaction();
            this.mSurfaceController.setPositionInTransaction(this.mWin.mFrame.left + left, this.mWin.mFrame.top + top, false);
            this.applyCrop(null, null, false);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error positioning surface of " + this.mWin + " pos=(" + left + "," + top + ")", e);
        }
        finally {
            this.mService.closeSurfaceTransaction();
        }
    }

    boolean tryChangeFormatInPlaceLocked() {
        int format;
        if (this.mSurfaceController == null) {
            return false;
        }
        WindowManager.LayoutParams attrs = this.mWin.getAttrs();
        boolean isHwAccelerated = (attrs.flags & 0x1000000) != 0;
        int n = format = isHwAccelerated ? -3 : attrs.format;
        if (format == this.mSurfaceFormat) {
            this.setOpaqueLocked(!PixelFormat.formatHasAlpha(attrs.format));
            return true;
        }
        return false;
    }

    void setOpaqueLocked(boolean isOpaque) {
        if (this.mSurfaceController == null) {
            return;
        }
        this.mSurfaceController.setOpaque(isOpaque);
    }

    void setSecureLocked(boolean isSecure) {
        if (this.mSurfaceController == null) {
            return;
        }
        this.mSurfaceController.setSecure(isSecure);
    }

    private boolean showSurfaceRobustlyLocked() {
        boolean shown;
        Task task = this.mWin.getTask();
        if (task != null && ActivityManager.StackId.windowsAreScaleable(task.mStack.mStackId)) {
            this.mSurfaceController.forceScaleableInTransaction(true);
        }
        if (!(shown = this.mSurfaceController.showRobustlyInTransaction())) {
            return false;
        }
        if (this.mWin.mTurnOnScreen) {
            this.mWin.mTurnOnScreen = false;
            this.mAnimator.mBulkUpdateParams |= 0x10;
        }
        return true;
    }

    void applyEnterAnimationLocked() {
        int transit;
        if (this.mWin.mSkipEnterAnimationForSeamlessReplacement) {
            return;
        }
        if (this.mEnterAnimationPending) {
            this.mEnterAnimationPending = false;
            transit = 1;
        } else {
            transit = 3;
        }
        this.applyAnimationLocked(transit, true);
        if (this.mService.mAccessibilityController != null && this.mWin.getDisplayId() == 0) {
            this.mService.mAccessibilityController.onWindowTransitionLocked(this.mWin, transit);
        }
    }

    boolean applyAnimationLocked(int transit, boolean isEntrance) {
        if (this.mLocalAnimating && this.mAnimationIsEntrance == isEntrance) {
            return true;
        }
        Trace.traceBegin(32L, "WSA#applyAnimationLocked");
        if (this.mService.okToDisplay()) {
            int anim2 = this.mPolicy.selectAnimationLw(this.mWin, transit);
            int attr2 = -1;
            Animation a = null;
            if (anim2 != 0) {
                a = anim2 != -1 ? AnimationUtils.loadAnimation(this.mContext, anim2) : null;
            } else {
                switch (transit) {
                    case 1: {
                        attr2 = 0;
                        break;
                    }
                    case 2: {
                        attr2 = 1;
                        break;
                    }
                    case 3: {
                        attr2 = 2;
                        break;
                    }
                    case 4: {
                        attr2 = 3;
                    }
                }
                if (attr2 >= 0) {
                    a = this.mService.mAppTransition.loadAnimationAttr(this.mWin.mAttrs, attr2);
                }
            }
            if (a != null) {
                this.setAnimation(a);
                this.mAnimationIsEntrance = isEntrance;
            }
        } else {
            this.clearAnimation();
        }
        Trace.traceEnd(32L);
        if (this.mWin.mAttrs.type == 2011) {
            this.mWin.getDisplayContent().adjustForImeIfNeeded();
            if (isEntrance) {
                this.mWin.setDisplayLayoutNeeded();
                this.mService.mWindowPlacerLocked.requestTraversal();
            }
        }
        return this.mAnimation != null;
    }

    private void applyFadeoutDuringKeyguardExitAnimation() {
        long elapsed;
        long startTime = this.mAnimation.getStartTime();
        long duration = this.mAnimation.getDuration();
        long fadeDuration = duration - (elapsed = this.mLastAnimationTime - startTime);
        if (fadeDuration <= 0L) {
            return;
        }
        AnimationSet newAnimation = new AnimationSet(false);
        newAnimation.setDuration(duration);
        newAnimation.setStartTime(startTime);
        newAnimation.addAnimation(this.mAnimation);
        Animation fadeOut = AnimationUtils.loadAnimation(this.mContext, 0x10A0011);
        fadeOut.setDuration(fadeDuration);
        fadeOut.setStartOffset(elapsed);
        newAnimation.addAnimation(fadeOut);
        newAnimation.initialize(this.mWin.mFrame.width(), this.mWin.mFrame.height(), this.mAnimDx, this.mAnimDy);
        this.mAnimation = newAnimation;
    }

    public void dump(PrintWriter pw, String prefix, boolean dumpAll) {
        if (this.mAnimating || this.mLocalAnimating || this.mAnimationIsEntrance || this.mAnimation != null) {
            pw.print(prefix);
            pw.print("mAnimating=");
            pw.print(this.mAnimating);
            pw.print(" mLocalAnimating=");
            pw.print(this.mLocalAnimating);
            pw.print(" mAnimationIsEntrance=");
            pw.print(this.mAnimationIsEntrance);
            pw.print(" mAnimation=");
            pw.print(this.mAnimation);
            pw.print(" mStackClip=");
            pw.println(this.mStackClip);
        }
        if (this.mHasTransformation || this.mHasLocalTransformation) {
            pw.print(prefix);
            pw.print("XForm: has=");
            pw.print(this.mHasTransformation);
            pw.print(" hasLocal=");
            pw.print(this.mHasLocalTransformation);
            pw.print(" ");
            this.mTransformation.printShortString(pw);
            pw.println();
        }
        if (this.mSurfaceController != null) {
            this.mSurfaceController.dump(pw, prefix, dumpAll);
        }
        if (dumpAll) {
            pw.print(prefix);
            pw.print("mDrawState=");
            pw.print(this.drawStateToString());
            pw.print(prefix);
            pw.print(" mLastHidden=");
            pw.println(this.mLastHidden);
            pw.print(prefix);
            pw.print("mSystemDecorRect=");
            this.mSystemDecorRect.printShortString(pw);
            pw.print(" last=");
            this.mLastSystemDecorRect.printShortString(pw);
            pw.print(" mHasClipRect=");
            pw.print(this.mHasClipRect);
            pw.print(" mLastClipRect=");
            this.mLastClipRect.printShortString(pw);
            if (!this.mLastFinalClipRect.isEmpty()) {
                pw.print(" mLastFinalClipRect=");
                this.mLastFinalClipRect.printShortString(pw);
            }
            pw.println();
        }
        if (this.mPendingDestroySurface != null) {
            pw.print(prefix);
            pw.print("mPendingDestroySurface=");
            pw.println(this.mPendingDestroySurface);
        }
        if (this.mSurfaceResized || this.mSurfaceDestroyDeferred) {
            pw.print(prefix);
            pw.print("mSurfaceResized=");
            pw.print(this.mSurfaceResized);
            pw.print(" mSurfaceDestroyDeferred=");
            pw.println(this.mSurfaceDestroyDeferred);
        }
        if (this.mShownAlpha != 1.0f || this.mAlpha != 1.0f || this.mLastAlpha != 1.0f) {
            pw.print(prefix);
            pw.print("mShownAlpha=");
            pw.print(this.mShownAlpha);
            pw.print(" mAlpha=");
            pw.print(this.mAlpha);
            pw.print(" mLastAlpha=");
            pw.println(this.mLastAlpha);
        }
        if (this.mHaveMatrix || this.mWin.mGlobalScale != 1.0f) {
            pw.print(prefix);
            pw.print("mGlobalScale=");
            pw.print(this.mWin.mGlobalScale);
            pw.print(" mDsDx=");
            pw.print(this.mDsDx);
            pw.print(" mDtDx=");
            pw.print(this.mDtDx);
            pw.print(" mDsDy=");
            pw.print(this.mDsDy);
            pw.print(" mDtDy=");
            pw.println(this.mDtDy);
        }
        if (this.mAnimationStartDelayed) {
            pw.print(prefix);
            pw.print("mAnimationStartDelayed=");
            pw.print(this.mAnimationStartDelayed);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WindowStateAnimator{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        sb.append(this.mWin.mAttrs.getTitle());
        sb.append('}');
        return sb.toString();
    }

    void reclaimSomeSurfaceMemory(String operation, boolean secure) {
        this.mService.mRoot.reclaimSomeSurfaceMemory(this, operation, secure);
    }

    boolean getShown() {
        if (this.mSurfaceController != null) {
            return this.mSurfaceController.getShown();
        }
        return false;
    }

    void destroySurface() {
        try {
            if (this.mSurfaceController != null) {
                this.mSurfaceController.destroyInTransaction();
            }
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Exception thrown when destroying surface " + this + " surface " + this.mSurfaceController + " session " + this.mSession + ": " + e);
        }
        finally {
            this.mWin.setHasSurface(false);
            this.mSurfaceController = null;
            this.mDrawState = 0;
        }
    }

    void setMoveAnimation(int left, int top) {
        Animation a = AnimationUtils.loadAnimation(this.mContext, 17432753);
        this.setAnimation(a);
        this.mAnimDx = this.mWin.mLastFrame.left - left;
        this.mAnimDy = this.mWin.mLastFrame.top - top;
        this.mAnimateMove = true;
    }

    void deferTransactionUntilParentFrame(long frameNumber) {
        if (!this.mWin.isChildWindow()) {
            return;
        }
        this.mSurfaceController.deferTransactionUntil(this.mWin.getParentWindow().mWinAnimator.mSurfaceController.getHandle(), frameNumber);
    }

    private long getAnimationFrameTime(Animation animation, long currentTime) {
        if (this.mAnimationStartDelayed) {
            animation.setStartTime(currentTime);
            return currentTime + 1L;
        }
        return currentTime;
    }

    void startDelayingAnimationStart() {
        this.mAnimationStartDelayed = true;
    }

    void endDelayingAnimationStart() {
        this.mAnimationStartDelayed = false;
    }

    void seamlesslyRotateWindow(int oldRotation, int newRotation) {
        WindowState w = this.mWin;
        if (!w.isVisibleNow() || w.mIsWallpaper) {
            return;
        }
        Rect cropRect = this.mService.mTmpRect;
        Rect displayRect = this.mService.mTmpRect2;
        RectF frameRect = this.mService.mTmpRectF;
        Matrix transform = this.mService.mTmpTransform;
        float x = w.mFrame.left;
        float y = w.mFrame.top;
        float width = w.mFrame.width();
        float height = w.mFrame.height();
        this.mService.getDefaultDisplayContentLocked().getLogicalDisplayRect(displayRect);
        float displayWidth = displayRect.width();
        float displayHeight = displayRect.height();
        int deltaRotation = DisplayContent.deltaRotation(newRotation, oldRotation);
        DisplayContent.createRotationMatrix(deltaRotation, x, y, displayWidth, displayHeight, transform);
        if (w.isChildWindow() && this.mSurfaceController.getTransformToDisplayInverse()) {
            frameRect.set(x, y, x + width, y + height);
            transform.mapRect(frameRect);
            Rect parentWindowFrame = w.getParentWindow().mFrame;
            w.mAttrs.x = (int)frameRect.left - parentWindowFrame.left;
            w.mAttrs.y = (int)frameRect.top - parentWindowFrame.top;
            w.mAttrs.width = (int)Math.ceil(frameRect.width());
            w.mAttrs.height = (int)Math.ceil(frameRect.height());
            w.setWindowScale(w.mRequestedWidth, w.mRequestedHeight);
            w.applyGravityAndUpdateFrame(w.mContainingFrame, w.mDisplayFrame);
            this.computeShownFrameLocked();
            this.setSurfaceBoundariesLocked(false);
            cropRect.set(0, 0, w.mRequestedWidth, w.mRequestedWidth + w.mRequestedHeight);
            this.mSurfaceController.setCropInTransaction(cropRect, false);
        } else {
            this.mService.markForSeamlessRotation(w, true);
            transform.getValues(this.mService.mTmpFloats);
            float DsDx = this.mService.mTmpFloats[0];
            float DtDx = this.mService.mTmpFloats[3];
            float DsDy = this.mService.mTmpFloats[1];
            float DtDy = this.mService.mTmpFloats[4];
            float nx = this.mService.mTmpFloats[2];
            float ny = this.mService.mTmpFloats[5];
            this.mSurfaceController.setPositionInTransaction(nx, ny, false);
            this.mSurfaceController.setMatrixInTransaction(DsDx * w.mHScale, DtDx * w.mVScale, DsDy * w.mHScale, DtDy * w.mVScale, false);
        }
    }

    void enableSurfaceTrace(FileDescriptor fd) {
        if (this.mSurfaceController != null) {
            this.mSurfaceController.installRemoteTrace(fd);
        }
    }

    void disableSurfaceTrace() {
        if (this.mSurfaceController != null) {
            try {
                this.mSurfaceController.removeRemoteTrace();
            }
            catch (ClassCastException e) {
                Slog.e(TAG, "Disable surface trace for " + this + " but its not enabled");
            }
        }
    }

    boolean isForceScaled() {
        Task task = this.mWin.getTask();
        if (task != null && task.mStack.isForceScaled()) {
            return true;
        }
        return this.mForceScaleUntilResize;
    }
}

