/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Debug;
import android.os.Trace;
import android.util.ArraySet;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.view.animation.Animation;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.PrintWriter;
import java.util.ArrayList;

class WindowSurfacePlacer {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private final WallpaperController mWallpaperControllerLocked;
    private boolean mInLayout = false;
    private int mLayoutRepeatCount;
    static final int SET_UPDATE_ROTATION = 1;
    static final int SET_WALLPAPER_MAY_CHANGE = 2;
    static final int SET_FORCE_HIDING_CHANGED = 4;
    static final int SET_ORIENTATION_CHANGE_COMPLETE = 8;
    static final int SET_TURN_ON_SCREEN = 16;
    static final int SET_WALLPAPER_ACTION_PENDING = 32;
    private final Rect mTmpStartRect = new Rect();
    private final Rect mTmpContentRect = new Rect();
    private boolean mTraversalScheduled;
    private int mDeferDepth = 0;
    private final LayerAndToken mTmpLayerAndToken = new LayerAndToken();
    private final ArrayList<SurfaceControl> mPendingDestroyingSurfaces = new ArrayList();

    public WindowSurfacePlacer(WindowManagerService service) {
        this.mService = service;
        this.mWallpaperControllerLocked = this.mService.mRoot.mWallpaperController;
    }

    void deferLayout() {
        ++this.mDeferDepth;
    }

    void continueLayout() {
        --this.mDeferDepth;
        if (this.mDeferDepth <= 0) {
            this.performSurfacePlacement();
        }
    }

    final void performSurfacePlacement() {
        this.performSurfacePlacement(false);
    }

    final void performSurfacePlacement(boolean force) {
        if (this.mDeferDepth > 0 && !force) {
            return;
        }
        int loopCount = 6;
        do {
            this.mTraversalScheduled = false;
            this.performSurfacePlacementLoop();
            this.mService.mH.removeMessages(4);
        } while (this.mTraversalScheduled && --loopCount > 0);
        this.mService.mRoot.mWallpaperActionPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSurfacePlacementLoop() {
        if (this.mInLayout) {
            Slog.w(TAG, "performLayoutAndPlaceSurfacesLocked called while in layout. Callers=" + Debug.getCallers(3));
            return;
        }
        if (this.mService.mWaitingForConfig) {
            return;
        }
        if (!this.mService.mDisplayReady) {
            return;
        }
        Trace.traceBegin(32L, "wmLayout");
        this.mInLayout = true;
        boolean recoveringMemory = false;
        if (!this.mService.mForceRemoves.isEmpty()) {
            Object tmp;
            recoveringMemory = true;
            while (!this.mService.mForceRemoves.isEmpty()) {
                WindowState ws = this.mService.mForceRemoves.remove(0);
                Slog.i(TAG, "Force removing: " + ws);
                ws.removeImmediately();
            }
            Slog.w(TAG, "Due to memory failure, waiting a bit for next layout");
            Object object = tmp = new Object();
            synchronized (object) {
                try {
                    tmp.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.mService.mRoot.performSurfacePlacement(recoveringMemory);
            this.mInLayout = false;
            if (this.mService.mRoot.isLayoutNeeded()) {
                if (++this.mLayoutRepeatCount < 6) {
                    this.requestTraversal();
                } else {
                    Slog.e(TAG, "Performed 6 layouts in a row. Skipping");
                    this.mLayoutRepeatCount = 0;
                }
            } else {
                this.mLayoutRepeatCount = 0;
            }
            if (this.mService.mWindowsChanged && !this.mService.mWindowChangeListeners.isEmpty()) {
                this.mService.mH.removeMessages(19);
                this.mService.mH.sendEmptyMessage(19);
            }
        }
        catch (RuntimeException e) {
            this.mInLayout = false;
            Slog.wtf(TAG, "Unhandled exception while laying out windows", e);
        }
        Trace.traceEnd(32L);
    }

    void debugLayoutRepeats(String msg, int pendingLayoutChanges) {
        if (this.mLayoutRepeatCount >= 4) {
            Slog.v(TAG, "Layouts looping: " + msg + ", mPendingLayoutChanges = 0x" + Integer.toHexString(pendingLayoutChanges));
        }
    }

    boolean isInLayout() {
        return this.mInLayout;
    }

    int handleAppTransitionReadyLocked() {
        int i;
        int appsCount = this.mService.mOpeningApps.size();
        if (!this.transitionGoodToGo(appsCount)) {
            return 0;
        }
        Trace.traceBegin(32L, "AppTransitionReady");
        int transit = this.mService.mAppTransition.getAppTransition();
        if (this.mService.mSkipAppTransitionAnimation) {
            transit = -1;
        }
        this.mService.mSkipAppTransitionAnimation = false;
        this.mService.mNoAnimationNotifyOnTransitionFinished.clear();
        this.mService.mH.removeMessages(13);
        DisplayContent displayContent = this.mService.getDefaultDisplayContentLocked();
        this.mService.mRoot.mWallpaperMayChange = false;
        WindowManager.LayoutParams animLp = null;
        int bestAnimLayer = -1;
        boolean fullscreenAnim = false;
        boolean voiceInteraction = false;
        for (i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = this.mService.mOpeningApps.valueAt(i);
            wtoken.clearAnimatingFlags();
        }
        this.mWallpaperControllerLocked.adjustWallpaperWindowsForAppTransitionIfNeeded(displayContent, this.mService.mOpeningApps);
        WindowState wallpaperTarget = this.mWallpaperControllerLocked.getWallpaperTarget();
        boolean openingAppHasWallpaper = false;
        boolean closingAppHasWallpaper = false;
        int closingAppsCount = this.mService.mClosingApps.size();
        appsCount = closingAppsCount + this.mService.mOpeningApps.size();
        for (i = 0; i < appsCount; ++i) {
            WindowState ws;
            AppWindowToken wtoken;
            if (i < closingAppsCount) {
                wtoken = this.mService.mClosingApps.valueAt(i);
                if (wallpaperTarget != null && wtoken.windowsCanBeWallpaperTarget()) {
                    closingAppHasWallpaper = true;
                }
            } else {
                wtoken = this.mService.mOpeningApps.valueAt(i - closingAppsCount);
                if (wallpaperTarget != null && wtoken.windowsCanBeWallpaperTarget()) {
                    openingAppHasWallpaper = true;
                }
            }
            voiceInteraction |= wtoken.mVoiceInteraction;
            if (wtoken.fillsParent()) {
                ws = wtoken.findMainWindow();
                if (ws == null) continue;
                animLp = ws.mAttrs;
                bestAnimLayer = ws.mLayer;
                fullscreenAnim = true;
                continue;
            }
            if (fullscreenAnim || (ws = wtoken.findMainWindow()) == null || ws.mLayer <= bestAnimLayer) continue;
            animLp = ws.mAttrs;
            bestAnimLayer = ws.mLayer;
        }
        transit = this.maybeUpdateTransitToWallpaper(transit, openingAppHasWallpaper, closingAppHasWallpaper);
        if (!this.mService.mPolicy.allowAppAnimationsLw()) {
            animLp = null;
        }
        this.processApplicationsAnimatingInPlace(transit);
        this.mTmpLayerAndToken.token = null;
        this.handleClosingApps(transit, animLp, voiceInteraction, this.mTmpLayerAndToken);
        AppWindowToken topClosingApp = this.mTmpLayerAndToken.token;
        int topClosingLayer = this.mTmpLayerAndToken.layer;
        AppWindowToken topOpeningApp = this.handleOpeningApps(transit, animLp, voiceInteraction, topClosingLayer);
        this.mService.mAppTransition.setLastAppTransition(transit, topOpeningApp, topClosingApp);
        AppWindowAnimator openingAppAnimator = topOpeningApp == null ? null : topOpeningApp.mAppAnimator;
        AppWindowAnimator closingAppAnimator = topClosingApp == null ? null : topClosingApp.mAppAnimator;
        int flags = this.mService.mAppTransition.getTransitFlags();
        int layoutRedo = this.mService.mAppTransition.goodToGo(transit, openingAppAnimator, closingAppAnimator, this.mService.mOpeningApps, this.mService.mClosingApps);
        this.handleNonAppWindowsInTransition(transit, flags);
        this.mService.mAppTransition.postAnimationCallback();
        this.mService.mAppTransition.clear();
        this.mService.mTaskSnapshotController.onTransitionStarting();
        this.mService.mOpeningApps.clear();
        this.mService.mClosingApps.clear();
        this.mService.mUnknownAppVisibilityController.clear();
        displayContent.setLayoutNeeded();
        DisplayContent dc = this.mService.getDefaultDisplayContentLocked();
        dc.computeImeTarget(true);
        this.mService.updateFocusedWindowLocked(2, true);
        this.mService.mFocusMayChange = false;
        Trace.traceEnd(32L);
        return layoutRedo | 1 | 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppWindowToken handleOpeningApps(int transit, WindowManager.LayoutParams animLp, boolean voiceInteraction, int topClosingLayer) {
        AppWindowToken topOpeningApp = null;
        int appsCount = this.mService.mOpeningApps.size();
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = this.mService.mOpeningApps.valueAt(i);
            AppWindowAnimator appAnimator = wtoken.mAppAnimator;
            if (!appAnimator.usingTransferredAnimation) {
                appAnimator.clearThumbnail();
                appAnimator.setNullAnimation();
            }
            if (!wtoken.setVisibility(animLp, true, transit, false, voiceInteraction)) {
                this.mService.mNoAnimationNotifyOnTransitionFinished.add(wtoken.token);
            }
            wtoken.updateReportedVisibilityLocked();
            wtoken.waitingToShow = false;
            wtoken.setAllAppWinAnimators();
            this.mService.openSurfaceTransaction();
            try {
                this.mService.mAnimator.orAnimating(appAnimator.showAllWindowsLocked());
            }
            finally {
                this.mService.closeSurfaceTransaction();
            }
            this.mService.mAnimator.mAppWindowAnimating |= appAnimator.isAnimating();
            int topOpeningLayer = 0;
            if (animLp != null) {
                int layer = wtoken.getHighestAnimLayer();
                if (topOpeningApp == null || layer > topOpeningLayer) {
                    topOpeningApp = wtoken;
                    topOpeningLayer = layer;
                }
            }
            if (!this.mService.mAppTransition.isNextAppTransitionThumbnailUp()) continue;
            this.createThumbnailAppAnimator(transit, wtoken, topOpeningLayer, topClosingLayer);
        }
        return topOpeningApp;
    }

    private void handleClosingApps(int transit, WindowManager.LayoutParams animLp, boolean voiceInteraction, LayerAndToken layerAndToken) {
        int appsCount = this.mService.mClosingApps.size();
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = this.mService.mClosingApps.valueAt(i);
            wtoken.markSavedSurfaceExiting();
            AppWindowAnimator appAnimator = wtoken.mAppAnimator;
            appAnimator.clearThumbnail();
            appAnimator.setNullAnimation();
            wtoken.setVisibility(animLp, false, transit, false, voiceInteraction);
            wtoken.updateReportedVisibilityLocked();
            wtoken.allDrawn = true;
            wtoken.deferClearAllDrawn = false;
            if (wtoken.startingWindow != null && !wtoken.startingWindow.mAnimatingExit && wtoken.getController() != null) {
                wtoken.getController().removeStartingWindow();
            }
            this.mService.mAnimator.mAppWindowAnimating |= appAnimator.isAnimating();
            if (animLp != null) {
                int layer = wtoken.getHighestAnimLayer();
                if (layerAndToken.token == null || layer > layerAndToken.layer) {
                    layerAndToken.token = wtoken;
                    layerAndToken.layer = layer;
                }
            }
            if (!this.mService.mAppTransition.isNextAppTransitionThumbnailDown()) continue;
            this.createThumbnailAppAnimator(transit, wtoken, 0, layerAndToken.layer);
        }
    }

    private void handleNonAppWindowsInTransition(int transit, int flags) {
        Animation anim2;
        if (transit == 20 && (flags & 4) != 0 && (flags & 2) == 0 && (anim2 = this.mService.mPolicy.createKeyguardWallpaperExit((flags & 1) != 0)) != null) {
            this.mService.getDefaultDisplayContentLocked().mWallpaperController.startWallpaperAnimation(anim2);
        }
        if (transit == 20 || transit == 21) {
            this.mService.getDefaultDisplayContentLocked().startKeyguardExitOnNonAppWindows(transit == 21, (flags & 1) != 0);
        }
    }

    private boolean transitionGoodToGo(int appsCount) {
        ScreenRotationAnimation screenRotationAnimation = this.mService.mAnimator.getScreenRotationAnimationLocked(0);
        int reason = 3;
        if (!this.mService.mAppTransition.isTimeout()) {
            boolean wallpaperReady;
            if (screenRotationAnimation != null && screenRotationAnimation.isAnimating() && this.mService.rotationNeedsUpdateLocked()) {
                return false;
            }
            for (int i = 0; i < appsCount; ++i) {
                boolean allDrawn;
                AppWindowToken wtoken = this.mService.mOpeningApps.valueAt(i);
                boolean drawnBeforeRestoring = wtoken.allDrawn;
                wtoken.restoreSavedSurfaceForInterestingWindows();
                boolean bl = allDrawn = wtoken.allDrawn && !wtoken.isRelaunching();
                if (!(allDrawn || wtoken.startingDisplayed || wtoken.startingMoved)) {
                    return false;
                }
                reason = allDrawn ? (drawnBeforeRestoring ? 2 : 0) : 1;
            }
            if (this.mService.mAppTransition.isFetchingAppTransitionsSpecs()) {
                return false;
            }
            if (!this.mService.mUnknownAppVisibilityController.allResolved()) {
                return false;
            }
            boolean bl = wallpaperReady = !this.mWallpaperControllerLocked.isWallpaperVisible() || this.mWallpaperControllerLocked.wallpaperTransitionReady();
            if (wallpaperReady) {
                this.mService.mH.obtainMessage(47, reason, 0).sendToTarget();
                return true;
            }
            return false;
        }
        this.mService.mH.obtainMessage(47, reason, 0).sendToTarget();
        return true;
    }

    private int maybeUpdateTransitToWallpaper(int transit, boolean openingAppHasWallpaper, boolean closingAppHasWallpaper) {
        WindowState wallpaperTarget = this.mWallpaperControllerLocked.getWallpaperTarget();
        WindowState oldWallpaper = this.mWallpaperControllerLocked.isWallpaperTargetAnimating() ? null : wallpaperTarget;
        ArraySet<AppWindowToken> openingApps = this.mService.mOpeningApps;
        ArraySet<AppWindowToken> closingApps = this.mService.mClosingApps;
        boolean openingCanBeWallpaperTarget = this.canBeWallpaperTarget(openingApps);
        this.mService.mAnimateWallpaperWithTarget = false;
        if (closingAppHasWallpaper && openingAppHasWallpaper) {
            switch (transit) {
                case 6: 
                case 8: 
                case 10: {
                    transit = 14;
                    break;
                }
                case 7: 
                case 9: 
                case 11: {
                    transit = 15;
                }
            }
        } else if (openingCanBeWallpaperTarget && transit == 20) {
            transit = 21;
        } else if (oldWallpaper != null && !this.mService.mOpeningApps.isEmpty() && !openingApps.contains(oldWallpaper.mAppToken) && closingApps.contains(oldWallpaper.mAppToken)) {
            transit = 12;
        } else if (wallpaperTarget != null && wallpaperTarget.isVisibleLw() && openingApps.contains(wallpaperTarget.mAppToken)) {
            transit = 13;
        } else {
            this.mService.mAnimateWallpaperWithTarget = true;
        }
        return transit;
    }

    private boolean canBeWallpaperTarget(ArraySet<AppWindowToken> apps) {
        for (int i = apps.size() - 1; i >= 0; --i) {
            if (!apps.valueAt(i).windowsCanBeWallpaperTarget()) continue;
            return true;
        }
        return false;
    }

    private void processApplicationsAnimatingInPlace(int transit) {
        WindowState win;
        if (transit == 17 && (win = this.mService.getDefaultDisplayContentLocked().findFocusedWindow()) != null) {
            AppWindowToken wtoken = win.mAppToken;
            AppWindowAnimator appAnimator = wtoken.mAppAnimator;
            appAnimator.clearThumbnail();
            appAnimator.setNullAnimation();
            this.mService.updateTokenInPlaceLocked(wtoken, transit);
            wtoken.updateReportedVisibilityLocked();
            wtoken.setAllAppWinAnimators();
            this.mService.mAnimator.mAppWindowAnimating |= appAnimator.isAnimating();
            this.mService.mAnimator.orAnimating(appAnimator.showAllWindowsLocked());
        }
    }

    private void createThumbnailAppAnimator(int transit, AppWindowToken appToken, int openingLayer, int closingLayer) {
        AppWindowAnimator openingAppAnimator;
        AppWindowAnimator appWindowAnimator = openingAppAnimator = appToken == null ? null : appToken.mAppAnimator;
        if (openingAppAnimator == null || openingAppAnimator.animation == null) {
            return;
        }
        int taskId = appToken.mTask.mTaskId;
        Bitmap thumbnailHeader = this.mService.mAppTransition.getAppTransitionThumbnailHeader(taskId);
        if (thumbnailHeader == null || thumbnailHeader.getConfig() == Bitmap.Config.ALPHA_8) {
            return;
        }
        Rect dirty = new Rect(0, 0, thumbnailHeader.getWidth(), thumbnailHeader.getHeight());
        try {
            Animation anim2;
            DisplayContent displayContent = this.mService.getDefaultDisplayContentLocked();
            Display display = displayContent.getDisplay();
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            SurfaceControl surfaceControl = new SurfaceControl(this.mService.mFxSession, "thumbnail anim", dirty.width(), dirty.height(), -3, 4);
            surfaceControl.setLayerStack(display.getLayerStack());
            Surface drawSurface = new Surface();
            drawSurface.copyFrom(surfaceControl);
            Canvas c = drawSurface.lockCanvas(dirty);
            c.drawBitmap(thumbnailHeader, 0.0f, 0.0f, null);
            drawSurface.unlockCanvasAndPost(c);
            drawSurface.release();
            if (this.mService.mAppTransition.isNextThumbnailTransitionAspectScaled()) {
                WindowState win = appToken.findMainWindow();
                Rect appRect = win != null ? win.getContentFrameLw() : new Rect(0, 0, displayInfo.appWidth, displayInfo.appHeight);
                Rect insets = win != null ? win.mContentInsets : null;
                Configuration displayConfig = displayContent.getConfiguration();
                anim2 = this.mService.mAppTransition.createThumbnailAspectScaleAnimationLocked(appRect, insets, thumbnailHeader, taskId, displayConfig.uiMode, displayConfig.orientation);
                openingAppAnimator.thumbnailForceAboveLayer = Math.max(openingLayer, closingLayer);
                openingAppAnimator.deferThumbnailDestruction = !this.mService.mAppTransition.isNextThumbnailTransitionScaleUp();
            } else {
                anim2 = this.mService.mAppTransition.createThumbnailScaleAnimationLocked(displayInfo.appWidth, displayInfo.appHeight, transit, thumbnailHeader);
            }
            anim2.restrictDuration(10000L);
            anim2.scaleCurrentDuration(this.mService.getTransitionAnimationScaleLocked());
            openingAppAnimator.thumbnail = surfaceControl;
            openingAppAnimator.thumbnailLayer = openingLayer;
            openingAppAnimator.thumbnailAnimation = anim2;
            this.mService.mAppTransition.getNextAppTransitionStartRect(taskId, this.mTmpStartRect);
        }
        catch (Surface.OutOfResourcesException e) {
            Slog.e(TAG, "Can't allocate thumbnail/Canvas surface w=" + dirty.width() + " h=" + dirty.height(), e);
            openingAppAnimator.clearThumbnail();
        }
    }

    void requestTraversal() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.mService.mH.sendEmptyMessage(4);
        }
    }

    void destroyAfterTransaction(SurfaceControl surface) {
        this.mPendingDestroyingSurfaces.add(surface);
    }

    void destroyPendingSurfaces() {
        for (int i = this.mPendingDestroyingSurfaces.size() - 1; i >= 0; --i) {
            this.mPendingDestroyingSurfaces.get(i).destroy();
        }
        this.mPendingDestroyingSurfaces.clear();
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "mTraversalScheduled=" + this.mTraversalScheduled);
        pw.println(prefix + "mHoldScreenWindow=" + this.mService.mRoot.mHoldScreenWindow);
        pw.println(prefix + "mObscuringWindow=" + this.mService.mRoot.mObscuringWindow);
    }

    private static final class LayerAndToken {
        public int layer;
        public AppWindowToken token;

        private LayerAndToken() {
        }
    }
}

