/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.IBinder;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken$$Lambda$27;
import java.io.PrintWriter;
import java.util.Comparator;

class WindowToken
extends WindowContainer<WindowState> {
    private static final String TAG = "WindowManager";
    protected final WindowManagerService mService;
    final IBinder token;
    final int windowType;
    boolean mPersistOnEmpty;
    String stringName;
    boolean paused = false;
    boolean hidden;
    boolean hasVisible;
    boolean waitingToShow;
    boolean sendingToBottom;
    protected DisplayContent mDisplayContent;
    final boolean mOwnerCanManageAppTokens;
    private final Comparator<WindowState> mWindowComparator = WindowToken$$Lambda$27.get$Lambda(this);

    WindowToken(WindowManagerService service, IBinder _token, int type, boolean persistOnEmpty, DisplayContent dc, boolean ownerCanManageAppTokens) {
        this.mService = service;
        this.token = _token;
        this.windowType = type;
        this.mPersistOnEmpty = persistOnEmpty;
        this.mOwnerCanManageAppTokens = ownerCanManageAppTokens;
        this.onDisplayChanged(dc);
    }

    void removeAllWindowsIfPossible() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            win.removeIfPossible();
        }
    }

    void setExiting() {
        this.mPersistOnEmpty = false;
        if (this.hidden) {
            return;
        }
        int count = this.mChildren.size();
        boolean changed = false;
        boolean delayed = false;
        for (int i = 0; i < count; ++i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            if (win.mWinAnimator.isAnimationSet()) {
                delayed = true;
            }
            changed |= win.onSetAppExiting();
        }
        this.hidden = true;
        if (changed) {
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
            this.mService.updateFocusedWindowLocked(0, false);
        }
        if (delayed) {
            this.mDisplayContent.mExitingTokens.add(this);
        }
    }

    int adjustAnimLayer(int adj) {
        int highestAnimLayer = -1;
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowState w = (WindowState)this.mChildren.get(j);
            int winHighestAnimLayer = w.adjustAnimLayer(adj);
            if (winHighestAnimLayer > highestAnimLayer) {
                highestAnimLayer = winHighestAnimLayer;
            }
            if (w != this.mService.mInputMethodTarget || this.mService.mInputMethodTargetWaitingAnim) continue;
            this.mDisplayContent.setInputMethodAnimLayerAdjustment(adj);
        }
        return highestAnimLayer;
    }

    protected boolean isFirstChildWindowGreaterThanSecond(WindowState newWindow, WindowState existingWindow) {
        return newWindow.mBaseLayer >= existingWindow.mBaseLayer;
    }

    void addWindow(WindowState win) {
        if (win.isChildWindow()) {
            return;
        }
        if (!this.mChildren.contains(win)) {
            this.addChild(win, this.mWindowComparator);
            this.mService.mWindowsChanged = true;
        }
    }

    boolean isEmpty() {
        return this.mChildren.isEmpty();
    }

    WindowState getReplacingWindow() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            WindowState replacing = win.getReplacingWindow();
            if (replacing == null) continue;
            return replacing;
        }
        return null;
    }

    boolean windowsCanBeWallpaperTarget() {
        for (int j = this.mChildren.size() - 1; j >= 0; --j) {
            WindowState w = (WindowState)this.mChildren.get(j);
            if ((w.mAttrs.flags & 0x100000) == 0) continue;
            return true;
        }
        return false;
    }

    int getHighestAnimLayer() {
        int highest = -1;
        for (int j = 0; j < this.mChildren.size(); ++j) {
            WindowState w = (WindowState)this.mChildren.get(j);
            int wLayer = w.getHighestAnimLayer();
            if (wLayer <= highest) continue;
            highest = wLayer;
        }
        return highest;
    }

    AppWindowToken asAppWindowToken() {
        return null;
    }

    DisplayContent getDisplayContent() {
        return this.mDisplayContent;
    }

    @Override
    void removeImmediately() {
        if (this.mDisplayContent != null) {
            this.mDisplayContent.removeWindowToken(this.token);
        }
        super.removeImmediately();
    }

    @Override
    void onDisplayChanged(DisplayContent dc) {
        dc.reParentWindowToken(this);
        this.mDisplayContent = dc;
        super.onDisplayChanged(dc);
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("windows=");
        pw.println(this.mChildren);
        pw.print(prefix);
        pw.print("windowType=");
        pw.print(this.windowType);
        pw.print(" hidden=");
        pw.print(this.hidden);
        pw.print(" hasVisible=");
        pw.println(this.hasVisible);
        if (this.waitingToShow || this.sendingToBottom) {
            pw.print(prefix);
            pw.print("waitingToShow=");
            pw.print(this.waitingToShow);
            pw.print(" sendingToBottom=");
            pw.print(this.sendingToBottom);
        }
    }

    public String toString() {
        if (this.stringName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("WindowToken{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" ");
            sb.append(this.token);
            sb.append('}');
            this.stringName = sb.toString();
        }
        return this.stringName;
    }

    @Override
    String getName() {
        return this.toString();
    }

    final /* synthetic */ int lambda$new$48$WindowToken(WindowState newWindow, WindowState existingWindow) {
        WindowToken token = this;
        if (newWindow.mToken != token) {
            throw new IllegalArgumentException("newWindow=" + newWindow + " is not a child of token=" + token);
        }
        if (existingWindow.mToken != token) {
            throw new IllegalArgumentException("existingWindow=" + existingWindow + " is not a child of token=" + token);
        }
        return this.isFirstChildWindowGreaterThanSecond(newWindow, existingWindow) ? 1 : -1;
    }
}

