/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.address.URI;
import javax.sip.header.AlertInfoHeader;

public final class AlertInfo
extends ParametersHeader
implements AlertInfoHeader {
    private static final long serialVersionUID = 4159657362051508719L;
    protected GenericURI uri;
    protected String string;

    public AlertInfo() {
        super("Alert-Info");
    }

    @Override
    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        if (this.uri != null) {
            encoding.append("<").append(this.uri.encode()).append(">");
        } else if (this.string != null) {
            encoding.append(this.string);
        }
        if (!this.parameters.isEmpty()) {
            encoding.append(";").append(this.parameters.encode());
        }
        return encoding.toString();
    }

    @Override
    public void setAlertInfo(URI uri) {
        this.uri = (GenericURI)uri;
    }

    @Override
    public void setAlertInfo(String string2) {
        this.string = string2;
    }

    @Override
    public URI getAlertInfo() {
        GenericURI alertInfoUri = null;
        if (this.uri != null) {
            alertInfoUri = this.uri;
        } else {
            try {
                alertInfoUri = new GenericURI(this.string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return alertInfoUri;
    }

    @Override
    public Object clone() {
        AlertInfo retval = (AlertInfo)super.clone();
        if (this.uri != null) {
            retval.uri = (GenericURI)this.uri.clone();
        } else if (this.string != null) {
            retval.string = this.string;
        }
        return retval;
    }
}

