/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.ServerLogger;
import gov.nist.core.StackLogger;
import gov.nist.core.ThreadAuditor;
import gov.nist.core.net.AddressResolver;
import gov.nist.core.net.DefaultNetworkLayer;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.DefaultAddressResolver;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.LogRecordFactory;
import gov.nist.javax.sip.SipListenerExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.extensions.JoinHeader;
import gov.nist.javax.sip.header.extensions.ReplacesHeader;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.DefaultRouter;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPDialogErrorEvent;
import gov.nist.javax.sip.stack.SIPDialogEventListener;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.header.CallIdHeader;

public abstract class SIPTransactionStack
implements SIPTransactionEventListener,
SIPDialogEventListener {
    public static final int BASE_TIMER_INTERVAL = 500;
    public static final int CONNECTION_LINGER_TIME = 8;
    protected ConcurrentHashMap<String, SIPServerTransaction> retransmissionAlertTransactions;
    protected ConcurrentHashMap<String, SIPDialog> earlyDialogTable;
    protected ConcurrentHashMap<String, SIPDialog> dialogTable;
    protected static final Set<String> dialogCreatingMethods = new HashSet<String>();
    private Timer timer;
    private ConcurrentHashMap<String, SIPServerTransaction> pendingTransactions;
    private ConcurrentHashMap<String, SIPClientTransaction> clientTransactionTable;
    protected boolean unlimitedServerTransactionTableSize = true;
    protected boolean unlimitedClientTransactionTableSize = true;
    protected int serverTransactionTableHighwaterMark = 5000;
    protected int serverTransactionTableLowaterMark = 4000;
    protected int clientTransactionTableHiwaterMark = 1000;
    protected int clientTransactionTableLowaterMark = 800;
    private AtomicInteger activeClientTransactionCount = new AtomicInteger(0);
    private ConcurrentHashMap<String, SIPServerTransaction> serverTransactionTable;
    private ConcurrentHashMap<String, SIPServerTransaction> mergeTable;
    private ConcurrentHashMap<String, SIPServerTransaction> terminatedServerTransactionsPendingAck;
    private ConcurrentHashMap<String, SIPClientTransaction> forkedClientTransactionTable;
    private StackLogger stackLogger;
    protected ServerLogger serverLogger;
    boolean udpFlag;
    protected DefaultRouter defaultRouter;
    protected boolean needsLogging;
    private boolean non2XXAckPassedToListener;
    protected IOHandler ioHandler;
    protected boolean toExit = false;
    protected String stackName;
    protected String stackAddress;
    protected InetAddress stackInetAddress;
    protected StackMessageFactory sipMessageFactory;
    protected Router router;
    protected int threadPoolSize = -1;
    protected int maxConnections = -1;
    protected boolean cacheServerConnections = true;
    protected boolean cacheClientConnections = true;
    protected boolean useRouterForAll;
    protected int maxContentLength;
    protected int maxMessageSize;
    private Collection<MessageProcessor> messageProcessors;
    protected int readTimeout = -1;
    protected NetworkLayer networkLayer;
    protected String outboundProxy;
    protected String routerPath;
    protected boolean isAutomaticDialogSupportEnabled;
    protected HashSet<String> forkedEvents;
    protected boolean generateTimeStampHeader;
    protected AddressResolver addressResolver;
    protected int maxListenerResponseTime = -1;
    protected boolean rfc2543Supported = true;
    protected ThreadAuditor threadAuditor = new ThreadAuditor();
    protected LogRecordFactory logRecordFactory;
    protected boolean cancelClientTransactionChecked = true;
    protected boolean remoteTagReassignmentAllowed = true;
    protected boolean logStackTraceOnMessageSend = true;
    protected int receiveUdpBufferSize;
    protected int sendUdpBufferSize;
    protected boolean stackDoesCongestionControl = true;
    protected boolean isBackToBackUserAgent = false;
    protected boolean checkBranchId;
    protected boolean isAutomaticDialogErrorHandlingEnabled = true;
    protected boolean isDialogTerminatedEventDeliveredForNullDialog = false;
    protected int maxForkTime = 0;

    protected SIPTransactionStack() {
        this.forkedEvents = new HashSet();
        this.messageProcessors = new ArrayList<MessageProcessor>();
        this.ioHandler = new IOHandler(this);
        this.addressResolver = new DefaultAddressResolver();
        this.dialogTable = new ConcurrentHashMap();
        this.earlyDialogTable = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.terminatedServerTransactionsPendingAck = new ConcurrentHashMap();
        this.mergeTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.timer = new Timer();
        this.pendingTransactions = new ConcurrentHashMap();
        this.forkedClientTransactionTable = new ConcurrentHashMap();
        if (this.getThreadAuditor().isEnabled()) {
            this.timer.schedule((TimerTask)new PingTimer(null), 0L);
        }
    }

    protected void reInit() {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("Re-initializing !");
        }
        this.messageProcessors = new ArrayList<MessageProcessor>();
        this.ioHandler = new IOHandler(this);
        this.pendingTransactions = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.mergeTable = new ConcurrentHashMap();
        this.dialogTable = new ConcurrentHashMap();
        this.earlyDialogTable = new ConcurrentHashMap();
        this.terminatedServerTransactionsPendingAck = new ConcurrentHashMap();
        this.forkedClientTransactionTable = new ConcurrentHashMap();
        this.timer = new Timer();
        this.activeClientTransactionCount = new AtomicInteger(0);
    }

    public SocketAddress obtainLocalAddress(InetAddress dst, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        return this.ioHandler.obtainLocalAddress(dst, dstPort, localAddress, localPort);
    }

    public void disableLogging() {
        this.getStackLogger().disableLogging();
    }

    public void enableLogging() {
        this.getStackLogger().enableLogging();
    }

    public void printDialogTable() {
        if (this.isLoggingEnabled()) {
            this.getStackLogger().logDebug("dialog table  = " + this.dialogTable);
            System.out.println("dialog table = " + this.dialogTable);
        }
    }

    public SIPServerTransaction getRetransmissionAlertTransaction(String dialogId) {
        return this.retransmissionAlertTransactions.get(dialogId);
    }

    public static boolean isDialogCreated(String method) {
        return dialogCreatingMethods.contains(method);
    }

    public void addExtensionMethod(String extensionMethod) {
        if (extensionMethod.equals("NOTIFY")) {
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug("NOTIFY Supported Natively");
            }
        } else {
            dialogCreatingMethods.add(extensionMethod.trim().toUpperCase());
        }
    }

    public void putDialog(SIPDialog dialog) {
        String dialogId = dialog.getDialogId();
        if (this.dialogTable.containsKey(dialogId)) {
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug("putDialog: dialog already exists" + dialogId + " in table = " + this.dialogTable.get(dialogId));
            }
            return;
        }
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("putDialog dialogId=" + dialogId + " dialog = " + dialog);
        }
        dialog.setStack(this);
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logStackTrace();
        }
        this.dialogTable.put(dialogId, dialog);
    }

    public SIPDialog createDialog(SIPTransaction transaction) {
        SIPDialog retval = null;
        if (transaction instanceof SIPClientTransaction) {
            String dialogId = ((SIPRequest)transaction.getRequest()).getDialogId(false);
            if (this.earlyDialogTable.get(dialogId) != null) {
                SIPDialog dialog = this.earlyDialogTable.get(dialogId);
                if (dialog.getState() == null || dialog.getState() == DialogState.EARLY) {
                    retval = dialog;
                } else {
                    retval = new SIPDialog(transaction);
                    this.earlyDialogTable.put(dialogId, retval);
                }
            } else {
                retval = new SIPDialog(transaction);
                this.earlyDialogTable.put(dialogId, retval);
            }
        } else {
            retval = new SIPDialog(transaction);
        }
        return retval;
    }

    public SIPDialog createDialog(SIPClientTransaction transaction, SIPResponse sipResponse) {
        String dialogId = ((SIPRequest)transaction.getRequest()).getDialogId(false);
        SIPDialog retval = null;
        if (this.earlyDialogTable.get(dialogId) != null) {
            retval = this.earlyDialogTable.get(dialogId);
            if (sipResponse.isFinalResponse()) {
                this.earlyDialogTable.remove(dialogId);
            }
        } else {
            retval = new SIPDialog(transaction, sipResponse);
        }
        return retval;
    }

    public SIPDialog createDialog(SipProviderImpl sipProvider, SIPResponse sipResponse) {
        return new SIPDialog(sipProvider, sipResponse);
    }

    public void removeDialog(SIPDialog dialog) {
        String id2 = dialog.getDialogId();
        String earlyId = dialog.getEarlyDialogId();
        if (earlyId != null) {
            this.earlyDialogTable.remove(earlyId);
            this.dialogTable.remove(earlyId);
        }
        if (id2 != null) {
            SIPDialog old = this.dialogTable.get(id2);
            if (old == dialog) {
                this.dialogTable.remove(id2);
            }
            if (!dialog.testAndSetIsDialogTerminatedEventDelivered()) {
                DialogTerminatedEvent event = new DialogTerminatedEvent(dialog.getSipProvider(), dialog);
                dialog.getSipProvider().handleEvent(event, null);
            }
        } else if (this.isDialogTerminatedEventDeliveredForNullDialog && !dialog.testAndSetIsDialogTerminatedEventDelivered()) {
            DialogTerminatedEvent event = new DialogTerminatedEvent(dialog.getSipProvider(), dialog);
            dialog.getSipProvider().handleEvent(event, null);
        }
    }

    public SIPDialog getDialog(String dialogId) {
        SIPDialog sipDialog = this.dialogTable.get(dialogId);
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("getDialog(" + dialogId + ") : returning " + sipDialog);
        }
        return sipDialog;
    }

    public void removeDialog(String dialogId) {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logWarning("Silently removing dialog from table");
        }
        this.dialogTable.remove(dialogId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIPClientTransaction findSubscribeTransaction(SIPRequest notifyMessage, ListeningPointImpl listeningPoint) {
        retval = null;
        try {
            it = this.clientTransactionTable.values().iterator();
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug("ct table size = " + this.clientTransactionTable.size());
            }
            if ((thisToTag = notifyMessage.getTo().getTag()) == null) {
                var6_6 = retval;
                if (this.stackLogger.isLoggingEnabled()) {
                    this.stackLogger.logDebug("findSubscribeTransaction : returning " + retval);
                }
                return var6_6;
            }
        }
        catch (Throwable var11_13) {
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug("findSubscribeTransaction : returning " + retval);
            }
            throw var11_13;
        }
        {
            eventHdr = (Event)notifyMessage.getHeader("Event");
            if (eventHdr != null) ** GOTO lbl-1000
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug("event Header is null -- returning null");
            }
            var7_8 = retval;
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug("findSubscribeTransaction : returning " + retval);
            }
            return var7_8;
        }
lbl-1000:
        // 4 sources

        {
            while (it.hasNext()) {
                ct = it.next();
                if (!ct.getMethod().equals("SUBSCRIBE")) continue;
                fromTag = ct.from.getTag();
                hisEvent = ct.event;
                if (hisEvent == null) continue;
                if (this.stackLogger.isLoggingEnabled()) {
                    this.stackLogger.logDebug("ct.fromTag = " + fromTag);
                    this.stackLogger.logDebug("thisToTag = " + thisToTag);
                    this.stackLogger.logDebug("hisEvent = " + hisEvent);
                    this.stackLogger.logDebug("eventHdr " + eventHdr);
                }
                if (!fromTag.equalsIgnoreCase(thisToTag) || hisEvent == null || !eventHdr.match(hisEvent) || !notifyMessage.getCallId().getCallId().equalsIgnoreCase(ct.callId.getCallId())) continue;
                if (ct.acquireSem()) {
                    retval = ct;
                }
                var10_12 = retval;
                if (this.stackLogger.isLoggingEnabled()) {
                    this.stackLogger.logDebug("findSubscribeTransaction : returning " + retval);
                }
                return var10_12;
            }
        }
        {
            var7_9 = retval;
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug("findSubscribeTransaction : returning " + retval);
            }
            return var7_9;
        }
    }

    public void addTransactionPendingAck(SIPServerTransaction serverTransaction) {
        String branchId = ((SIPRequest)serverTransaction.getRequest()).getTopmostVia().getBranch();
        if (branchId != null) {
            this.terminatedServerTransactionsPendingAck.put(branchId, serverTransaction);
        }
    }

    public SIPServerTransaction findTransactionPendingAck(SIPRequest ackMessage) {
        return this.terminatedServerTransactionsPendingAck.get(ackMessage.getTopmostVia().getBranch());
    }

    public boolean removeTransactionPendingAck(SIPServerTransaction serverTransaction) {
        String branchId = ((SIPRequest)serverTransaction.getRequest()).getTopmostVia().getBranch();
        if (branchId != null && this.terminatedServerTransactionsPendingAck.containsKey(branchId)) {
            this.terminatedServerTransactionsPendingAck.remove(branchId);
            return true;
        }
        return false;
    }

    public boolean isTransactionPendingAck(SIPServerTransaction serverTransaction) {
        String branchId = ((SIPRequest)serverTransaction.getRequest()).getTopmostVia().getBranch();
        return this.terminatedServerTransactionsPendingAck.contains(branchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIPTransaction findTransaction(SIPMessage sipMessage, boolean isServer) {
        block13: {
            retval = null;
            try {
                if (isServer) {
                    via = sipMessage.getTopmostVia();
                    if (via.getBranch() != null) {
                        key = sipMessage.getTransactionId();
                        retval = this.serverTransactionTable.get(key);
                        if (this.stackLogger.isLoggingEnabled()) {
                            this.getStackLogger().logDebug("serverTx: looking for key " + key + " existing=" + this.serverTransactionTable);
                        }
                        if (key.startsWith("z9hg4bk")) {
                            var6_8 = retval;
                            if (this.getStackLogger().isLoggingEnabled() == false) return var6_8;
                            this.getStackLogger().logDebug("findTransaction: returning  : " + retval);
                            return var6_8;
                        }
                    }
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var8_14) {
                if (this.getStackLogger().isLoggingEnabled() == false) throw var8_14;
                this.getStackLogger().logDebug("findTransaction: returning  : " + retval);
                throw var8_14;
            }
            {
                for (SIPServerTransaction sipServerTransaction : this.serverTransactionTable.values()) {
                    if (!sipServerTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                    var7_12 = retval = sipServerTransaction;
                    if (this.getStackLogger().isLoggingEnabled() == false) return var7_12;
                    this.getStackLogger().logDebug("findTransaction: returning  : " + retval);
                    return var7_12;
                }
                break block13;
            }
lbl-1000:
            // 1 sources

            {
                via = sipMessage.getTopmostVia();
                if (via.getBranch() == null) ** GOTO lbl-1000
                key = sipMessage.getTransactionId();
                if (this.stackLogger.isLoggingEnabled()) {
                    this.getStackLogger().logDebug("clientTx: looking for key " + key);
                }
                retval = this.clientTransactionTable.get(key);
                if (!key.startsWith("z9hg4bk")) ** GOTO lbl-1000
                sipServerTransaction = retval;
                if (this.getStackLogger().isLoggingEnabled() == false) return sipServerTransaction;
                this.getStackLogger().logDebug("findTransaction: returning  : " + retval);
                return sipServerTransaction;
            }
lbl-1000:
            // 3 sources

            {
                for (SIPClientTransaction clientTransaction : this.clientTransactionTable.values()) {
                    if (!clientTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                    var7_13 = retval = clientTransaction;
                    if (this.getStackLogger().isLoggingEnabled() == false) return var7_13;
                    this.getStackLogger().logDebug("findTransaction: returning  : " + retval);
                    return var7_13;
                }
            }
        }
        if (this.getStackLogger().isLoggingEnabled() == false) return retval;
        this.getStackLogger().logDebug("findTransaction: returning  : " + retval);
        return retval;
    }

    public SIPTransaction findCancelTransaction(SIPRequest cancelRequest, boolean isServer) {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("findCancelTransaction request= \n" + cancelRequest + "\nfindCancelRequest isServer=" + isServer);
        }
        if (isServer) {
            for (SIPTransaction sIPTransaction : this.serverTransactionTable.values()) {
                SIPServerTransaction sipServerTransaction = (SIPServerTransaction)sIPTransaction;
                if (!sipServerTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipServerTransaction;
            }
        } else {
            for (SIPTransaction sIPTransaction : this.clientTransactionTable.values()) {
                SIPClientTransaction sipClientTransaction = (SIPClientTransaction)sIPTransaction;
                if (!sipClientTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipClientTransaction;
            }
        }
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("Could not find transaction for cancel request");
        }
        return null;
    }

    protected SIPTransactionStack(StackMessageFactory messageFactory) {
        this();
        this.sipMessageFactory = messageFactory;
    }

    public SIPServerTransaction findPendingTransaction(SIPRequest requestReceived) {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("looking for pending tx for :" + requestReceived.getTransactionId());
        }
        return this.pendingTransactions.get(requestReceived.getTransactionId());
    }

    public SIPServerTransaction findMergedTransaction(SIPRequest sipRequest) {
        if (!sipRequest.getMethod().equals("INVITE")) {
            return null;
        }
        String mergeId = sipRequest.getMergeId();
        SIPServerTransaction mergedTransaction = this.mergeTable.get(mergeId);
        if (mergeId == null) {
            return null;
        }
        if (mergedTransaction != null && !mergedTransaction.isMessagePartOfTransaction(sipRequest)) {
            return mergedTransaction;
        }
        for (Dialog dialog : this.dialogTable.values()) {
            SIPDialog sipDialog = (SIPDialog)dialog;
            if (sipDialog.getFirstTransaction() == null || !(sipDialog.getFirstTransaction() instanceof ServerTransaction)) continue;
            SIPServerTransaction serverTransaction = (SIPServerTransaction)sipDialog.getFirstTransaction();
            SIPRequest transactionRequest = ((SIPServerTransaction)sipDialog.getFirstTransaction()).getOriginalRequest();
            if (serverTransaction.isMessagePartOfTransaction(sipRequest) || !sipRequest.getMergeId().equals(transactionRequest.getMergeId())) continue;
            return (SIPServerTransaction)sipDialog.getFirstTransaction();
        }
        return null;
    }

    public void removePendingTransaction(SIPServerTransaction tr) {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("removePendingTx: " + tr.getTransactionId());
        }
        this.pendingTransactions.remove(tr.getTransactionId());
    }

    public void removeFromMergeTable(SIPServerTransaction tr) {
        String key;
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("Removing tx from merge table ");
        }
        if ((key = ((SIPRequest)tr.getRequest()).getMergeId()) != null) {
            this.mergeTable.remove(key);
        }
    }

    public void putInMergeTable(SIPServerTransaction sipTransaction, SIPRequest sipRequest) {
        String mergeKey = sipRequest.getMergeId();
        if (mergeKey != null) {
            this.mergeTable.put(mergeKey, sipTransaction);
        }
    }

    public void mapTransaction(SIPServerTransaction transaction) {
        if (transaction.isMapped) {
            return;
        }
        this.addTransactionHash(transaction);
        transaction.isMapped = true;
    }

    public ServerRequestInterface newSIPServerRequest(SIPRequest requestReceived, MessageChannel requestMessageChannel) {
        String key = requestReceived.getTransactionId();
        requestReceived.setMessageChannel(requestMessageChannel);
        SIPServerTransaction currentTransaction = this.serverTransactionTable.get(key);
        if (currentTransaction == null || !currentTransaction.isMessagePartOfTransaction(requestReceived)) {
            Iterator<SIPServerTransaction> transactionIterator = this.serverTransactionTable.values().iterator();
            currentTransaction = null;
            if (!key.toLowerCase().startsWith("z9hg4bk")) {
                while (transactionIterator.hasNext() && currentTransaction == null) {
                    SIPServerTransaction nextTransaction = transactionIterator.next();
                    if (!nextTransaction.isMessagePartOfTransaction(requestReceived)) continue;
                    currentTransaction = nextTransaction;
                }
            }
            if (currentTransaction == null) {
                currentTransaction = this.findPendingTransaction(requestReceived);
                if (currentTransaction != null) {
                    requestReceived.setTransaction(currentTransaction);
                    if (currentTransaction != null && currentTransaction.acquireSem()) {
                        return currentTransaction;
                    }
                    return null;
                }
                currentTransaction = this.createServerTransaction(requestMessageChannel);
                if (currentTransaction != null) {
                    currentTransaction.setOriginalRequest(requestReceived);
                    requestReceived.setTransaction(currentTransaction);
                }
            }
        }
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("newSIPServerRequest( " + requestReceived.getMethod() + ":" + requestReceived.getTopmostVia().getBranch() + "):" + currentTransaction);
        }
        if (currentTransaction != null) {
            currentTransaction.setRequestInterface(this.sipMessageFactory.newSIPServerRequest(requestReceived, currentTransaction));
        }
        if (currentTransaction != null && currentTransaction.acquireSem()) {
            return currentTransaction;
        }
        if (currentTransaction != null) {
            block14: {
                try {
                    if (currentTransaction.isMessagePartOfTransaction(requestReceived) && currentTransaction.getMethod().equals(requestReceived.getMethod())) {
                        SIPResponse trying = requestReceived.createResponse(100);
                        trying.removeContent();
                        currentTransaction.getMessageChannel().sendMessage(trying);
                    }
                }
                catch (Exception ex) {
                    if (!this.isLoggingEnabled()) break block14;
                    this.stackLogger.logError("Exception occured sending TRYING");
                }
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ServerResponseInterface newSIPServerResponse(SIPResponse responseReceived, MessageChannel responseMessageChannel) {
        boolean acquired;
        SIPClientTransaction currentTransaction;
        block11: {
            String key = responseReceived.getTransactionId();
            currentTransaction = this.clientTransactionTable.get(key);
            if (currentTransaction == null || !currentTransaction.isMessagePartOfTransaction(responseReceived) && !key.startsWith("z9hg4bk")) {
                Iterator<SIPClientTransaction> transactionIterator = this.clientTransactionTable.values().iterator();
                currentTransaction = null;
                while (transactionIterator.hasNext() && currentTransaction == null) {
                    SIPClientTransaction nextTransaction = transactionIterator.next();
                    if (!nextTransaction.isMessagePartOfTransaction(responseReceived)) continue;
                    currentTransaction = nextTransaction;
                }
                if (currentTransaction == null) {
                    if (this.stackLogger.isLoggingEnabled(16)) {
                        responseMessageChannel.logResponse(responseReceived, System.currentTimeMillis(), "before processing");
                    }
                    return this.sipMessageFactory.newSIPServerResponse(responseReceived, responseMessageChannel);
                }
            }
            acquired = currentTransaction.acquireSem();
            if (this.stackLogger.isLoggingEnabled(16)) {
                currentTransaction.logResponse(responseReceived, System.currentTimeMillis(), "before processing");
            }
            if (acquired) {
                ServerResponseInterface sri = this.sipMessageFactory.newSIPServerResponse(responseReceived, currentTransaction);
                if (sri != null) {
                    currentTransaction.setResponseInterface(sri);
                    break block11;
                } else {
                    if (this.stackLogger.isLoggingEnabled()) {
                        this.stackLogger.logDebug("returning null - serverResponseInterface is null!");
                    }
                    currentTransaction.releaseSem();
                    return null;
                }
            }
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug("Could not aquire semaphore !!");
            }
        }
        if (acquired) {
            return currentTransaction;
        }
        return null;
    }

    public MessageChannel createMessageChannel(SIPRequest request, MessageProcessor mp, Hop nextHop) throws IOException {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel mc = mp.createMessageChannel(targetHostPort);
        if (mc == null) {
            return null;
        }
        SIPClientTransaction returnChannel = this.createClientTransaction(request, mc);
        returnChannel.setViaPort(nextHop.getPort());
        returnChannel.setViaHost(nextHop.getHost());
        this.addTransactionHash(returnChannel);
        return returnChannel;
    }

    public SIPClientTransaction createClientTransaction(SIPRequest sipRequest, MessageChannel encapsulatedMessageChannel) {
        SIPClientTransaction ct = new SIPClientTransaction(this, encapsulatedMessageChannel);
        ct.setOriginalRequest(sipRequest);
        return ct;
    }

    public SIPServerTransaction createServerTransaction(MessageChannel encapsulatedMessageChannel) {
        boolean decision;
        if (this.unlimitedServerTransactionTableSize) {
            return new SIPServerTransaction(this, encapsulatedMessageChannel);
        }
        float threshold = (float)(this.serverTransactionTable.size() - this.serverTransactionTableLowaterMark) / (float)(this.serverTransactionTableHighwaterMark - this.serverTransactionTableLowaterMark);
        boolean bl = decision = Math.random() > 1.0 - (double)threshold;
        if (decision) {
            return null;
        }
        return new SIPServerTransaction(this, encapsulatedMessageChannel);
    }

    public int getClientTransactionTableSize() {
        return this.clientTransactionTable.size();
    }

    public int getServerTransactionTableSize() {
        return this.serverTransactionTable.size();
    }

    public void addTransaction(SIPClientTransaction clientTransaction) {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("added transaction " + clientTransaction);
        }
        this.addTransactionHash(clientTransaction);
    }

    public void removeTransaction(SIPTransaction sipTransaction) {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("Removing Transaction = " + sipTransaction.getTransactionId() + " transaction = " + sipTransaction);
        }
        if (sipTransaction instanceof SIPServerTransaction) {
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logStackTrace();
            }
            String key = sipTransaction.getTransactionId();
            SIPServerTransaction removed = this.serverTransactionTable.remove(key);
            String method = sipTransaction.getMethod();
            this.removePendingTransaction((SIPServerTransaction)sipTransaction);
            this.removeTransactionPendingAck((SIPServerTransaction)sipTransaction);
            if (method.equalsIgnoreCase("INVITE")) {
                this.removeFromMergeTable((SIPServerTransaction)sipTransaction);
            }
            SipProviderImpl sipProvider = sipTransaction.getSipProvider();
            if (removed != null && sipTransaction.testAndSetTransactionTerminatedEvent()) {
                TransactionTerminatedEvent event = new TransactionTerminatedEvent((Object)sipProvider, (ServerTransaction)((Object)sipTransaction));
                sipProvider.handleEvent(event, sipTransaction);
            }
        } else {
            String key = sipTransaction.getTransactionId();
            SIPClientTransaction removed = this.clientTransactionTable.remove(key);
            if (this.stackLogger.isLoggingEnabled()) {
                SIPClientTransaction clientTx;
                this.stackLogger.logDebug("REMOVED client tx " + removed + " KEY = " + key);
                if (removed != null && (clientTx = removed).getMethod().equals("INVITE") && this.maxForkTime != 0) {
                    RemoveForkedTransactionTimerTask ttask = new RemoveForkedTransactionTimerTask(clientTx);
                    this.timer.schedule((TimerTask)ttask, this.maxForkTime * 1000);
                }
            }
            if (removed != null && sipTransaction.testAndSetTransactionTerminatedEvent()) {
                SipProviderImpl sipProvider = sipTransaction.getSipProvider();
                TransactionTerminatedEvent event = new TransactionTerminatedEvent((Object)sipProvider, (ClientTransaction)((Object)sipTransaction));
                sipProvider.handleEvent(event, sipTransaction);
            }
        }
    }

    public void addTransaction(SIPServerTransaction serverTransaction) throws IOException {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("added transaction " + serverTransaction);
        }
        serverTransaction.map();
        this.addTransactionHash(serverTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        if (sipTransaction instanceof SIPClientTransaction) {
            if (!this.unlimitedClientTransactionTableSize) {
                if (this.activeClientTransactionCount.get() > this.clientTransactionTableHiwaterMark) {
                    try {
                        ConcurrentHashMap<String, SIPClientTransaction> concurrentHashMap = this.clientTransactionTable;
                        synchronized (concurrentHashMap) {
                            this.clientTransactionTable.wait();
                            this.activeClientTransactionCount.incrementAndGet();
                        }
                    }
                    catch (Exception ex) {
                        if (this.stackLogger.isLoggingEnabled()) {
                            this.stackLogger.logError("Exception occured while waiting for room", ex);
                        }
                    }
                }
            } else {
                this.activeClientTransactionCount.incrementAndGet();
            }
            String key = sipRequest.getTransactionId();
            this.clientTransactionTable.put(key, (SIPClientTransaction)sipTransaction);
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug(" putTransactionHash :  key = " + key);
            }
        } else {
            String key = sipRequest.getTransactionId();
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug(" putTransactionHash :  key = " + key);
            }
            this.serverTransactionTable.put(key, (SIPServerTransaction)sipTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementActiveClientTransactionCount() {
        if (this.activeClientTransactionCount.decrementAndGet() <= this.clientTransactionTableLowaterMark && !this.unlimitedClientTransactionTableSize) {
            ConcurrentHashMap<String, SIPClientTransaction> concurrentHashMap = this.clientTransactionTable;
            synchronized (concurrentHashMap) {
                this.clientTransactionTable.notify();
            }
        }
    }

    protected void removeTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        if (sipRequest == null) {
            return;
        }
        if (sipTransaction instanceof SIPClientTransaction) {
            String key = sipTransaction.getTransactionId();
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logStackTrace();
                this.stackLogger.logDebug("removing client Tx : " + key);
            }
            this.clientTransactionTable.remove(key);
        } else if (sipTransaction instanceof SIPServerTransaction) {
            String key = sipTransaction.getTransactionId();
            this.serverTransactionTable.remove(key);
            if (this.stackLogger.isLoggingEnabled()) {
                this.stackLogger.logDebug("removing server Tx : " + key);
            }
        }
    }

    @Override
    public synchronized void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        SIPTransaction transaction = (SIPTransaction)transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            transaction.setState(SIPTransaction.TERMINATED_STATE);
            if (transaction instanceof SIPServerTransaction) {
                ((SIPServerTransaction)transaction).collectionTime = 0;
            }
            transaction.disableTimeoutTimer();
            transaction.disableRetransmissionTimer();
        }
    }

    @Override
    public synchronized void dialogErrorEvent(SIPDialogErrorEvent dialogErrorEvent) {
        SIPDialog sipDialog = (SIPDialog)dialogErrorEvent.getSource();
        SipListener sipListener = ((SipStackImpl)this).getSipListener();
        if (sipDialog != null && !(sipListener instanceof SipListenerExt)) {
            sipDialog.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        this.pendingTransactions.clear();
        this.toExit = true;
        Collection<MessageProcessor> collection = this;
        synchronized (collection) {
            this.notifyAll();
        }
        collection = this.clientTransactionTable;
        synchronized (collection) {
            this.clientTransactionTable.notifyAll();
        }
        collection = this.messageProcessors;
        synchronized (collection) {
            MessageProcessor[] processorList = this.getMessageProcessors();
            for (int processorIndex = 0; processorIndex < processorList.length; ++processorIndex) {
                this.removeMessageProcessor(processorList[processorIndex]);
            }
            this.ioHandler.closeAll();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.clientTransactionTable.clear();
        this.serverTransactionTable.clear();
        this.dialogTable.clear();
        this.serverLogger.closeLogFile();
    }

    public void putPendingTransaction(SIPServerTransaction tr) {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("putPendingTransaction: " + tr);
        }
        this.pendingTransactions.put(tr.getTransactionId(), tr);
    }

    public NetworkLayer getNetworkLayer() {
        if (this.networkLayer == null) {
            return DefaultNetworkLayer.SINGLETON;
        }
        return this.networkLayer;
    }

    public boolean isLoggingEnabled() {
        return this.stackLogger == null ? false : this.stackLogger.isLoggingEnabled();
    }

    public StackLogger getStackLogger() {
        return this.stackLogger;
    }

    public ServerLogger getServerLogger() {
        return this.serverLogger;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setSingleThreaded() {
        this.threadPoolSize = 1;
    }

    public void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public void setMaxConnections(int nconnections) {
        this.maxConnections = nconnections;
    }

    public Hop getNextHop(SIPRequest sipRequest) throws SipException {
        if (this.useRouterForAll) {
            if (this.router != null) {
                return this.router.getNextHop(sipRequest);
            }
            return null;
        }
        if (sipRequest.getRequestURI().isSipURI() || sipRequest.getRouteHeaders() != null) {
            return this.defaultRouter.getNextHop(sipRequest);
        }
        if (this.router != null) {
            return this.router.getNextHop(sipRequest);
        }
        return null;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    protected void setHostAddress(String stackAddress) throws UnknownHostException {
        this.stackAddress = stackAddress.indexOf(58) != stackAddress.lastIndexOf(58) && stackAddress.trim().charAt(0) != '[' ? '[' + stackAddress + ']' : stackAddress;
        this.stackInetAddress = InetAddress.getByName(stackAddress);
    }

    public String getHostAddress() {
        return this.stackAddress;
    }

    protected void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter(SIPRequest request) {
        if (request.getRequestLine() == null) {
            return this.defaultRouter;
        }
        if (this.useRouterForAll) {
            return this.router;
        }
        if (request.getRequestURI().getScheme().equals("sip") || request.getRequestURI().getScheme().equals("sips")) {
            return this.defaultRouter;
        }
        if (this.router != null) {
            return this.router;
        }
        return this.defaultRouter;
    }

    public Router getRouter() {
        return this.router;
    }

    public boolean isAlive() {
        return !this.toExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessageProcessor(MessageProcessor newMessageProcessor) throws IOException {
        Collection<MessageProcessor> collection = this.messageProcessors;
        synchronized (collection) {
            this.messageProcessors.add(newMessageProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageProcessor(MessageProcessor oldMessageProcessor) {
        Collection<MessageProcessor> collection = this.messageProcessors;
        synchronized (collection) {
            if (this.messageProcessors.remove(oldMessageProcessor)) {
                oldMessageProcessor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageProcessor[] getMessageProcessors() {
        Collection<MessageProcessor> collection = this.messageProcessors;
        synchronized (collection) {
            return this.messageProcessors.toArray(new MessageProcessor[0]);
        }
    }

    protected MessageProcessor createMessageProcessor(InetAddress ipAddress, int port, String transport) throws IOException {
        if (transport.equalsIgnoreCase("udp")) {
            UDPMessageProcessor udpMessageProcessor = new UDPMessageProcessor(ipAddress, this, port);
            this.addMessageProcessor(udpMessageProcessor);
            this.udpFlag = true;
            return udpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("tcp")) {
            TCPMessageProcessor tcpMessageProcessor = new TCPMessageProcessor(ipAddress, this, port);
            this.addMessageProcessor(tcpMessageProcessor);
            return tcpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("tls")) {
            TLSMessageProcessor tlsMessageProcessor = new TLSMessageProcessor(ipAddress, this, port);
            this.addMessageProcessor(tlsMessageProcessor);
            return tlsMessageProcessor;
        }
        if (transport.equalsIgnoreCase("sctp")) {
            try {
                Class<?> mpc = ClassLoader.getSystemClassLoader().loadClass("gov.nist.javax.sip.stack.sctp.SCTPMessageProcessor");
                MessageProcessor mp = (MessageProcessor)mpc.newInstance();
                mp.initialize(ipAddress, port, this);
                this.addMessageProcessor(mp);
                return mp;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("SCTP not supported (needs Java 7 and SCTP jar in classpath)");
            }
            catch (InstantiationException ie) {
                throw new IllegalArgumentException("Error initializing SCTP", ie);
            }
            catch (IllegalAccessException ie) {
                throw new IllegalArgumentException("Error initializing SCTP", ie);
            }
        }
        throw new IllegalArgumentException("bad transport");
    }

    protected void setMessageFactory(StackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public MessageChannel createRawMessageChannel(String sourceIpAddress, int sourcePort, Hop nextHop) throws UnknownHostException {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel newChannel = null;
        Iterator<MessageProcessor> processorIterator = this.messageProcessors.iterator();
        while (processorIterator.hasNext() && newChannel == null) {
            MessageProcessor nextProcessor = processorIterator.next();
            if (!nextHop.getTransport().equalsIgnoreCase(nextProcessor.getTransport()) || !sourceIpAddress.equals(nextProcessor.getIpAddress().getHostAddress()) || sourcePort != nextProcessor.getPort()) continue;
            try {
                newChannel = nextProcessor.createMessageChannel(targetHostPort);
            }
            catch (UnknownHostException ex) {
                if (this.stackLogger.isLoggingEnabled()) {
                    this.stackLogger.logException(ex);
                }
                throw ex;
            }
            catch (IOException e) {
                if (!this.stackLogger.isLoggingEnabled()) continue;
                this.stackLogger.logException(e);
            }
        }
        return newChannel;
    }

    public boolean isEventForked(String ename) {
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("isEventForked: " + ename + " returning " + this.forkedEvents.contains(ename));
        }
        return this.forkedEvents.contains(ename);
    }

    public AddressResolver getAddressResolver() {
        return this.addressResolver;
    }

    public void setAddressResolver(AddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }

    public void setLogRecordFactory(LogRecordFactory logRecordFactory) {
        this.logRecordFactory = logRecordFactory;
    }

    public ThreadAuditor getThreadAuditor() {
        return this.threadAuditor;
    }

    public String auditStack(Set activeCallIDs, long leakedDialogTimer, long leakedTransactionTimer) {
        String auditReport = null;
        String leakedDialogs = this.auditDialogs(activeCallIDs, leakedDialogTimer);
        String leakedServerTransactions = this.auditTransactions(this.serverTransactionTable, leakedTransactionTimer);
        String leakedClientTransactions = this.auditTransactions(this.clientTransactionTable, leakedTransactionTimer);
        if (leakedDialogs != null || leakedServerTransactions != null || leakedClientTransactions != null) {
            auditReport = "SIP Stack Audit:\n" + (leakedDialogs != null ? leakedDialogs : "") + (leakedServerTransactions != null ? leakedServerTransactions : "") + (leakedClientTransactions != null ? leakedClientTransactions : "");
        }
        return auditReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String auditDialogs(Set activeCallIDs, long leakedDialogTimer) {
        LinkedList<SIPDialog> dialogs;
        String auditReport = "  Leaked dialogs:\n";
        int leakedDialogs = 0;
        long currentTime = System.currentTimeMillis();
        ConcurrentHashMap<String, SIPDialog> concurrentHashMap = this.dialogTable;
        synchronized (concurrentHashMap) {
            dialogs = new LinkedList<SIPDialog>(this.dialogTable.values());
        }
        for (SIPDialog itDialog : dialogs) {
            String callID;
            CallIdHeader callIdHeader = itDialog != null ? itDialog.getCallId() : null;
            String string2 = callID = callIdHeader != null ? callIdHeader.getCallId() : null;
            if (itDialog == null || callID == null || activeCallIDs.contains(callID)) continue;
            if (itDialog.auditTag == 0L) {
                itDialog.auditTag = currentTime;
                continue;
            }
            if (currentTime - itDialog.auditTag < leakedDialogTimer) continue;
            ++leakedDialogs;
            DialogState dialogState = itDialog.getState();
            String dialogReport = "dialog id: " + itDialog.getDialogId() + ", dialog state: " + (dialogState != null ? dialogState.toString() : "null");
            auditReport = auditReport + "    " + dialogReport + "\n";
            itDialog.setState(SIPDialog.TERMINATED_STATE);
            if (!this.stackLogger.isLoggingEnabled()) continue;
            this.stackLogger.logDebug("auditDialogs: leaked " + dialogReport);
        }
        auditReport = leakedDialogs > 0 ? auditReport + "    Total: " + Integer.toString(leakedDialogs) + " leaked dialogs detected and removed.\n" : null;
        return auditReport;
    }

    private String auditTransactions(ConcurrentHashMap transactionsMap, long a_nLeakedTransactionTimer) {
        String auditReport = "  Leaked transactions:\n";
        int leakedTransactions = 0;
        long currentTime = System.currentTimeMillis();
        LinkedList transactionsList = new LinkedList(transactionsMap.values());
        for (SIPTransaction sipTransaction : transactionsList) {
            if (sipTransaction == null) continue;
            if (sipTransaction.auditTag == 0L) {
                sipTransaction.auditTag = currentTime;
                continue;
            }
            if (currentTime - sipTransaction.auditTag < a_nLeakedTransactionTimer) continue;
            ++leakedTransactions;
            TransactionState transactionState = sipTransaction.getState();
            SIPRequest origRequest = sipTransaction.getOriginalRequest();
            String origRequestMethod = origRequest != null ? origRequest.getMethod() : null;
            String transactionReport = sipTransaction.getClass().getName() + ", state: " + (transactionState != null ? transactionState.toString() : "null") + ", OR: " + (origRequestMethod != null ? origRequestMethod : "null");
            auditReport = auditReport + "    " + transactionReport + "\n";
            this.removeTransaction(sipTransaction);
            if (!this.isLoggingEnabled()) continue;
            this.stackLogger.logDebug("auditTransactions: leaked " + transactionReport);
        }
        auditReport = leakedTransactions > 0 ? auditReport + "    Total: " + Integer.toString(leakedTransactions) + " leaked transactions detected and removed.\n" : null;
        return auditReport;
    }

    public void setNon2XXAckPassedToListener(boolean passToListener) {
        this.non2XXAckPassedToListener = passToListener;
    }

    public boolean isNon2XXAckPassedToListener() {
        return this.non2XXAckPassedToListener;
    }

    public int getActiveClientTransactionCount() {
        return this.activeClientTransactionCount.get();
    }

    public boolean isRfc2543Supported() {
        return this.rfc2543Supported;
    }

    public boolean isCancelClientTransactionChecked() {
        return this.cancelClientTransactionChecked;
    }

    public boolean isRemoteTagReassignmentAllowed() {
        return this.remoteTagReassignmentAllowed;
    }

    public Collection<Dialog> getDialogs() {
        HashSet<Dialog> dialogs = new HashSet<Dialog>();
        dialogs.addAll(this.dialogTable.values());
        dialogs.addAll(this.earlyDialogTable.values());
        return dialogs;
    }

    public Collection<Dialog> getDialogs(DialogState state) {
        HashSet<Dialog> matchingDialogs = new HashSet<Dialog>();
        if (DialogState.EARLY.equals((Object)state)) {
            matchingDialogs.addAll(this.earlyDialogTable.values());
        } else {
            Collection<SIPDialog> dialogs = this.dialogTable.values();
            for (SIPDialog dialog : dialogs) {
                if (dialog.getState() == null || !dialog.getState().equals((Object)state)) continue;
                matchingDialogs.add(dialog);
            }
        }
        return matchingDialogs;
    }

    public Dialog getReplacesDialog(ReplacesHeader replacesHeader) {
        Dialog replacesDialog;
        String cid = replacesHeader.getCallId();
        String fromTag = replacesHeader.getFromTag();
        String toTag = replacesHeader.getToTag();
        StringBuffer dialogId = new StringBuffer(cid);
        if (toTag != null) {
            dialogId.append(":");
            dialogId.append(toTag);
        }
        if (fromTag != null) {
            dialogId.append(":");
            dialogId.append(fromTag);
        }
        String did = dialogId.toString().toLowerCase();
        if (this.stackLogger.isLoggingEnabled()) {
            this.stackLogger.logDebug("Looking for dialog " + did);
        }
        if ((replacesDialog = (Dialog)this.dialogTable.get(did)) == null) {
            for (SIPClientTransaction ctx : this.clientTransactionTable.values()) {
                if (ctx.getDialog(did) == null) continue;
                replacesDialog = ctx.getDialog(did);
                break;
            }
        }
        return replacesDialog;
    }

    public Dialog getJoinDialog(JoinHeader joinHeader) {
        String cid = joinHeader.getCallId();
        String fromTag = joinHeader.getFromTag();
        String toTag = joinHeader.getToTag();
        StringBuffer retval = new StringBuffer(cid);
        if (toTag != null) {
            retval.append(":");
            retval.append(toTag);
        }
        if (fromTag != null) {
            retval.append(":");
            retval.append(fromTag);
        }
        return this.dialogTable.get(retval.toString().toLowerCase());
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public int getReceiveUdpBufferSize() {
        return this.receiveUdpBufferSize;
    }

    public void setReceiveUdpBufferSize(int receiveUdpBufferSize) {
        this.receiveUdpBufferSize = receiveUdpBufferSize;
    }

    public int getSendUdpBufferSize() {
        return this.sendUdpBufferSize;
    }

    public void setSendUdpBufferSize(int sendUdpBufferSize) {
        this.sendUdpBufferSize = sendUdpBufferSize;
    }

    public void setStackLogger(StackLogger stackLogger) {
        this.stackLogger = stackLogger;
    }

    public boolean checkBranchId() {
        return this.checkBranchId;
    }

    public void setLogStackTraceOnMessageSend(boolean logStackTraceOnMessageSend) {
        this.logStackTraceOnMessageSend = logStackTraceOnMessageSend;
    }

    public boolean isLogStackTraceOnMessageSend() {
        return this.logStackTraceOnMessageSend;
    }

    public void setDeliverDialogTerminatedEventForNullDialog() {
        this.isDialogTerminatedEventDeliveredForNullDialog = true;
    }

    public void addForkedClientTransaction(SIPClientTransaction clientTransaction) {
        this.forkedClientTransactionTable.put(clientTransaction.getTransactionId(), clientTransaction);
    }

    public SIPClientTransaction getForkedTransaction(String transactionId) {
        return this.forkedClientTransactionTable.get(transactionId);
    }

    static {
        dialogCreatingMethods.add("REFER");
        dialogCreatingMethods.add("INVITE");
        dialogCreatingMethods.add("SUBSCRIBE");
    }

    class RemoveForkedTransactionTimerTask
    extends SIPStackTimerTask {
        private SIPClientTransaction clientTransaction;

        public RemoveForkedTransactionTimerTask(SIPClientTransaction sipClientTransaction) {
            this.clientTransaction = sipClientTransaction;
        }

        @Override
        protected void runTask() {
            SIPTransactionStack.this.forkedClientTransactionTable.remove(this.clientTransaction.getTransactionId());
        }
    }

    class PingTimer
    extends SIPStackTimerTask {
        ThreadAuditor.ThreadHandle threadHandle;

        public PingTimer(ThreadAuditor.ThreadHandle a_oThreadHandle) {
            this.threadHandle = a_oThreadHandle;
        }

        @Override
        protected void runTask() {
            if (SIPTransactionStack.this.getTimer() != null) {
                if (this.threadHandle == null) {
                    this.threadHandle = SIPTransactionStack.this.getThreadAuditor().addCurrentThread();
                }
                this.threadHandle.ping();
                SIPTransactionStack.this.getTimer().schedule((TimerTask)new PingTimer(this.threadHandle), this.threadHandle.getPingIntervalInMillisecs());
            }
        }
    }
}

