/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.update2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import libcore.tzdata.update2.DistroException;
import libcore.tzdata.update2.DistroVersion;
import libcore.tzdata.update2.FileUtils;

public final class TimeZoneDistro {
    public static final String TZDATA_FILE_NAME = "tzdata";
    public static final String ICU_DATA_FILE_NAME = "icu/icu_tzdata.dat";
    public static final String DISTRO_VERSION_FILE_NAME = "distro_version";
    private static final int BUFFER_SIZE = 8192;
    private static final long MAX_GET_ENTRY_CONTENTS_SIZE = 131072L;
    private final byte[] bytes;

    public TimeZoneDistro(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public DistroVersion getDistroVersion() throws DistroException, IOException {
        byte[] contents = TimeZoneDistro.getEntryContents(new ByteArrayInputStream(this.bytes), DISTRO_VERSION_FILE_NAME);
        if (contents == null) {
            throw new DistroException("Distro version file entry not found");
        }
        return DistroVersion.fromBytes(contents);
    }

    private static byte[] getEntryContents(InputStream is, String entryName) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                if (!entryName.equals(name)) continue;
                if (entry.getSize() > 131072L) {
                    throw new IOException("Entry " + entryName + " too large: " + entry.getSize());
                }
                byte[] buffer = new byte[8192];
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    int count;
                    while ((count = zipInputStream.read(buffer)) != -1) {
                        baos.write(buffer, 0, count);
                    }
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    public void extractTo(File targetDir) throws IOException {
        TimeZoneDistro.extractZipSafely(new ByteArrayInputStream(this.bytes), targetDir, true);
    }

    static void extractZipSafely(InputStream is, File targetDir, boolean makeWorldReadable) throws IOException {
        FileUtils.ensureDirectoriesExist(targetDir, makeWorldReadable);
        try (ZipInputStream zipInputStream = new ZipInputStream(is);){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                File entryFile = FileUtils.createSubFile(targetDir, name);
                if (entry.isDirectory()) {
                    FileUtils.ensureDirectoriesExist(entryFile, makeWorldReadable);
                    continue;
                }
                if (!entryFile.getParentFile().exists()) {
                    FileUtils.ensureDirectoriesExist(entryFile.getParentFile(), makeWorldReadable);
                }
                try (FileOutputStream fos = new FileOutputStream(entryFile);){
                    int count;
                    while ((count = zipInputStream.read(buffer)) != -1) {
                        fos.write(buffer, 0, count);
                    }
                    fos.getFD().sync();
                }
                if (!makeWorldReadable) continue;
                FileUtils.makeWorldReadable(entryFile);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneDistro that = (TimeZoneDistro)o;
        return Arrays.equals(this.bytes, that.bytes);
    }
}

