/*
 * Decompiled with CFR 0.152.
 */
package libcore.tzdata.update2;

import android.util.Slog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import libcore.tzdata.update2.DistroException;
import libcore.tzdata.update2.DistroVersion;
import libcore.tzdata.update2.FileUtils;
import libcore.tzdata.update2.TimeZoneDistro;
import libcore.util.ZoneInfoDB;

public final class TimeZoneDistroInstaller {
    public static final int INSTALL_SUCCESS = 0;
    public static final int INSTALL_FAIL_BAD_DISTRO_STRUCTURE = 1;
    public static final int INSTALL_FAIL_BAD_DISTRO_FORMAT_VERSION = 2;
    public static final int INSTALL_FAIL_RULES_TOO_OLD = 3;
    public static final int INSTALL_FAIL_VALIDATION_ERROR = 4;
    private static final String CURRENT_TZ_DATA_DIR_NAME = "current";
    private static final String WORKING_DIR_NAME = "working";
    private static final String OLD_TZ_DATA_DIR_NAME = "old";
    private final String logTag;
    private final File systemTzDataFile;
    private final File oldTzDataDir;
    private final File currentTzDataDir;
    private final File workingDir;

    public TimeZoneDistroInstaller(String logTag, File systemTzDataFile, File installDir) {
        this.logTag = logTag;
        this.systemTzDataFile = systemTzDataFile;
        this.oldTzDataDir = new File(installDir, OLD_TZ_DATA_DIR_NAME);
        this.currentTzDataDir = new File(installDir, CURRENT_TZ_DATA_DIR_NAME);
        this.workingDir = new File(installDir, WORKING_DIR_NAME);
    }

    File getOldTzDataDir() {
        return this.oldTzDataDir;
    }

    File getCurrentTzDataDir() {
        return this.currentTzDataDir;
    }

    File getWorkingDir() {
        return this.workingDir;
    }

    public boolean install(byte[] content) throws IOException {
        int result = this.installWithErrorCode(content);
        return result == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int installWithErrorCode(byte[] content) throws IOException {
        DistroVersion distroVersion;
        if (this.oldTzDataDir.exists()) {
            FileUtils.deleteRecursive(this.oldTzDataDir);
        }
        if (this.workingDir.exists()) {
            FileUtils.deleteRecursive(this.workingDir);
        }
        Slog.i(this.logTag, "Unpacking / verifying time zone update");
        this.unpackDistro(content, this.workingDir);
        try {
            distroVersion = this.readDistroVersion(this.workingDir);
        }
        catch (DistroException e) {
            Slog.i(this.logTag, "Invalid distro version: " + e.getMessage());
            int n = 1;
            this.deleteBestEffort(this.oldTzDataDir);
            this.deleteBestEffort(this.workingDir);
            return n;
        }
        if (distroVersion == null) {
            Slog.i(this.logTag, "Update not applied: Distro version could not be loaded");
            int e = 1;
            return e;
        }
        if (!DistroVersion.isCompatibleWithThisDevice(distroVersion)) {
            Slog.i(this.logTag, "Update not applied: Distro format version check failed: " + distroVersion);
            int e = 2;
            return e;
        }
        if (!this.checkDistroDataFilesExist(this.workingDir)) {
            Slog.i(this.logTag, "Update not applied: Distro is missing required data file(s)");
            int e = 1;
            return e;
        }
        if (!this.checkDistroRulesNewerThanSystem(this.systemTzDataFile, distroVersion)) {
            Slog.i(this.logTag, "Update not applied: Distro rules version check failed");
            int e = 3;
            return e;
        }
        File zoneInfoFile = new File(this.workingDir, "tzdata");
        ZoneInfoDB.TzData tzData = ZoneInfoDB.TzData.loadTzData(zoneInfoFile.getPath());
        if (tzData == null) {
            Slog.i(this.logTag, "Update not applied: " + zoneInfoFile + " could not be loaded");
            int n = 4;
            return n;
        }
        try {
            tzData.validate();
        }
        catch (IOException e) {
            Slog.i(this.logTag, "Update not applied: " + zoneInfoFile + " failed validation", e);
            int n = 4;
            this.deleteBestEffort(this.oldTzDataDir);
            this.deleteBestEffort(this.workingDir);
            return n;
        }
        finally {
            tzData.close();
        }
        Slog.i(this.logTag, "Applying time zone update");
        FileUtils.makeDirectoryWorldAccessible(this.workingDir);
        if (this.currentTzDataDir.exists()) {
            Slog.i(this.logTag, "Moving " + this.currentTzDataDir + " to " + this.oldTzDataDir);
            FileUtils.rename(this.currentTzDataDir, this.oldTzDataDir);
        }
        Slog.i(this.logTag, "Moving " + this.workingDir + " to " + this.currentTzDataDir);
        FileUtils.rename(this.workingDir, this.currentTzDataDir);
        Slog.i(this.logTag, "Update applied: " + this.currentTzDataDir + " successfully created");
        int n = 0;
        return n;
        finally {
            this.deleteBestEffort(this.oldTzDataDir);
            this.deleteBestEffort(this.workingDir);
        }
    }

    public boolean uninstall() throws IOException {
        Slog.i(this.logTag, "Uninstalling time zone update");
        if (this.oldTzDataDir.exists()) {
            FileUtils.deleteRecursive(this.oldTzDataDir);
        }
        if (!this.currentTzDataDir.exists()) {
            Slog.i(this.logTag, "Nothing to uninstall at " + this.currentTzDataDir);
            return false;
        }
        Slog.i(this.logTag, "Moving " + this.currentTzDataDir + " to " + this.oldTzDataDir);
        FileUtils.rename(this.currentTzDataDir, this.oldTzDataDir);
        this.deleteBestEffort(this.oldTzDataDir);
        Slog.i(this.logTag, "Time zone update uninstalled.");
        return true;
    }

    public DistroVersion getInstalledDistroVersion() throws DistroException, IOException {
        if (!this.currentTzDataDir.exists()) {
            return null;
        }
        return this.readDistroVersion(this.currentTzDataDir);
    }

    public String getSystemRulesVersion() throws IOException {
        return this.readSystemRulesVersion(this.systemTzDataFile);
    }

    private void deleteBestEffort(File dir) {
        if (dir.exists()) {
            Slog.i(this.logTag, "Deleting " + dir);
            try {
                FileUtils.deleteRecursive(dir);
            }
            catch (IOException e) {
                Slog.w(this.logTag, "Unable to delete " + dir, e);
            }
        }
    }

    private void unpackDistro(byte[] content, File targetDir) throws IOException {
        Slog.i(this.logTag, "Unpacking update content to: " + targetDir);
        TimeZoneDistro distro = new TimeZoneDistro(content);
        distro.extractTo(targetDir);
    }

    private boolean checkDistroDataFilesExist(File unpackedContentDir) throws IOException {
        Slog.i(this.logTag, "Verifying distro contents");
        return FileUtils.filesExist(unpackedContentDir, "tzdata", "icu/icu_tzdata.dat");
    }

    private DistroVersion readDistroVersion(File distroDir) throws DistroException, IOException {
        Slog.i(this.logTag, "Reading distro format version");
        File distroVersionFile = new File(distroDir, "distro_version");
        if (!distroVersionFile.exists()) {
            throw new DistroException("No distro version file found: " + distroVersionFile);
        }
        byte[] versionBytes = FileUtils.readBytes(distroVersionFile, DistroVersion.DISTRO_VERSION_FILE_LENGTH);
        return DistroVersion.fromBytes(versionBytes);
    }

    private boolean checkDistroRulesNewerThanSystem(File systemTzDataFile, DistroVersion distroVersion) throws IOException {
        boolean canApply;
        Slog.i(this.logTag, "Reading /system rules version");
        String systemRulesVersion = this.readSystemRulesVersion(systemTzDataFile);
        String distroRulesVersion = distroVersion.rulesVersion;
        boolean bl = canApply = distroRulesVersion.compareTo(systemRulesVersion) >= 0;
        if (!canApply) {
            Slog.i(this.logTag, "Failed rules version check: distroRulesVersion=" + distroRulesVersion + ", systemRulesVersion=" + systemRulesVersion);
        } else {
            Slog.i(this.logTag, "Passed rules version check: distroRulesVersion=" + distroRulesVersion + ", systemRulesVersion=" + systemRulesVersion);
        }
        return canApply;
    }

    private String readSystemRulesVersion(File systemTzDataFile) throws IOException {
        if (!systemTzDataFile.exists()) {
            Slog.i(this.logTag, "tzdata file cannot be found in /system");
            throw new FileNotFoundException("system tzdata does not exist: " + systemTzDataFile);
        }
        return ZoneInfoDB.TzData.getRulesVersion(systemTzDataFile);
    }
}

