/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Bundle;
import android.os.UserHandle;
import android.os.UserManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=UserManager.class, minSdk=17)
public class ShadowUserManager {
    private boolean userUnlocked = true;
    private boolean managedProfile = false;
    private Map<UserHandle, Bundle> userRestrictions = new HashMap<UserHandle, Bundle>();

    @Implementation(minSdk=18)
    public Bundle getApplicationRestrictions(String packageName) {
        return null;
    }

    @Implementation(minSdk=21)
    public List<UserHandle> getUserProfiles() {
        return Collections.emptyList();
    }

    @Implementation(minSdk=24)
    public boolean isUserUnlocked() {
        return this.userUnlocked;
    }

    public void setUserUnlocked(boolean userUnlocked) {
        this.userUnlocked = userUnlocked;
    }

    @Implementation(minSdk=21)
    public boolean isManagedProfile() {
        return this.managedProfile;
    }

    public void setManagedProfile(boolean managedProfile) {
        this.managedProfile = managedProfile;
    }

    @Implementation(minSdk=21)
    public boolean hasUserRestriction(String restrictionKey, UserHandle userHandle) {
        Bundle bundle = this.userRestrictions.get(userHandle);
        return bundle != null && bundle.getBoolean(restrictionKey);
    }

    public void setUserRestriction(UserHandle userHandle, String restrictionKey, boolean value) {
        Bundle bundle = this.getUserRestrictionsForUser(userHandle);
        bundle.putBoolean(restrictionKey, value);
    }

    @Implementation(minSdk=18)
    public Bundle getUserRestrictions(UserHandle userHandle) {
        return this.getUserRestrictionsForUser(userHandle);
    }

    private Bundle getUserRestrictionsForUser(UserHandle userHandle) {
        Bundle bundle = this.userRestrictions.get(userHandle);
        if (bundle == null) {
            bundle = new Bundle();
            this.userRestrictions.put(userHandle, bundle);
        }
        return bundle;
    }
}

