/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import java.util.HashMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=RemoteCallbackList.class)
public class ShadowRemoteCallbackList<E extends IInterface> {
    private HashMap<IBinder, Callback> callbacks = new HashMap();
    private Object[] activeBroadcast;
    private int broadcastCount = -1;
    private boolean killed = false;

    @Implementation
    public boolean register(E callback) {
        return this.register(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public boolean register(E callback, Object cookie) {
        HashMap<IBinder, Callback> hashMap = this.callbacks;
        synchronized (hashMap) {
            if (this.killed) {
                return false;
            }
            IBinder binder = callback.asBinder();
            try {
                Callback cb = new Callback(this, callback, cookie);
                binder.linkToDeath((IBinder.DeathRecipient)cb, 0);
                this.callbacks.put(binder, cb);
                return true;
            }
            catch (RemoteException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public boolean unregister(E callback) {
        HashMap<IBinder, Callback> hashMap = this.callbacks;
        synchronized (hashMap) {
            Callback cb = this.callbacks.remove(callback.asBinder());
            if (cb != null) {
                cb.callback.asBinder().unlinkToDeath((IBinder.DeathRecipient)cb, 0);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public void kill() {
        HashMap<IBinder, Callback> hashMap = this.callbacks;
        synchronized (hashMap) {
            for (Callback cb : this.callbacks.values()) {
                cb.callback.asBinder().unlinkToDeath((IBinder.DeathRecipient)cb, 0);
            }
            this.callbacks.clear();
            this.killed = true;
        }
    }

    @Implementation
    public void onCallbackDied(E callback) {
    }

    @Implementation
    public void onCallbackDied(E callback, Object cookie) {
        this.onCallbackDied(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    public int beginBroadcast() {
        HashMap<IBinder, Callback> hashMap = this.callbacks;
        synchronized (hashMap) {
            if (this.broadcastCount > 0) {
                throw new IllegalStateException("beginBroadcast() called while already in a broadcast");
            }
            this.broadcastCount = this.callbacks.size();
            int N = this.broadcastCount;
            if (N <= 0) {
                return 0;
            }
            Object[] active = this.activeBroadcast;
            if (active == null || active.length < N) {
                this.activeBroadcast = active = new Object[N];
            }
            int i = 0;
            for (Callback cb : this.callbacks.values()) {
                active[i++] = cb;
            }
            return i;
        }
    }

    @Implementation
    public E getBroadcastItem(int index) {
        return ((Callback)this.activeBroadcast[index]).callback;
    }

    @Implementation
    public Object getBroadcastCookie(int index) {
        return ((Callback)this.activeBroadcast[index]).cookie;
    }

    @Implementation
    public void finishBroadcast() {
        if (this.broadcastCount < 0) {
            throw new IllegalStateException("finishBroadcast() called outside of a broadcast");
        }
        Object[] active = this.activeBroadcast;
        if (active != null) {
            int N = this.broadcastCount;
            for (int i = 0; i < N; ++i) {
                active[i] = null;
            }
        }
        this.broadcastCount = -1;
    }

    private static final class Callback
    implements IBinder.DeathRecipient {
        final E callback;
        final Object cookie;
        final /* synthetic */ ShadowRemoteCallbackList this$0;

        Callback(E callback, Object cookie) {
            this.this$0 = var1_1;
            this.callback = callback;
            this.cookie = cookie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            HashMap hashMap = this.this$0.callbacks;
            synchronized (hashMap) {
                this.this$0.callbacks.remove(this.callback.asBinder());
            }
            this.this$0.onCallbackDied(this.callback, this.cookie);
        }
    }
}

