/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=ShortcutManager.class, minSdk=25)
public class ShadowShortcutManager {
    private static final int MAX_ICON_DIMENSION = 128;
    private static final int MAX_NUM_SHORTCUTS_PER_ACTIVITY = 16;
    private final Map<String, ShortcutInfo> dynamicShortcuts = new HashMap<String, ShortcutInfo>();
    private final Map<String, ShortcutInfo> activePinnedShortcuts = new HashMap<String, ShortcutInfo>();
    private final Map<String, ShortcutInfo> disabledPinnedShortcuts = new HashMap<String, ShortcutInfo>();
    private boolean isRequestPinShortcutSupported = true;

    @Implementation
    public boolean addDynamicShortcuts(List<ShortcutInfo> shortcutInfoList) {
        for (ShortcutInfo shortcutInfo : shortcutInfoList) {
            ShortcutInfo previousShortcut;
            if (this.activePinnedShortcuts.containsKey(shortcutInfo.getId())) {
                previousShortcut = this.activePinnedShortcuts.get(shortcutInfo.getId());
                if (previousShortcut.isImmutable()) continue;
                this.activePinnedShortcuts.put(shortcutInfo.getId(), shortcutInfo);
                continue;
            }
            if (this.disabledPinnedShortcuts.containsKey(shortcutInfo.getId())) {
                previousShortcut = this.disabledPinnedShortcuts.get(shortcutInfo.getId());
                if (previousShortcut.isImmutable()) continue;
                this.disabledPinnedShortcuts.put(shortcutInfo.getId(), shortcutInfo);
                continue;
            }
            if (this.dynamicShortcuts.containsKey(shortcutInfo.getId())) {
                previousShortcut = this.dynamicShortcuts.get(shortcutInfo.getId());
                if (previousShortcut.isImmutable()) continue;
                this.dynamicShortcuts.put(shortcutInfo.getId(), shortcutInfo);
                continue;
            }
            this.dynamicShortcuts.put(shortcutInfo.getId(), shortcutInfo);
        }
        return true;
    }

    @Implementation(minSdk=10000)
    public Intent createShortcutResultIntent(ShortcutInfo shortcut) {
        if (this.disabledPinnedShortcuts.containsKey(shortcut.getId())) {
            throw new IllegalArgumentException();
        }
        return new Intent();
    }

    @Implementation
    public void disableShortcuts(List<String> shortcutIds) {
        this.disableShortcuts(shortcutIds, "Shortcut is disabled.");
    }

    @Implementation
    public void disableShortcuts(List<String> shortcutIds, CharSequence unused) {
        for (String shortcutId : shortcutIds) {
            ShortcutInfo shortcut = this.activePinnedShortcuts.remove(shortcutId);
            if (shortcut == null) continue;
            this.disabledPinnedShortcuts.put(shortcutId, shortcut);
        }
    }

    @Implementation
    public void enableShortcuts(List<String> shortcutIds) {
        for (String shortcutId : shortcutIds) {
            ShortcutInfo shortcut = this.disabledPinnedShortcuts.remove(shortcutId);
            if (shortcut == null) continue;
            this.activePinnedShortcuts.put(shortcutId, shortcut);
        }
    }

    @Implementation
    public List<ShortcutInfo> getDynamicShortcuts() {
        return ImmutableList.copyOf(this.dynamicShortcuts.values());
    }

    @Implementation
    public int getIconMaxHeight() {
        return 128;
    }

    @Implementation
    public int getIconMaxWidth() {
        return 128;
    }

    @Implementation
    public List<ShortcutInfo> getManifestShortcuts() {
        return ImmutableList.of();
    }

    @Implementation
    public int getMaxShortcutCountPerActivity() {
        return 16;
    }

    @Implementation
    public List<ShortcutInfo> getPinnedShortcuts() {
        ImmutableList.Builder pinnedShortcuts = ImmutableList.builder();
        pinnedShortcuts.addAll(this.activePinnedShortcuts.values());
        pinnedShortcuts.addAll(this.disabledPinnedShortcuts.values());
        return pinnedShortcuts.build();
    }

    @Implementation
    public boolean isRateLimitingActive() {
        return false;
    }

    @Implementation(minSdk=10000)
    public boolean isRequestPinShortcutSupported() {
        return this.isRequestPinShortcutSupported;
    }

    public void setIsRequestPinShortcutSupported(boolean isRequestPinShortcutSupported) {
        this.isRequestPinShortcutSupported = isRequestPinShortcutSupported;
    }

    @Implementation
    public void removeAllDynamicShortcuts() {
        this.dynamicShortcuts.clear();
    }

    @Implementation
    public void removeDynamicShortcuts(List<String> shortcutIds) {
        for (String shortcutId : shortcutIds) {
            this.dynamicShortcuts.remove(shortcutId);
        }
    }

    @Implementation
    public void reportShortcutUsed(String shortcutId) {
    }

    @Implementation(minSdk=10000)
    public boolean requestPinShortcut(ShortcutInfo shortcut, IntentSender resultIntent) {
        if (this.disabledPinnedShortcuts.containsKey(shortcut.getId())) {
            throw new IllegalArgumentException("Shortcut with ID [" + shortcut.getId() + "] already exists and is disabled.");
        }
        if (this.dynamicShortcuts.containsKey(shortcut.getId())) {
            this.activePinnedShortcuts.put(shortcut.getId(), this.dynamicShortcuts.remove(shortcut.getId()));
        } else {
            this.activePinnedShortcuts.put(shortcut.getId(), shortcut);
        }
        if (resultIntent != null) {
            try {
                resultIntent.sendIntent((Context)RuntimeEnvironment.application, 0, null, null, null);
            }
            catch (IntentSender.SendIntentException e) {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    @Implementation
    public boolean setDynamicShortcuts(List<ShortcutInfo> shortcutInfoList) {
        this.dynamicShortcuts.clear();
        return this.addDynamicShortcuts(shortcutInfoList);
    }

    @Implementation
    public boolean updateShortcuts(List<ShortcutInfo> shortcutInfoList) {
        ArrayList<ShortcutInfo> existingShortcutsToUpdate = new ArrayList<ShortcutInfo>();
        for (ShortcutInfo shortcutInfo : shortcutInfoList) {
            if (!this.dynamicShortcuts.containsKey(shortcutInfo.getId()) && !this.activePinnedShortcuts.containsKey(shortcutInfo.getId()) && !this.disabledPinnedShortcuts.containsKey(shortcutInfo.getId())) continue;
            existingShortcutsToUpdate.add(shortcutInfo);
        }
        return this.addDynamicShortcuts(existingShortcutsToUpdate);
    }
}

