/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.Interceptor;
import org.robolectric.internal.bytecode.Interceptors;
import org.robolectric.internal.bytecode.Sandbox;
import org.robolectric.internal.bytecode.SandboxClassLoader;
import org.robolectric.internal.bytecode.SandboxConfig;
import org.robolectric.internal.bytecode.ShadowMap;
import org.robolectric.internal.bytecode.ShadowWrangler;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.PerfStatsReporter;

public class SandboxTestRunner
extends BlockJUnit4ClassRunner {
    private final Interceptors interceptors;
    private final List<PerfStatsReporter> perfStatsReporters;
    private final HashSet<Class<?>> loadedTestClasses = new HashSet();

    public SandboxTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.interceptors = new Interceptors(this.findInterceptors());
        this.perfStatsReporters = Lists.newArrayList(this.getPerfStatsReporters().iterator());
    }

    @Nonnull
    protected Iterable<PerfStatsReporter> getPerfStatsReporters() {
        return ServiceLoader.load(PerfStatsReporter.class);
    }

    @Nonnull
    protected Collection<Interceptor> findInterceptors() {
        return Collections.emptyList();
    }

    @Nonnull
    protected Interceptors getInterceptors() {
        return this.interceptors;
    }

    protected Statement classBlock(RunNotifier notifier) {
        final Statement statement = this.childrenInvoker(notifier);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                    for (Class testClass : SandboxTestRunner.this.loadedTestClasses) {
                        SandboxTestRunner.invokeAfterClass(testClass);
                    }
                }
                finally {
                    SandboxTestRunner.this.afterClass();
                    SandboxTestRunner.this.loadedTestClasses.clear();
                }
            }
        };
    }

    private void invokeBeforeClass(Class clazz) throws Throwable {
        if (!this.loadedTestClasses.contains(clazz)) {
            this.loadedTestClasses.add(clazz);
            TestClass testClass = new TestClass(clazz);
            List befores = testClass.getAnnotatedMethods(BeforeClass.class);
            for (FrameworkMethod before : befores) {
                before.invokeExplosively(null, new Object[0]);
            }
        }
    }

    private static void invokeAfterClass(Class<?> clazz) throws Throwable {
        TestClass testClass = new TestClass(clazz);
        List afters = testClass.getAnnotatedMethods(AfterClass.class);
        for (FrameworkMethod after : afters) {
            after.invokeExplosively(null, new Object[0]);
        }
    }

    protected void afterClass() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        if (this.shouldIgnore(method)) {
            eachNotifier.fireTestIgnored();
        } else {
            eachNotifier.fireTestStarted();
            try {
                this.methodBlock(method).evaluate();
            }
            catch (AssumptionViolatedException e) {
                eachNotifier.addFailedAssumption(e);
            }
            catch (Throwable e) {
                eachNotifier.addFailure(e);
            }
            finally {
                eachNotifier.fireTestFinished();
            }
        }
    }

    @Nonnull
    protected Sandbox getSandbox(FrameworkMethod method) {
        InstrumentationConfiguration instrumentationConfiguration = this.createClassLoaderConfig(method);
        URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        SandboxClassLoader sandboxClassLoader = new SandboxClassLoader((ClassLoader)systemClassLoader, instrumentationConfiguration, new URL[0]);
        Sandbox sandbox = new Sandbox((ClassLoader)sandboxClassLoader);
        this.configureShadows(method, sandbox);
        return sandbox;
    }

    @Nonnull
    protected InstrumentationConfiguration createClassLoaderConfig(FrameworkMethod method) {
        InstrumentationConfiguration.Builder builder = InstrumentationConfiguration.newBuilder().doNotAcquirePackage("java.").doNotAcquirePackage("sun.").doNotAcquirePackage("org.robolectric.annotation.").doNotAcquirePackage("org.robolectric.internal.").doNotAcquirePackage("org.robolectric.util.").doNotAcquirePackage("org.junit.");
        for (Class<?> shadowClass : this.getExtraShadows(method)) {
            ShadowMap.ShadowInfo shadowInfo = ShadowMap.getShadowInfo(shadowClass);
            builder.addInstrumentedClass(shadowInfo.getShadowedClassName());
        }
        this.addInstrumentedPackages(method, builder);
        return builder.build();
    }

    private void addInstrumentedPackages(FrameworkMethod method, InstrumentationConfiguration.Builder builder) {
        SandboxConfig methodConfig;
        SandboxConfig classConfig = this.getTestClass().getJavaClass().getAnnotation(SandboxConfig.class);
        if (classConfig != null) {
            for (String pkgName : classConfig.instrumentedPackages()) {
                builder.addInstrumentedPackage(pkgName);
            }
        }
        if ((methodConfig = (SandboxConfig)method.getAnnotation(SandboxConfig.class)) != null) {
            for (String pkgName : methodConfig.instrumentedPackages()) {
                builder.addInstrumentedPackage(pkgName);
            }
        }
    }

    protected void configureShadows(FrameworkMethod method, Sandbox sandbox) {
        ShadowMap.Builder builder = this.createShadowMap().newBuilder();
        Class[] shadows = this.getExtraShadows(method);
        if (shadows.length > 0) {
            builder.addShadowClasses(shadows);
        }
        ShadowMap shadowMap = builder.build();
        sandbox.replaceShadowMap(shadowMap);
        sandbox.configure(this.createClassHandler(shadowMap, sandbox), this.getInterceptors());
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Method bootstrappedMethod;
                PerfStatsCollector perfStatsCollector = PerfStatsCollector.getInstance();
                perfStatsCollector.reset();
                perfStatsCollector.setEnabled(!SandboxTestRunner.this.perfStatsReporters.isEmpty());
                PerfStatsCollector.Event initialization = perfStatsCollector.startEvent("initialization");
                Sandbox sandbox = SandboxTestRunner.this.getSandbox(method);
                SandboxTestRunner.this.configureShadows(method, sandbox);
                ClassLoader priorContextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(sandbox.getRobolectricClassLoader());
                Class bootstrappedTestClass = sandbox.bootstrappedClass(SandboxTestRunner.this.getTestClass().getJavaClass());
                HelperTestRunner helperTestRunner = SandboxTestRunner.this.getHelperTestRunner(bootstrappedTestClass);
                helperTestRunner.frameworkMethod = method;
                try {
                    bootstrappedMethod = bootstrappedTestClass.getMethod(method.getMethod().getName(), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                try {
                    SandboxTestRunner.this.invokeBeforeClass(bootstrappedTestClass);
                    SandboxTestRunner.this.beforeTest(sandbox, method, bootstrappedMethod);
                    initialization.finished();
                    Statement statement = helperTestRunner.methodBlock(new FrameworkMethod(bootstrappedMethod));
                    try {
                        statement.evaluate();
                    }
                    finally {
                        SandboxTestRunner.this.afterTest(method, bootstrappedMethod);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(priorContextClassLoader);
                    SandboxTestRunner.this.finallyAfterTest(method);
                    SandboxTestRunner.this.reportPerfStats(perfStatsCollector);
                    perfStatsCollector.reset();
                }
            }
        };
    }

    private void reportPerfStats(PerfStatsCollector perfStatsCollector) {
        if (this.perfStatsReporters.isEmpty()) {
            return;
        }
        PerfStatsCollector.Metadata metadata = perfStatsCollector.getMetadata();
        Collection metrics = perfStatsCollector.getMetrics();
        for (PerfStatsReporter perfStatsReporter : this.perfStatsReporters) {
            try {
                perfStatsReporter.report(metadata, metrics);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void beforeTest(Sandbox sandbox, FrameworkMethod method, Method bootstrappedMethod) throws Throwable {
    }

    protected void afterTest(FrameworkMethod method, Method bootstrappedMethod) {
    }

    protected void finallyAfterTest(FrameworkMethod method) {
    }

    protected HelperTestRunner getHelperTestRunner(Class bootstrappedTestClass) {
        try {
            return new HelperTestRunner(bootstrappedTestClass);
        }
        catch (InitializationError initializationError) {
            throw new RuntimeException(initializationError);
        }
    }

    @Nonnull
    protected Class<?>[] getExtraShadows(FrameworkMethod method) {
        ArrayList shadowClasses = new ArrayList();
        this.addShadows(shadowClasses, this.getTestClass().getJavaClass().getAnnotation(SandboxConfig.class));
        this.addShadows(shadowClasses, (SandboxConfig)method.getAnnotation(SandboxConfig.class));
        return shadowClasses.toArray(new Class[shadowClasses.size()]);
    }

    private void addShadows(List<Class<?>> shadowClasses, SandboxConfig annotation) {
        if (annotation != null) {
            shadowClasses.addAll(Arrays.asList(annotation.shadows()));
        }
    }

    protected ShadowMap createShadowMap() {
        return ShadowMap.EMPTY;
    }

    @Nonnull
    protected ClassHandler createClassHandler(ShadowMap shadowMap, Sandbox sandbox) {
        return new ShadowWrangler(shadowMap, 0, this.interceptors);
    }

    protected boolean shouldIgnore(FrameworkMethod method) {
        return method.getAnnotation(Ignore.class) != null;
    }

    protected static class HelperTestRunner
    extends BlockJUnit4ClassRunner {
        public FrameworkMethod frameworkMethod;

        public HelperTestRunner(Class<?> klass) throws InitializationError {
            super(klass);
        }

        protected Statement methodBlock(FrameworkMethod method) {
            return super.methodBlock(method);
        }
    }
}

