/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal;

import com.google.common.base.Splitter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.robolectric.internal.TimeLimitedStatement;
import org.robolectric.internal.bytecode.ClassHandler;
import org.robolectric.internal.bytecode.ClassHandlerBuilder;
import org.robolectric.internal.bytecode.ClassInstrumentor;
import org.robolectric.internal.bytecode.InstrumentationConfiguration;
import org.robolectric.internal.bytecode.Interceptor;
import org.robolectric.internal.bytecode.Interceptors;
import org.robolectric.internal.bytecode.ResourceProvider;
import org.robolectric.internal.bytecode.Sandbox;
import org.robolectric.internal.bytecode.SandboxConfig;
import org.robolectric.internal.bytecode.ShadowInfo;
import org.robolectric.internal.bytecode.ShadowMap;
import org.robolectric.internal.bytecode.ShadowProviders;
import org.robolectric.internal.bytecode.UrlResourceProvider;
import org.robolectric.pluginapi.perf.Metadata;
import org.robolectric.pluginapi.perf.PerfStatsReporter;
import org.robolectric.sandbox.ShadowMatcher;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Util;
import org.robolectric.util.inject.Injector;

public class SandboxTestRunner
extends BlockJUnit4ClassRunner {
    private static final Injector DEFAULT_INJECTOR = SandboxTestRunner.defaultInjector().build();
    private final ClassInstrumentor classInstrumentor;
    private final Interceptors interceptors;
    private final ShadowProviders shadowProviders;
    protected final ClassHandlerBuilder classHandlerBuilder;
    private final List<PerfStatsReporter> perfStatsReporters;
    private final HashMap<Class<?>, Sandbox> loadedTestClasses = new HashMap();
    private final HashSet<Class<?>> invokedBeforeClasses = new HashSet();
    private final HashMap<Class<?>, HelperTestRunner> helperRunners = new HashMap();
    private final WeakHashMap<Sandbox, LinkageError> firstLinkageErrors = new WeakHashMap();
    private static final boolean USE_LEGACY_SANDBOX_FLOW = Boolean.getBoolean("robolectric.useLegacySandboxFlow");

    protected static Injector.Builder defaultInjector() {
        return new Injector.Builder();
    }

    public SandboxTestRunner(Class<?> klass) throws InitializationError {
        this(klass, DEFAULT_INJECTOR);
    }

    public SandboxTestRunner(Class<?> klass, Injector injector) throws InitializationError {
        super(klass);
        this.classInstrumentor = (ClassInstrumentor)injector.getInstance(ClassInstrumentor.class);
        this.interceptors = new Interceptors(this.findInterceptors());
        this.shadowProviders = (ShadowProviders)injector.getInstance(ShadowProviders.class);
        this.classHandlerBuilder = (ClassHandlerBuilder)injector.getInstance(ClassHandlerBuilder.class);
        this.perfStatsReporters = Arrays.asList((PerfStatsReporter[])injector.getInstance(PerfStatsReporter[].class));
    }

    @Nonnull
    protected Collection<Interceptor> findInterceptors() {
        return Collections.emptyList();
    }

    @Nonnull
    protected Interceptors getInterceptors() {
        return this.interceptors;
    }

    protected Statement classBlock(RunNotifier notifier) {
        if (USE_LEGACY_SANDBOX_FLOW) {
            return this.legacyClassBlock(notifier);
        }
        return this.sandboxGroupingClassBlock(notifier);
    }

    private Statement legacyClassBlock(RunNotifier notifier) {
        Statement statement = this.childrenInvoker(notifier);
        statement = this.withAfterClassesInSandbox(statement);
        if (SandboxTestRunner.hasClassRules(this.getTestClass().getJavaClass())) {
            statement = this.withClassRulesInSandbox(statement);
        }
        return statement;
    }

    private Statement sandboxGroupingClassBlock(final RunNotifier notifier) {
        List children = (List)ReflectionHelpers.callInstanceMethod((Object)((Object)this), (String)"getFilteredChildren", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        final LinkedHashMap<Sandbox, List> methodsBySandbox = new LinkedHashMap<Sandbox, List>();
        for (FrameworkMethod method : children) {
            Description description = this.describeChild(method);
            if (!this.isIgnored(method)) {
                try {
                    Sandbox sandbox = this.getSandbox(method);
                    methodsBySandbox.computeIfAbsent(sandbox, k -> new ArrayList()).add(method);
                }
                catch (IllegalArgumentException e) {
                    notifier.fireTestStarted(description);
                    notifier.fireTestFailure(new Failure(description, (Throwable)e));
                    notifier.fireTestFinished(description);
                }
                continue;
            }
            notifier.fireTestIgnored(description);
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                for (Map.Entry entry : methodsBySandbox.entrySet()) {
                    Sandbox sandbox = (Sandbox)entry.getKey();
                    FrameworkMethod firstMethod = (FrameworkMethod)((List)entry.getValue()).get(0);
                    if (sandbox.isShutdown()) {
                        sandbox = SandboxTestRunner.this.getSandbox(firstMethod);
                    }
                    Statement statement = SandboxTestRunner.this.childrenInvoker((List)entry.getValue(), notifier);
                    Class bootstrappedTestClass = sandbox.bootstrappedClass(SandboxTestRunner.this.getTestClass().getJavaClass());
                    HelperTestRunner helperTestRunner = SandboxTestRunner.this.getCachedHelperTestRunner(bootstrappedTestClass);
                    statement = helperTestRunner.withBeforeClasses(statement);
                    statement = helperTestRunner.withAfterClasses(statement);
                    statement = SandboxTestRunner.this.withClassRules(statement, bootstrappedTestClass);
                    Statement statementsOfTestGroup = SandboxTestRunner.this.inSandboxThread(sandbox, firstMethod, statement);
                    statementsOfTestGroup.evaluate();
                }
            }
        };
    }

    private static boolean hasClassRules(Class<?> testClass) {
        for (Field field : testClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(ClassRule.class)) continue;
            return true;
        }
        return false;
    }

    private Statement withAfterClassesInSandbox(final Statement base) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                    for (Map.Entry entry : SandboxTestRunner.this.loadedTestClasses.entrySet()) {
                        Sandbox sandbox = (Sandbox)entry.getValue();
                        sandbox.runOnMainThread(() -> {
                            ClassLoader priorContextClassLoader = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(sandbox.getRobolectricClassLoader());
                            try {
                                SandboxTestRunner.invokeAfterClass((Class)entry.getKey());
                            }
                            catch (Throwable throwable) {
                                throw Util.sneakyThrow((Throwable)throwable);
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(priorContextClassLoader);
                            }
                        });
                    }
                }
                finally {
                    SandboxTestRunner.this.afterClass();
                    SandboxTestRunner.this.loadedTestClasses.clear();
                }
            }
        };
    }

    private Statement withClassRules(final Statement statement, Class<?> bootstrappedTestClass) {
        final HelperTestRunner helperTestRunner = this.getCachedHelperTestRunner(bootstrappedTestClass);
        return new Statement(){

            public void evaluate() throws Throwable {
                List<TestRule> classRules = helperTestRunner.classRules();
                if (!classRules.isEmpty()) {
                    RunRules runRules = new RunRules(statement, classRules, SandboxTestRunner.this.getDescription());
                    runRules.evaluate();
                } else {
                    statement.evaluate();
                }
            }
        };
    }

    private Statement withClassRulesInSandbox(Statement statement) {
        for (FrameworkMethod frameworkMethod : this.getChildren()) {
            Sandbox sandbox = this.getSandbox(frameworkMethod);
            Class bootstrappedTestClass = sandbox.bootstrappedClass(this.getTestClass().getJavaClass());
            if (this.loadedTestClasses.containsKey(bootstrappedTestClass)) continue;
            this.loadedTestClasses.put(bootstrappedTestClass, sandbox);
            this.configureSandbox(sandbox, frameworkMethod);
            HelperTestRunner helperTestRunner = this.getCachedHelperTestRunner(bootstrappedTestClass);
            List<TestRule> classRules = helperTestRunner.classRules();
            for (TestRule classRule : classRules) {
                statement = this.applyRuleInSandbox(classRule, sandbox, statement, this.getDescription());
            }
        }
        return statement;
    }

    private Statement applyRuleInSandbox(final TestRule rule, final Sandbox sandbox, final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ClassLoader priorContextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(sandbox.getRobolectricClassLoader());
                try {
                    rule.apply(base, description).evaluate();
                }
                catch (Throwable throwable) {
                    throw Util.sneakyThrow((Throwable)throwable);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(priorContextClassLoader);
                }
            }
        };
    }

    private void invokeBeforeClass(Class<?> clazz) throws Throwable {
        if (!this.invokedBeforeClasses.contains(clazz)) {
            this.invokedBeforeClasses.add(clazz);
            TestClass testClass = new TestClass(clazz);
            List befores = testClass.getAnnotatedMethods(BeforeClass.class);
            for (FrameworkMethod before : befores) {
                before.invokeExplosively(null, new Object[0]);
            }
        }
    }

    private static void invokeAfterClass(Class<?> clazz) throws Throwable {
        TestClass testClass = new TestClass(clazz);
        List afters = testClass.getAnnotatedMethods(AfterClass.class);
        for (FrameworkMethod after : afters) {
            after.invokeExplosively(null, new Object[0]);
        }
    }

    private Statement inSandboxThread(final Sandbox sandbox, final FrameworkMethod firstMethod, final Statement base) {
        return new Statement(){

            public void evaluate() throws Throwable {
                SandboxTestRunner.this.configureSandbox(sandbox, firstMethod);
                sandbox.runOnMainThread(() -> {
                    ClassLoader priorContextClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(sandbox.getRobolectricClassLoader());
                    try {
                        base.evaluate();
                    }
                    catch (Throwable throwable) {
                        throw Util.sneakyThrow((Throwable)throwable);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(priorContextClassLoader);
                    }
                });
            }
        };
    }

    private Statement childrenInvoker(final List<FrameworkMethod> children, final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() throws Throwable {
                for (FrameworkMethod method : children) {
                    SandboxTestRunner.this.runChild(method, notifier);
                }
            }
        };
    }

    protected void afterClass() {
    }

    @Nonnull
    protected Sandbox getSandbox(FrameworkMethod method) {
        InstrumentationConfiguration instrumentationConfiguration = this.createClassLoaderConfig(method);
        return new Sandbox(instrumentationConfiguration, (ResourceProvider)new UrlResourceProvider(new URL[0]), this.classInstrumentor);
    }

    @Nonnull
    protected InstrumentationConfiguration createClassLoaderConfig(FrameworkMethod method) {
        InstrumentationConfiguration.Builder builder = InstrumentationConfiguration.newBuilder();
        String customPackages = System.getProperty("org.robolectric.packagesToNotAcquire", "");
        for (String pkg : Splitter.on((char)',').split((CharSequence)customPackages)) {
            if (pkg.isEmpty()) continue;
            builder.doNotAcquirePackage(pkg);
        }
        String customClassesRegex = System.getProperty("org.robolectric.classesToNotInstrumentRegex", "");
        if (!customClassesRegex.isEmpty()) {
            builder.setDoNotInstrumentClassRegex(customClassesRegex);
        }
        for (Class<?> shadowClass : this.getExtraShadows(method)) {
            ShadowInfo shadowInfo = ShadowMap.obtainShadowInfo(shadowClass);
            builder.addInstrumentedClass(shadowInfo.shadowedClassName);
        }
        this.addInstrumentedPackages(method, builder);
        return builder.build();
    }

    private void addInstrumentedPackages(FrameworkMethod method, InstrumentationConfiguration.Builder builder) {
        SandboxConfig methodConfig;
        SandboxConfig classConfig = this.getTestClass().getJavaClass().getAnnotation(SandboxConfig.class);
        if (classConfig != null) {
            for (String pkgName : classConfig.instrumentedPackages()) {
                builder.addInstrumentedPackage(pkgName);
            }
        }
        if ((methodConfig = (SandboxConfig)method.getAnnotation(SandboxConfig.class)) != null) {
            for (String pkgName : methodConfig.instrumentedPackages()) {
                builder.addInstrumentedPackage(pkgName);
            }
        }
    }

    protected void configureSandbox(Sandbox sandbox, FrameworkMethod method) {
        ShadowMap.Builder builder = this.shadowProviders.getBaseShadowMap().newBuilder();
        Class[] shadows = this.getExtraShadows(method);
        if (shadows.length > 0) {
            builder.addShadowClasses(shadows);
        }
        ShadowMap shadowMap = builder.build();
        sandbox.replaceShadowMap(shadowMap);
        sandbox.configure(this.createClassHandler(shadowMap, sandbox), this.getInterceptors());
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        return new Statement(){

            public void evaluate() throws Throwable {
                PerfStatsCollector perfStatsCollector = PerfStatsCollector.getInstance();
                perfStatsCollector.setEnabled(!SandboxTestRunner.this.perfStatsReporters.isEmpty());
                PerfStatsCollector.Event initialization = perfStatsCollector.startEvent("initialization");
                Sandbox sandbox = SandboxTestRunner.this.getSandbox(method);
                SandboxTestRunner.this.configureSandbox(sandbox, method);
                if (USE_LEGACY_SANDBOX_FLOW) {
                    PerfStatsCollector finalPerfStatsCollector = perfStatsCollector;
                    PerfStatsCollector.Event finalInitialization = initialization;
                    sandbox.runOnMainThread(() -> SandboxTestRunner.this.executeInSandbox(sandbox, method, finalPerfStatsCollector, finalInitialization));
                } else {
                    SandboxTestRunner.this.executeInSandbox(sandbox, method, perfStatsCollector, initialization);
                }
            }
        };
    }

    private void executeInSandbox(Sandbox sandbox, FrameworkMethod method, PerfStatsCollector perfStatsCollector, PerfStatsCollector.Event initialization) {
        Method bootstrappedMethod;
        ClassLoader priorContextClassLoader = null;
        if (USE_LEGACY_SANDBOX_FLOW) {
            priorContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(sandbox.getRobolectricClassLoader());
        }
        Class bootstrappedTestClass = sandbox.bootstrappedClass(this.getTestClass().getJavaClass());
        HelperTestRunner helperTestRunner = this.getCachedHelperTestRunner(bootstrappedTestClass);
        helperTestRunner.frameworkMethod = method;
        Class bootstrappedMethodClass = sandbox.bootstrappedClass(method.getMethod().getDeclaringClass());
        try {
            Class[] parameterTypes = (Class[])Arrays.stream(method.getMethod().getParameterTypes()).map(type -> type.isPrimitive() ? type : sandbox.bootstrappedClass(type)).toArray(Class[]::new);
            bootstrappedMethod = bootstrappedMethodClass.getMethod(method.getMethod().getName(), parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        ArrayDeque<Throwable> thrown = new ArrayDeque<Throwable>();
        try {
            if (USE_LEGACY_SANDBOX_FLOW) {
                this.invokeBeforeClass(bootstrappedTestClass);
                this.loadedTestClasses.putIfAbsent(bootstrappedTestClass, sandbox);
            }
            this.beforeTest(sandbox, method, bootstrappedMethod);
            initialization.finished();
            Statement statement = helperTestRunner.methodBlock(new FrameworkMethod(bootstrappedMethod));
            statement.evaluate();
        }
        catch (Throwable throwable) {
            thrown.add(throwable);
        }
        try {
            this.afterTest(method, bootstrappedMethod);
        }
        catch (Throwable throwable) {
            thrown.add(throwable);
        }
        try {
            if (USE_LEGACY_SANDBOX_FLOW) {
                Thread.currentThread().setContextClassLoader(priorContextClassLoader);
            }
            this.finallyAfterTest(method);
            this.reportPerfStats(perfStatsCollector);
            perfStatsCollector.reset();
        }
        catch (Throwable throwable) {
            thrown.add(throwable);
        }
        Throwable first = (Throwable)thrown.poll();
        if (first != null) {
            if (first instanceof LinkageError) {
                first = this.handleLinkageError(first, sandbox);
            }
            while (!thrown.isEmpty()) {
                first.addSuppressed((Throwable)thrown.remove());
            }
            throw Util.sneakyThrow((Throwable)first);
        }
    }

    private Throwable handleLinkageError(Throwable throwable, Sandbox sandbox) {
        if (!this.firstLinkageErrors.containsKey(sandbox)) {
            this.firstLinkageErrors.put(sandbox, (LinkageError)throwable);
            return throwable;
        }
        if (throwable instanceof NoClassDefFoundError && this.firstLinkageErrors.containsKey(sandbox) && this.linkageErrorsMatch((NoClassDefFoundError)throwable, this.firstLinkageErrors.get(sandbox))) {
            return this.firstLinkageErrors.get(sandbox);
        }
        return throwable;
    }

    private boolean linkageErrorsMatch(NoClassDefFoundError error, LinkageError first) {
        if (error.getStackTrace().length == 0 || first.getStackTrace().length == 0) {
            return false;
        }
        StackTraceElement firstElement = error.getStackTrace()[0];
        for (StackTraceElement element : first.getStackTrace()) {
            if (!Objects.equals(firstElement, element)) continue;
            return true;
        }
        return false;
    }

    private void reportPerfStats(PerfStatsCollector perfStatsCollector) {
        if (this.perfStatsReporters.isEmpty()) {
            return;
        }
        Metadata metadata = perfStatsCollector.getMetadata();
        Collection metrics = perfStatsCollector.getMetrics();
        for (PerfStatsReporter perfStatsReporter : this.perfStatsReporters) {
            try {
                perfStatsReporter.report(metadata, metrics);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void beforeTest(Sandbox sandbox, FrameworkMethod method, Method bootstrappedMethod) throws Throwable {
    }

    protected void afterTest(FrameworkMethod method, Method bootstrappedMethod) {
    }

    protected void finallyAfterTest(FrameworkMethod method) {
    }

    protected HelperTestRunner getHelperTestRunner(Class<?> bootstrappedTestClass) throws InitializationError {
        return new HelperTestRunner(bootstrappedTestClass);
    }

    private HelperTestRunner getCachedHelperTestRunner(Class<?> bootstrappedTestClass) {
        return this.helperRunners.computeIfAbsent(bootstrappedTestClass, klass -> {
            try {
                return this.getHelperTestRunner((Class<?>)klass);
            }
            catch (InitializationError e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Nonnull
    protected Class<?>[] getExtraShadows(FrameworkMethod method) {
        ArrayList shadowClasses = new ArrayList();
        this.addShadows(shadowClasses, this.getTestClass().getJavaClass().getAnnotation(SandboxConfig.class));
        this.addShadows(shadowClasses, (SandboxConfig)method.getAnnotation(SandboxConfig.class));
        return shadowClasses.toArray(new Class[0]);
    }

    private void addShadows(List<Class<?>> shadowClasses, SandboxConfig annotation) {
        if (annotation != null) {
            shadowClasses.addAll(Arrays.asList(annotation.shadows()));
        }
    }

    @Nonnull
    protected ClassHandler createClassHandler(ShadowMap shadowMap, Sandbox sandbox) {
        return this.classHandlerBuilder.build(shadowMap, ShadowMatcher.MATCH_ALL, this.interceptors);
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        return next;
    }

    protected static class HelperTestRunner
    extends BlockJUnit4ClassRunner {
        public FrameworkMethod frameworkMethod;

        public HelperTestRunner(Class<?> klass) throws InitializationError {
            super(klass);
        }

        protected Statement methodBlock(FrameworkMethod method) {
            return super.methodBlock(method);
        }

        public List<TestRule> classRules() {
            return super.classRules();
        }

        protected Statement withAfterClasses(Statement statement) {
            return super.withAfterClasses(statement);
        }

        protected Statement withBeforeClasses(Statement statement) {
            return super.withBeforeClasses(statement);
        }

        protected Statement methodInvoker(FrameworkMethod method, Object test) {
            Statement delegate = super.methodInvoker(method, test);
            long timeout = this.getTimeout((Test)method.getAnnotation(Test.class));
            if (timeout == 0L) {
                return delegate;
            }
            return new TimeLimitedStatement(timeout, delegate);
        }

        protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
            return next;
        }

        private long getTimeout(Test annotation) {
            if (annotation == null) {
                return 0L;
            }
            return annotation.timeout();
        }

        protected String testName(FrameworkMethod method) {
            return this.frameworkMethod.getName();
        }
    }
}

