/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.nativeruntime;

import android.database.CursorWindow;
import android.graphics.Typeface;
import android.text.Hyphenator;
import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javax.annotation.Priority;
import org.robolectric.pluginapi.NativeRuntimeLoader;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.Logger;
import org.robolectric.util.OsUtil;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.TempDirectory;
import org.robolectric.util.inject.Injector;
import org.robolectric.versioning.AndroidVersions;

@Priority(value=-2147483648)
@AutoService(value={NativeRuntimeLoader.class})
public class DefaultNativeRuntimeLoader
implements NativeRuntimeLoader {
    protected static final AtomicBoolean loaded = new AtomicBoolean(false);
    private static final AtomicReference<NativeRuntimeLoader> nativeRuntimeLoader = new AtomicReference();
    protected static final String METHOD_BINDING_FORMAT = "$$robo$$${method}$nativeBinding";
    private static final String HYPHEN_DATA_DIR = "hyphen-data";
    protected static final ImmutableList<String> CORE_CLASS_NATIVES = ImmutableList.copyOf((Object[])new String[]{"android.animation.PropertyValuesHolder", "android.database.CursorWindow", "android.database.sqlite.SQLiteConnection", "android.database.sqlite.SQLiteRawStatement", "android.media.ImageReader", "android.os.SystemProperties", "android.text.Hyphenator", "android.view.Surface", "com.android.internal.util.VirtualRefBasePtr", "libcore.util.NativeAllocationRegistry"});
    protected static final ImmutableList<String> GRAPHICS_CLASS_NATIVES = ImmutableList.copyOf((Object[])new String[]{"android.graphics.Bitmap", "android.graphics.BitmapFactory", "android.graphics.ByteBufferStreamAdaptor", "android.graphics.Camera", "android.graphics.Canvas", "android.graphics.CanvasProperty", "android.graphics.Color", "android.graphics.ColorFilter", "android.graphics.ColorSpace", "android.graphics.CreateJavaOutputStreamAdaptor", "android.graphics.DrawFilter", "android.graphics.FontFamily", "android.graphics.Gainmap", "android.graphics.Graphics", "android.graphics.HardwareRenderer", "android.graphics.HardwareRendererObserver", "android.graphics.ImageDecoder", "android.graphics.Interpolator", "android.graphics.MaskFilter", "android.graphics.Matrix", "android.graphics.NinePatch", "android.graphics.Paint", "android.graphics.Path", "android.graphics.PathEffect", "android.graphics.PathIterator", "android.graphics.PathMeasure", "android.graphics.Picture", "android.graphics.RecordingCanvas", "android.graphics.Region", "android.graphics.RenderEffect", "android.graphics.RenderNode", "android.graphics.Shader", "android.graphics.Typeface", "android.graphics.YuvImage", "android.graphics.animation.NativeInterpolatorFactory", "android.graphics.animation.RenderNodeAnimator", "android.graphics.drawable.AnimatedVectorDrawable", "android.graphics.drawable.AnimatedImageDrawable", "android.graphics.drawable.VectorDrawable", "android.graphics.fonts.Font", "android.graphics.fonts.FontFamily", "android.graphics.text.LineBreaker", "android.graphics.text.MeasuredText", "android.graphics.text.TextRunShaper", "android.util.PathParser"});
    protected static final ImmutableList<String> DEFERRED_STATIC_INITIALIZERS = ImmutableList.copyOf((Object[])new String[]{"android.graphics.FontFamily", "android.graphics.Path", "android.graphics.PathIterator", "android.graphics.Typeface", "android.graphics.text.MeasuredText$Builder", "android.media.ImageReader"});
    private TempDirectory extractDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectAndLoad() {
        AtomicReference<NativeRuntimeLoader> atomicReference = nativeRuntimeLoader;
        synchronized (atomicReference) {
            if (nativeRuntimeLoader.get() == null) {
                Injector injector = new Injector.Builder(CursorWindow.class.getClassLoader()).build();
                NativeRuntimeLoader loader = (NativeRuntimeLoader)injector.getInstance(NativeRuntimeLoader.class);
                nativeRuntimeLoader.set(loader);
            }
        }
        nativeRuntimeLoader.get().ensureLoaded();
    }

    protected void maybeCopyExtraResources(TempDirectory dir) {
    }

    protected List<String> getCoreClassNatives() {
        return CORE_CLASS_NATIVES;
    }

    protected List<String> getDeferredStaticInitializers() {
        return DEFERRED_STATIC_INITIALIZERS;
    }

    protected List<String> getGraphicsNatives() {
        return GRAPHICS_CLASS_NATIVES;
    }

    public synchronized void ensureLoaded() {
        if (loaded.get()) {
            return;
        }
        if (!DefaultNativeRuntimeLoader.isSupported()) {
            String errorMessage = String.format("The Robolectric native runtime is not supported on %s (%s)", StandardSystemProperty.OS_NAME.value(), StandardSystemProperty.OS_ARCH.value());
            throw new AssertionError((Object)errorMessage);
        }
        loaded.set(true);
        try {
            PerfStatsCollector.getInstance().measure("loadNativeRuntime", () -> {
                this.extractDirectory = new TempDirectory("nativeruntime");
                if (AndroidVersions.CURRENT.getSdkInt() >= 26) {
                    this.maybeCopyFonts(this.extractDirectory);
                    this.maybeCopyHyphenData(this.extractDirectory);
                }
                this.maybeCopyIcuData(this.extractDirectory);
                this.maybeCopyExtraResources(this.extractDirectory);
                if (DefaultNativeRuntimeLoader.isAndroidVOrGreater()) {
                    System.setProperty("core_native_classes", String.join((CharSequence)",", this.getCoreClassNatives()));
                    System.setProperty("graphics_native_classes", String.join((CharSequence)",", this.getGraphicsNatives()));
                    System.setProperty("method_binding_format", METHOD_BINDING_FORMAT);
                }
                this.loadLibrary(this.extractDirectory);
                String hyphenDataDir = this.extractDirectory.getBasePath().resolve(HYPHEN_DATA_DIR).toFile().getAbsolutePath();
                if (DefaultNativeRuntimeLoader.isAndroidVOrGreater()) {
                    this.invokeDeferredStaticInitializers();
                    DefaultNativeRuntimeLoader.setNativeSystemProperty("ro.hyphen.data.dir", hyphenDataDir);
                    Typeface.loadPreinstalledSystemFontMap();
                } else {
                    System.setProperty("hyphen.data.dir", hyphenDataDir);
                }
                if (AndroidVersions.CURRENT.getSdkInt() >= 28) {
                    Hyphenator.init();
                }
            });
        }
        catch (IOException e) {
            throw new AssertionError("Unable to load Robolectric native runtime library", e);
        }
    }

    private static List<String> getResourcesInAndroidAll(String prefix) throws IOException {
        try {
            String jarPath = ((String)Iterables.get((Iterable)Splitter.on((char)'!').split((CharSequence)Resources.getResource((String)"build.prop").toURI().toString()), (int)0)).substring("jar:file:".length());
            ArrayList<String> resources = new ArrayList<String>();
            try (JarFile jarFile = new JarFile(jarPath);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(prefix) || entry.isDirectory()) continue;
                    resources.add(entry.getName());
                }
            }
            return resources;
        }
        catch (URISyntaxException syntaxException) {
            throw new IOException(syntaxException);
        }
    }

    private void maybeCopyIcuData(TempDirectory tempDirectory) throws IOException {
        Path icuDatPath;
        URL icuDatUrl;
        try {
            if (AndroidVersions.CURRENT.getSdkInt() <= 34) {
                icuDatUrl = Resources.getResource((String)"icu/icudt68l.dat");
            } else {
                List<String> resources = DefaultNativeRuntimeLoader.getResourcesInAndroidAll("icu/icudt");
                if (resources.size() != 1) {
                    throw new RuntimeException("More than one icudt file in android-all jar: " + resources);
                }
                icuDatUrl = Resources.getResource((String)resources.get(0));
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("Could not load icu data file ");
            throw new RuntimeException(e);
        }
        Path icuPath = tempDirectory.create("icu");
        if (AndroidVersions.CURRENT.getSdkInt() <= 34) {
            icuDatPath = icuPath.resolve("icudt68l.dat");
        } else {
            List parts = Splitter.on((char)'/').splitToList((CharSequence)icuDatUrl.toString());
            icuDatPath = icuPath.resolve((String)Iterables.getLast((Iterable)parts));
        }
        Resources.asByteSource((URL)icuDatUrl).copyTo(com.google.common.io.Files.asByteSink((File)icuDatPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
        System.setProperty("icu.data.path", icuDatPath.toAbsolutePath().toString());
        System.setProperty("icu.locale.default", Locale.getDefault().toLanguageTag());
    }

    private void maybeCopyFonts(TempDirectory tempDirectory) throws IOException {
        URI fontsUri;
        try {
            fontsUri = Resources.getResource((String)"fonts/").toURI();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return;
        }
        FileSystem zipfs = null;
        if ("jar".equals(fontsUri.getScheme())) {
            zipfs = FileSystems.newFileSystem(fontsUri, ImmutableMap.of((Object)"create", (Object)"true"));
        }
        Path fontsInputPath = Paths.get(fontsUri);
        Path fontsOutputPath = tempDirectory.create("fonts");
        try (Stream<Path> pathStream = Files.walk(fontsInputPath, new FileVisitOption[0]);){
            Iterator fileIterator = pathStream.iterator();
            while (fileIterator.hasNext()) {
                Path path = (Path)fileIterator.next();
                if ("fonts".equals(path.getFileName().toString())) continue;
                String fontPath = "fonts/" + path.getFileName();
                URL resource = Resources.getResource((String)fontPath);
                Path outputPath = tempDirectory.getBasePath().resolve(fontPath);
                Resources.asByteSource((URL)resource).copyTo(com.google.common.io.Files.asByteSink((File)outputPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
            }
        }
        System.setProperty("robolectric.nativeruntime.fontdir", fontsOutputPath.toAbsolutePath() + File.separator);
        if (zipfs != null) {
            zipfs.close();
        }
    }

    private void maybeCopyHyphenData(TempDirectory tempDirectory) throws IOException {
        URI hyphenDataUri;
        try {
            hyphenDataUri = Resources.getResource((String)"hyphen-data/").toURI();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            Logger.info((String)("Could not load hyphen data files: " + e.getMessage()), (Object[])new Object[0]);
            return;
        }
        FileSystem zipfs = null;
        if ("jar".equals(hyphenDataUri.getScheme())) {
            zipfs = FileSystems.newFileSystem(hyphenDataUri, ImmutableMap.of((Object)"create", (Object)"true"));
        }
        Path hyphenDataInputPath = Paths.get(hyphenDataUri);
        tempDirectory.create(HYPHEN_DATA_DIR);
        try (Stream<Path> pathStream = Files.walk(hyphenDataInputPath, new FileVisitOption[0]);){
            Iterator fileIterator = pathStream.iterator();
            while (fileIterator.hasNext()) {
                Path path = (Path)fileIterator.next();
                if (Objects.equals(path.getFileName().toString(), HYPHEN_DATA_DIR)) continue;
                String hyphenDataPath = "hyphen-data/" + path.getFileName();
                URL resource = Resources.getResource((String)hyphenDataPath);
                Path outputPath = tempDirectory.getBasePath().resolve(hyphenDataPath);
                Resources.asByteSource((URL)resource).copyTo(com.google.common.io.Files.asByteSink((File)outputPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
            }
        }
        if (zipfs != null) {
            zipfs.close();
        }
    }

    private void loadLibrary(TempDirectory tempDirectory) throws IOException {
        Path libraryPath = tempDirectory.getBasePath().resolve(DefaultNativeRuntimeLoader.libraryName());
        URL libraryResource = Resources.getResource((String)DefaultNativeRuntimeLoader.nativeLibraryPath());
        Logger.info((String)"Loading android native library from: %s", (Object[])new Object[]{libraryResource});
        Resources.asByteSource((URL)libraryResource).copyTo(com.google.common.io.Files.asByteSink((File)libraryPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
        System.load(libraryPath.toAbsolutePath().toString());
    }

    private static boolean isSupported() {
        return OsUtil.isMac() && (Objects.equals(DefaultNativeRuntimeLoader.arch(), "aarch64") || Objects.equals(DefaultNativeRuntimeLoader.arch(), "x86_64")) || OsUtil.isLinux() && Objects.equals(DefaultNativeRuntimeLoader.arch(), "x86_64") || OsUtil.isWindows() && Objects.equals(DefaultNativeRuntimeLoader.arch(), "x86_64");
    }

    private static String nativeLibraryPath() {
        return String.format("native/%s/%s/%s", DefaultNativeRuntimeLoader.osName(), DefaultNativeRuntimeLoader.arch(), DefaultNativeRuntimeLoader.libraryName());
    }

    protected static String libraryName() {
        if (DefaultNativeRuntimeLoader.isAndroidVOrGreater()) {
            return System.mapLibraryName(OsUtil.isWindows() ? "libandroid_runtime" : "android_runtime");
        }
        return System.mapLibraryName("robolectric-nativeruntime");
    }

    private static String osName() {
        if (OsUtil.isLinux()) {
            return "linux";
        }
        if (OsUtil.isMac()) {
            return "mac";
        }
        if (OsUtil.isWindows()) {
            return "windows";
        }
        return "unknown";
    }

    private static String arch() {
        String arch = StandardSystemProperty.OS_ARCH.value().toLowerCase(Locale.US);
        if (arch.equals("x86_64") || arch.equals("amd64")) {
            return "x86_64";
        }
        return arch;
    }

    @VisibleForTesting
    static boolean isLoaded() {
        return loaded.get();
    }

    @VisibleForTesting
    Path getDirectory() {
        return this.extractDirectory == null ? null : this.extractDirectory.getBasePath();
    }

    @VisibleForTesting
    static void resetLoaded() {
        loaded.set(false);
    }

    protected void invokeDeferredStaticInitializers() {
        for (String className : DEFERRED_STATIC_INITIALIZERS) {
            ReflectionHelpers.callStaticMethod((ClassLoader)Shadow.class.getClassLoader(), (String)className, (String)"__staticInitializer__", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
    }

    private static boolean isAndroidVOrGreater() {
        return AndroidVersions.CURRENT.getSdkInt() >= 35;
    }

    protected static void setNativeSystemProperty(String key, String value) {
        String nativeSetMethodName = Shadow.directNativeMethodName((String)"android.os.SystemProperties", (String)"native_set");
        ReflectionHelpers.callStaticMethod((ClassLoader)Shadow.class.getClassLoader(), (String)"android.os.SystemProperties", (String)nativeSetMethodName, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)key), ReflectionHelpers.ClassParameter.from(String.class, (Object)value)});
    }
}

