/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.nativeruntime;

import android.database.CursorWindow;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.StandardSystemProperty;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Priority;
import org.robolectric.pluginapi.NativeRuntimeLoader;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.inject.Injector;

@Priority(value=-2147483648)
public class DefaultNativeRuntimeLoader
implements NativeRuntimeLoader {
    protected static final AtomicBoolean loaded = new AtomicBoolean(false);
    private static final AtomicReference<NativeRuntimeLoader> nativeRuntimeLoader = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectAndLoad() {
        AtomicReference<NativeRuntimeLoader> atomicReference = nativeRuntimeLoader;
        synchronized (atomicReference) {
            if (nativeRuntimeLoader.get() == null) {
                Injector injector = new Injector.Builder(CursorWindow.class.getClassLoader()).build();
                NativeRuntimeLoader loader = (NativeRuntimeLoader)injector.getInstance(NativeRuntimeLoader.class);
                nativeRuntimeLoader.set(loader);
            }
        }
        nativeRuntimeLoader.get().ensureLoaded();
    }

    public synchronized void ensureLoaded() {
        if (loaded.get()) {
            return;
        }
        if (!DefaultNativeRuntimeLoader.isSupported()) {
            String errorMessage = String.format("The Robolectric native runtime is not supported on %s (%s)", StandardSystemProperty.OS_NAME.value(), StandardSystemProperty.OS_ARCH.value());
            throw new AssertionError((Object)errorMessage);
        }
        loaded.set(true);
        try {
            PerfStatsCollector.getInstance().measure("loadNativeRuntime", () -> {
                String libraryName = System.mapLibraryName("robolectric-nativeruntime");
                System.setProperty("robolectric.nativeruntime.languageTag", Locale.getDefault().toLanguageTag());
                File tmpLibraryFile = Files.createTempFile("", libraryName, new FileAttribute[0]).toFile();
                tmpLibraryFile.deleteOnExit();
                URL resource = Resources.getResource((String)DefaultNativeRuntimeLoader.nativeLibraryPath());
                Resources.asByteSource((URL)resource).copyTo(com.google.common.io.Files.asByteSink((File)tmpLibraryFile, (FileWriteMode[])new FileWriteMode[0]));
                System.load(tmpLibraryFile.getAbsolutePath());
            });
        }
        catch (IOException e) {
            throw new AssertionError("Unable to load Robolectric native runtime library", e);
        }
    }

    private static boolean isSupported() {
        return "mac".equals(DefaultNativeRuntimeLoader.osName()) && ("aarch64".equals(DefaultNativeRuntimeLoader.arch()) || "x86_64".equals(DefaultNativeRuntimeLoader.arch())) || "linux".equals(DefaultNativeRuntimeLoader.osName()) && "x86_64".equals(DefaultNativeRuntimeLoader.arch()) || "windows".equals(DefaultNativeRuntimeLoader.osName()) && "x86_64".equals(DefaultNativeRuntimeLoader.arch());
    }

    private static String nativeLibraryPath() {
        String os = DefaultNativeRuntimeLoader.osName();
        String arch = DefaultNativeRuntimeLoader.arch();
        return String.format("native/%s/%s/%s", os, arch, System.mapLibraryName("robolectric-nativeruntime"));
    }

    private static String osName() {
        String osName = StandardSystemProperty.OS_NAME.value().toLowerCase(Locale.US);
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("mac")) {
            return "mac";
        }
        if (osName.contains("win")) {
            return "windows";
        }
        return "unknown";
    }

    private static String arch() {
        String arch = StandardSystemProperty.OS_ARCH.value().toLowerCase(Locale.US);
        if (arch.equals("x86_64") || arch.equals("amd64")) {
            return "x86_64";
        }
        return arch;
    }

    @VisibleForTesting
    static boolean isLoaded() {
        return loaded.get();
    }
}

