/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.plugins;

import java.io.File;
import java.net.URL;
import org.robolectric.internal.dependency.CachedDependencyResolver;
import org.robolectric.internal.dependency.DependencyJar;
import org.robolectric.internal.dependency.DependencyResolver;
import org.robolectric.internal.dependency.MavenDependencyResolver;
import org.robolectric.util.Logger;

public class CachedMavenDependencyResolver
implements DependencyResolver {
    private final DependencyResolver delegate;

    public CachedMavenDependencyResolver() {
        File cacheDir = new File(new File(System.getProperty("java.io.tmpdir")), "robolectric-2");
        MavenDependencyResolver dependencyResolver = new MavenDependencyResolver();
        if (cacheDir.exists() || cacheDir.mkdir()) {
            Logger.info((String)"Dependency cache location: %s", (Object[])new Object[]{cacheDir.getAbsolutePath()});
            this.delegate = new CachedDependencyResolver(dependencyResolver, cacheDir, 86400000L);
        } else {
            this.delegate = dependencyResolver;
        }
    }

    public URL getLocalArtifactUrl(DependencyJar dependency) {
        return this.delegate.getLocalArtifactUrl(dependency);
    }
}

