/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.Style;
import org.robolectric.res.StyleData;
import org.robolectric.res.TypedResource;

public class StyleResolver
implements Style {
    private final List<StyleData> styles = new ArrayList<StyleData>();
    private final ResourceTable appResourceTable;
    private final ResourceTable systemResourceTable;
    private final Style theme;
    private final ResName myResName;
    private final String qualifiers;

    public StyleResolver(ResourceTable appResourceTable, ResourceTable systemResourceTable, StyleData styleData, Style theme, ResName myResName, String qualifiers) {
        this.appResourceTable = appResourceTable;
        this.systemResourceTable = systemResourceTable;
        this.theme = theme;
        this.myResName = myResName;
        this.qualifiers = qualifiers;
        this.styles.add(styleData);
    }

    @Override
    public AttributeResource getAttrValue(ResName resName) {
        AttributeResource value;
        StyleData parent;
        for (StyleData style : this.styles) {
            AttributeResource value2 = style.getAttrValue(resName);
            if (value2 == null) continue;
            return value2;
        }
        int initialSize = this.styles.size();
        while (StyleResolver.hasParent(this.styles.get(this.styles.size() - 1)) && (parent = this.getParent(this.styles.get(this.styles.size() - 1))) != null) {
            this.styles.add(parent);
        }
        for (int i = initialSize; i < this.styles.size(); ++i) {
            StyleData style = this.styles.get(i);
            AttributeResource value3 = style.getAttrValue(resName);
            if (value3 == null) continue;
            return value3;
        }
        if (this.theme != null && (value = this.theme.getAttrValue(resName)) != null) {
            return value;
        }
        return null;
    }

    private static String getParentStyleName(StyleData style) {
        if (style == null) {
            return null;
        }
        String parent = style.getParent();
        if (parent == null || parent.isEmpty()) {
            parent = null;
            String name = style.getName();
            if (name.contains(".") && (parent = name.substring(0, name.lastIndexOf(46))).isEmpty()) {
                return null;
            }
        }
        return parent;
    }

    private static boolean hasParent(StyleData style) {
        if (style == null) {
            return false;
        }
        String parent = style.getParent();
        return parent != null && !parent.isEmpty();
    }

    private StyleData getParent(StyleData style) {
        String parent = StyleResolver.getParentStyleName(style);
        if (parent == null) {
            return null;
        }
        if (parent.startsWith("@")) {
            parent = parent.substring(1);
        }
        ResName styleRef = ResName.qualifyResName(parent, style.getPackageName(), "style");
        styleRef = this.dereferenceResName(styleRef);
        ResourceTable resourceProvider = "android".equals(styleRef.packageName) ? this.systemResourceTable : this.appResourceTable;
        TypedResource typedResource = resourceProvider.getValue(styleRef, this.qualifiers);
        if (typedResource == null) {
            StringBuilder builder = new StringBuilder("Could not find any resource").append(" from reference ").append(styleRef).append(" from ").append(style).append(" with ").append(this.theme);
            throw new RuntimeException(builder.toString());
        }
        Object data = typedResource.getData();
        if (data instanceof StyleData) {
            return (StyleData)data;
        }
        StringBuilder builder = new StringBuilder(styleRef.toString()).append(" does not resolve to a Style.").append(" got ").append(data).append(" instead. ").append(" from ").append(style).append(" with ").append(this.theme);
        throw new RuntimeException(builder.toString());
    }

    private ResName dereferenceResName(ResName res) {
        ResName styleRef = res;
        boolean dereferencing = true;
        while ("attr".equals(styleRef.type) && dereferencing) {
            AttributeResource value;
            dereferencing = false;
            for (StyleData parentStyle : this.styles) {
                AttributeResource value2 = parentStyle.getAttrValue(styleRef);
                if (value2 == null) continue;
                styleRef = this.dereferenceAttr(value2);
                dereferencing = true;
                break;
            }
            if (dereferencing || this.theme == null || (value = this.theme.getAttrValue(styleRef)) == null) continue;
            styleRef = this.dereferenceAttr(value);
            dereferencing = true;
        }
        return styleRef;
    }

    private ResName dereferenceAttr(AttributeResource attr) {
        if (attr.isResourceReference()) {
            return attr.getResourceReference();
        }
        if (attr.isStyleReference()) {
            return attr.getStyleReference();
        }
        throw new RuntimeException("Found a " + attr + " but can't cast it :(");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StyleResolver)) {
            return false;
        }
        StyleResolver other = (StyleResolver)obj;
        return (this.theme == null && other.theme == null || this.theme != null && this.theme.equals(other.theme)) && (this.myResName == null && other.myResName == null || this.myResName != null && this.myResName.equals(other.myResName)) && Objects.equals(this.qualifiers, other.qualifiers);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.theme != null ? this.theme.hashCode() : 0);
        hashCode = 31 * hashCode + (this.myResName != null ? this.myResName.hashCode() : 0);
        hashCode = 31 * hashCode + Strings.nullToEmpty((String)this.qualifiers).hashCode();
        return hashCode;
    }

    public String toString() {
        return this.styles.get(0) + " (and parents)";
    }
}

