/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.robolectric.manifest.IntentFilterData;
import org.robolectric.manifest.MetaData;

public class ServiceData {
    private static final String EXPORTED = "android:exported";
    private static final String NAME = "android:name";
    private static final String PERMISSION = "android:permission";
    private final Map<String, String> attributes;
    private final MetaData metaData;
    private final List<String> actions;
    private List<IntentFilterData> intentFilters;

    public ServiceData(Map<String, String> attributes, MetaData metaData, List<IntentFilterData> intentFilters) {
        this.attributes = attributes;
        this.actions = new ArrayList<String>();
        this.metaData = metaData;
        this.intentFilters = new LinkedList<IntentFilterData>(intentFilters);
    }

    public ServiceData(String className, MetaData metaData, List<IntentFilterData> intentFilterData) {
        this.attributes = new HashMap<String, String>();
        this.attributes.put(NAME, className);
        this.actions = new ArrayList<String>();
        this.metaData = metaData;
        this.intentFilters = new LinkedList<IntentFilterData>(intentFilterData);
    }

    public String getClassName() {
        return this.attributes.get(NAME);
    }

    public List<String> getActions() {
        return this.actions;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void addAction(String action) {
        this.actions.add(action);
    }

    public void setPermission(String permission) {
        this.attributes.put(PERMISSION, permission);
    }

    public String getPermission() {
        return this.attributes.get(PERMISSION);
    }

    public List<IntentFilterData> getIntentFilters() {
        return this.intentFilters;
    }

    public Map<String, String> getAllAttributes() {
        return this.attributes;
    }

    public boolean isExported() {
        boolean defaultValue = !this.intentFilters.isEmpty();
        return this.attributes.containsKey(EXPORTED) ? Boolean.parseBoolean(this.attributes.get(EXPORTED)) : defaultValue;
    }
}

