/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import javax.annotation.Nonnull;
import org.robolectric.res.ResName;

public class AttributeResource {
    public static final String ANDROID_RES_NS_PREFIX = "http://schemas.android.com/apk/res/";
    public static final String RES_AUTO_NS_URI = "http://schemas.android.com/apk/res-auto";
    public static final String NULL_VALUE = "@null";
    public static final String EMPTY_VALUE = "@empty";
    @Nonnull
    public final ResName resName;
    @Nonnull
    public final String value;
    @Nonnull
    public final String contextPackageName;
    private final Integer referenceResId;

    public AttributeResource(@Nonnull ResName resName, @Nonnull String value, @Nonnull String contextPackageName) {
        this(resName, value, contextPackageName, null);
    }

    public AttributeResource(@Nonnull ResName resName, @Nonnull String value, @Nonnull String contextPackageName, Integer referenceResId) {
        this.referenceResId = referenceResId;
        if (!resName.type.equals("attr")) {
            throw new IllegalStateException("\"" + resName.getFullyQualifiedName() + "\" unexpected");
        }
        this.resName = resName;
        this.value = value;
        this.contextPackageName = contextPackageName;
    }

    public boolean isResourceReference() {
        return AttributeResource.isResourceReference(this.value);
    }

    @Nonnull
    public ResName getResourceReference() {
        if (!this.isResourceReference()) {
            throw new RuntimeException("not a resource reference: " + this);
        }
        return ResName.qualifyResName(this.value.substring(1).replace("+", ""), this.contextPackageName, "style");
    }

    public boolean isStyleReference() {
        return AttributeResource.isStyleReference(this.value);
    }

    public ResName getStyleReference() {
        if (!this.isStyleReference()) {
            throw new RuntimeException("not a style reference: " + this);
        }
        return ResName.qualifyResName(this.value.substring(1), this.contextPackageName, "attr");
    }

    public boolean isNull() {
        return NULL_VALUE.equals(this.value);
    }

    public boolean isEmpty() {
        return EMPTY_VALUE.equals(this.value);
    }

    public String toString() {
        return "Attribute{name='" + this.resName + '\'' + ", value='" + this.value + '\'' + ", contextPackageName='" + this.contextPackageName + '\'' + '}';
    }

    public static boolean isResourceReference(String value) {
        return value.startsWith("@") && !AttributeResource.isNull(value);
    }

    @Nonnull
    public static ResName getResourceReference(String value, String defPackage, String defType) {
        if (!AttributeResource.isResourceReference(value)) {
            throw new IllegalArgumentException("not a resource reference: " + value);
        }
        return ResName.qualifyResName(value.substring(1).replace("+", ""), defPackage, defType);
    }

    public static boolean isStyleReference(String value) {
        return value.startsWith("?");
    }

    public static ResName getStyleReference(String value, String defPackage, String defType) {
        if (!AttributeResource.isStyleReference(value)) {
            throw new IllegalArgumentException("not a style reference: " + value);
        }
        return ResName.qualifyResName(value.substring(1), defPackage, defType);
    }

    public static boolean isNull(String value) {
        return NULL_VALUE.equals(value);
    }

    public static boolean isEmpty(String value) {
        return EMPTY_VALUE.equals(value);
    }

    public Integer getReferenceResId() {
        return this.referenceResId;
    }
}

