/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceIds;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.ResourceTableFactory;
import org.robolectric.res.TypedResource;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.builder.XmlBlock;

public class RoutingResourceTable
implements ResourceTable {
    private static final PackageResourceTable EMPTY_RESOURCE_TABLE = new ResourceTableFactory().newResourceTable("", new ResourcePath[0]);
    private final Map<String, PackageResourceTable> resourceTables = new HashMap<String, PackageResourceTable>();

    public RoutingResourceTable(PackageResourceTable ... resourceTables) {
        for (PackageResourceTable resourceTable : resourceTables) {
            this.resourceTables.put(resourceTable.getPackageName(), resourceTable);
        }
    }

    @Override
    public InputStream getRawValue(int resId, ResTable_config config) {
        ResName resName = this.getResName(resId);
        return resName != null ? this.getRawValue(resName, config) : null;
    }

    @Override
    public TypedResource getValue(@Nonnull ResName resName, ResTable_config config) {
        return this.pickFor(resName).getValue(resName, config);
    }

    @Override
    public TypedResource getValue(int resId, ResTable_config config) {
        ResName resName = this.pickFor(resId).getResName(resId);
        return resName != null ? this.getValue(resName, config) : null;
    }

    @Override
    public XmlBlock getXml(ResName resName, ResTable_config config) {
        return this.pickFor(resName).getXml(resName, config);
    }

    @Override
    public InputStream getRawValue(ResName resName, ResTable_config config) {
        return this.pickFor(resName).getRawValue(resName, config);
    }

    @Override
    public Integer getResourceId(ResName resName) {
        return this.pickFor(resName).getResourceId(resName);
    }

    @Override
    public ResName getResName(int resourceId) {
        return this.pickFor(resourceId).getResName(resourceId);
    }

    @Override
    public void receive(ResourceTable.Visitor visitor) {
        for (PackageResourceTable resourceTable : this.resourceTables.values()) {
            resourceTable.receive(visitor);
        }
    }

    private PackageResourceTable pickFor(int resId) {
        for (PackageResourceTable resourceTable : this.resourceTables.values()) {
            if (resourceTable.getPackageIdentifier() != ResourceIds.getPackageIdentifier(resId)) continue;
            return resourceTable;
        }
        return EMPTY_RESOURCE_TABLE;
    }

    private PackageResourceTable pickFor(ResName resName) {
        if (resName == null) {
            return EMPTY_RESOURCE_TABLE;
        }
        return this.pickFor(resName.packageName);
    }

    private PackageResourceTable pickFor(String namespace) {
        if (namespace.equals("android.internal")) {
            return EMPTY_RESOURCE_TABLE;
        }
        PackageResourceTable resourceTable = this.resourceTables.get(namespace);
        if (resourceTable == null) {
            resourceTable = this.whichProvidesFor(namespace);
            return resourceTable != null ? resourceTable : EMPTY_RESOURCE_TABLE;
        }
        return resourceTable;
    }

    private PackageResourceTable whichProvidesFor(String namespace) {
        for (PackageResourceTable resourceTable : this.resourceTables.values()) {
            if (!resourceTable.getPackageName().equals(namespace)) continue;
            return resourceTable;
        }
        return null;
    }

    public String toString() {
        return new TreeSet<String>(this.resourceTables.keySet()).toString();
    }
}

