/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import javax.annotation.Nonnull;
import org.robolectric.res.FsFile;
import org.robolectric.res.Qualifiers;
import org.robolectric.res.StartsWithFilter;
import org.robolectric.res.XmlContext;
import org.robolectric.util.Logger;

public abstract class DocumentLoader {
    private static final FsFile.Filter ENDS_WITH_XML = new FsFile.Filter(){

        @Override
        public boolean accept(@Nonnull FsFile fsFile) {
            return fsFile.getName().endsWith(".xml");
        }
    };
    protected final String packageName;
    private final FsFile resourceBase;

    public DocumentLoader(String packageName, FsFile resourceBase) {
        this.packageName = packageName;
        this.resourceBase = resourceBase;
    }

    public void load(String folderBaseName) {
        FsFile[] files = this.resourceBase.listFiles(new StartsWithFilter(folderBaseName));
        if (files == null) {
            throw new RuntimeException(this.resourceBase.join(folderBaseName) + " is not a directory");
        }
        for (FsFile dir : files) {
            this.loadFile(dir);
        }
    }

    private void loadFile(FsFile dir) {
        Qualifiers qualifiers;
        if (!dir.exists()) {
            throw new RuntimeException("no such directory " + dir);
        }
        if (!dir.isDirectory()) {
            return;
        }
        try {
            qualifiers = Qualifiers.fromParentDir(dir);
        }
        catch (IllegalArgumentException e) {
            Logger.warn((String)(dir + ": " + e.getMessage()), (Object[])new Object[0]);
            return;
        }
        for (FsFile file : dir.listFiles(ENDS_WITH_XML)) {
            this.loadResourceXmlFile(new XmlContext(this.packageName, file, qualifiers));
        }
    }

    protected abstract void loadResourceXmlFile(XmlContext var1);
}

