/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.FileTypedResource;
import org.robolectric.res.FsFile;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.Qualifiers;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.XmlContext;
import org.robolectric.util.Logger;

public class DrawableResourceLoader {
    private final PackageResourceTable resourceTable;

    DrawableResourceLoader(PackageResourceTable resourceTable) {
        this.resourceTable = resourceTable;
    }

    void findDrawableResources(ResourcePath resourcePath) {
        FsFile[] files = resourcePath.getResourceBase().listFiles();
        if (files != null) {
            for (FsFile f : files) {
                if (f.isDirectory() && f.getName().startsWith("drawable")) {
                    this.listDrawableResources(f, "drawable");
                    continue;
                }
                if (!f.isDirectory() || !f.getName().startsWith("mipmap")) continue;
                this.listDrawableResources(f, "mipmap");
            }
        }
    }

    private void listDrawableResources(FsFile dir, String type) {
        FsFile[] files = dir.listFiles();
        if (files != null) {
            Qualifiers qualifiers = null;
            try {
                qualifiers = Qualifiers.fromParentDir(dir);
            }
            catch (IllegalArgumentException e) {
                Logger.warn((String)(dir + ": " + e.getMessage()), (Object[])new Object[0]);
                return;
            }
            for (FsFile f : files) {
                boolean isNinePatch;
                String shortName;
                String name = f.getName();
                if (name.startsWith(".") || name.endsWith(".xml")) continue;
                if (name.endsWith(".9.png")) {
                    String[] tokens = name.split("\\.9\\.png$");
                    shortName = tokens[0];
                    isNinePatch = true;
                } else {
                    shortName = f.getBaseName();
                    isNinePatch = false;
                }
                XmlContext fakeXmlContext = new XmlContext(this.resourceTable.getPackageName(), f, qualifiers);
                this.resourceTable.addResource(type, shortName, new FileTypedResource.Image(f, isNinePatch, fakeXmlContext));
            }
        }
    }
}

