/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.robolectric.res.Fs;
import org.robolectric.res.android.ApkAssetsCookie;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.AssetDir;
import org.robolectric.res.android.AssetPath;
import org.robolectric.res.android.ByteBucketArray;
import org.robolectric.res.android.CppApkAssets;
import org.robolectric.res.android.DynamicRefTable;
import org.robolectric.res.android.Idmap;
import org.robolectric.res.android.LoadedArsc;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResStringPool;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.ResourceUtils;
import org.robolectric.res.android.SortedVector;
import org.robolectric.res.android.String8;
import org.robolectric.res.android.StringPoolRef;
import org.robolectric.res.android.Util;

public class CppAssetManager2 {
    private List<CppApkAssets> apk_assets_;
    private final List<PackageGroup> package_groups_ = new ArrayList<PackageGroup>();
    private final byte[] package_ids_ = new byte[256];
    private ResTable_config configuration_ = new ResTable_config();
    private final Map<Integer, ResolvedBag> cached_bags_ = new HashMap<Integer, ResolvedBag>();

    public final List<CppApkAssets> GetApkAssets() {
        return this.apk_assets_;
    }

    final ResTable_config GetConfiguration() {
        return this.configuration_;
    }

    public boolean SetApkAssets(List<CppApkAssets> apk_assets, boolean invalidate_caches) {
        this.apk_assets_ = apk_assets;
        this.BuildDynamicRefTable();
        this.RebuildFilterList();
        if (invalidate_caches) {
            this.InvalidateCaches(-1);
        }
        return true;
    }

    void BuildDynamicRefTable() {
        this.package_groups_.clear();
        for (int i = 0; i < this.package_ids_.length; ++i) {
            this.package_ids_[i] = -1;
        }
        int next_package_id = 2;
        int apk_assets_count = this.apk_assets_.size();
        for (int i = 0; i < apk_assets_count; ++i) {
            LoadedArsc loaded_arsc = this.apk_assets_.get(i).GetLoadedArsc();
            for (LoadedArsc.LoadedPackage package_ : loaded_arsc.GetPackages()) {
                int package_id = package_.IsDynamic() ? next_package_id++ : package_.GetPackageId();
                byte idx = this.package_ids_[package_id];
                if (idx == -1) {
                    this.package_ids_[package_id] = idx = (byte)this.package_groups_.size();
                    DynamicRefTable ref_table = new DynamicRefTable((byte)package_id, package_.IsDynamic() && package_.GetPackageId() == 127);
                    PackageGroup newPackageGroup = new PackageGroup();
                    newPackageGroup.dynamic_ref_table = ref_table;
                    this.package_groups_.add(newPackageGroup);
                }
                PackageGroup package_group = this.package_groups_.get(idx);
                package_group.packages_.add(new ConfiguredPackage(package_));
                package_group.cookies_.add(ApkAssetsCookie.forInt(i));
                for (LoadedArsc.DynamicPackageEntry dynamicPackageEntry : package_.GetDynamicPackageMap()) {
                    package_group.dynamic_ref_table.mEntries.put(dynamicPackageEntry.package_name, (byte)dynamicPackageEntry.package_id);
                }
            }
        }
        for (PackageGroup iter : this.package_groups_) {
            String package_name = iter.packages_.get((int)0).loaded_package_.GetPackageName();
            for (PackageGroup iter2 : this.package_groups_) {
                iter2.dynamic_ref_table.addMapping(package_name, iter.dynamic_ref_table.mAssignedPackageId);
                for (ConfiguredPackage pkg : iter.packages_) {
                    for (Map.Entry entry : pkg.loaded_package_.getAliasResourceIdMap().entrySet()) {
                        iter2.dynamic_ref_table.addAlias((Integer)entry.getKey(), (Integer)entry.getValue());
                    }
                }
            }
        }
    }

    final ResStringPool GetStringPoolForCookie(ApkAssetsCookie cookie) {
        if (cookie.intValue() < 0 || cookie.intValue() >= this.apk_assets_.size()) {
            return null;
        }
        return this.apk_assets_.get(cookie.intValue()).GetLoadedArsc().GetStringPool();
    }

    final DynamicRefTable GetDynamicRefTableForPackage(int package_id) {
        if (package_id >= this.package_ids_.length) {
            return null;
        }
        byte idx = this.package_ids_[package_id];
        if (idx == 255) {
            return null;
        }
        return this.package_groups_.get((int)idx).dynamic_ref_table;
    }

    public final DynamicRefTable GetDynamicRefTableForCookie(ApkAssetsCookie cookie) {
        for (PackageGroup package_group : this.package_groups_) {
            for (ApkAssetsCookie package_cookie : package_group.cookies_) {
                if (package_cookie != cookie) continue;
                return package_group.dynamic_ref_table;
            }
        }
        return null;
    }

    public void SetConfiguration(ResTable_config configuration) {
        int diff = this.configuration_.diff(configuration);
        this.configuration_ = configuration;
        if (Util.isTruthy(diff)) {
            this.RebuildFilterList();
            this.InvalidateCaches(diff);
        }
    }

    public Set<ResTable_config> GetResourceConfigurations(boolean exclude_system, boolean exclude_mipmap) {
        HashSet<ResTable_config> configurations = new HashSet<ResTable_config>();
        for (PackageGroup package_group : this.package_groups_) {
            for (ConfiguredPackage package_ : package_group.packages_) {
                if (exclude_system && package_.loaded_package_.IsSystem()) continue;
                package_.loaded_package_.CollectConfigurations(exclude_mipmap, configurations);
            }
        }
        return configurations;
    }

    public Set<String> GetResourceLocales(boolean exclude_system, boolean merge_equivalent_languages) {
        Util.ATRACE_CALL();
        HashSet<String> locales = new HashSet<String>();
        for (PackageGroup package_group : this.package_groups_) {
            for (ConfiguredPackage package_ : package_group.packages_) {
                if (exclude_system && package_.loaded_package_.IsSystem()) continue;
                package_.loaded_package_.CollectLocales(merge_equivalent_languages, locales);
            }
        }
        return locales;
    }

    public Asset Open(String filename, Asset.AccessMode mode) {
        String new_path = "assets/" + filename;
        return this.OpenNonAsset(new_path, mode);
    }

    Asset Open(String filename, ApkAssetsCookie cookie, Asset.AccessMode mode) {
        String new_path = "assets/" + filename;
        return this.OpenNonAsset(new_path, cookie, mode);
    }

    public AssetDir OpenDir(String dirname) {
        Util.ATRACE_CALL();
        String full_path = "assets/" + dirname;
        SortedVector<AssetDir.FileInfo> files = new SortedVector<AssetDir.FileInfo>();
        for (CppApkAssets apk_assets : this.apk_assets_) {
            CppApkAssets.ForEachFileCallback func;
            if (apk_assets.ForEachFile(full_path, func = (name, type) -> {
                AssetDir.FileInfo info = new AssetDir.FileInfo();
                info.setFileName(new String8(name));
                info.setFileType(type);
                info.setSourceName(new String8(apk_assets.GetPath()));
                files.add(info);
            })) continue;
            return new AssetDir();
        }
        AssetDir asset_dir = new AssetDir();
        asset_dir.setFileList(files);
        return asset_dir;
    }

    public Asset OpenNonAsset(String filename, Asset.AccessMode mode, Ref<ApkAssetsCookie> out_cookie) {
        Util.ATRACE_CALL();
        for (int i = this.apk_assets_.size() - 1; i >= 0; --i) {
            Asset asset = this.apk_assets_.get(i).Open(filename, mode);
            if (!Util.isTruthy(asset)) continue;
            if (out_cookie != null) {
                out_cookie.set(ApkAssetsCookie.forInt(i));
            }
            return asset;
        }
        if (out_cookie != null) {
            out_cookie.set(ApkAssetsCookie.K_INVALID_COOKIE);
        }
        return null;
    }

    public Asset OpenNonAsset(String filename, Asset.AccessMode mode) {
        return this.OpenNonAsset(filename, mode, null);
    }

    public Asset OpenNonAsset(String filename, ApkAssetsCookie cookie, Asset.AccessMode mode) {
        Util.ATRACE_CALL();
        if (cookie.intValue() < 0 || cookie.intValue() >= this.apk_assets_.size()) {
            return null;
        }
        return this.apk_assets_.get(cookie.intValue()).Open(filename, mode);
    }

    public void ForEachPackage(PackageFunc func) {
        for (PackageGroup package_group : this.package_groups_) {
            func.apply(package_group.packages_.get((int)0).loaded_package_.GetPackageName(), package_group.dynamic_ref_table.mAssignedPackageId);
        }
    }

    private ApkAssetsCookie FindEntry(int resid, short density_override, Ref<FindEntryResult> out_entry) {
        Util.ATRACE_CALL();
        ResTable_config desired_config = this.configuration_;
        if (density_override != 0 && density_override != this.configuration_.density) {
            ResTable_config density_override_config = this.configuration_;
            density_override_config.density = density_override;
            desired_config = density_override_config;
        }
        if (!ResourceUtils.is_valid_resid(resid)) {
            System.err.println(String.format("Invalid ID 0x%08x.", resid));
            return ApkAssetsCookie.K_INVALID_COOKIE;
        }
        int package_id = ResourceUtils.get_package_id(resid);
        byte type_idx = (byte)(ResourceUtils.get_type_id(resid) - 1);
        int entry_idx = ResourceUtils.get_entry_id(resid);
        byte package_idx = this.package_ids_[package_id];
        if (package_idx == -1) {
            System.err.println(String.format("No package ID %02x found for ID 0x%08x.", package_id, resid));
            return ApkAssetsCookie.K_INVALID_COOKIE;
        }
        PackageGroup package_group = this.package_groups_.get(package_idx);
        int package_count = package_group.packages_.size();
        ApkAssetsCookie best_cookie = ApkAssetsCookie.K_INVALID_COOKIE;
        LoadedArsc.LoadedPackage best_package = null;
        ResourceTypes.ResTable_type best_type = null;
        ResTable_config best_config = null;
        int best_offset = 0;
        int type_flags = 0;
        boolean use_fast_path = desired_config == this.configuration_;
        for (int pi = 0; pi < package_count; ++pi) {
            int offset;
            ConfiguredPackage loaded_package_impl = package_group.packages_.get(pi);
            LoadedArsc.LoadedPackage loaded_package = loaded_package_impl.loaded_package_;
            ApkAssetsCookie cookie = package_group.cookies_.get(pi);
            LoadedArsc.TypeSpec type_spec = loaded_package.GetTypeSpecByTypeIndex(type_idx);
            if (Util.UNLIKELY(type_spec == null)) continue;
            int local_entry_idx = entry_idx;
            if (type_spec.idmap_entries != null && !Idmap.LoadedIdmap.Lookup(type_spec.idmap_entries, local_entry_idx, new Ref<Integer>(local_entry_idx))) continue;
            type_flags |= type_spec.GetFlagsForEntryIndex(local_entry_idx);
            boolean package_is_overlay = loaded_package.IsOverlay();
            FilteredConfigGroup filtered_group = loaded_package_impl.filtered_configs_.get(type_idx);
            if (use_fast_path) {
                List<ResTable_config> candidate_configs = filtered_group.configurations;
                int type_count = candidate_configs.size();
                for (int i = 0; i < type_count; ++i) {
                    ResourceTypes.ResTable_type type_chunk;
                    ResTable_config this_config = candidate_configs.get(i);
                    if (best_config != null && !this_config.isBetterThan(best_config, desired_config) && (!package_is_overlay || this_config.compare(best_config) != 0) || (offset = LoadedArsc.LoadedPackage.GetEntryOffset(type_chunk = filtered_group.types.get(i), local_entry_idx)) == -1) continue;
                    best_cookie = cookie;
                    best_package = loaded_package;
                    best_type = type_chunk;
                    best_config = this_config;
                    best_offset = offset;
                }
                continue;
            }
            for (ResourceTypes.ResTable_type type : type_spec.types) {
                ResTable_config best_config_copy;
                ResTable_config this_config = ResTable_config.fromDtoH(type.config);
                if (!this_config.match(desired_config) || best_config != null && !this_config.isBetterThan(best_config, desired_config) && (!package_is_overlay || this_config.compare(best_config) != 0) || (offset = LoadedArsc.LoadedPackage.GetEntryOffset(type, local_entry_idx)) == -1) continue;
                best_cookie = cookie;
                best_package = loaded_package;
                best_type = type;
                best_config = best_config_copy = this_config;
                best_offset = offset;
            }
        }
        if (Util.UNLIKELY(best_cookie.intValue() == -1)) {
            return ApkAssetsCookie.K_INVALID_COOKIE;
        }
        ResourceTypes.ResTable_entry best_entry = LoadedArsc.LoadedPackage.GetEntryFromOffset(best_type, best_offset);
        if (Util.UNLIKELY(best_entry == null)) {
            return ApkAssetsCookie.K_INVALID_COOKIE;
        }
        FindEntryResult out_entry_ = new FindEntryResult();
        out_entry_.entry = best_entry;
        out_entry_.config = best_config;
        out_entry_.type_flags = type_flags;
        out_entry_.type_string_ref = new StringPoolRef(best_package.GetTypeStringPool(), best_type.id - 1);
        out_entry_.entry_string_ref = new StringPoolRef(best_package.GetKeyStringPool(), best_entry.getKeyIndex());
        out_entry_.dynamic_ref_table = package_group.dynamic_ref_table;
        out_entry.set(out_entry_);
        return best_cookie;
    }

    public boolean GetResourceName(int resid, ResourceName out_name) {
        Ref<Object> entryRef = new Ref<Object>(null);
        ApkAssetsCookie cookie = this.FindEntry(resid, (short)0, entryRef);
        if (cookie.intValue() == -1) {
            return false;
        }
        LoadedArsc.LoadedPackage package_ = this.apk_assets_.get(cookie.intValue()).GetLoadedArsc().GetPackageById(ResourceUtils.get_package_id(resid));
        if (package_ == null) {
            return false;
        }
        out_name.package_ = package_.GetPackageName();
        FindEntryResult entry = entryRef.get();
        out_name.type = entry.type_string_ref.string();
        if (out_name.type == null) {
            return false;
        }
        out_name.entry = entry.entry_string_ref.string();
        return out_name.entry != null;
    }

    boolean GetResourceFlags(int resid, Ref<Integer> out_flags) {
        Ref<Object> entry = new Ref<Object>(null);
        ApkAssetsCookie cookie = this.FindEntry(resid, (short)0, entry);
        if (cookie.intValue() != -1) {
            out_flags.set(((FindEntryResult)entry.get()).type_flags);
        }
        return cookie.intValue() != -1;
    }

    public ApkAssetsCookie GetResource(int resid, boolean may_be_bag, short density_override, Ref<ResourceTypes.Res_value> out_value, Ref<ResTable_config> out_selected_config, Ref<Integer> out_flags) {
        Ref<Object> entry = new Ref<Object>(null);
        ApkAssetsCookie cookie = this.FindEntry(resid, density_override, entry);
        if (cookie.intValue() == -1) {
            return ApkAssetsCookie.K_INVALID_COOKIE;
        }
        if (Util.isTruthy(Util.dtohl(((FindEntryResult)entry.get()).entry.flags) & 1)) {
            if (!may_be_bag) {
                System.err.println(String.format("Resource %08x is a complex map type.", resid));
                return ApkAssetsCookie.K_INVALID_COOKIE;
            }
            out_value.set(new ResourceTypes.Res_value(1, resid));
            out_selected_config.set(new ResTable_config(((FindEntryResult)entry.get()).config));
            out_flags.set(((FindEntryResult)entry.get()).type_flags);
            return cookie;
        }
        ResourceTypes.Res_value device_value = ((FindEntryResult)entry.get()).entry.getResValue();
        out_value.set(device_value.copy());
        ((FindEntryResult)entry.get()).dynamic_ref_table.lookupResourceValue(out_value);
        out_selected_config.set(new ResTable_config(((FindEntryResult)entry.get()).config));
        out_flags.set(((FindEntryResult)entry.get()).type_flags);
        return cookie;
    }

    public ApkAssetsCookie ResolveReference(ApkAssetsCookie cookie, Ref<ResourceTypes.Res_value> in_out_value, Ref<ResTable_config> in_out_selected_config, Ref<Integer> in_out_flags, Ref<Integer> out_last_reference) {
        int kMaxIterations = 20;
        for (int iteration = 0; in_out_value.get().dataType == 1 && in_out_value.get().data != 0 && iteration < 20; ++iteration) {
            out_last_reference.set(in_out_value.get().data);
            Ref<Integer> new_flags = new Ref<Integer>(0);
            cookie = this.GetResource(in_out_value.get().data, true, (short)0, in_out_value, in_out_selected_config, new_flags);
            if (cookie.intValue() == -1) {
                return ApkAssetsCookie.K_INVALID_COOKIE;
            }
            if (in_out_flags != null) {
                in_out_flags.set(in_out_flags.get() | new_flags.get());
            }
            if (out_last_reference.get() != in_out_value.get().data) continue;
            return cookie;
        }
        return cookie;
    }

    public final ResolvedBag GetBag(int resid) {
        ArrayList<Integer> found_resids = new ArrayList<Integer>();
        return this.GetBag(resid, found_resids);
    }

    ResolvedBag GetBag(int resid, List<Integer> child_resids) {
        ResolvedBag cached_iter = this.cached_bags_.get(resid);
        if (cached_iter != null) {
            return cached_iter;
        }
        Ref<Object> entryRef = new Ref<Object>(null);
        ApkAssetsCookie cookie = this.FindEntry(resid, (short)0, entryRef);
        if (cookie.intValue() == -1) {
            return null;
        }
        FindEntryResult entry = entryRef.get();
        if (Util.dtohs(entry.entry.size) < 16 || (Util.dtohs(entry.entry.flags) & 1) == 0) {
            return null;
        }
        ResourceTypes.ResTable_map_entry map = new ResourceTypes.ResTable_map_entry(entry.entry.myBuf(), entry.entry.myOffset());
        int curOffset = map.myOffset() + map.size;
        ResourceTypes.ResTable_map map_entry = null;
        int map_entry_end = curOffset + Util.dtohl(map.count) * 12;
        if (curOffset < map_entry_end) {
            map_entry = new ResourceTypes.ResTable_map(map.myBuf(), curOffset);
        }
        child_resids.add(resid);
        Ref<Integer> parent_resid = new Ref<Integer>(Util.dtohl(map.parent.ident));
        if (parent_resid.get() == 0 || child_resids.contains(parent_resid.get())) {
            int entry_count = (map_entry_end - curOffset) / 12;
            ResolvedBag new_bag = new ResolvedBag();
            new_bag.entries = new ResolvedBag.Entry[entry_count];
            ResolvedBag.Entry[] new_entry = new_bag.entries;
            int i = 0;
            while (curOffset < map_entry_end) {
                map_entry = new ResourceTypes.ResTable_map(map_entry.myBuf(), curOffset);
                Ref<Integer> new_key = new Ref<Integer>(Util.dtohl(map_entry.name.ident));
                if (!ResourceUtils.is_internal_resid(new_key.get()) && entry.dynamic_ref_table.lookupResourceId(new_key) != 0) {
                    System.err.println(String.format("Failed to resolve key 0x%08x in bag 0x%08x.", new_key.get(), resid));
                    return null;
                }
                ResolvedBag.Entry new_entry_ = new_entry[i] = new ResolvedBag.Entry();
                new_entry_.cookie = cookie;
                new_entry_.key = new_key.get();
                new_entry_.key_pool = null;
                new_entry_.type_pool = null;
                new_entry_.style = resid;
                new_entry_.value = map_entry.value.copy();
                Ref<ResourceTypes.Res_value> valueRef = new Ref<ResourceTypes.Res_value>(new_entry_.value);
                int err = entry.dynamic_ref_table.lookupResourceValue(valueRef);
                new_entry_.value = valueRef.get();
                if (err != 0) {
                    System.err.println(String.format("Failed to resolve value t=0x%02x d=0x%08x for key 0x%08x.", new_entry_.value.dataType, new_entry_.value.data, new_key.get()));
                    return null;
                }
                ++i;
                short size = Util.dtohs(map_entry.value.size);
                curOffset += size + 12 - 8;
            }
            new_bag.type_spec_flags = entry.type_flags;
            new_bag.entry_count = entry_count;
            ResolvedBag result = new_bag;
            this.cached_bags_.put(resid, new_bag);
            return result;
        }
        entry.dynamic_ref_table.lookupResourceId(parent_resid);
        ResolvedBag parent_bag = this.GetBag(parent_resid.get(), child_resids);
        if (parent_bag == null) {
            System.err.println(String.format("Failed to find parent 0x%08x of bag 0x%08x.", parent_resid.get(), resid));
            return null;
        }
        int max_count = parent_bag.entry_count + Util.dtohl(map.count);
        ResolvedBag new_bag = new ResolvedBag();
        ResolvedBag.Entry[] new_entry = new_bag.entries = new ResolvedBag.Entry[max_count];
        int newEntryIndex = 0;
        int parentEntryIndex = 0;
        int parentEntryCount = parent_bag.entry_count;
        while (map_entry != null && curOffset != map_entry_end && parentEntryIndex != parentEntryCount) {
            map_entry = new ResourceTypes.ResTable_map(map_entry.myBuf(), curOffset);
            Ref<Integer> child_keyRef = new Ref<Integer>(Util.dtohl(map_entry.name.ident));
            if (!ResourceUtils.is_internal_resid(child_keyRef.get()) && entry.dynamic_ref_table.lookupResourceId(child_keyRef) != 0) {
                System.err.println(String.format("Failed to resolve key 0x%08x in bag 0x%08x.", child_keyRef.get(), resid));
                return null;
            }
            int child_key = child_keyRef.get();
            ResolvedBag.Entry parent_entry = parent_bag.entries[parentEntryIndex];
            if (parent_entry == null) {
                parent_entry = new ResolvedBag.Entry();
            }
            if (child_key <= parent_entry.key) {
                ResolvedBag.Entry new_entry_ = new_entry[newEntryIndex] = new ResolvedBag.Entry();
                new_entry_.cookie = cookie;
                new_entry_.key = child_key;
                new_entry_.key_pool = null;
                new_entry_.type_pool = null;
                new_entry_.value = map_entry.value.copy();
                new_entry_.style = resid;
                Ref<ResourceTypes.Res_value> valueRef = new Ref<ResourceTypes.Res_value>(new_entry_.value);
                int err = entry.dynamic_ref_table.lookupResourceValue(valueRef);
                new_entry_.value = valueRef.get();
                if (err != 0) {
                    System.err.println(String.format("Failed to resolve value t=0x%02x d=0x%08x for key 0x%08x.", new_entry_.value.dataType, new_entry_.value.data, child_key));
                    return null;
                }
                curOffset += map_entry.value.size + 12 - 8;
            } else {
                new_entry[newEntryIndex] = parent_entry.copy();
            }
            if (child_key >= parent_entry.key) {
                ++parentEntryIndex;
            }
            ++newEntryIndex;
        }
        while (map_entry != null && curOffset != map_entry_end) {
            map_entry = new ResourceTypes.ResTable_map(map_entry.myBuf(), curOffset);
            Ref<Integer> new_key = new Ref<Integer>(map_entry.name.ident);
            if (!ResourceUtils.is_internal_resid(new_key.get()) && entry.dynamic_ref_table.lookupResourceId(new_key) != 0) {
                System.err.println(String.format("Failed to resolve key 0x%08x in bag 0x%08x.", new_key.get(), resid));
                return null;
            }
            ResolvedBag.Entry new_entry_ = new_entry[newEntryIndex] = new ResolvedBag.Entry();
            new_entry_.cookie = cookie;
            new_entry_.key = new_key.get();
            new_entry_.key_pool = null;
            new_entry_.type_pool = null;
            new_entry_.value = map_entry.value.copy();
            new_entry_.style = resid;
            Ref<ResourceTypes.Res_value> valueRef = new Ref<ResourceTypes.Res_value>(new_entry_.value);
            int err = entry.dynamic_ref_table.lookupResourceValue(valueRef);
            new_entry_.value = valueRef.get();
            if (err != 0) {
                System.err.println(String.format("Failed to resolve value t=0x%02x d=0x%08x for key 0x%08x.", new_entry_.value.dataType, new_entry_.value.data, new_key.get()));
                return null;
            }
            curOffset += map_entry.value.size + 12 - 8;
            ++newEntryIndex;
        }
        while (parentEntryIndex != parent_bag.entry_count) {
            ResolvedBag.Entry parentEntry = parent_bag.entries[parentEntryIndex];
            new_entry[newEntryIndex] = parentEntry == null ? new ResolvedBag.Entry() : parentEntry.copy();
            ++newEntryIndex;
            ++parentEntryIndex;
        }
        int actual_count = newEntryIndex;
        if (actual_count != max_count) {
            ResolvedBag.Entry[] resizedEntries = new ResolvedBag.Entry[actual_count];
            System.arraycopy(new_bag.entries, 0, resizedEntries, 0, actual_count);
            new_bag.entries = resizedEntries;
        }
        new_bag.type_spec_flags = entry.type_flags | parent_bag.type_spec_flags;
        new_bag.entry_count = actual_count;
        ResolvedBag result2 = new_bag;
        this.cached_bags_.put(resid, new_bag);
        return result2;
    }

    String GetResourceName(int resid) {
        ResourceName out_name = new ResourceName();
        if (this.GetResourceName(resid, out_name)) {
            return out_name.package_ + ":" + out_name.type + "@" + out_name.entry;
        }
        return null;
    }

    static boolean Utf8ToUtf16(String str, Ref<String> out) {
        throw new UnsupportedOperationException();
    }

    public int GetResourceId(String resource_name, String fallback_type, String fallback_package) {
        Ref<Object> package_name = new Ref<Object>(null);
        Ref<Object> type = new Ref<Object>(null);
        Ref<Object> entry = new Ref<Object>(null);
        if (!ResourceUtils.ExtractResourceName(resource_name, package_name, type, entry)) {
            return 0;
        }
        if (((String)entry.get()).isEmpty()) {
            return 0;
        }
        if (((String)package_name.get()).isEmpty()) {
            package_name.set(fallback_package);
        }
        if (((String)type.get()).isEmpty()) {
            type.set(fallback_type);
        }
        String type16 = type.get();
        String entry16 = entry.get();
        String kAttr16 = "attr";
        String kAttrPrivate16 = "^attr-private";
        block0: for (PackageGroup package_group : this.package_groups_) {
            for (ConfiguredPackage package_impl : package_group.packages_) {
                LoadedArsc.LoadedPackage package_ = package_impl.loaded_package_;
                if (!Objects.equals(package_name.get(), package_.GetPackageName())) continue block0;
                int resid = package_.FindEntryByName(type16, entry16);
                if (resid == 0 && Objects.equals("attr", type16)) {
                    resid = package_.FindEntryByName("^attr-private", entry16);
                }
                if (resid == 0) continue;
                return ResourceUtils.fix_package_id(resid, package_group.dynamic_ref_table.mAssignedPackageId);
            }
        }
        return 0;
    }

    void RebuildFilterList() {
        for (PackageGroup group : this.package_groups_) {
            for (ConfiguredPackage impl : group.packages_) {
                impl.filtered_configs_ = new ByteBucketArray<FilteredConfigGroup>(new FilteredConfigGroup()){

                    @Override
                    FilteredConfigGroup newInstance() {
                        return new FilteredConfigGroup();
                    }
                };
                impl.loaded_package_.ForEachTypeSpec((spec, type_index) -> {
                    FilteredConfigGroup configGroup = impl.filtered_configs_.editItemAt(type_index);
                    for (ResourceTypes.ResTable_type iter : spec.types) {
                        ResTable_config this_config = ResTable_config.fromDtoH(iter.config);
                        if (!this_config.match(this.configuration_)) continue;
                        configGroup.configurations.add(this_config);
                        configGroup.types.add(iter);
                    }
                });
            }
        }
    }

    private void InvalidateCaches(int diff) {
        if (diff == -1) {
            this.cached_bags_.clear();
            return;
        }
        for (Integer key : new ArrayList<Integer>(this.cached_bags_.keySet())) {
            if (!Util.isTruthy(diff & this.cached_bags_.get((Object)key).type_spec_flags)) continue;
            this.cached_bags_.remove(key);
        }
    }

    public Theme NewTheme() {
        return new Theme(this);
    }

    public List<AssetPath> getAssetPaths() {
        ArrayList<AssetPath> assetPaths = new ArrayList<AssetPath>(this.apk_assets_.size());
        for (CppApkAssets apkAssets : this.apk_assets_) {
            Path path = Fs.fromUrl(apkAssets.GetPath());
            assetPaths.add(new AssetPath(path, apkAssets.GetLoadedArsc().IsSystem()));
        }
        return assetPaths;
    }

    public static class Theme {
        private final CppAssetManager2 asset_manager_;
        private int type_spec_flags_ = 0;
        private ThemePackage[] packages_ = new ThemePackage[256];
        static final int kPackageCount = 256;
        static final int kTypeCount = 256;

        public CppAssetManager2 GetAssetManager() {
            return this.asset_manager_;
        }

        public int GetChangingConfigurations() {
            return this.type_spec_flags_;
        }

        public Theme(CppAssetManager2 cppAssetManager2) {
            this.asset_manager_ = cppAssetManager2;
        }

        public boolean ApplyStyle(int resid, boolean force) {
            ResolvedBag bag = this.asset_manager_.GetBag(resid);
            if (bag == null) {
                return false;
            }
            this.type_spec_flags_ |= bag.type_spec_flags;
            int last_type_idx = -1;
            int last_package_idx = -1;
            ThemePackage last_package = null;
            ThemeType last_type = null;
            ArrayList<ResolvedBag.Entry> bagEntries = new ArrayList<ResolvedBag.Entry>(Arrays.asList(bag.entries));
            Collections.reverse(bagEntries);
            for (ResolvedBag.Entry bag_iter : bagEntries) {
                ThemeEntry entry;
                int attr_resid;
                int n = attr_resid = bag_iter == null ? 0 : bag_iter.key;
                if (!ResourceUtils.is_valid_resid(attr_resid)) {
                    return false;
                }
                int package_idx = ResourceUtils.get_package_id(attr_resid);
                int type_idx = ResourceUtils.get_type_id(attr_resid);
                int entry_idx = ResourceUtils.get_entry_id(attr_resid);
                if (last_package_idx != package_idx) {
                    ThemePackage package_ = this.packages_[package_idx];
                    if (package_ == null) {
                        package_ = this.packages_[package_idx] = new ThemePackage();
                    }
                    last_package_idx = package_idx;
                    last_package = package_;
                    last_type_idx = -1;
                }
                if (last_type_idx != type_idx) {
                    ThemeType type = last_package.types[type_idx];
                    if (type == null) {
                        type = last_package.types[type_idx] = new ThemeType();
                        type.entries = new ThemeEntry[entry_idx + 1];
                        type.entry_count = entry_idx + 1;
                    } else if (entry_idx >= type.entry_count) {
                        int new_count = entry_idx + 1;
                        ThemeEntry[] oldEntries = type.entries;
                        type.entries = new ThemeEntry[new_count];
                        System.arraycopy(oldEntries, 0, type.entries, 0, oldEntries.length);
                        type.entry_count = new_count;
                    }
                    last_type_idx = type_idx;
                    last_type = type;
                }
                if ((entry = last_type.entries[entry_idx]) == null) {
                    entry = last_type.entries[entry_idx] = new ThemeEntry();
                    entry.value = new ResourceTypes.Res_value();
                }
                if (!force && (entry.value.dataType != 0 || entry.value.data == 1)) continue;
                entry.cookie = bag_iter.cookie;
                entry.type_spec_flags |= bag.type_spec_flags;
                entry.value = bag_iter.value;
            }
            return true;
        }

        public ApkAssetsCookie GetAttribute(int resid, Ref<ResourceTypes.Res_value> out_value, Ref<Integer> out_flags) {
            int entry_idx;
            int type_idx;
            ThemeType type;
            int package_idx;
            ThemePackage package_;
            int cnt = 20;
            int type_spec_flags = 0;
            while ((package_ = this.packages_[package_idx = ResourceUtils.get_package_id(resid)]) != null && (type = package_.types[type_idx = ResourceUtils.get_type_id(resid)]) != null && (entry_idx = ResourceUtils.get_entry_id(resid)) < type.entry_count) {
                ThemeEntry entry = type.entries[entry_idx];
                if (entry == null) {
                    entry = new ThemeEntry();
                    entry.value = new ResourceTypes.Res_value();
                }
                type_spec_flags |= entry.type_spec_flags;
                if (entry.value.dataType == 2) {
                    if (cnt > 0) {
                        --cnt;
                        resid = entry.value.data;
                        continue;
                    }
                    return ApkAssetsCookie.K_INVALID_COOKIE;
                }
                if (entry.value.dataType == 0 && entry.value.data != 1) {
                    return ApkAssetsCookie.K_INVALID_COOKIE;
                }
                out_value.set(entry.value);
                out_flags.set(type_spec_flags);
                return entry.cookie;
            }
            return ApkAssetsCookie.K_INVALID_COOKIE;
        }

        ApkAssetsCookie ResolveAttributeReference(ApkAssetsCookie cookie, Ref<ResourceTypes.Res_value> in_out_value, Ref<ResTable_config> in_out_selected_config, Ref<Integer> in_out_type_spec_flags, Ref<Integer> out_last_ref) {
            if (in_out_value.get().dataType == 2) {
                Ref<Integer> new_flags = new Ref<Integer>(0);
                cookie = this.GetAttribute(in_out_value.get().data, in_out_value, new_flags);
                if (cookie.intValue() == -1) {
                    return ApkAssetsCookie.K_INVALID_COOKIE;
                }
                if (in_out_type_spec_flags != null) {
                    in_out_type_spec_flags.set(in_out_type_spec_flags.get() | new_flags.get());
                }
            }
            return this.asset_manager_.ResolveReference(cookie, in_out_value, in_out_selected_config, in_out_type_spec_flags, out_last_ref);
        }

        public void Clear() {
            this.type_spec_flags_ = 0;
            for (int i = 0; i < this.packages_.length; ++i) {
                this.packages_[i] = null;
            }
        }

        public boolean SetTo(Theme o) {
            if (this == o) {
                return true;
            }
            this.type_spec_flags_ = o.type_spec_flags_;
            boolean copy_only_system = this.asset_manager_ != o.asset_manager_;
            for (int p = 0; p < this.packages_.length; ++p) {
                ThemePackage package_ = o.packages_[p];
                if (package_ == null || copy_only_system && p != 1) {
                    this.packages_[p] = new ThemePackage();
                    continue;
                }
                if (this.packages_[p] == null) {
                    this.packages_[p] = new ThemePackage();
                }
                for (int t = 0; t < package_.types.length; ++t) {
                    ThemeType type = package_.types[t];
                    if (type == null) continue;
                    ThemeType copied_data = new ThemeType();
                    copied_data.entry_count = type.entry_count;
                    copied_data.entries = new ThemeEntry[type.entry_count];
                    ThemeEntry[] newEntries = copied_data.entries;
                    for (int i = 0; i < type.entry_count; ++i) {
                        ThemeEntry entry = type.entries[i];
                        ThemeEntry newEntry = new ThemeEntry();
                        if (entry != null) {
                            newEntry.cookie = entry.cookie;
                            newEntry.type_spec_flags = entry.type_spec_flags;
                            newEntry.value = entry.value.copy();
                        } else {
                            newEntry.value = ResourceTypes.Res_value.NULL_VALUE;
                        }
                        newEntries[i] = newEntry;
                    }
                    this.packages_[p].types[t] = copied_data;
                }
            }
            return true;
        }

        private static class ThemePackage {
            ThemeType[] types = new ThemeType[256];

            private ThemePackage() {
            }
        }

        private static class ThemeType {
            static final int SIZEOF_WITHOUT_ENTRIES = 8;
            int entry_count;
            ThemeEntry[] entries;

            private ThemeType() {
            }
        }

        private static class ThemeEntry {
            static final int SIZEOF = 16;
            ApkAssetsCookie cookie;
            int type_spec_flags;
            ResourceTypes.Res_value value;

            private ThemeEntry() {
            }
        }
    }

    public static interface PackageFunc {
        public void apply(String var1, byte var2);
    }

    static class FindEntryResult {
        ResourceTypes.ResTable_entry entry;
        ResTable_config config;
        int type_flags;
        DynamicRefTable dynamic_ref_table;
        StringPoolRef type_string_ref;
        StringPoolRef entry_string_ref;

        FindEntryResult() {
        }
    }

    static class PackageGroup {
        final List<ConfiguredPackage> packages_ = new ArrayList<ConfiguredPackage>();
        final List<ApkAssetsCookie> cookies_ = new ArrayList<ApkAssetsCookie>();
        DynamicRefTable dynamic_ref_table;

        PackageGroup() {
        }
    }

    static class ConfiguredPackage {
        LoadedArsc.LoadedPackage loaded_package_;
        ByteBucketArray<FilteredConfigGroup> filtered_configs_;

        public ConfiguredPackage(LoadedArsc.LoadedPackage package_) {
            this.loaded_package_ = package_;
        }
    }

    static class FilteredConfigGroup {
        final List<ResTable_config> configurations = new ArrayList<ResTable_config>();
        final List<ResourceTypes.ResTable_type> types = new ArrayList<ResourceTypes.ResTable_type>();

        FilteredConfigGroup() {
        }
    }

    public static class ResourceName {
        public String package_ = null;
        public String type = null;
        public String entry = null;
    }

    public static class ResolvedBag {
        public int type_spec_flags;
        public int entry_count;
        public Entry[] entries;

        public static class Entry {
            public int key;
            public ResourceTypes.Res_value value = new ResourceTypes.Res_value();
            public int style;
            public ApkAssetsCookie cookie;
            ResStringPool key_pool;
            ResStringPool type_pool;

            public Entry copy() {
                Entry entry = new Entry();
                entry.key = this.key;
                entry.value = this.value.copy();
                entry.cookie = this.cookie == null ? null : ApkAssetsCookie.forInt(this.cookie.intValue());
                entry.key_pool = this.key_pool;
                entry.type_pool = this.type_pool;
                return entry;
            }

            public String toString() {
                return "Entry{key=" + this.key + ", value=" + this.value + '}';
            }
        }
    }
}

