/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.robolectric.res.AttrData;
import org.robolectric.res.NodeHandler;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.ResType;
import org.robolectric.res.StaxLoader;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlContext;

public class StaxAttrLoader
extends StaxLoader {
    private String name;
    private String format;
    private final List<AttrData.Pair> pairs = new ArrayList<AttrData.Pair>();

    public StaxAttrLoader(PackageResourceTable resourceTable, String attrType, ResType resType) {
        super(resourceTable, attrType, resType);
        this.addHandler("*", new NodeHandler(){

            @Override
            public void onStart(XMLStreamReader xml, XmlContext xmlContext) {
                String type = xml.getLocalName();
                if (StaxAttrLoader.this.pairs.isEmpty()) {
                    if (StaxAttrLoader.this.format == null) {
                        StaxAttrLoader.this.format = type;
                    } else {
                        StaxAttrLoader.this.format = StaxAttrLoader.this.format + "|" + type;
                    }
                }
                String name = xml.getAttributeValue(null, "name");
                String value = xml.getAttributeValue(null, "value");
                StaxAttrLoader.this.pairs.add(new AttrData.Pair(name, value));
            }

            @Override
            public void onCharacters(XMLStreamReader xml, XmlContext xmlContext) {
            }

            @Override
            public void onEnd(XMLStreamReader xml, XmlContext xmlContext) {
            }
        });
    }

    @Override
    public void onStart(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
        this.name = xml.getAttributeValue(null, "name");
        this.format = xml.getAttributeValue(null, "format");
    }

    @Override
    public void onEnd(XMLStreamReader xml, XmlContext xmlContext) {
        AttrData attrData = new AttrData(this.name, this.format, new ArrayList<AttrData.Pair>(this.pairs));
        this.pairs.clear();
        if (attrData.getFormat() != null) {
            this.resourceTable.addResource(this.attrType, this.name, new TypedResource<AttrData>(attrData, this.resType, xmlContext));
        }
    }
}

