/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import org.robolectric.res.android.DataType;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.ResTable;
import org.robolectric.res.android.ResTableTheme;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.ResXMLParser;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.util.Logger;

public class AttributeResolution {
    public static final boolean kThrowOnBadId = false;
    private static final boolean kDebugStyles = false;
    public static final int STYLE_NUM_ENTRIES = 6;
    public static final int STYLE_TYPE = 0;
    public static final int STYLE_DATA = 1;
    public static final int STYLE_ASSET_COOKIE = 2;
    public static final int STYLE_RESOURCE_ID = 3;
    public static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    public static final int STYLE_DENSITY = 5;

    public static boolean ResolveAttrs(ResTableTheme theme, int defStyleAttr, int defStyleRes, int[] srcValues, int srcValuesLength, int[] attrs, int attrsLength, int[] outValues, int[] outIndices) {
        ResourceTypes.Res_value value;
        Ref<Object> valueRef;
        ResTable res = theme.getResTable();
        ResTable_config config = new ResTable_config();
        int indicesIdx = 0;
        Ref<Integer> defStyleBagTypeSetFlags = new Ref<Integer>(0);
        if (defStyleAttr != 0 && theme.GetAttribute(defStyleAttr, valueRef = new Ref<Object>(null), defStyleBagTypeSetFlags) >= 0) {
            value = valueRef.get();
            if (value.dataType == 1) {
                defStyleRes = value.data;
            }
        }
        res.lock();
        Ref<Object> defStyleStart = new Ref<Object>(null);
        Ref<Integer> defStyleTypeSetFlags = new Ref<Integer>(0);
        int bagOff = defStyleRes != 0 ? res.getBagLocked(defStyleRes, defStyleStart, defStyleTypeSetFlags) : -1;
        defStyleTypeSetFlags.set(defStyleTypeSetFlags.get() | defStyleBagTypeSetFlags.get());
        int defStyleEnd = Math.max(bagOff, 0);
        BagAttributeFinder defStyleAttrFinder = new BagAttributeFinder(defStyleStart.get(), defStyleEnd);
        int destOffset = 0;
        for (int ii = 0; ii < attrsLength; ++ii) {
            int newBlock;
            int curIdent = attrs[ii];
            int block = -1;
            int typeSetFlags = 0;
            value = ResourceTypes.Res_value.NULL_VALUE;
            config.density = 0;
            if (srcValuesLength > 0 && srcValues[ii] != 0) {
                value = new ResourceTypes.Res_value(2, srcValues[ii]);
            } else {
                ResTable.bag_entry defStyleEntry = defStyleAttrFinder.find(curIdent);
                if (defStyleEntry != null) {
                    block = defStyleEntry.stringBlock;
                    typeSetFlags = defStyleTypeSetFlags.get();
                    value = defStyleEntry.map.value;
                }
            }
            int resid = 0;
            Ref<ResourceTypes.Res_value> valueRef2 = new Ref<ResourceTypes.Res_value>(value);
            Ref<Integer> residRef = new Ref<Integer>(resid);
            Ref<Integer> typeSetFlagsRef = new Ref<Integer>(typeSetFlags);
            Ref<ResTable_config> configRef = new Ref<ResTable_config>(config);
            if (value.dataType != 0) {
                newBlock = theme.resolveAttributeReference(valueRef2, block, residRef, typeSetFlagsRef, configRef);
                value = valueRef2.get();
                resid = residRef.get();
                typeSetFlags = typeSetFlagsRef.get();
                config = configRef.get();
                if (newBlock >= 0) {
                    block = newBlock;
                }
            } else {
                newBlock = theme.GetAttribute(curIdent, valueRef2, typeSetFlagsRef);
                value = valueRef2.get();
                typeSetFlags = typeSetFlagsRef.get();
                if (newBlock >= 0) {
                    newBlock = res.resolveReference(valueRef2, newBlock, residRef, typeSetFlagsRef, configRef);
                    value = valueRef2.get();
                    resid = residRef.get();
                    typeSetFlags = typeSetFlagsRef.get();
                    config = configRef.get();
                    if (newBlock >= 0) {
                        block = newBlock;
                    }
                }
            }
            if (value.dataType == 1 && value.data == 0) {
                value = ResourceTypes.Res_value.NULL_VALUE;
                block = -1;
            }
            outValues[destOffset + 0] = value.dataType;
            outValues[destOffset + 1] = value.data;
            outValues[destOffset + 2] = block != -1 ? res.getTableCookie(block) : -1;
            outValues[destOffset + 3] = resid;
            outValues[destOffset + 4] = typeSetFlags;
            outValues[destOffset + 5] = config.density;
            if (outIndices != null && value.dataType != 0) {
                outIndices[++indicesIdx] = ii;
            }
            destOffset += 6;
        }
        res.unlock();
        if (outIndices != null) {
            outIndices[0] = indicesIdx;
        }
        return true;
    }

    public static void ApplyStyle(ResTableTheme theme, ResXMLParser xmlParser, int defStyleAttr, int defStyleRes, int[] attrs, int attrsLength, int[] outValues, int[] outIndices) {
        int idx;
        ResTable res = theme.getResTable();
        Ref<ResTable_config> config = new Ref<ResTable_config>(new ResTable_config());
        Ref<ResourceTypes.Res_value> value = new Ref<ResourceTypes.Res_value>(new ResourceTypes.Res_value());
        int indices_idx = 0;
        Ref<Integer> defStyleBagTypeSetFlags = new Ref<Integer>(0);
        if (defStyleAttr != 0 && theme.GetAttribute(defStyleAttr, value, defStyleBagTypeSetFlags) >= 0 && value.get().dataType == DataType.REFERENCE.code()) {
            defStyleRes = value.get().data;
        }
        int style = 0;
        Ref<Integer> styleBagTypeSetFlags = new Ref<Integer>(0);
        if (xmlParser != null && (idx = xmlParser.indexOfStyle()) >= 0 && xmlParser.getAttributeValue(idx, value) >= 0) {
            if (value.get().dataType == DataType.ATTRIBUTE.code() && theme.GetAttribute(value.get().data, value, styleBagTypeSetFlags) < 0) {
                value.set(value.get().withType(DataType.NULL.code()));
            }
            if (value.get().dataType == DataType.REFERENCE.code()) {
                style = value.get().data;
            }
        }
        res.lock();
        Ref<Object> defStyleAttrStart = new Ref<Object>(null);
        Ref<Integer> defStyleTypeSetFlags = new Ref<Integer>(0);
        int bagOff = defStyleRes != 0 ? res.getBagLocked(defStyleRes, defStyleAttrStart, defStyleTypeSetFlags) : -1;
        defStyleTypeSetFlags.set(defStyleTypeSetFlags.get() | defStyleBagTypeSetFlags.get());
        BagAttributeFinder defStyleAttrFinder = new BagAttributeFinder(defStyleAttrStart.get(), bagOff);
        Ref<Object> styleAttrStart = new Ref<Object>(null);
        Ref<Integer> styleTypeSetFlags = new Ref<Integer>(0);
        bagOff = style != 0 ? res.getBagLocked(style, styleAttrStart, styleTypeSetFlags) : -1;
        styleTypeSetFlags.set(styleTypeSetFlags.get() | styleBagTypeSetFlags.get());
        BagAttributeFinder styleAttrFinder = new BagAttributeFinder(styleAttrStart.get(), bagOff);
        int kXmlBlock = 0x10000000;
        XmlAttributeFinder xmlAttrFinder = new XmlAttributeFinder(xmlParser);
        int xmlAttrEnd = xmlParser != null ? xmlParser.getAttributeCount() : 0;
        for (int ii = 0; ii < attrsLength; ++ii) {
            int newBlock;
            ResTable.bag_entry defStyleAttrEntry;
            ResTable.bag_entry styleAttrEntry;
            int curIdent = attrs[ii];
            int block = 0x10000000;
            Ref<Integer> typeSetFlags = new Ref<Integer>(0);
            value.set(ResourceTypes.Res_value.NULL_VALUE);
            config.get().density = 0;
            int xmlAttrIdx = xmlAttrFinder.find(curIdent);
            if (xmlAttrIdx != xmlAttrEnd) {
                xmlParser.getAttributeValue(xmlAttrIdx, value);
            }
            if (value.get().dataType == DataType.NULL.code() && value.get().data != 1 && (styleAttrEntry = styleAttrFinder.find(curIdent)) != null) {
                block = styleAttrEntry.stringBlock;
                typeSetFlags.set(styleTypeSetFlags.get());
                value.set(styleAttrEntry.map.value);
            }
            if (value.get().dataType == DataType.NULL.code() && value.get().data != 1 && (defStyleAttrEntry = defStyleAttrFinder.find(curIdent)) != null) {
                block = defStyleAttrEntry.stringBlock;
                typeSetFlags.set(styleTypeSetFlags.get());
                value.set(defStyleAttrEntry.map.value);
            }
            Ref<Integer> resid = new Ref<Integer>(0);
            if (value.get().dataType != DataType.NULL.code()) {
                newBlock = theme.resolveAttributeReference(value, block, resid, typeSetFlags, config);
                if (newBlock >= 0) {
                    block = newBlock;
                }
            } else if (value.get().data != 1 && (newBlock = theme.GetAttribute(curIdent, value, typeSetFlags)) >= 0 && (newBlock = res.resolveReference(value, newBlock, resid, typeSetFlags, config)) >= 0) {
                block = newBlock;
            }
            if (value.get().dataType == DataType.REFERENCE.code() && value.get().data == 0) {
                value.set(ResourceTypes.Res_value.NULL_VALUE);
                block = 0x10000000;
            }
            int destIndex = ii * 6;
            ResourceTypes.Res_value res_value = value.get();
            outValues[destIndex + 0] = res_value.dataType;
            outValues[destIndex + 1] = res_value.data;
            outValues[destIndex + 2] = block != 0x10000000 ? res.getTableCookie(block) : -1;
            outValues[destIndex + 3] = resid.get();
            outValues[destIndex + 4] = typeSetFlags.get();
            outValues[destIndex + 5] = config.get().density;
            if (res_value.dataType != DataType.NULL.code() || res_value.data == 1) {
                outIndices[++indices_idx] = ii;
            }
            if (res_value.dataType != DataType.ATTRIBUTE.code()) continue;
            ResTable.ResourceName attrName = new ResTable.ResourceName();
            ResTable.ResourceName attrRefName = new ResTable.ResourceName();
            boolean gotName = res.getResourceName(curIdent, true, attrName);
            boolean gotRefName = res.getResourceName(res_value.data, true, attrRefName);
            Logger.warn((String)"Failed to resolve attribute lookup: %s=\"?%s\"; theme: %s", (Object[])new Object[]{gotName ? attrName : "unknown", gotRefName ? attrRefName : "unknown", theme});
        }
        res.unlock();
        outIndices[0] = indices_idx;
    }

    public static boolean RetrieveAttributes(ResTable res, ResXMLParser xmlParser, int[] attrs, int attrsLength, int[] outValues, int[] outIndices) {
        Ref<ResTable_config> config = new Ref<ResTable_config>(new ResTable_config());
        Ref<Object> value = new Ref<Object>(null);
        int indices_idx = 0;
        res.lock();
        int xmlAttrCount = xmlParser.getAttributeCount();
        int ix = 0;
        int curXmlAttr = xmlParser.getAttributeNameResID(ix);
        int kXmlBlock = 0x10000000;
        int baseDest = 0;
        for (int ii = 0; ii < attrsLength; ++ii) {
            int newBlock;
            int curIdent = attrs[ii];
            int block = 0;
            Ref<Integer> typeSetFlags = new Ref<Integer>(0);
            value.set(ResourceTypes.Res_value.NULL_VALUE);
            config.get().density = 0;
            while (ix < xmlAttrCount && curIdent > curXmlAttr) {
                curXmlAttr = xmlParser.getAttributeNameResID(++ix);
            }
            if (ix < xmlAttrCount && curIdent == curXmlAttr) {
                block = 0x10000000;
                xmlParser.getAttributeValue(ix, value);
                curXmlAttr = xmlParser.getAttributeNameResID(++ix);
            }
            Ref<Integer> resid = new Ref<Integer>(0);
            if (((ResourceTypes.Res_value)value.get()).dataType != 0 && (newBlock = res.resolveReference(value, block, resid, typeSetFlags, config)) >= 0) {
                block = newBlock;
            }
            if (((ResourceTypes.Res_value)value.get()).dataType == 1 && ((ResourceTypes.Res_value)value.get()).data == 0) {
                value.set(ResourceTypes.Res_value.NULL_VALUE);
                block = 0x10000000;
            }
            outValues[baseDest + 0] = ((ResourceTypes.Res_value)value.get()).dataType;
            outValues[baseDest + 1] = ((ResourceTypes.Res_value)value.get()).data;
            outValues[baseDest + 2] = block != 0x10000000 ? res.getTableCookie(block) : -1;
            outValues[baseDest + 3] = resid.get();
            outValues[baseDest + 4] = typeSetFlags.get();
            outValues[baseDest + 5] = config.get().density;
            if (outIndices != null && (((ResourceTypes.Res_value)value.get()).dataType != 0 || ((ResourceTypes.Res_value)value.get()).data == 1)) {
                outIndices[++indices_idx] = ii;
            }
            baseDest += 6;
        }
        res.unlock();
        if (outIndices != null) {
            outIndices[0] = indices_idx;
        }
        return true;
    }

    public static class BagAttributeFinder {
        private final ResTable.bag_entry[] bag_entries;
        private final int bagEndIndex;

        public BagAttributeFinder(ResTable.bag_entry[] bag_entries, int bagEndIndex) {
            this.bag_entries = bag_entries;
            this.bagEndIndex = bagEndIndex;
        }

        public ResTable.bag_entry find(int curIdent) {
            for (int curIndex = this.bagEndIndex - 1; curIndex >= 0; --curIndex) {
                if (this.bag_entries[curIndex].map.name.ident != curIdent) continue;
                return this.bag_entries[curIndex];
            }
            return null;
        }
    }

    public static class XmlAttributeFinder {
        private final ResXMLParser xmlParser;

        public XmlAttributeFinder(ResXMLParser xmlParser) {
            this.xmlParser = xmlParser;
        }

        public int find(int curIdent) {
            if (this.xmlParser == null) {
                return 0;
            }
            int attributeCount = this.xmlParser.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                if (this.xmlParser.getAttributeNameResID(i) != curIdent) continue;
                return i;
            }
            return attributeCount;
        }
    }
}

