/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.manifest;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.robolectric.manifest.ActivityData;
import org.robolectric.manifest.BroadcastReceiverData;
import org.robolectric.manifest.ContentProviderData;
import org.robolectric.manifest.IntentFilterData;
import org.robolectric.manifest.MetaData;
import org.robolectric.manifest.PackageItemData;
import org.robolectric.manifest.PathPermissionData;
import org.robolectric.manifest.PermissionGroupItemData;
import org.robolectric.manifest.PermissionItemData;
import org.robolectric.manifest.RoboNotFoundException;
import org.robolectric.manifest.ServiceData;
import org.robolectric.pluginapi.UsesSdk;
import org.robolectric.res.Fs;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.ResourceTable;
import org.robolectric.util.Logger;
import org.robolectric.versioning.AndroidVersions;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidManifest
implements UsesSdk {
    private final Path androidManifestFile;
    private final Path resDirectory;
    private final Path assetsDirectory;
    private final String overridePackageName;
    private final List<AndroidManifest> libraryManifests;
    private final Path apkFile;
    private boolean manifestIsParsed;
    private String applicationName;
    private String applicationLabel;
    private String rClassName;
    private String packageName;
    private String processName;
    private String themeRef;
    private String labelRef;
    private String appComponentFactory;
    private Integer minSdkVersion;
    private Integer targetSdkVersion;
    private Integer maxSdkVersion;
    private int versionCode;
    private String versionName;
    private final Map<String, PermissionItemData> permissions = new HashMap<String, PermissionItemData>();
    private final Map<String, PermissionGroupItemData> permissionGroups = new HashMap<String, PermissionGroupItemData>();
    private final List<ContentProviderData> providers = new ArrayList<ContentProviderData>();
    private final List<BroadcastReceiverData> receivers = new ArrayList<BroadcastReceiverData>();
    private final Map<String, ServiceData> serviceDatas = new LinkedHashMap<String, ServiceData>();
    private final Map<String, ActivityData> activityDatas = new LinkedHashMap<String, ActivityData>();
    private final List<String> usedPermissions = new ArrayList<String>();
    private final Map<String, String> applicationAttributes = new HashMap<String, String>();
    private MetaData applicationMetaData;

    public AndroidManifest(Path androidManifestFile, Path resDirectory, Path assetsDirectory) {
        this(androidManifestFile, resDirectory, assetsDirectory, null);
    }

    public AndroidManifest(Path androidManifestFile, Path resDirectory, Path assetsDirectory, String overridePackageName) {
        this(androidManifestFile, resDirectory, assetsDirectory, Collections.emptyList(), overridePackageName);
    }

    public AndroidManifest(Path androidManifestFile, Path resDirectory, Path assetsDirectory, @Nonnull List<AndroidManifest> libraryManifests, String overridePackageName) {
        this(androidManifestFile, resDirectory, assetsDirectory, libraryManifests, overridePackageName, null);
    }

    public AndroidManifest(Path androidManifestFile, Path resDirectory, Path assetsDirectory, @Nonnull List<AndroidManifest> libraryManifests, String overridePackageName, Path apkFile) {
        this.androidManifestFile = androidManifestFile;
        this.resDirectory = resDirectory;
        this.assetsDirectory = assetsDirectory;
        this.overridePackageName = overridePackageName;
        this.libraryManifests = libraryManifests;
        this.packageName = overridePackageName;
        this.apkFile = apkFile;
    }

    public String getThemeRef(String activityClassName) {
        String themeRef;
        ActivityData activityData = this.getActivityData(activityClassName);
        String string = themeRef = activityData != null ? activityData.getThemeRef() : null;
        if (themeRef == null) {
            themeRef = this.getThemeRef();
        }
        return themeRef;
    }

    public String getRClassName() {
        this.parseAndroidManifest();
        return this.rClassName;
    }

    public Class<?> getRClass() {
        try {
            String rClassName = this.getRClassName();
            return Class.forName(rClassName);
        }
        catch (Exception e) {
            return null;
        }
    }

    void parseAndroidManifest() {
        if (this.manifestIsParsed) {
            return;
        }
        Logger.debug((String)("Manifest file location: " + this.androidManifestFile), (Object[])new Object[0]);
        if (this.androidManifestFile != null && Files.exists(this.androidManifestFile, new LinkOption[0])) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputStream inputStream = Fs.getInputStream(this.androidManifestFile);
                Document manifestDocument = db.parse(inputStream);
                inputStream.close();
                Logger.debug((String)"Manifest doc location:\n%s", (Object[])new Object[]{this.androidManifestFile.toString()});
                if (!this.packageNameIsOverridden()) {
                    this.packageName = AndroidManifest.getTagAttributeText(manifestDocument, "manifest", "package");
                }
                this.versionCode = this.getTagAttributeIntValue(manifestDocument, "manifest", "android:versionCode", 0);
                this.versionName = AndroidManifest.getTagAttributeText(manifestDocument, "manifest", "android:versionName");
                this.rClassName = this.packageName + ".R";
                Node applicationNode = this.findApplicationNode(manifestDocument);
                if (applicationNode != null) {
                    NamedNodeMap attributes = applicationNode.getAttributes();
                    int attrCount = attributes.getLength();
                    for (int i = 0; i < attrCount; ++i) {
                        Node attr = attributes.item(i);
                        this.applicationAttributes.put(attr.getNodeName(), attr.getTextContent());
                    }
                    this.applicationName = this.applicationAttributes.get("android:name");
                    this.applicationLabel = this.applicationAttributes.get("android:label");
                    this.processName = this.applicationAttributes.get("android:process");
                    this.themeRef = this.applicationAttributes.get("android:theme");
                    this.labelRef = this.applicationAttributes.get("android:label");
                    this.appComponentFactory = this.applicationAttributes.get("android:appComponentFactory");
                    this.parseReceivers(applicationNode);
                    this.parseServices(applicationNode);
                    this.parseActivities(applicationNode);
                    this.parseApplicationMetaData(applicationNode);
                    this.parseContentProviders(applicationNode);
                }
                this.minSdkVersion = this.getTagAttributeSdkIntValue(manifestDocument, "uses-sdk", "android:minSdkVersion");
                this.targetSdkVersion = this.getTagAttributeSdkIntValue(manifestDocument, "uses-sdk", "android:targetSdkVersion");
                this.maxSdkVersion = this.getTagAttributeSdkIntValue(manifestDocument, "uses-sdk", "android:maxSdkVersion");
                if (this.processName == null) {
                    this.processName = this.packageName;
                }
                this.parseUsedPermissions(manifestDocument);
                this.parsePermissions(manifestDocument);
                this.parsePermissionGroups(manifestDocument);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        } else {
            if (this.androidManifestFile != null) {
                System.out.println("WARNING: No manifest file found at " + this.androidManifestFile + ".");
                System.out.println("Falling back to the Android OS resources only.");
                System.out.println("To remove this warning, annotate your test class with @Config(manifest=Config.NONE).");
                System.out.println("If you're using Android Gradle Plugin, add testOptions.unitTests.includeAndroidResources = true to your build.gradle");
            }
            if (this.packageName == null || this.packageName.isEmpty()) {
                this.packageName = "org.robolectric.default";
            }
            this.rClassName = this.packageName + ".R";
        }
        this.manifestIsParsed = true;
    }

    private boolean packageNameIsOverridden() {
        return this.overridePackageName != null && !this.overridePackageName.isEmpty();
    }

    private void parseUsedPermissions(Document manifestDocument) {
        NodeList elementsByTagName = manifestDocument.getElementsByTagName("uses-permission");
        int length = elementsByTagName.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = elementsByTagName.item(i).getAttributes().getNamedItem("android:name");
            this.usedPermissions.add(node.getNodeValue());
        }
    }

    private void parsePermissions(Document manifestDocument) {
        NodeList elementsByTagName = manifestDocument.getElementsByTagName("permission");
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Node permissionNode = elementsByTagName.item(i);
            MetaData metaData = new MetaData(this.getChildrenTags(permissionNode, "meta-data"));
            String name = this.getAttributeValue(permissionNode, "android:name");
            this.permissions.put(name, new PermissionItemData(name, this.getAttributeValue(permissionNode, "android:label"), this.getAttributeValue(permissionNode, "android:description"), this.getAttributeValue(permissionNode, "android:permissionGroup"), this.getAttributeValue(permissionNode, "android:protectionLevel"), metaData));
        }
    }

    private void parsePermissionGroups(Document manifestDocument) {
        NodeList elementsByTagName = manifestDocument.getElementsByTagName("permission-group");
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Node permissionGroupNode = elementsByTagName.item(i);
            MetaData metaData = new MetaData(this.getChildrenTags(permissionGroupNode, "meta-data"));
            String name = this.getAttributeValue(permissionGroupNode, "android:name");
            this.permissionGroups.put(name, new PermissionGroupItemData(name, this.getAttributeValue(permissionGroupNode, "android:label"), this.getAttributeValue(permissionGroupNode, "android:description"), metaData));
        }
    }

    private void parseContentProviders(Node applicationNode) {
        for (Node contentProviderNode : this.getChildrenTags(applicationNode, "provider")) {
            String name = this.getAttributeValue(contentProviderNode, "android:name");
            String authorities = this.getAttributeValue(contentProviderNode, "android:authorities");
            MetaData metaData = new MetaData(this.getChildrenTags(contentProviderNode, "meta-data"));
            ArrayList<PathPermissionData> pathPermissionDatas = new ArrayList<PathPermissionData>();
            for (Node node : this.getChildrenTags(contentProviderNode, "path-permission")) {
                pathPermissionDatas.add(new PathPermissionData(this.getAttributeValue(node, "android:path"), this.getAttributeValue(node, "android:pathPrefix"), this.getAttributeValue(node, "android:pathPattern"), this.getAttributeValue(node, "android:readPermission"), this.getAttributeValue(node, "android:writePermission")));
            }
            this.providers.add(new ContentProviderData(this.resolveClassRef(name), metaData, authorities, AndroidManifest.parseNodeAttributes(contentProviderNode), pathPermissionDatas));
        }
    }

    @Nullable
    private String getAttributeValue(Node parentNode, String attributeName) {
        Node attributeNode = parentNode.getAttributes().getNamedItem(attributeName);
        return attributeNode == null ? null : attributeNode.getTextContent();
    }

    private static HashMap<String, String> parseNodeAttributes(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        int attrCount = attributes.getLength();
        HashMap<String, String> receiverAttrs = new HashMap<String, String>(attributes.getLength());
        for (int i = 0; i < attrCount; ++i) {
            Node attribute = attributes.item(i);
            String value = attribute.getNodeValue();
            if (value == null) continue;
            receiverAttrs.put(attribute.getNodeName(), value);
        }
        return receiverAttrs;
    }

    private void parseReceivers(Node applicationNode) {
        for (Node receiverNode : this.getChildrenTags(applicationNode, "receiver")) {
            HashMap<String, String> receiverAttrs = AndroidManifest.parseNodeAttributes(receiverNode);
            String receiverName = this.resolveClassRef(receiverAttrs.get("android:name"));
            receiverAttrs.put("android:name", receiverName);
            MetaData metaData = new MetaData(this.getChildrenTags(receiverNode, "meta-data"));
            List<IntentFilterData> intentFilterData = this.parseIntentFilters(receiverNode);
            BroadcastReceiverData receiver = new BroadcastReceiverData(receiverAttrs, metaData, intentFilterData);
            List<Node> intentFilters = this.getChildrenTags(receiverNode, "intent-filter");
            for (Node intentFilterNode : intentFilters) {
                for (Node actionNode : this.getChildrenTags(intentFilterNode, "action")) {
                    Node nameNode = actionNode.getAttributes().getNamedItem("android:name");
                    if (nameNode == null) continue;
                    receiver.addAction(nameNode.getTextContent());
                }
            }
            this.receivers.add(receiver);
        }
    }

    private void parseServices(Node applicationNode) {
        for (Node serviceNode : this.getChildrenTags(applicationNode, "service")) {
            HashMap<String, String> serviceAttrs = AndroidManifest.parseNodeAttributes(serviceNode);
            String serviceName = this.resolveClassRef(serviceAttrs.get("android:name"));
            serviceAttrs.put("android:name", serviceName);
            MetaData metaData = new MetaData(this.getChildrenTags(serviceNode, "meta-data"));
            List<IntentFilterData> intentFilterData = this.parseIntentFilters(serviceNode);
            ServiceData service = new ServiceData(serviceAttrs, metaData, intentFilterData);
            List<Node> intentFilters = this.getChildrenTags(serviceNode, "intent-filter");
            for (Node intentFilterNode : intentFilters) {
                for (Node actionNode : this.getChildrenTags(intentFilterNode, "action")) {
                    Node nameNode = actionNode.getAttributes().getNamedItem("android:name");
                    if (nameNode == null) continue;
                    service.addAction(nameNode.getTextContent());
                }
            }
            this.serviceDatas.put(serviceName, service);
        }
    }

    private void parseActivities(Node applicationNode) {
        for (Node activityNode : this.getChildrenTags(applicationNode, "activity")) {
            this.parseActivity(activityNode, false);
        }
        for (Node activityNode : this.getChildrenTags(applicationNode, "activity-alias")) {
            this.parseActivity(activityNode, true);
        }
    }

    private Node findApplicationNode(Document manifestDocument) {
        NodeList applicationNodes = manifestDocument.getElementsByTagName("application");
        if (applicationNodes.getLength() > 1) {
            throw new RuntimeException("found " + applicationNodes.getLength() + " application elements");
        }
        return applicationNodes.item(0);
    }

    private void parseActivity(Node activityNode, boolean isAlias) {
        List<IntentFilterData> intentFilterData = this.parseIntentFilters(activityNode);
        MetaData metaData = new MetaData(this.getChildrenTags(activityNode, "meta-data"));
        HashMap<String, String> activityAttrs = AndroidManifest.parseNodeAttributes(activityNode);
        String activityName = this.resolveClassRef(activityAttrs.get(ActivityData.getNameAttr("android")));
        if (activityName == null) {
            return;
        }
        ActivityData targetActivity = null;
        if (isAlias) {
            String targetName = this.resolveClassRef(activityAttrs.get(ActivityData.getTargetAttr("android")));
            targetActivity = this.activityDatas.get(targetName);
            activityAttrs.put(ActivityData.getTargetAttr("android"), targetName);
        }
        activityAttrs.put(ActivityData.getNameAttr("android"), activityName);
        this.activityDatas.put(activityName, new ActivityData("android", activityAttrs, intentFilterData, targetActivity, metaData));
    }

    private List<IntentFilterData> parseIntentFilters(Node activityNode) {
        ArrayList<IntentFilterData> intentFilterDatas = new ArrayList<IntentFilterData>();
        for (Node n : this.getChildrenTags(activityNode, "intent-filter")) {
            NamedNodeMap attributes;
            ArrayList<String> actionNames = new ArrayList<String>();
            ArrayList<String> categories = new ArrayList<String>();
            for (Node action : this.getChildrenTags(n, "action")) {
                attributes = action.getAttributes();
                Node actionNameNode = attributes.getNamedItem("android:name");
                if (actionNameNode == null) continue;
                actionNames.add(actionNameNode.getNodeValue());
            }
            for (Node category : this.getChildrenTags(n, "category")) {
                attributes = category.getAttributes();
                Node categoryNameNode = attributes.getNamedItem("android:name");
                if (categoryNameNode == null) continue;
                categories.add(categoryNameNode.getNodeValue());
            }
            IntentFilterData intentFilterData = new IntentFilterData(actionNames, categories);
            intentFilterData = this.parseIntentFilterData(n, intentFilterData);
            intentFilterDatas.add(intentFilterData);
        }
        return intentFilterDatas;
    }

    private IntentFilterData parseIntentFilterData(Node intentFilterNode, IntentFilterData intentFilterData) {
        for (Node n : this.getChildrenTags(intentFilterNode, "data")) {
            Node mimeTypeNode;
            Node pathPrefixNode;
            Node pathPatternNode;
            Node portNode;
            Node hostNode;
            NamedNodeMap attributes = n.getAttributes();
            String host = null;
            String port = null;
            Node schemeNode = attributes.getNamedItem("android:scheme");
            if (schemeNode != null) {
                intentFilterData.addScheme(schemeNode.getNodeValue());
            }
            if ((hostNode = attributes.getNamedItem("android:host")) != null) {
                host = hostNode.getNodeValue();
            }
            if ((portNode = attributes.getNamedItem("android:port")) != null) {
                port = portNode.getNodeValue();
            }
            intentFilterData.addAuthority(host, port);
            Node pathNode = attributes.getNamedItem("android:path");
            if (pathNode != null) {
                intentFilterData.addPath(pathNode.getNodeValue());
            }
            if ((pathPatternNode = attributes.getNamedItem("android:pathPattern")) != null) {
                intentFilterData.addPathPattern(pathPatternNode.getNodeValue());
            }
            if ((pathPrefixNode = attributes.getNamedItem("android:pathPrefix")) != null) {
                intentFilterData.addPathPrefix(pathPrefixNode.getNodeValue());
            }
            if ((mimeTypeNode = attributes.getNamedItem("android:mimeType")) == null) continue;
            intentFilterData.addMimeType(mimeTypeNode.getNodeValue());
        }
        return intentFilterData;
    }

    public void initMetaData(ResourceTable resourceTable) throws RoboNotFoundException {
        if (!this.packageNameIsOverridden()) {
            this.parseAndroidManifest();
        }
        if (this.applicationMetaData != null) {
            this.applicationMetaData.init(resourceTable, this.packageName);
        }
        for (PackageItemData packageItemData : this.receivers) {
            packageItemData.getMetaData().init(resourceTable, this.packageName);
        }
        for (ServiceData serviceData : this.serviceDatas.values()) {
            serviceData.getMetaData().init(resourceTable, this.packageName);
        }
        for (ContentProviderData contentProviderData : this.providers) {
            contentProviderData.getMetaData().init(resourceTable, this.packageName);
        }
    }

    private void parseApplicationMetaData(Node applicationNode) {
        this.applicationMetaData = new MetaData(this.getChildrenTags(applicationNode, "meta-data"));
    }

    private String resolveClassRef(String maybePartialClassName) {
        return maybePartialClassName.startsWith(".") ? this.packageName + maybePartialClassName : maybePartialClassName;
    }

    private List<Node> getChildrenTags(Node node, String tagName) {
        ArrayList<Node> children = new ArrayList<Node>();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (!childNode.getNodeName().equalsIgnoreCase(tagName)) continue;
            children.add(childNode);
        }
        return children;
    }

    private Integer getTagAttributeIntValue(Document doc, String tag, String attribute, Integer defaultValue) {
        String valueString = AndroidManifest.getTagAttributeText(doc, tag, attribute);
        if (valueString != null) {
            return Integer.parseInt(valueString);
        }
        return defaultValue;
    }

    private Integer getTagAttributeSdkIntValue(Document doc, String tag, String attribute) {
        String sdkString = AndroidManifest.getTagAttributeText(doc, tag, attribute);
        if (sdkString != null) {
            try {
                return Integer.parseInt(sdkString);
            }
            catch (NumberFormatException e) {
                List releasedReleases = AndroidVersions.getReleases();
                List unreleasedReleases = AndroidVersions.getUnreleased();
                if (!releasedReleases.isEmpty()) {
                    AndroidVersions.AndroidRelease latestRelease = (AndroidVersions.AndroidRelease)releasedReleases.get(releasedReleases.size() - 1);
                    if (latestRelease.getShortCode().equals(sdkString)) {
                        return latestRelease.getSdkInt();
                    }
                }
                for (AndroidVersions.AndroidRelease release : unreleasedReleases) {
                    if (!release.getShortCode().equals(sdkString)) continue;
                    return release.getSdkInt();
                }
            }
        }
        return null;
    }

    public String getApplicationName() {
        this.parseAndroidManifest();
        return this.applicationName;
    }

    public String getActivityLabel(String activityClassName) {
        this.parseAndroidManifest();
        ActivityData data = this.getActivityData(activityClassName);
        return data != null && data.getLabel() != null ? data.getLabel() : this.applicationLabel;
    }

    public String getPackageName() {
        this.parseAndroidManifest();
        return this.packageName;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getLabelRef() {
        return this.labelRef;
    }

    public String getAppComponentFactory() {
        this.parseAndroidManifest();
        return this.appComponentFactory;
    }

    public int getMinSdkVersion() {
        this.parseAndroidManifest();
        return this.minSdkVersion == null ? 21 : this.minSdkVersion;
    }

    public int getTargetSdkVersion() {
        this.parseAndroidManifest();
        return this.targetSdkVersion == null ? this.getMinSdkVersion() : this.targetSdkVersion.intValue();
    }

    public Integer getMaxSdkVersion() {
        this.parseAndroidManifest();
        return this.maxSdkVersion;
    }

    public Map<String, String> getApplicationAttributes() {
        this.parseAndroidManifest();
        return this.applicationAttributes;
    }

    public String getProcessName() {
        this.parseAndroidManifest();
        return this.processName;
    }

    public Map<String, Object> getApplicationMetaData() {
        this.parseAndroidManifest();
        if (this.applicationMetaData == null) {
            this.applicationMetaData = new MetaData(Collections.emptyList());
        }
        return this.applicationMetaData.getValueMap();
    }

    public ResourcePath getResourcePath() {
        return new ResourcePath(this.getRClass(), this.resDirectory, this.assetsDirectory);
    }

    public List<ResourcePath> getIncludedResourcePaths() {
        LinkedHashSet<ResourcePath> resourcePaths = new LinkedHashSet<ResourcePath>();
        resourcePaths.add(this.getResourcePath());
        for (AndroidManifest libraryManifest : this.getLibraryManifests()) {
            resourcePaths.addAll(libraryManifest.getIncludedResourcePaths());
        }
        return new ArrayList<ResourcePath>(resourcePaths);
    }

    public List<ContentProviderData> getContentProviders() {
        this.parseAndroidManifest();
        return this.providers;
    }

    public List<AndroidManifest> getLibraryManifests() {
        assert (this.libraryManifests != null);
        return Collections.unmodifiableList(this.libraryManifests);
    }

    public List<AndroidManifest> getAllManifests() {
        HashSet<AndroidManifest> seenManifests = new HashSet<AndroidManifest>();
        ArrayList<AndroidManifest> uniqueManifests = new ArrayList<AndroidManifest>();
        this.addTransitiveManifests(seenManifests, uniqueManifests);
        return uniqueManifests;
    }

    private void addTransitiveManifests(Set<AndroidManifest> unique, List<AndroidManifest> list) {
        if (unique.add(this)) {
            list.add(this);
            for (AndroidManifest androidManifest : this.getLibraryManifests()) {
                androidManifest.addTransitiveManifests(unique, list);
            }
        }
    }

    public Path getResDirectory() {
        return this.resDirectory;
    }

    public Path getAssetsDirectory() {
        return this.assetsDirectory;
    }

    public Path getAndroidManifestFile() {
        return this.androidManifestFile;
    }

    public List<BroadcastReceiverData> getBroadcastReceivers() {
        this.parseAndroidManifest();
        return this.receivers;
    }

    public List<ServiceData> getServices() {
        this.parseAndroidManifest();
        return new ArrayList<ServiceData>(this.serviceDatas.values());
    }

    public ServiceData getServiceData(String serviceClassName) {
        this.parseAndroidManifest();
        return this.serviceDatas.get(serviceClassName);
    }

    private static String getTagAttributeText(Document doc, String tag, String attribute) {
        NodeList elementsByTagName = doc.getElementsByTagName(tag);
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Node item = elementsByTagName.item(i);
            Node namedItem = item.getAttributes().getNamedItem(attribute);
            if (namedItem == null) continue;
            return namedItem.getTextContent();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AndroidManifest)) {
            return false;
        }
        AndroidManifest that = (AndroidManifest)o;
        if (!Objects.equals(this.androidManifestFile, that.androidManifestFile)) {
            return false;
        }
        if (!Objects.equals(this.resDirectory, that.resDirectory)) {
            return false;
        }
        if (!Objects.equals(this.assetsDirectory, that.assetsDirectory)) {
            return false;
        }
        if (!Objects.equals(this.overridePackageName, that.overridePackageName)) {
            return false;
        }
        if (!Objects.equals(this.libraryManifests, that.libraryManifests)) {
            return false;
        }
        return Objects.equals(this.apkFile, that.apkFile);
    }

    public int hashCode() {
        int result = this.androidManifestFile != null ? this.androidManifestFile.hashCode() : 0;
        result = 31 * result + (this.resDirectory != null ? this.resDirectory.hashCode() : 0);
        result = 31 * result + (this.assetsDirectory != null ? this.assetsDirectory.hashCode() : 0);
        result = 31 * result + (this.overridePackageName != null ? this.overridePackageName.hashCode() : 0);
        result = 31 * result + (this.libraryManifests != null ? this.libraryManifests.hashCode() : 0);
        result = 31 * result + (this.apkFile != null ? this.apkFile.hashCode() : 0);
        return result;
    }

    public ActivityData getActivityData(String activityClassName) {
        this.parseAndroidManifest();
        return this.activityDatas.get(activityClassName);
    }

    public String getThemeRef() {
        return this.themeRef;
    }

    public Map<String, ActivityData> getActivityDatas() {
        this.parseAndroidManifest();
        return this.activityDatas;
    }

    public List<String> getUsedPermissions() {
        this.parseAndroidManifest();
        return this.usedPermissions;
    }

    public Map<String, PermissionItemData> getPermissions() {
        this.parseAndroidManifest();
        return this.permissions;
    }

    public Map<String, PermissionGroupItemData> getPermissionGroups() {
        this.parseAndroidManifest();
        return this.permissionGroups;
    }

    @Nullable
    public BroadcastReceiverData getBroadcastReceiver(String className) {
        this.parseAndroidManifest();
        for (BroadcastReceiverData receiver : this.receivers) {
            if (!receiver.getName().equals(className)) continue;
            return receiver;
        }
        return null;
    }

    public Path getApkFile() {
        return this.apkFile;
    }
}

