/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.res.ResName;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.util.Logger;

public class ResBundle {
    private final ResMap valuesMap = new ResMap();

    public void put(ResName resName, TypedResource value) {
        this.valuesMap.put(resName, value);
    }

    public TypedResource get(ResName resName, ResTable_config config) {
        return this.valuesMap.pick(resName, config);
    }

    public void receive(ResourceTable.Visitor visitor) {
        for (Map.Entry entry : this.valuesMap.map.entrySet()) {
            visitor.visit((ResName)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    static class ResMap {
        private final Map<ResName, List<TypedResource>> map = new HashMap<ResName, List<TypedResource>>();

        ResMap() {
        }

        public TypedResource pick(ResName resName, ResTable_config toMatch) {
            List<TypedResource> values = this.map.get(resName);
            if (values == null || values.isEmpty()) {
                return null;
            }
            TypedResource bestMatchSoFar = null;
            for (TypedResource candidate : values) {
                ResTable_config candidateConfig = candidate.getConfig();
                if (!candidateConfig.match(toMatch) || bestMatchSoFar != null && !candidateConfig.isBetterThan(bestMatchSoFar.getConfig(), toMatch)) continue;
                bestMatchSoFar = candidate;
            }
            if (Logger.loggingEnabled()) {
                Logger.debug((String)"Picked '%s' for %s for qualifiers '%s' (%d candidates)", (Object[])new Object[]{bestMatchSoFar == null ? "<none>" : bestMatchSoFar.getXmlContext().getQualifiers().toString(), resName.getFullyQualifiedName(), toMatch, values.size()});
            }
            return bestMatchSoFar;
        }

        public void put(ResName resName, TypedResource value) {
            if (!this.map.containsKey(resName)) {
                this.map.put(resName, new ArrayList());
            }
            this.map.get(resName).add(value);
        }

        public int size() {
            return this.map.size();
        }
    }
}

