/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.HashMap;
import java.util.Map;
import org.robolectric.res.ResourceIds;

public class ResourceIdGenerator {
    private final Map<String, TypeTracker> typeInfo = new HashMap<String, TypeTracker>();
    private final int packageIdentifier;

    ResourceIdGenerator(int packageIdentifier) {
        this.packageIdentifier = packageIdentifier;
    }

    public void record(int resId, String type, String name) {
        TypeTracker typeTracker = this.typeInfo.get(type);
        if (typeTracker == null) {
            typeTracker = new TypeTracker(ResourceIds.getTypeIdentifier(resId));
            this.typeInfo.put(type, typeTracker);
        }
        typeTracker.record(ResourceIds.getEntryIdentifier(resId));
    }

    public int generate(String type, String name) {
        TypeTracker typeTracker = this.typeInfo.get(type);
        if (typeTracker == null) {
            typeTracker = new TypeTracker(this.getNextFreeTypeIdentifier());
            this.typeInfo.put(type, typeTracker);
        }
        return ResourceIds.makeIdentifier(this.packageIdentifier, typeTracker.getTypeIdentifier(), typeTracker.getFreeIdentifier());
    }

    private int getNextFreeTypeIdentifier() {
        int result = 0;
        for (TypeTracker typeTracker : this.typeInfo.values()) {
            result = Math.max(result, typeTracker.getTypeIdentifier());
        }
        return ++result;
    }

    private static class TypeTracker {
        private final int typeIdentifier;
        private int currentMaxEntry;

        TypeTracker(int typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        void record(int entryIdentifier) {
            this.currentMaxEntry = Math.max(this.currentMaxEntry, entryIdentifier);
        }

        public int getFreeIdentifier() {
            return ++this.currentMaxEntry;
        }

        public int getTypeIdentifier() {
            return this.typeIdentifier;
        }
    }
}

