/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.Fs;

public class ResName {
    public static final String ID_TYPE = "id";
    private static final Pattern FQN_PATTERN = Pattern.compile("^([^:]*):([^/]+)/(.+)$");
    private static final int NAMESPACE = 1;
    private static final int TYPE = 2;
    private static final int NAME = 3;
    @Nonnull
    public final String packageName;
    @Nonnull
    public final String type;
    @Nonnull
    public final String name;
    public final int hashCode;

    public ResName(@Nonnull String packageName, @Nonnull String type, @Nonnull String name) {
        this.packageName = packageName;
        this.type = type.trim();
        this.name = name.trim();
        this.hashCode = this.computeHashCode();
    }

    public ResName(@Nonnull String fullyQualifiedName) {
        Matcher matcher = FQN_PATTERN.matcher(fullyQualifiedName.trim());
        if (!matcher.find()) {
            throw new IllegalStateException("\"" + fullyQualifiedName + "\" is not fully qualified");
        }
        this.packageName = matcher.group(1);
        this.type = matcher.group(2).trim();
        this.name = matcher.group(3).trim();
        this.hashCode = this.computeHashCode();
        if (this.packageName.equals("xmlns")) {
            throw new IllegalStateException("\"" + fullyQualifiedName + "\" unexpected");
        }
    }

    public static String qualifyResourceName(@Nonnull String possiblyQualifiedResourceName, String defaultPackageName, String defaultType) {
        ResName resName = ResName.qualifyResName(possiblyQualifiedResourceName, defaultPackageName, defaultType);
        return resName != null ? resName.getFullyQualifiedName() : null;
    }

    public static ResName qualifyResName(@Nonnull String possiblyQualifiedResourceName, ResName defaults) {
        return ResName.qualifyResName(possiblyQualifiedResourceName, defaults.packageName, defaults.type);
    }

    public static ResName qualifyResName(@Nonnull String possiblyQualifiedResourceName, String defaultPackageName, String defaultType) {
        int indexOfColon = possiblyQualifiedResourceName.indexOf(58);
        int indexOfSlash = possiblyQualifiedResourceName.indexOf(47);
        String type = null;
        String packageName = null;
        String name = possiblyQualifiedResourceName;
        if (indexOfColon > indexOfSlash) {
            if (indexOfSlash > 0) {
                type = possiblyQualifiedResourceName.substring(0, indexOfSlash);
            }
            packageName = possiblyQualifiedResourceName.substring(indexOfSlash + 1, indexOfColon);
            name = possiblyQualifiedResourceName.substring(indexOfColon + 1);
        } else if (indexOfSlash > indexOfColon) {
            if (indexOfColon > 0) {
                packageName = possiblyQualifiedResourceName.substring(0, indexOfColon);
            }
            type = possiblyQualifiedResourceName.substring(indexOfColon + 1, indexOfSlash);
            name = possiblyQualifiedResourceName.substring(indexOfSlash + 1);
        }
        if (type == null && defaultType == null || packageName == null && defaultPackageName == null) {
            return null;
        }
        if (packageName == null) {
            packageName = defaultPackageName;
        } else if ("*android".equals(packageName)) {
            packageName = "android";
        }
        return new ResName(packageName, type == null ? defaultType : type, name);
    }

    public static String qualifyResName(String possiblyQualifiedResourceName, String contextPackageName) {
        if (possiblyQualifiedResourceName == null) {
            return null;
        }
        if (AttributeResource.isNull(possiblyQualifiedResourceName)) {
            return null;
        }
        String fullyQualifiedResourceName = ResName.qualifyResourceName(possiblyQualifiedResourceName, contextPackageName, null);
        if (fullyQualifiedResourceName == null) {
            return null;
        }
        return fullyQualifiedResourceName.replaceAll("[@+]", "");
    }

    public static ResName qualifyFromFilePath(@Nonnull String packageName, @Nonnull String filePath) {
        File file = new File(filePath);
        String type = file.getParentFile().getName().split("-", 0)[0];
        String name = Fs.baseNameFor(file.toPath());
        return new ResName(packageName, type, name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResName resName = (ResName)o;
        if (this.hashCode() != resName.hashCode()) {
            return false;
        }
        if (!this.packageName.equals(resName.packageName)) {
            return false;
        }
        if (!this.type.equals(resName.type)) {
            return false;
        }
        return this.name.equals(resName.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ResName{" + this.getFullyQualifiedName() + "}";
    }

    public String getFullyQualifiedName() {
        return this.packageName + ":" + this.type + "/" + this.name;
    }

    public String getNamespaceUri() {
        return "http://schemas.android.com/apk/res/" + this.packageName;
    }

    public ResName withPackageName(String packageName) {
        if (packageName.equals(this.packageName)) {
            return this;
        }
        return new ResName(packageName, this.type, this.name);
    }

    public void mustBe(String expectedType) {
        if (!this.type.equals(expectedType)) {
            throw new RuntimeException("expected " + this.getFullyQualifiedName() + " to be a " + expectedType + ", is a " + this.type);
        }
    }

    private int computeHashCode() {
        int result = this.packageName.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

