/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

public abstract class ByteBucketArray<T> {
    private static final int NUM_BUCKETS = 16;
    private static final int BUCKET_SIZE = 16;
    Object[][] mBuckets = new Object[16][];
    T mDefault;

    public ByteBucketArray(T mDefault) {
        this.mDefault = mDefault;
    }

    final int size() {
        return 256;
    }

    final T get(int index) {
        if (index >= this.size()) {
            return this.mDefault;
        }
        byte bucketIndex = (byte)(index >> 4);
        Object[] bucket = this.mBuckets[bucketIndex];
        if (bucket == null) {
            return this.mDefault;
        }
        Object t = bucket[0xF & (byte)index];
        return (T)(t == null ? this.mDefault : t);
    }

    T editItemAt(int index) {
        Object t;
        byte bucketIndex = (byte)((byte)index >> 4);
        Object[] bucket = this.mBuckets[bucketIndex];
        if (bucket == null) {
            this.mBuckets[bucketIndex] = new Object[16];
            bucket = this.mBuckets[bucketIndex];
        }
        if ((t = bucket[0xF & (byte)index]) == null) {
            bucket[0xF & (byte)index] = t = this.newInstance();
        }
        return (T)t;
    }

    abstract T newInstance();

    boolean set(int index, T value) {
        if (index >= this.size()) {
            return false;
        }
        byte bucketIndex = (byte)((byte)index >> 4);
        Object[] bucket = this.mBuckets[bucketIndex];
        if (bucket == null) {
            this.mBuckets[bucketIndex] = new Object[16];
            bucket = this.mBuckets[bucketIndex];
        }
        bucket[0xF & (byte)index] = value;
        return true;
    }
}

